<?php

namespace Visualsoft;

class AddressType
{

    /**
     * @var string $CUSTOMER_TITLE
     */
    protected $CUSTOMER_TITLE = null;

    /**
     * @var string $CUSTOMER_FIRSTNAME
     */
    protected $CUSTOMER_FIRSTNAME = null;

    /**
     * @var string $CUSTOMER_LASTNAME
     */
    protected $CUSTOMER_LASTNAME = null;

    /**
     * @var string $COMPANY_NAME
     */
    protected $COMPANY_NAME = null;

    /**
     * @var string $ADDRESS_LINE_1
     */
    protected $ADDRESS_LINE_1 = null;

    /**
     * @var string $ADDRESS_LINE_2
     */
    protected $ADDRESS_LINE_2 = null;

    /**
     * @var string $TOWN
     */
    protected $TOWN = null;

    /**
     * @var string $COUNTY
     */
    protected $COUNTY = null;

    /**
     * @var string $POSTCODE
     */
    protected $POSTCODE = null;

    /**
     * @var string $COUNTRY_ISO_CODE
     */
    protected $COUNTRY_ISO_CODE = null;

    /**
     * @var string $COUNTRY_NAME
     */
    protected $COUNTRY_NAME = null;

    /**
     * @var string $TELEPHONE
     */
    protected $TELEPHONE = null;

    /**
     * @var string $MOBILE
     */
    protected $MOBILE = null;

    /**
     * @var string $IS_DEFAULT
     */
    protected $IS_DEFAULT = null;

    /**
     * @var string $ADDRESS_ID
     */
    protected $ADDRESS_ID = null;

    /**
     * @param string $CUSTOMER_FIRSTNAME
     * @param string $CUSTOMER_LASTNAME
     */
    public function __construct($CUSTOMER_FIRSTNAME, $CUSTOMER_LASTNAME)
    {
      $this->CUSTOMER_FIRSTNAME = $CUSTOMER_FIRSTNAME;
      $this->CUSTOMER_LASTNAME = $CUSTOMER_LASTNAME;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_TITLE()
    {
      return $this->CUSTOMER_TITLE;
    }

    /**
     * @param string $CUSTOMER_TITLE
     * @return \Visualsoft\AddressType
     */
    public function setCUSTOMER_TITLE($CUSTOMER_TITLE)
    {
      $this->CUSTOMER_TITLE = $CUSTOMER_TITLE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_FIRSTNAME()
    {
      return $this->CUSTOMER_FIRSTNAME;
    }

    /**
     * @param string $CUSTOMER_FIRSTNAME
     * @return \Visualsoft\AddressType
     */
    public function setCUSTOMER_FIRSTNAME($CUSTOMER_FIRSTNAME)
    {
      $this->CUSTOMER_FIRSTNAME = $CUSTOMER_FIRSTNAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_LASTNAME()
    {
      return $this->CUSTOMER_LASTNAME;
    }

    /**
     * @param string $CUSTOMER_LASTNAME
     * @return \Visualsoft\AddressType
     */
    public function setCUSTOMER_LASTNAME($CUSTOMER_LASTNAME)
    {
      $this->CUSTOMER_LASTNAME = $CUSTOMER_LASTNAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOMPANY_NAME()
    {
      return $this->COMPANY_NAME;
    }

    /**
     * @param string $COMPANY_NAME
     * @return \Visualsoft\AddressType
     */
    public function setCOMPANY_NAME($COMPANY_NAME)
    {
      $this->COMPANY_NAME = $COMPANY_NAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getADDRESS_LINE_1()
    {
      return $this->ADDRESS_LINE_1;
    }

    /**
     * @param string $ADDRESS_LINE_1
     * @return \Visualsoft\AddressType
     */
    public function setADDRESS_LINE_1($ADDRESS_LINE_1)
    {
      $this->ADDRESS_LINE_1 = $ADDRESS_LINE_1;
      return $this;
    }

    /**
     * @return string
     */
    public function getADDRESS_LINE_2()
    {
      return $this->ADDRESS_LINE_2;
    }

    /**
     * @param string $ADDRESS_LINE_2
     * @return \Visualsoft\AddressType
     */
    public function setADDRESS_LINE_2($ADDRESS_LINE_2)
    {
      $this->ADDRESS_LINE_2 = $ADDRESS_LINE_2;
      return $this;
    }

    /**
     * @return string
     */
    public function getTOWN()
    {
      return $this->TOWN;
    }

    /**
     * @param string $TOWN
     * @return \Visualsoft\AddressType
     */
    public function setTOWN($TOWN)
    {
      $this->TOWN = $TOWN;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOUNTY()
    {
      return $this->COUNTY;
    }

    /**
     * @param string $COUNTY
     * @return \Visualsoft\AddressType
     */
    public function setCOUNTY($COUNTY)
    {
      $this->COUNTY = $COUNTY;
      return $this;
    }

    /**
     * @return string
     */
    public function getPOSTCODE()
    {
      return $this->POSTCODE;
    }

    /**
     * @param string $POSTCODE
     * @return \Visualsoft\AddressType
     */
    public function setPOSTCODE($POSTCODE)
    {
      $this->POSTCODE = $POSTCODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOUNTRY_ISO_CODE()
    {
      return $this->COUNTRY_ISO_CODE;
    }

    /**
     * @param string $COUNTRY_ISO_CODE
     * @return \Visualsoft\AddressType
     */
    public function setCOUNTRY_ISO_CODE($COUNTRY_ISO_CODE)
    {
      $this->COUNTRY_ISO_CODE = $COUNTRY_ISO_CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOUNTRY_NAME()
    {
      return $this->COUNTRY_NAME;
    }

    /**
     * @param string $COUNTRY_NAME
     * @return \Visualsoft\AddressType
     */
    public function setCOUNTRY_NAME($COUNTRY_NAME)
    {
      $this->COUNTRY_NAME = $COUNTRY_NAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getTELEPHONE()
    {
      return $this->TELEPHONE;
    }

    /**
     * @param string $TELEPHONE
     * @return \Visualsoft\AddressType
     */
    public function setTELEPHONE($TELEPHONE)
    {
      $this->TELEPHONE = $TELEPHONE;
      return $this;
    }

    /**
     * @return string
     */
    public function getMOBILE()
    {
      return $this->MOBILE;
    }

    /**
     * @param string $MOBILE
     * @return \Visualsoft\AddressType
     */
    public function setMOBILE($MOBILE)
    {
      $this->MOBILE = $MOBILE;
      return $this;
    }

    /**
     * @return string
     */
    public function getIS_DEFAULT()
    {
      return $this->IS_DEFAULT;
    }

    /**
     * @param string $IS_DEFAULT
     * @return \Visualsoft\AddressType
     */
    public function setIS_DEFAULT($IS_DEFAULT)
    {
      $this->IS_DEFAULT = $IS_DEFAULT;
      return $this;
    }

    /**
     * @return string
     */
    public function getADDRESS_ID()
    {
      return $this->ADDRESS_ID;
    }

    /**
     * @param string $ADDRESS_ID
     * @return \Visualsoft\AddressType
     */
    public function setADDRESS_ID($ADDRESS_ID)
    {
      $this->ADDRESS_ID = $ADDRESS_ID;
      return $this;
    }

}
