<?php

namespace Visualsoft;

class stock_level
{

    /**
     * @var NonEmptyStringType $product_reference
     */
    protected $product_reference = null;

    /**
     * @var float $stock_level
     */
    protected $stock_level = null;

    /**
     * @var stock_locations $stock_locations
     */
    protected $stock_locations = null;

    /**
     * @param NonEmptyStringType $product_reference
     * @param float $stock_level
     * @param stock_locations $stock_locations
     */
    public function __construct($product_reference, $stock_level, $stock_locations)
    {
      $this->product_reference = $product_reference;
      $this->stock_level = $stock_level;
      $this->stock_locations = $stock_locations;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getProduct_reference()
    {
      return $this->product_reference;
    }

    /**
     * @param NonEmptyStringType $product_reference
     * @return \Visualsoft\stock_level
     */
    public function setProduct_reference($product_reference)
    {
      $this->product_reference = $product_reference;
      return $this;
    }

    /**
     * @return float
     */
    public function getStock_level()
    {
      return $this->stock_level;
    }

    /**
     * @param float $stock_level
     * @return \Visualsoft\stock_level
     */
    public function setStock_level($stock_level)
    {
      $this->stock_level = $stock_level;
      return $this;
    }

    /**
     * @return stock_locations
     */
    public function getStock_locations()
    {
      return $this->stock_locations;
    }

    /**
     * @param stock_locations $stock_locations
     * @return \Visualsoft\stock_level
     */
    public function setStock_locations($stock_locations)
    {
      $this->stock_locations = $stock_locations;
      return $this;
    }

}
