<?php

namespace Visualsoft;

class VSAuthType
{

    /**
     * @var string $ClientID
     */
    protected $ClientID = null;

    /**
     * @var string $Username
     */
    protected $Username = null;

    /**
     * @var string $Password
     */
    protected $Password = null;

    /**
     * @param string $ClientID
     * @param string $Username
     * @param string $Password
     */
    public function __construct($ClientID, $Username, $Password)
    {
      $this->ClientID = $ClientID;
      $this->Username = $Username;
      $this->Password = $Password;
    }

    /**
     * @return string
     */
    public function getClientID()
    {
      return $this->ClientID;
    }

    /**
     * @param string $ClientID
     * @return \Visualsoft\VSAuthType
     */
    public function setClientID($ClientID)
    {
      $this->ClientID = $ClientID;
      return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
      return $this->Username;
    }

    /**
     * @param string $Username
     * @return \Visualsoft\VSAuthType
     */
    public function setUsername($Username)
    {
      $this->Username = $Username;
      return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
      return $this->Password;
    }

    /**
     * @param string $Password
     * @return \Visualsoft\VSAuthType
     */
    public function setPassword($Password)
    {
      $this->Password = $Password;
      return $this;
    }

}
