<?php

namespace Visualsoft;

class TradeDiscountType
{

    /**
     * @var int $TRADE_DISCOUNT_ID
     */
    protected $TRADE_DISCOUNT_ID = null;

    /**
     * @var string $NAME
     */
    protected $NAME = null;

    /**
     * @var string $TYPE
     */
    protected $TYPE = null;

    /**
     * @var float $VALUE
     */
    protected $VALUE = null;

    /**
     * @var string $TRADE_DISCOUNT_REFERENCE
     */
    protected $TRADE_DISCOUNT_REFERENCE = null;

    /**
     * @var string $DATE_CREATED
     */
    protected $DATE_CREATED = null;

    /**
     * @var CUSTOMER_GROUPS $CUSTOMER_GROUPS
     */
    protected $CUSTOMER_GROUPS = null;

    /**
     * @var ArrayOfTradeProducts $TRADE_DISCOUNT_PRODUCTS
     */
    protected $TRADE_DISCOUNT_PRODUCTS = null;

    /**
     * @param int $TRADE_DISCOUNT_ID
     * @param string $NAME
     * @param string $TYPE
     * @param float $VALUE
     */
    public function __construct($TRADE_DISCOUNT_ID, $NAME, $TYPE, $VALUE)
    {
      $this->TRADE_DISCOUNT_ID = $TRADE_DISCOUNT_ID;
      $this->NAME = $NAME;
      $this->TYPE = $TYPE;
      $this->VALUE = $VALUE;
    }

    /**
     * @return int
     */
    public function getTRADE_DISCOUNT_ID()
    {
      return $this->TRADE_DISCOUNT_ID;
    }

    /**
     * @param int $TRADE_DISCOUNT_ID
     * @return \Visualsoft\TradeDiscountType
     */
    public function setTRADE_DISCOUNT_ID($TRADE_DISCOUNT_ID)
    {
      $this->TRADE_DISCOUNT_ID = $TRADE_DISCOUNT_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getNAME()
    {
      return $this->NAME;
    }

    /**
     * @param string $NAME
     * @return \Visualsoft\TradeDiscountType
     */
    public function setNAME($NAME)
    {
      $this->NAME = $NAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getTYPE()
    {
      return $this->TYPE;
    }

    /**
     * @param string $TYPE
     * @return \Visualsoft\TradeDiscountType
     */
    public function setTYPE($TYPE)
    {
      $this->TYPE = $TYPE;
      return $this;
    }

    /**
     * @return float
     */
    public function getVALUE()
    {
      return $this->VALUE;
    }

    /**
     * @param float $VALUE
     * @return \Visualsoft\TradeDiscountType
     */
    public function setVALUE($VALUE)
    {
      $this->VALUE = $VALUE;
      return $this;
    }

    /**
     * @return string
     */
    public function getTRADE_DISCOUNT_REFERENCE()
    {
      return $this->TRADE_DISCOUNT_REFERENCE;
    }

    /**
     * @param string $TRADE_DISCOUNT_REFERENCE
     * @return \Visualsoft\TradeDiscountType
     */
    public function setTRADE_DISCOUNT_REFERENCE($TRADE_DISCOUNT_REFERENCE)
    {
      $this->TRADE_DISCOUNT_REFERENCE = $TRADE_DISCOUNT_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getDATE_CREATED()
    {
      return $this->DATE_CREATED;
    }

    /**
     * @param string $DATE_CREATED
     * @return \Visualsoft\TradeDiscountType
     */
    public function setDATE_CREATED($DATE_CREATED)
    {
      $this->DATE_CREATED = $DATE_CREATED;
      return $this;
    }

    /**
     * @return CUSTOMER_GROUPS
     */
    public function getCUSTOMER_GROUPS()
    {
      return $this->CUSTOMER_GROUPS;
    }

    /**
     * @param CUSTOMER_GROUPS $CUSTOMER_GROUPS
     * @return \Visualsoft\TradeDiscountType
     */
    public function setCUSTOMER_GROUPS($CUSTOMER_GROUPS)
    {
      $this->CUSTOMER_GROUPS = $CUSTOMER_GROUPS;
      return $this;
    }

    /**
     * @return ArrayOfTradeProducts
     */
    public function getTRADE_DISCOUNT_PRODUCTS()
    {
      return $this->TRADE_DISCOUNT_PRODUCTS;
    }

    /**
     * @param ArrayOfTradeProducts $TRADE_DISCOUNT_PRODUCTS
     * @return \Visualsoft\TradeDiscountType
     */
    public function setTRADE_DISCOUNT_PRODUCTS($TRADE_DISCOUNT_PRODUCTS)
    {
      $this->TRADE_DISCOUNT_PRODUCTS = $TRADE_DISCOUNT_PRODUCTS;
      return $this;
    }

}
