<?php

namespace Visualsoft;

class StockExchangeSoapServerService extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'WebOrdersContainerType' => 'Visualsoft\\WebOrdersContainerType',
      'WebOrderType' => 'Visualsoft\\WebOrderType',
      'OrderDetailsType' => 'Visualsoft\\OrderDetailsType',
      'MULTICHANNEL_SOURCE' => 'Visualsoft\\MULTICHANNEL_SOURCE',
      'TRACKING_INFO' => 'Visualsoft\\TRACKING_INFO',
      'CustomersContainerType' => 'Visualsoft\\CustomersContainerType',
      'CustomerType' => 'Visualsoft\\CustomerType',
      'SimpleCustomersContainerType' => 'Visualsoft\\SimpleCustomersContainerType',
      'SimpleCustomerType' => 'Visualsoft\\SimpleCustomerType',
      'ImportCustomerType' => 'Visualsoft\\ImportCustomerType',
      'CustomerExportType' => 'Visualsoft\\CustomerExportType',
      'AddressesType' => 'Visualsoft\\AddressesType',
      'AddressType' => 'Visualsoft\\AddressType',
      'OptInsType' => 'Visualsoft\\OptInsType',
      'CustomerDatesType' => 'Visualsoft\\CustomerDatesType',
      'CustomerEwalletType' => 'Visualsoft\\CustomerEwalletType',
      'CustomerEwalletLogsType' => 'Visualsoft\\CustomerEwalletLogsType',
      'EwalletLogType' => 'Visualsoft\\EwalletLogType',
      'OrderProductsContainerType' => 'Visualsoft\\OrderProductsContainerType',
      'OrderProductType' => 'Visualsoft\\OrderProductType',
      'STOCK_MESSAGE' => 'Visualsoft\\STOCK_MESSAGE',
      'STOCK_LOCATION' => 'Visualsoft\\STOCK_LOCATION',
      'BRANCH_FULFILMENT' => 'Visualsoft\\BRANCH_FULFILMENT',
      'PaymentType' => 'Visualsoft\\PaymentType',
      'TransactionBreakdownType' => 'Visualsoft\\TransactionBreakdownType',
      'DiscountsContainerType' => 'Visualsoft\\DiscountsContainerType',
      'DiscountType' => 'Visualsoft\\DiscountType',
      'OrderProductPersonalisationType' => 'Visualsoft\\OrderProductPersonalisationType',
      'OrderProductCategoriesContainerType' => 'Visualsoft\\OrderProductCategoriesContainerType',
      'PersonalisationType' => 'Visualsoft\\PersonalisationType',
      'PersonalisationDetailsContainerType' => 'Visualsoft\\PersonalisationDetailsContainerType',
      'PersonalisationDetailsType' => 'Visualsoft\\PersonalisationDetailsType',
      'OrderProductComponentContainerType' => 'Visualsoft\\OrderProductComponentContainerType',
      'ComponentType' => 'Visualsoft\\ComponentType',
      'CollectPlusType' => 'Visualsoft\\CollectPlusType',
      'CollectPlusLabelType' => 'Visualsoft\\CollectPlusLabelType',
      'OrderTagsType' => 'Visualsoft\\OrderTagsType',
      'ProductContainerType' => 'Visualsoft\\ProductContainerType',
      'ProductType' => 'Visualsoft\\ProductType',
      'SubProductsContainerType' => 'Visualsoft\\SubProductsContainerType',
      'SubProductType' => 'Visualsoft\\SubProductType',
      'ImagesType' => 'Visualsoft\\ImagesType',
      'CategoriesType' => 'Visualsoft\\CategoriesType',
      'DEPARTMENT' => 'Visualsoft\\DEPARTMENT',
      'DEPART_LEVEL' => 'Visualsoft\\DEPART_LEVEL',
      'TagsType' => 'Visualsoft\\TagsType',
      'TAGGROUP' => 'Visualsoft\\TAGGROUP',
      'UpsellingType' => 'Visualsoft\\UpsellingType',
      'UPSELLING_GROUP' => 'Visualsoft\\UPSELLING_GROUP',
      'AttributesType' => 'Visualsoft\\AttributesType',
      'ATTRIBUTE' => 'Visualsoft\\ATTRIBUTE',
      'StockContainerType' => 'Visualsoft\\StockContainerType',
      'STOCK' => 'Visualsoft\\STOCK',
      'ProductDimensionsType' => 'Visualsoft\\ProductDimensionsType',
      'PackDimensionsType' => 'Visualsoft\\PackDimensionsType',
      'StockLocationsType' => 'Visualsoft\\StockLocationsType',
      'VSAuthType' => 'Visualsoft\\VSAuthType',
      'ResultType' => 'Visualsoft\\ResultType',
      'SortOrdersContainerType' => 'Visualsoft\\SortOrdersContainerType',
      'SortOrderContainerType' => 'Visualsoft\\SortOrderContainerType',
      'SortOrderProductsContainerType' => 'Visualsoft\\SortOrderProductsContainerType',
      'SortOrderProductContainerType' => 'Visualsoft\\SortOrderProductContainerType',
      'Result' => 'Visualsoft\\Result',
      'ResultErrorsType' => 'Visualsoft\\ResultErrorsType',
      'ResultWarningsType' => 'Visualsoft\\ResultWarningsType',
      'ArrayOfOrders' => 'Visualsoft\\ArrayOfOrders',
      'ArrayOfOrdersIDs' => 'Visualsoft\\ArrayOfOrdersIDs',
      'ArrayOfOrdersRefs' => 'Visualsoft\\ArrayOfOrdersRefs',
      'ProductReferences' => 'Visualsoft\\ProductReferences',
      'GetData' => 'Visualsoft\\GetData',
      'OrderIds' => 'Visualsoft\\OrderIds',
      'AddCustomerGroupType' => 'Visualsoft\\AddCustomerGroupType',
      'ArrayOfSimpleCustomers' => 'Visualsoft\\ArrayOfSimpleCustomers',
      'TradeProduct' => 'Visualsoft\\TradeProduct',
      'ArrayOfTradeProducts' => 'Visualsoft\\ArrayOfTradeProducts',
      'TradeDiscountType' => 'Visualsoft\\TradeDiscountType',
      'CUSTOMER_GROUPS' => 'Visualsoft\\CUSTOMER_GROUPS',
      'CustomerGroupType' => 'Visualsoft\\CustomerGroupType',
      'TRADE_DISCOUNTS' => 'Visualsoft\\TRADE_DISCOUNTS',
      'ArrayOfCustomerGroups' => 'Visualsoft\\ArrayOfCustomerGroups',
      'ArrayOfTradeDiscounts' => 'Visualsoft\\ArrayOfTradeDiscounts',
      'TradeDiscountProductsType' => 'Visualsoft\\TradeDiscountProductsType',
      'TradeDiscountProductElementType' => 'Visualsoft\\TradeDiscountProductElementType',
      'ArrayOfTradePriceElements' => 'Visualsoft\\ArrayOfTradePriceElements',
      'TradeDiscountPriceElementType' => 'Visualsoft\\TradeDiscountPriceElementType',
      'AddTradeDiscountType' => 'Visualsoft\\AddTradeDiscountType',
      'WebsiteType' => 'Visualsoft\\WebsiteType',
      'ArrayOfWebsites' => 'Visualsoft\\ArrayOfWebsites',
      'OrderFraudUpdateType' => 'Visualsoft\\OrderFraudUpdateType',
      'NewsletterSubscriberType' => 'Visualsoft\\NewsletterSubscriberType',
      'subscriber_group_ids' => 'Visualsoft\\subscriber_group_ids',
      'ModifyNewsletterSubscriberType' => 'Visualsoft\\ModifyNewsletterSubscriberType',
      'SetStockMultipleType' => 'Visualsoft\\SetStockMultipleType',
      'stock_level' => 'Visualsoft\\stock_level',
      'stock_locations' => 'Visualsoft\\stock_locations',
      'stock_location' => 'Visualsoft\\stock_location',
      'LoyaltyPointTransactionContainerType' => 'Visualsoft\\LoyaltyPointTransactionContainerType',
      'CustomerPointsContainerType' => 'Visualsoft\\CustomerPointsContainerType',
      'CUSTOMER' => 'Visualsoft\\CUSTOMER',
      'AUDIT_LOG' => 'Visualsoft\\AUDIT_LOG',
      'AUDIT' => 'Visualsoft\\AUDIT',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://demo.visualsoft.co.uk/api/soap/wsdl/6';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * Test server and client connection with a simple 'Hello World'.
     *
     * @return ResultType
     */
    public function HelloWorld()
    {
      return $this->__soapCall('HelloWorld', array());
    }

    /**
     * Returns product data in the specified format.
     *
     * @param ProductReferences $product_references
     * @param GetData $get_data
     * @param string $file_type
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetProducts(ProductReferences $product_references, GetData $get_data, $file_type, $limit, $offset)
    {
      return $this->__soapCall('GetProducts', array($product_references, $get_data, $file_type, $limit, $offset));
    }

    /**
     * Increase the stock level, by the given amount, for the given product reference.
     *
     * @param string $product_reference
     * @param int $stock_to_add
     * @return ResultType
     */
    public function AddStock($product_reference, $stock_to_add)
    {
      return $this->__soapCall('AddStock', array($product_reference, $stock_to_add));
    }

    /**
     * Sets the stock level to the given amount for the given product reference.
     *
     * @param string $product_reference
     * @param float $stock_level
     * @return ResultType
     */
    public function SetStock($product_reference, $stock_level)
    {
      return $this->__soapCall('SetStock', array($product_reference, $stock_level));
    }

    /**
     * Import an order.
     *
     * @param string $order_data
     * @return ResultType
     */
    public function ImportOrders($order_data)
    {
      return $this->__soapCall('ImportOrders', array($order_data));
    }

    /**
     * Decrease the stock level, by the given amount, for the given product reference.
     *
     * @param string $product_reference
     * @param int $stock_to_remove
     * @return ResultType
     */
    public function RemoveStock($product_reference, $stock_to_remove)
    {
      return $this->__soapCall('RemoveStock', array($product_reference, $stock_to_remove));
    }

    /**
     * Imports the given product data into the system.
     *                 The data must follow the schema provided in the web service description.
     *
     * @param ProductContainerType $PRODUCTS
     * @return ResultType
     */
    public function SubmitProducts(ProductContainerType $PRODUCTS)
    {
      return $this->__soapCall('SubmitProducts', array($PRODUCTS));
    }

    /**
     * Imports the given product data into the system.
     *                 If check_only is provided as FALSE, this will return the result of the analysis on the products_data and add
     *                 this submission to the import queue to process asynchronously.
     *                 Use CheckSubmitProgress to verify whether the import was completed and whether it was successful.
     *
     * @param string $products_data
     * @param string $data_type
     * @param boolean $check_only
     * @return ResultType
     */
    public function SubmitProductsData($products_data, $data_type, $check_only)
    {
      return $this->__soapCall('SubmitProductsData', array($products_data, $data_type, $check_only));
    }

    /**
     * Returns all new orders that have not been marked as 'downloaded' yet.
     *                 By default, this will return new orders since the last request call to this method.
     *
     * @param boolean $auto_update
     * @param string $file_type
     * @param ChannelType $channel Constant: string - Valid values: All, Website, Amazon, eBay, Play, Mobile, Amazon Fulfilment, Amazon Merchant Fulfilled, POQ Studio, Intu, Debenhams, Rakuten, Spartoo, App, Volo - eBay AUS, Volo - eBay USA, Volo - Amazon UK, Retail Direct - eBay, Tesco, Fruugo, JDWilliams, C Discount, Trade Me, Love the Sales
     * @param int $limt
     * @param int $offset
     * @return ResultType
     */
    public function GetNewOrders($auto_update, $file_type, $channel, $limt, $offset)
    {
      return $this->__soapCall('GetNewOrders', array($auto_update, $file_type, $channel, $limt, $offset));
    }

    /**
     * Returns the order for the given order id or order reference.
     *
     * @param string $order_ref
     * @param string $order_id
     * @return ResultType
     */
    public function GetOrder($order_ref, $order_id)
    {
      return $this->__soapCall('GetOrder', array($order_ref, $order_id));
    }

    /**
     * Returns all successful orders within the given date ranges. To return all orders, and not just
     *                 successful ones, pass through false in the successful_only parameter.
     *
     * @param dateTime $from_date
     * @param dateTime $to_date
     * @param boolean $successful_only
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetOrdersByDateRange($from_date, $to_date, $successful_only, $limit, $offset)
    {
      return $this->__soapCall('GetOrdersByDateRange', array($from_date, $to_date, $successful_only, $limit, $offset));
    }

    /**
     * Returns all new orders that have already been downloaded, but have been modified within the given
     *                 timeframe.
     *
     * @param int $mins_since
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetUpdatedOrders($mins_since, $limit, $offset)
    {
      return $this->__soapCall('GetUpdatedOrders', array($mins_since, $limit, $offset));
    }

    /**
     * This is called once an order has been exported from GetNewOrders (or similar) and needs to be
     *                 marked as 'downloaded' so it is not exported again.
     *
     * @param OrderIds $order_ids
     * @return ResultType
     */
    public function MarkOrdersAsDownloaded(OrderIds $order_ids)
    {
      return $this->__soapCall('MarkOrdersAsDownloaded', array($order_ids));
    }

    /**
     * Update a set of orders to a given order status.
     *
     * @param string $order_update_data
     * @param string $data_type
     * @return ResultType
     */
    public function OrderStatusUpdate($order_update_data, $data_type)
    {
      return $this->__soapCall('OrderStatusUpdate', array($order_update_data, $data_type));
    }

    /**
     * Update a set of order products to a given order product status.
     *
     * @param string $order_update_data
     * @param string $data_type
     * @return ResultType
     */
    public function OrderProductStatusUpdate($order_update_data, $data_type)
    {
      return $this->__soapCall('OrderProductStatusUpdate', array($order_update_data, $data_type));
    }

    /**
     * Returns the orders for the given order ids or order references.
     *
     * @param ArrayOfOrders $orders
     * @return ResultType
     */
    public function GetOrders(ArrayOfOrders $orders)
    {
      return $this->__soapCall('GetOrders', array($orders));
    }

    /**
     * Returns a customer for the given ID.
     *
     * @param int $customer_id
     * @return ResultType
     */
    public function GetCustomer($customer_id)
    {
      return $this->__soapCall('GetCustomer', array($customer_id));
    }

    /**
     * Returns the customers matching the lookup value according to the match mode ('account_number',
     *                 'email' or 'address').
     *
     * @param string $match_mode
     * @param string $lookup
     * @return ResultType
     */
    public function GetCustomers($match_mode, $lookup)
    {
      return $this->__soapCall('GetCustomers', array($match_mode, $lookup));
    }

    /**
     * Returns customers updated in the given timeframe. Default one hour.
     *
     * @param int $interval
     * @param string $timestamp
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetUpdatedCustomers($interval, $timestamp, $limit, $offset)
    {
      return $this->__soapCall('GetUpdatedCustomers', array($interval, $timestamp, $limit, $offset));
    }

    /**
     * Returns all active countries.
     *
     * @return ResultType
     */
    public function GetCountries()
    {
      return $this->__soapCall('GetCountries', array());
    }

    /**
     * Import a customer array
     *
     * @param ImportCustomerType $importcustomer
     * @return ResultType
     */
    public function ImportCustomer(ImportCustomerType $importcustomer)
    {
      return $this->__soapCall('ImportCustomer', array($importcustomer));
    }

    /**
     * Get a customer's ewallet balance and logs
     *
     * @param CustomerType $customer
     * @return ResultType
     */
    public function GetEwallet(CustomerType $customer)
    {
      return $this->__soapCall('GetEwallet', array($customer));
    }

    /**
     * Add a transaction to a customer's eWallet
     *
     * @param CustomerType $customer
     * @return ResultType
     */
    public function EwalletTransaction(CustomerType $customer)
    {
      return $this->__soapCall('EwalletTransaction', array($customer));
    }

    /**
     * Set the sort order of products
     *
     * @param string $sort_data
     * @return ResultType
     */
    public function SetProductSortOrders($sort_data)
    {
      return $this->__soapCall('SetProductSortOrders', array($sort_data));
    }

    /**
     * Add a Customer Group
     *
     * @param AddCustomerGroupType $customer_group
     * @return ResultType
     */
    public function AddCustomerGroup(AddCustomerGroupType $customer_group)
    {
      return $this->__soapCall('AddCustomerGroup', array($customer_group));
    }

    /**
     * Modify an existing Customer Group
     *
     * @param AddCustomerGroupType $customer_group
     * @return ResultType
     */
    public function ModifyCustomerGroup(AddCustomerGroupType $customer_group)
    {
      return $this->__soapCall('ModifyCustomerGroup', array($customer_group));
    }

    /**
     * Fetch details of Customer Groups
     *
     * @param int $limit
     * @param int $offset
     * @return ArrayOfCustomerGroups
     */
    public function GetCustomerGroups($limit, $offset)
    {
      return $this->__soapCall('GetCustomerGroups', array($limit, $offset));
    }

    /**
     * Fetch details of Trade Discounts
     *
     * @param int $limit
     * @param int $offset
     * @return ArrayOfTradeDiscounts
     */
    public function GetTradeDiscounts($limit, $offset)
    {
      return $this->__soapCall('GetTradeDiscounts', array($limit, $offset));
    }

    /**
     * Add a new Trade Discounts
     *
     * @param AddTradeDiscountType $trade_discount
     * @return ResultType
     */
    public function AddTradeDiscount(AddTradeDiscountType $trade_discount)
    {
      return $this->__soapCall('AddTradeDiscount', array($trade_discount));
    }

    /**
     * Update an existing Trade Discounts
     *
     * @param AddTradeDiscountType $trade_discount
     * @return ResultType
     */
    public function ModifyTradeDiscount(AddTradeDiscountType $trade_discount)
    {
      return $this->__soapCall('ModifyTradeDiscount', array($trade_discount));
    }

    /**
     * Fetch details of Websites
     *
     * @return ArrayOfWebsites
     */
    public function GetWebsites()
    {
      return $this->__soapCall('GetWebsites', array());
    }

    /**
     * Update Fraud status of an order
     *
     * @param OrderFraudUpdateType $fraud_update_data
     * @return ResultType
     */
    public function OrderFraudStatusUpdate(OrderFraudUpdateType $fraud_update_data)
    {
      return $this->__soapCall('OrderFraudStatusUpdate', array($fraud_update_data));
    }

    /**
     * Update the stock for a specific product in a specifc stock location
     *
     * @param NonEmptyStringType $product_reference
     * @param float $stock_level
     * @param NonEmptyStringType $stock_location
     * @param boolean $allow_minus_one_change
     * @return ResultType
     */
    public function SetStockInLocation($product_reference, $stock_level, $stock_location, $allow_minus_one_change)
    {
      return $this->__soapCall('SetStockInLocation', array($product_reference, $stock_level, $stock_location, $allow_minus_one_change));
    }

    /**
     * Fetch details of Newsletter Mailing Lists
     *
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetNewsletterMailingLists($limit, $offset)
    {
      return $this->__soapCall('GetNewsletterMailingLists', array($limit, $offset));
    }

    /**
     * Fetch Newsletter subscribers from a Newsletter Mailing Lists
     *
     * @param int $mailing_list_id
     * @param int $limit
     * @param int $offset
     * @param boolean $rebuild_list_first
     * @return ResultType
     */
    public function GetNewsletterMailingListSubscribers($mailing_list_id, $limit, $offset, $rebuild_list_first)
    {
      return $this->__soapCall('GetNewsletterMailingListSubscribers', array($mailing_list_id, $limit, $offset, $rebuild_list_first));
    }

    /**
     * Fetch details of Newsletter Subscriber Groups
     *
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetNewsletterSubscriberGroups($limit, $offset)
    {
      return $this->__soapCall('GetNewsletterSubscriberGroups', array($limit, $offset));
    }

    /**
     * Fetch Newsletter subscribers from a Newsletter Subscriber Group
     *
     * @param int $subscriber_group_id
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetNewsletterSubscriberGroupSubscribers($subscriber_group_id, $limit, $offset)
    {
      return $this->__soapCall('GetNewsletterSubscriberGroupSubscribers', array($subscriber_group_id, $limit, $offset));
    }

    /**
     * Add a Newsletter subscriber
     *
     * @param NewsletterSubscriberType $subscriber_data
     * @return ResultType
     */
    public function AddNewsletterSubscriber(NewsletterSubscriberType $subscriber_data)
    {
      return $this->__soapCall('AddNewsletterSubscriber', array($subscriber_data));
    }

    /**
     * Fetch details of a Newsletter subscriber
     *
     * @param NonEmptyStringType $email_address
     * @param int $website_id
     * @return ResultType
     */
    public function GetNewsletterSubscriber($email_address, $website_id)
    {
      return $this->__soapCall('GetNewsletterSubscriber', array($email_address, $website_id));
    }

    /**
     * Modify an existing Newsletter subscriber
     *
     * @param ModifyNewsletterSubscriberType $modify_subscriber_data
     * @return ResultType
     */
    public function ModifyNewsletterSubscriber(ModifyNewsletterSubscriberType $modify_subscriber_data)
    {
      return $this->__soapCall('ModifyNewsletterSubscriber', array($modify_subscriber_data));
    }

    /**
     * Get details of products updated after a specific date / time
     *
     * @param NonEmptyStringType $date_time
     * @param boolean $include_stock_updates
     * @param GetData $get_data
     * @param string $file_type
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetUpdatedProducts($date_time, $include_stock_updates, GetData $get_data, $file_type, $limit, $offset)
    {
      return $this->__soapCall('GetUpdatedProducts', array($date_time, $include_stock_updates, $get_data, $file_type, $limit, $offset));
    }

    /**
     * Get stock levels of multiple products in a single request
     *
     * @param SetStockMultipleType $stock_update_data
     * @return ResultType
     */
    public function SetStockMultiple(SetStockMultipleType $stock_update_data)
    {
      return $this->__soapCall('SetStockMultiple', array($stock_update_data));
    }

    /**
     * Change a child products stock message by id
     *
     * @param string $product_identifier
     * @param string $stock_message_identifier
     * @param boolean $using_product_reference
     * @param boolean $using_stock_message_name
     * @param int $website_id
     * @return ResultType
     */
    public function ChangeProductStockMessage($product_identifier, $stock_message_identifier, $using_product_reference, $using_stock_message_name, $website_id)
    {
      return $this->__soapCall('ChangeProductStockMessage', array($product_identifier, $stock_message_identifier, $using_product_reference, $using_stock_message_name, $website_id));
    }

    /**
     * Retrieve the current points balance for a customers or an individual customer via their CUSTOMER_ID
     *
     * @param int $customer_id
     * @param dateTime $from_date
     * @param dateTime $to_date
     * @param int $limit
     * @param int $offset
     * @return ResultType
     */
    public function GetLoyaltyPoints($customer_id, $from_date, $to_date, $limit, $offset)
    {
      return $this->__soapCall('GetLoyaltyPoints', array($customer_id, $from_date, $to_date, $limit, $offset));
    }

    /**
     * Increase or decrease the customer's existing points by the stated amount
     *
     * @param int $customer_id
     * @param float $amount
     * @return ResultType
     */
    public function LoyaltyPointTransaction($customer_id, $amount)
    {
      return $this->__soapCall('LoyaltyPointTransaction', array($customer_id, $amount));
    }

    /**
     * Check the status of an import / Export process
     *
     * @param int $exchange_id
     * @return ResultType
     */
    public function GetExchangeStatus($exchange_id)
    {
      return $this->__soapCall('GetExchangeStatus', array($exchange_id));
    }

}
