<?php

namespace Visualsoft;

class Result
{

    /**
     * @var WebOrdersContainerType $WEB_ORDERS
     */
    protected $WEB_ORDERS = null;

    /**
     * @var ProductContainerType $PRODUCTS
     */
    protected $PRODUCTS = null;

    /**
     * @var StockContainerType $STOCK
     */
    protected $STOCK = null;

    /**
     * @var CustomerExportType $CUSTOMER
     */
    protected $CUSTOMER = null;

    /**
     * @var SimpleCustomersContainerType $CUSTOMERS
     */
    protected $CUSTOMERS = null;

    /**
     * @var SortOrdersContainerType $SORT_ORDERS
     */
    protected $SORT_ORDERS = null;

    /**
     * @var boolean $Success
     */
    protected $Success = null;

    /**
     * @var string $STATUS
     */
    protected $STATUS = null;

    /**
     * @var CustomerPointsContainerType $CUSTOMER_POINTS
     */
    protected $CUSTOMER_POINTS = null;

    /**
     * @var LoyaltyPointTransactionContainerType $LOYALTY_POINT_TRANSACTION
     */
    protected $LOYALTY_POINT_TRANSACTION = null;

    /**
     * @param WebOrdersContainerType $WEB_ORDERS
     * @param ProductContainerType $PRODUCTS
     * @param StockContainerType $STOCK
     * @param CustomerExportType $CUSTOMER
     * @param SimpleCustomersContainerType $CUSTOMERS
     * @param SortOrdersContainerType $SORT_ORDERS
     * @param boolean $Success
     * @param string $STATUS
     * @param CustomerPointsContainerType $CUSTOMER_POINTS
     * @param LoyaltyPointTransactionContainerType $LOYALTY_POINT_TRANSACTION
     */
    public function __construct($WEB_ORDERS, $PRODUCTS, $STOCK, $CUSTOMER, $CUSTOMERS, $SORT_ORDERS, $Success, $STATUS, $CUSTOMER_POINTS, $LOYALTY_POINT_TRANSACTION)
    {
      $this->WEB_ORDERS = $WEB_ORDERS;
      $this->PRODUCTS = $PRODUCTS;
      $this->STOCK = $STOCK;
      $this->CUSTOMER = $CUSTOMER;
      $this->CUSTOMERS = $CUSTOMERS;
      $this->SORT_ORDERS = $SORT_ORDERS;
      $this->Success = $Success;
      $this->STATUS = $STATUS;
      $this->CUSTOMER_POINTS = $CUSTOMER_POINTS;
      $this->LOYALTY_POINT_TRANSACTION = $LOYALTY_POINT_TRANSACTION;
    }

    /**
     * @return WebOrdersContainerType
     */
    public function getWEB_ORDERS()
    {
      return $this->WEB_ORDERS;
    }

    /**
     * @param WebOrdersContainerType $WEB_ORDERS
     * @return \Visualsoft\Result
     */
    public function setWEB_ORDERS($WEB_ORDERS)
    {
      $this->WEB_ORDERS = $WEB_ORDERS;
      return $this;
    }

    /**
     * @return ProductContainerType
     */
    public function getPRODUCTS()
    {
      return $this->PRODUCTS;
    }

    /**
     * @param ProductContainerType $PRODUCTS
     * @return \Visualsoft\Result
     */
    public function setPRODUCTS($PRODUCTS)
    {
      $this->PRODUCTS = $PRODUCTS;
      return $this;
    }

    /**
     * @return StockContainerType
     */
    public function getSTOCK()
    {
      return $this->STOCK;
    }

    /**
     * @param StockContainerType $STOCK
     * @return \Visualsoft\Result
     */
    public function setSTOCK($STOCK)
    {
      $this->STOCK = $STOCK;
      return $this;
    }

    /**
     * @return CustomerExportType
     */
    public function getCUSTOMER()
    {
      return $this->CUSTOMER;
    }

    /**
     * @param CustomerExportType $CUSTOMER
     * @return \Visualsoft\Result
     */
    public function setCUSTOMER($CUSTOMER)
    {
      $this->CUSTOMER = $CUSTOMER;
      return $this;
    }

    /**
     * @return SimpleCustomersContainerType
     */
    public function getCUSTOMERS()
    {
      return $this->CUSTOMERS;
    }

    /**
     * @param SimpleCustomersContainerType $CUSTOMERS
     * @return \Visualsoft\Result
     */
    public function setCUSTOMERS($CUSTOMERS)
    {
      $this->CUSTOMERS = $CUSTOMERS;
      return $this;
    }

    /**
     * @return SortOrdersContainerType
     */
    public function getSORT_ORDERS()
    {
      return $this->SORT_ORDERS;
    }

    /**
     * @param SortOrdersContainerType $SORT_ORDERS
     * @return \Visualsoft\Result
     */
    public function setSORT_ORDERS($SORT_ORDERS)
    {
      $this->SORT_ORDERS = $SORT_ORDERS;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getSuccess()
    {
      return $this->Success;
    }

    /**
     * @param boolean $Success
     * @return \Visualsoft\Result
     */
    public function setSuccess($Success)
    {
      $this->Success = $Success;
      return $this;
    }

    /**
     * @return string
     */
    public function getSTATUS()
    {
      return $this->STATUS;
    }

    /**
     * @param string $STATUS
     * @return \Visualsoft\Result
     */
    public function setSTATUS($STATUS)
    {
      $this->STATUS = $STATUS;
      return $this;
    }

    /**
     * @return CustomerPointsContainerType
     */
    public function getCUSTOMER_POINTS()
    {
      return $this->CUSTOMER_POINTS;
    }

    /**
     * @param CustomerPointsContainerType $CUSTOMER_POINTS
     * @return \Visualsoft\Result
     */
    public function setCUSTOMER_POINTS($CUSTOMER_POINTS)
    {
      $this->CUSTOMER_POINTS = $CUSTOMER_POINTS;
      return $this;
    }

    /**
     * @return LoyaltyPointTransactionContainerType
     */
    public function getLOYALTY_POINT_TRANSACTION()
    {
      return $this->LOYALTY_POINT_TRANSACTION;
    }

    /**
     * @param LoyaltyPointTransactionContainerType $LOYALTY_POINT_TRANSACTION
     * @return \Visualsoft\Result
     */
    public function setLOYALTY_POINT_TRANSACTION($LOYALTY_POINT_TRANSACTION)
    {
      $this->LOYALTY_POINT_TRANSACTION = $LOYALTY_POINT_TRANSACTION;
      return $this;
    }

}
