<?php

namespace Visualsoft;

class OrderProductType
{

    /**
     * @var int $ORDER_PRODUCT_ID
     */
    protected $ORDER_PRODUCT_ID = null;

    /**
     * @var int $PRODUCT_ID
     */
    protected $PRODUCT_ID = null;

    /**
     * @var string $PARENT_PRODUCT_REFERENCE
     */
    protected $PARENT_PRODUCT_REFERENCE = null;

    /**
     * @var string $CHILD_PRODUCT_REFERENCE
     */
    protected $CHILD_PRODUCT_REFERENCE = null;

    /**
     * @var string $PRODUCT_REFERENCE
     */
    protected $PRODUCT_REFERENCE = null;

    /**
     * @var string $MODEL
     */
    protected $MODEL = null;

    /**
     * @var string $CHILD_PRODUCT_MODEL
     */
    protected $CHILD_PRODUCT_MODEL = null;

    /**
     * @var string $EAN
     */
    protected $EAN = null;

    /**
     * @var string $MANUFACTURER_NAME
     */
    protected $MANUFACTURER_NAME = null;

    /**
     * @var string $TITLE
     */
    protected $TITLE = null;

    /**
     * @var string $SUMMARY
     */
    protected $SUMMARY = null;

    /**
     * @var OrderProductCategoriesContainerType $CATEGORIES
     */
    protected $CATEGORIES = null;

    /**
     * @var int $QUANTITY
     */
    protected $QUANTITY = null;

    /**
     * @var float $PRICE_INC
     */
    protected $PRICE_INC = null;

    /**
     * @var float $PRICE_EX
     */
    protected $PRICE_EX = null;

    /**
     * @var float $PRICE_VAT
     */
    protected $PRICE_VAT = null;

    /**
     * @var float $DISCOUNT_PRICE_INC
     */
    protected $DISCOUNT_PRICE_INC = null;

    /**
     * @var float $DISCOUNT_PRICE_EX
     */
    protected $DISCOUNT_PRICE_EX = null;

    /**
     * @var float $DISCOUNT_PRICE_VAT
     */
    protected $DISCOUNT_PRICE_VAT = null;

    /**
     * @var float $TAX_RATE
     */
    protected $TAX_RATE = null;

    /**
     * @var string $GIFT_WRAP_METHOD
     */
    protected $GIFT_WRAP_METHOD = null;

    /**
     * @var string $GIFT_WRAP_COST_INC
     */
    protected $GIFT_WRAP_COST_INC = null;

    /**
     * @var string $GIFT_WRAP_COST_NET
     */
    protected $GIFT_WRAP_COST_NET = null;

    /**
     * @var string $GIFT_WRAP_TAX
     */
    protected $GIFT_WRAP_TAX = null;

    /**
     * @var string $GIFT_WRAP_MESSAGE
     */
    protected $GIFT_WRAP_MESSAGE = null;

    /**
     * @var OrderProductPersonalisationType $PERSONALISATIONS
     */
    protected $PERSONALISATIONS = null;

    /**
     * @var OrderProductComponentContainerType $COMPONENTS
     */
    protected $COMPONENTS = null;

    /**
     * @var string $ACTIVE
     */
    protected $ACTIVE = null;

    /**
     * @var string $RETURN_REASON
     */
    protected $RETURN_REASON = null;

    /**
     * @var float $WEIGHT
     */
    protected $WEIGHT = null;

    /**
     * @var STOCK_MESSAGE $STOCK_MESSAGE
     */
    protected $STOCK_MESSAGE = null;

    /**
     * @var string $PICK_LOCATION
     */
    protected $PICK_LOCATION = null;

    /**
     * @var STOCK_LOCATION $STOCK_LOCATION
     */
    protected $STOCK_LOCATION = null;

    /**
     * @var BRANCH_FULFILMENT $BRANCH_FULFILMENT
     */
    protected $BRANCH_FULFILMENT = null;

    /**
     * @var string $SUPPLIER
     */
    protected $SUPPLIER = null;

    /**
     * @param int $ORDER_PRODUCT_ID
     * @param int $PRODUCT_ID
     * @param string $PARENT_PRODUCT_REFERENCE
     * @param string $CHILD_PRODUCT_REFERENCE
     * @param string $PRODUCT_REFERENCE
     * @param string $MODEL
     * @param string $CHILD_PRODUCT_MODEL
     * @param string $EAN
     * @param string $MANUFACTURER_NAME
     * @param string $TITLE
     * @param string $SUMMARY
     * @param int $QUANTITY
     * @param float $PRICE_INC
     * @param float $PRICE_EX
     * @param float $PRICE_VAT
     * @param float $DISCOUNT_PRICE_INC
     * @param float $DISCOUNT_PRICE_EX
     * @param float $DISCOUNT_PRICE_VAT
     * @param float $TAX_RATE
     */
    public function __construct($ORDER_PRODUCT_ID, $PRODUCT_ID, $PARENT_PRODUCT_REFERENCE, $CHILD_PRODUCT_REFERENCE, $PRODUCT_REFERENCE, $MODEL, $CHILD_PRODUCT_MODEL, $EAN, $MANUFACTURER_NAME, $TITLE, $SUMMARY, $QUANTITY, $PRICE_INC, $PRICE_EX, $PRICE_VAT, $DISCOUNT_PRICE_INC, $DISCOUNT_PRICE_EX, $DISCOUNT_PRICE_VAT, $TAX_RATE)
    {
      $this->ORDER_PRODUCT_ID = $ORDER_PRODUCT_ID;
      $this->PRODUCT_ID = $PRODUCT_ID;
      $this->PARENT_PRODUCT_REFERENCE = $PARENT_PRODUCT_REFERENCE;
      $this->CHILD_PRODUCT_REFERENCE = $CHILD_PRODUCT_REFERENCE;
      $this->PRODUCT_REFERENCE = $PRODUCT_REFERENCE;
      $this->MODEL = $MODEL;
      $this->CHILD_PRODUCT_MODEL = $CHILD_PRODUCT_MODEL;
      $this->EAN = $EAN;
      $this->MANUFACTURER_NAME = $MANUFACTURER_NAME;
      $this->TITLE = $TITLE;
      $this->SUMMARY = $SUMMARY;
      $this->QUANTITY = $QUANTITY;
      $this->PRICE_INC = $PRICE_INC;
      $this->PRICE_EX = $PRICE_EX;
      $this->PRICE_VAT = $PRICE_VAT;
      $this->DISCOUNT_PRICE_INC = $DISCOUNT_PRICE_INC;
      $this->DISCOUNT_PRICE_EX = $DISCOUNT_PRICE_EX;
      $this->DISCOUNT_PRICE_VAT = $DISCOUNT_PRICE_VAT;
      $this->TAX_RATE = $TAX_RATE;
    }

    /**
     * @return int
     */
    public function getORDER_PRODUCT_ID()
    {
      return $this->ORDER_PRODUCT_ID;
    }

    /**
     * @param int $ORDER_PRODUCT_ID
     * @return \Visualsoft\OrderProductType
     */
    public function setORDER_PRODUCT_ID($ORDER_PRODUCT_ID)
    {
      $this->ORDER_PRODUCT_ID = $ORDER_PRODUCT_ID;
      return $this;
    }

    /**
     * @return int
     */
    public function getPRODUCT_ID()
    {
      return $this->PRODUCT_ID;
    }

    /**
     * @param int $PRODUCT_ID
     * @return \Visualsoft\OrderProductType
     */
    public function setPRODUCT_ID($PRODUCT_ID)
    {
      $this->PRODUCT_ID = $PRODUCT_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getPARENT_PRODUCT_REFERENCE()
    {
      return $this->PARENT_PRODUCT_REFERENCE;
    }

    /**
     * @param string $PARENT_PRODUCT_REFERENCE
     * @return \Visualsoft\OrderProductType
     */
    public function setPARENT_PRODUCT_REFERENCE($PARENT_PRODUCT_REFERENCE)
    {
      $this->PARENT_PRODUCT_REFERENCE = $PARENT_PRODUCT_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCHILD_PRODUCT_REFERENCE()
    {
      return $this->CHILD_PRODUCT_REFERENCE;
    }

    /**
     * @param string $CHILD_PRODUCT_REFERENCE
     * @return \Visualsoft\OrderProductType
     */
    public function setCHILD_PRODUCT_REFERENCE($CHILD_PRODUCT_REFERENCE)
    {
      $this->CHILD_PRODUCT_REFERENCE = $CHILD_PRODUCT_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getPRODUCT_REFERENCE()
    {
      return $this->PRODUCT_REFERENCE;
    }

    /**
     * @param string $PRODUCT_REFERENCE
     * @return \Visualsoft\OrderProductType
     */
    public function setPRODUCT_REFERENCE($PRODUCT_REFERENCE)
    {
      $this->PRODUCT_REFERENCE = $PRODUCT_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getMODEL()
    {
      return $this->MODEL;
    }

    /**
     * @param string $MODEL
     * @return \Visualsoft\OrderProductType
     */
    public function setMODEL($MODEL)
    {
      $this->MODEL = $MODEL;
      return $this;
    }

    /**
     * @return string
     */
    public function getCHILD_PRODUCT_MODEL()
    {
      return $this->CHILD_PRODUCT_MODEL;
    }

    /**
     * @param string $CHILD_PRODUCT_MODEL
     * @return \Visualsoft\OrderProductType
     */
    public function setCHILD_PRODUCT_MODEL($CHILD_PRODUCT_MODEL)
    {
      $this->CHILD_PRODUCT_MODEL = $CHILD_PRODUCT_MODEL;
      return $this;
    }

    /**
     * @return string
     */
    public function getEAN()
    {
      return $this->EAN;
    }

    /**
     * @param string $EAN
     * @return \Visualsoft\OrderProductType
     */
    public function setEAN($EAN)
    {
      $this->EAN = $EAN;
      return $this;
    }

    /**
     * @return string
     */
    public function getMANUFACTURER_NAME()
    {
      return $this->MANUFACTURER_NAME;
    }

    /**
     * @param string $MANUFACTURER_NAME
     * @return \Visualsoft\OrderProductType
     */
    public function setMANUFACTURER_NAME($MANUFACTURER_NAME)
    {
      $this->MANUFACTURER_NAME = $MANUFACTURER_NAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getTITLE()
    {
      return $this->TITLE;
    }

    /**
     * @param string $TITLE
     * @return \Visualsoft\OrderProductType
     */
    public function setTITLE($TITLE)
    {
      $this->TITLE = $TITLE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSUMMARY()
    {
      return $this->SUMMARY;
    }

    /**
     * @param string $SUMMARY
     * @return \Visualsoft\OrderProductType
     */
    public function setSUMMARY($SUMMARY)
    {
      $this->SUMMARY = $SUMMARY;
      return $this;
    }

    /**
     * @return OrderProductCategoriesContainerType
     */
    public function getCATEGORIES()
    {
      return $this->CATEGORIES;
    }

    /**
     * @param OrderProductCategoriesContainerType $CATEGORIES
     * @return \Visualsoft\OrderProductType
     */
    public function setCATEGORIES($CATEGORIES)
    {
      $this->CATEGORIES = $CATEGORIES;
      return $this;
    }

    /**
     * @return int
     */
    public function getQUANTITY()
    {
      return $this->QUANTITY;
    }

    /**
     * @param int $QUANTITY
     * @return \Visualsoft\OrderProductType
     */
    public function setQUANTITY($QUANTITY)
    {
      $this->QUANTITY = $QUANTITY;
      return $this;
    }

    /**
     * @return float
     */
    public function getPRICE_INC()
    {
      return $this->PRICE_INC;
    }

    /**
     * @param float $PRICE_INC
     * @return \Visualsoft\OrderProductType
     */
    public function setPRICE_INC($PRICE_INC)
    {
      $this->PRICE_INC = $PRICE_INC;
      return $this;
    }

    /**
     * @return float
     */
    public function getPRICE_EX()
    {
      return $this->PRICE_EX;
    }

    /**
     * @param float $PRICE_EX
     * @return \Visualsoft\OrderProductType
     */
    public function setPRICE_EX($PRICE_EX)
    {
      $this->PRICE_EX = $PRICE_EX;
      return $this;
    }

    /**
     * @return float
     */
    public function getPRICE_VAT()
    {
      return $this->PRICE_VAT;
    }

    /**
     * @param float $PRICE_VAT
     * @return \Visualsoft\OrderProductType
     */
    public function setPRICE_VAT($PRICE_VAT)
    {
      $this->PRICE_VAT = $PRICE_VAT;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_PRICE_INC()
    {
      return $this->DISCOUNT_PRICE_INC;
    }

    /**
     * @param float $DISCOUNT_PRICE_INC
     * @return \Visualsoft\OrderProductType
     */
    public function setDISCOUNT_PRICE_INC($DISCOUNT_PRICE_INC)
    {
      $this->DISCOUNT_PRICE_INC = $DISCOUNT_PRICE_INC;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_PRICE_EX()
    {
      return $this->DISCOUNT_PRICE_EX;
    }

    /**
     * @param float $DISCOUNT_PRICE_EX
     * @return \Visualsoft\OrderProductType
     */
    public function setDISCOUNT_PRICE_EX($DISCOUNT_PRICE_EX)
    {
      $this->DISCOUNT_PRICE_EX = $DISCOUNT_PRICE_EX;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_PRICE_VAT()
    {
      return $this->DISCOUNT_PRICE_VAT;
    }

    /**
     * @param float $DISCOUNT_PRICE_VAT
     * @return \Visualsoft\OrderProductType
     */
    public function setDISCOUNT_PRICE_VAT($DISCOUNT_PRICE_VAT)
    {
      $this->DISCOUNT_PRICE_VAT = $DISCOUNT_PRICE_VAT;
      return $this;
    }

    /**
     * @return float
     */
    public function getTAX_RATE()
    {
      return $this->TAX_RATE;
    }

    /**
     * @param float $TAX_RATE
     * @return \Visualsoft\OrderProductType
     */
    public function setTAX_RATE($TAX_RATE)
    {
      $this->TAX_RATE = $TAX_RATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getGIFT_WRAP_METHOD()
    {
      return $this->GIFT_WRAP_METHOD;
    }

    /**
     * @param string $GIFT_WRAP_METHOD
     * @return \Visualsoft\OrderProductType
     */
    public function setGIFT_WRAP_METHOD($GIFT_WRAP_METHOD)
    {
      $this->GIFT_WRAP_METHOD = $GIFT_WRAP_METHOD;
      return $this;
    }

    /**
     * @return string
     */
    public function getGIFT_WRAP_COST_INC()
    {
      return $this->GIFT_WRAP_COST_INC;
    }

    /**
     * @param string $GIFT_WRAP_COST_INC
     * @return \Visualsoft\OrderProductType
     */
    public function setGIFT_WRAP_COST_INC($GIFT_WRAP_COST_INC)
    {
      $this->GIFT_WRAP_COST_INC = $GIFT_WRAP_COST_INC;
      return $this;
    }

    /**
     * @return string
     */
    public function getGIFT_WRAP_COST_NET()
    {
      return $this->GIFT_WRAP_COST_NET;
    }

    /**
     * @param string $GIFT_WRAP_COST_NET
     * @return \Visualsoft\OrderProductType
     */
    public function setGIFT_WRAP_COST_NET($GIFT_WRAP_COST_NET)
    {
      $this->GIFT_WRAP_COST_NET = $GIFT_WRAP_COST_NET;
      return $this;
    }

    /**
     * @return string
     */
    public function getGIFT_WRAP_TAX()
    {
      return $this->GIFT_WRAP_TAX;
    }

    /**
     * @param string $GIFT_WRAP_TAX
     * @return \Visualsoft\OrderProductType
     */
    public function setGIFT_WRAP_TAX($GIFT_WRAP_TAX)
    {
      $this->GIFT_WRAP_TAX = $GIFT_WRAP_TAX;
      return $this;
    }

    /**
     * @return string
     */
    public function getGIFT_WRAP_MESSAGE()
    {
      return $this->GIFT_WRAP_MESSAGE;
    }

    /**
     * @param string $GIFT_WRAP_MESSAGE
     * @return \Visualsoft\OrderProductType
     */
    public function setGIFT_WRAP_MESSAGE($GIFT_WRAP_MESSAGE)
    {
      $this->GIFT_WRAP_MESSAGE = $GIFT_WRAP_MESSAGE;
      return $this;
    }

    /**
     * @return OrderProductPersonalisationType
     */
    public function getPERSONALISATIONS()
    {
      return $this->PERSONALISATIONS;
    }

    /**
     * @param OrderProductPersonalisationType $PERSONALISATIONS
     * @return \Visualsoft\OrderProductType
     */
    public function setPERSONALISATIONS($PERSONALISATIONS)
    {
      $this->PERSONALISATIONS = $PERSONALISATIONS;
      return $this;
    }

    /**
     * @return OrderProductComponentContainerType
     */
    public function getCOMPONENTS()
    {
      return $this->COMPONENTS;
    }

    /**
     * @param OrderProductComponentContainerType $COMPONENTS
     * @return \Visualsoft\OrderProductType
     */
    public function setCOMPONENTS($COMPONENTS)
    {
      $this->COMPONENTS = $COMPONENTS;
      return $this;
    }

    /**
     * @return string
     */
    public function getACTIVE()
    {
      return $this->ACTIVE;
    }

    /**
     * @param string $ACTIVE
     * @return \Visualsoft\OrderProductType
     */
    public function setACTIVE($ACTIVE)
    {
      $this->ACTIVE = $ACTIVE;
      return $this;
    }

    /**
     * @return string
     */
    public function getRETURN_REASON()
    {
      return $this->RETURN_REASON;
    }

    /**
     * @param string $RETURN_REASON
     * @return \Visualsoft\OrderProductType
     */
    public function setRETURN_REASON($RETURN_REASON)
    {
      $this->RETURN_REASON = $RETURN_REASON;
      return $this;
    }

    /**
     * @return float
     */
    public function getWEIGHT()
    {
      return $this->WEIGHT;
    }

    /**
     * @param float $WEIGHT
     * @return \Visualsoft\OrderProductType
     */
    public function setWEIGHT($WEIGHT)
    {
      $this->WEIGHT = $WEIGHT;
      return $this;
    }

    /**
     * @return STOCK_MESSAGE
     */
    public function getSTOCK_MESSAGE()
    {
      return $this->STOCK_MESSAGE;
    }

    /**
     * @param STOCK_MESSAGE $STOCK_MESSAGE
     * @return \Visualsoft\OrderProductType
     */
    public function setSTOCK_MESSAGE($STOCK_MESSAGE)
    {
      $this->STOCK_MESSAGE = $STOCK_MESSAGE;
      return $this;
    }

    /**
     * @return string
     */
    public function getPICK_LOCATION()
    {
      return $this->PICK_LOCATION;
    }

    /**
     * @param string $PICK_LOCATION
     * @return \Visualsoft\OrderProductType
     */
    public function setPICK_LOCATION($PICK_LOCATION)
    {
      $this->PICK_LOCATION = $PICK_LOCATION;
      return $this;
    }

    /**
     * @return STOCK_LOCATION
     */
    public function getSTOCK_LOCATION()
    {
      return $this->STOCK_LOCATION;
    }

    /**
     * @param STOCK_LOCATION $STOCK_LOCATION
     * @return \Visualsoft\OrderProductType
     */
    public function setSTOCK_LOCATION($STOCK_LOCATION)
    {
      $this->STOCK_LOCATION = $STOCK_LOCATION;
      return $this;
    }

    /**
     * @return BRANCH_FULFILMENT
     */
    public function getBRANCH_FULFILMENT()
    {
      return $this->BRANCH_FULFILMENT;
    }

    /**
     * @param BRANCH_FULFILMENT $BRANCH_FULFILMENT
     * @return \Visualsoft\OrderProductType
     */
    public function setBRANCH_FULFILMENT($BRANCH_FULFILMENT)
    {
      $this->BRANCH_FULFILMENT = $BRANCH_FULFILMENT;
      return $this;
    }

    /**
     * @return string
     */
    public function getSUPPLIER()
    {
      return $this->SUPPLIER;
    }

    /**
     * @param string $SUPPLIER
     * @return \Visualsoft\OrderProductType
     */
    public function setSUPPLIER($SUPPLIER)
    {
      $this->SUPPLIER = $SUPPLIER;
      return $this;
    }

}
