<?php

namespace Visualsoft;

class OrderDetailsType
{

    /**
     * @var int $ORDER_ID
     */
    protected $ORDER_ID = null;

    /**
     * @var int $WEBSITE_ID
     */
    protected $WEBSITE_ID = null;

    /**
     * @var string $ORDER_REFERENCE
     */
    protected $ORDER_REFERENCE = null;

    /**
     * @var int $ORDER_STATUS_ID
     */
    protected $ORDER_STATUS_ID = null;

    /**
     * @var string $ORDER_STATUS
     */
    protected $ORDER_STATUS = null;

    /**
     * @var string $AMAZON_PRIME
     */
    protected $AMAZON_PRIME = null;

    /**
     * @var string $IS_SPLIT_PARENT
     */
    protected $IS_SPLIT_PARENT = null;

    /**
     * @var int $PARENT_ORDER_ID
     */
    protected $PARENT_ORDER_ID = null;

    /**
     * @var int $ORDER_FRAUD_STATE_ID
     */
    protected $ORDER_FRAUD_STATE_ID = null;

    /**
     * @var string $ORDER_DATE
     */
    protected $ORDER_DATE = null;

    /**
     * @var string $UPDATED_DATE
     */
    protected $UPDATED_DATE = null;

    /**
     * @var string $DISPATCH_DATE
     */
    protected $DISPATCH_DATE = null;

    /**
     * @var string $DELIVERY_DATE
     */
    protected $DELIVERY_DATE = null;

    /**
     * @var string $ESTIMATED_DELIVERY_DATE
     */
    protected $ESTIMATED_DELIVERY_DATE = null;

    /**
     * @var string $DOWNLOADED
     */
    protected $DOWNLOADED = null;

    /**
     * @var string $DOWNLOADED_DATE
     */
    protected $DOWNLOADED_DATE = null;

    /**
     * @var float $PRODUCT_TOTAL_INC
     */
    protected $PRODUCT_TOTAL_INC = null;

    /**
     * @var float $PRODUCT_TOTAL_EX
     */
    protected $PRODUCT_TOTAL_EX = null;

    /**
     * @var float $PRODUCT_TOTAL_VAT
     */
    protected $PRODUCT_TOTAL_VAT = null;

    /**
     * @var float $SHIPPING_TOTAL_INC
     */
    protected $SHIPPING_TOTAL_INC = null;

    /**
     * @var float $SHIPPING_TOTAL_EX
     */
    protected $SHIPPING_TOTAL_EX = null;

    /**
     * @var float $SHIPPING_TOTAL_VAT
     */
    protected $SHIPPING_TOTAL_VAT = null;

    /**
     * @var float $DISCOUNT_TOTAL_INC
     */
    protected $DISCOUNT_TOTAL_INC = null;

    /**
     * @var float $DISCOUNT_TOTAL_EX
     */
    protected $DISCOUNT_TOTAL_EX = null;

    /**
     * @var float $DISCOUNT_TOTAL_VAT
     */
    protected $DISCOUNT_TOTAL_VAT = null;

    /**
     * @var float $GRAND_TOTAL_INC
     */
    protected $GRAND_TOTAL_INC = null;

    /**
     * @var float $GRAND_TOTAL_EX
     */
    protected $GRAND_TOTAL_EX = null;

    /**
     * @var float $GRAND_TOTAL_VAT
     */
    protected $GRAND_TOTAL_VAT = null;

    /**
     * @var string $TAX_COLLECTION_ID
     */
    protected $TAX_COLLECTION_ID = null;

    /**
     * @var float $CURRENCY_RATE_USED
     */
    protected $CURRENCY_RATE_USED = null;

    /**
     * @var string $ORDER_CURRENCY
     */
    protected $ORDER_CURRENCY = null;

    /**
     * @var string $ORDER_CUSTOMER_COMMENTS
     */
    protected $ORDER_CUSTOMER_COMMENTS = null;

    /**
     * @var string $ORDER_NOTES
     */
    protected $ORDER_NOTES = null;

    /**
     * @var string $ORDER_TYPE
     */
    protected $ORDER_TYPE = null;

    /**
     * @var string $ORDER_REFERER
     */
    protected $ORDER_REFERER = null;

    /**
     * @var string $DELIVERY_METHOD
     */
    protected $DELIVERY_METHOD = null;

    /**
     * @var float $GIFTWRAP_TOTAL_INC
     */
    protected $GIFTWRAP_TOTAL_INC = null;

    /**
     * @var float $GIFTWRAP_TOTAL_NET
     */
    protected $GIFTWRAP_TOTAL_NET = null;

    /**
     * @var float $GIFTWRAP_TOTAL_VAT
     */
    protected $GIFTWRAP_TOTAL_VAT = null;

    /**
     * @var int $NUMBER_PRODUCTS
     */
    protected $NUMBER_PRODUCTS = null;

    /**
     * @var MULTICHANNEL_SOURCE $MULTICHANNEL_SOURCE
     */
    protected $MULTICHANNEL_SOURCE = null;

    /**
     * @var string $COURIER_STOCK_SYSTEM_REFERENCE_CODE
     */
    protected $COURIER_STOCK_SYSTEM_REFERENCE_CODE = null;

    /**
     * @var string $PO_NUMBER
     */
    protected $PO_NUMBER = null;

    /**
     * @var string $CUSTOMER_DELIVERY_NOTES
     */
    protected $CUSTOMER_DELIVERY_NOTES = null;

    /**
     * @var string $BRANCH_INTERNAL_REFERENCE
     */
    protected $BRANCH_INTERNAL_REFERENCE = null;

    /**
     * @var TRACKING_INFO $TRACKING_INFO
     */
    protected $TRACKING_INFO = null;

    /**
     * @var string $ORDER_IS_GIFT
     */
    protected $ORDER_IS_GIFT = null;

    /**
     * @param int $ORDER_ID
     * @param int $WEBSITE_ID
     * @param string $ORDER_REFERENCE
     * @param int $ORDER_STATUS_ID
     * @param string $ORDER_STATUS
     * @param string $AMAZON_PRIME
     * @param int $ORDER_FRAUD_STATE_ID
     * @param string $ORDER_DATE
     * @param string $UPDATED_DATE
     * @param string $DISPATCH_DATE
     * @param string $DOWNLOADED
     * @param string $DOWNLOADED_DATE
     * @param float $PRODUCT_TOTAL_INC
     * @param float $PRODUCT_TOTAL_EX
     * @param float $PRODUCT_TOTAL_VAT
     * @param float $SHIPPING_TOTAL_INC
     * @param float $SHIPPING_TOTAL_EX
     * @param float $SHIPPING_TOTAL_VAT
     * @param float $DISCOUNT_TOTAL_INC
     * @param float $DISCOUNT_TOTAL_EX
     * @param float $DISCOUNT_TOTAL_VAT
     * @param float $GRAND_TOTAL_INC
     * @param float $GRAND_TOTAL_EX
     * @param float $GRAND_TOTAL_VAT
     * @param string $TAX_COLLECTION_ID
     * @param float $CURRENCY_RATE_USED
     * @param string $ORDER_CURRENCY
     * @param string $ORDER_CUSTOMER_COMMENTS
     * @param string $ORDER_NOTES
     * @param string $ORDER_TYPE
     * @param string $ORDER_REFERER
     * @param string $DELIVERY_METHOD
     * @param float $GIFTWRAP_TOTAL_INC
     * @param float $GIFTWRAP_TOTAL_NET
     * @param float $GIFTWRAP_TOTAL_VAT
     * @param int $NUMBER_PRODUCTS
     * @param string $CUSTOMER_DELIVERY_NOTES
     * @param string $ORDER_IS_GIFT
     */
    public function __construct($ORDER_ID, $WEBSITE_ID, $ORDER_REFERENCE, $ORDER_STATUS_ID, $ORDER_STATUS, $AMAZON_PRIME, $ORDER_FRAUD_STATE_ID, $ORDER_DATE, $UPDATED_DATE, $DISPATCH_DATE, $DOWNLOADED, $DOWNLOADED_DATE, $PRODUCT_TOTAL_INC, $PRODUCT_TOTAL_EX, $PRODUCT_TOTAL_VAT, $SHIPPING_TOTAL_INC, $SHIPPING_TOTAL_EX, $SHIPPING_TOTAL_VAT, $DISCOUNT_TOTAL_INC, $DISCOUNT_TOTAL_EX, $DISCOUNT_TOTAL_VAT, $GRAND_TOTAL_INC, $GRAND_TOTAL_EX, $GRAND_TOTAL_VAT, $TAX_COLLECTION_ID, $CURRENCY_RATE_USED, $ORDER_CURRENCY, $ORDER_CUSTOMER_COMMENTS, $ORDER_NOTES, $ORDER_TYPE, $ORDER_REFERER, $DELIVERY_METHOD, $GIFTWRAP_TOTAL_INC, $GIFTWRAP_TOTAL_NET, $GIFTWRAP_TOTAL_VAT, $NUMBER_PRODUCTS, $CUSTOMER_DELIVERY_NOTES, $ORDER_IS_GIFT)
    {
      $this->ORDER_ID = $ORDER_ID;
      $this->WEBSITE_ID = $WEBSITE_ID;
      $this->ORDER_REFERENCE = $ORDER_REFERENCE;
      $this->ORDER_STATUS_ID = $ORDER_STATUS_ID;
      $this->ORDER_STATUS = $ORDER_STATUS;
      $this->AMAZON_PRIME = $AMAZON_PRIME;
      $this->ORDER_FRAUD_STATE_ID = $ORDER_FRAUD_STATE_ID;
      $this->ORDER_DATE = $ORDER_DATE;
      $this->UPDATED_DATE = $UPDATED_DATE;
      $this->DISPATCH_DATE = $DISPATCH_DATE;
      $this->DOWNLOADED = $DOWNLOADED;
      $this->DOWNLOADED_DATE = $DOWNLOADED_DATE;
      $this->PRODUCT_TOTAL_INC = $PRODUCT_TOTAL_INC;
      $this->PRODUCT_TOTAL_EX = $PRODUCT_TOTAL_EX;
      $this->PRODUCT_TOTAL_VAT = $PRODUCT_TOTAL_VAT;
      $this->SHIPPING_TOTAL_INC = $SHIPPING_TOTAL_INC;
      $this->SHIPPING_TOTAL_EX = $SHIPPING_TOTAL_EX;
      $this->SHIPPING_TOTAL_VAT = $SHIPPING_TOTAL_VAT;
      $this->DISCOUNT_TOTAL_INC = $DISCOUNT_TOTAL_INC;
      $this->DISCOUNT_TOTAL_EX = $DISCOUNT_TOTAL_EX;
      $this->DISCOUNT_TOTAL_VAT = $DISCOUNT_TOTAL_VAT;
      $this->GRAND_TOTAL_INC = $GRAND_TOTAL_INC;
      $this->GRAND_TOTAL_EX = $GRAND_TOTAL_EX;
      $this->GRAND_TOTAL_VAT = $GRAND_TOTAL_VAT;
      $this->TAX_COLLECTION_ID = $TAX_COLLECTION_ID;
      $this->CURRENCY_RATE_USED = $CURRENCY_RATE_USED;
      $this->ORDER_CURRENCY = $ORDER_CURRENCY;
      $this->ORDER_CUSTOMER_COMMENTS = $ORDER_CUSTOMER_COMMENTS;
      $this->ORDER_NOTES = $ORDER_NOTES;
      $this->ORDER_TYPE = $ORDER_TYPE;
      $this->ORDER_REFERER = $ORDER_REFERER;
      $this->DELIVERY_METHOD = $DELIVERY_METHOD;
      $this->GIFTWRAP_TOTAL_INC = $GIFTWRAP_TOTAL_INC;
      $this->GIFTWRAP_TOTAL_NET = $GIFTWRAP_TOTAL_NET;
      $this->GIFTWRAP_TOTAL_VAT = $GIFTWRAP_TOTAL_VAT;
      $this->NUMBER_PRODUCTS = $NUMBER_PRODUCTS;
      $this->CUSTOMER_DELIVERY_NOTES = $CUSTOMER_DELIVERY_NOTES;
      $this->ORDER_IS_GIFT = $ORDER_IS_GIFT;
    }

    /**
     * @return int
     */
    public function getORDER_ID()
    {
      return $this->ORDER_ID;
    }

    /**
     * @param int $ORDER_ID
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_ID($ORDER_ID)
    {
      $this->ORDER_ID = $ORDER_ID;
      return $this;
    }

    /**
     * @return int
     */
    public function getWEBSITE_ID()
    {
      return $this->WEBSITE_ID;
    }

    /**
     * @param int $WEBSITE_ID
     * @return \Visualsoft\OrderDetailsType
     */
    public function setWEBSITE_ID($WEBSITE_ID)
    {
      $this->WEBSITE_ID = $WEBSITE_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_REFERENCE()
    {
      return $this->ORDER_REFERENCE;
    }

    /**
     * @param string $ORDER_REFERENCE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_REFERENCE($ORDER_REFERENCE)
    {
      $this->ORDER_REFERENCE = $ORDER_REFERENCE;
      return $this;
    }

    /**
     * @return int
     */
    public function getORDER_STATUS_ID()
    {
      return $this->ORDER_STATUS_ID;
    }

    /**
     * @param int $ORDER_STATUS_ID
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_STATUS_ID($ORDER_STATUS_ID)
    {
      $this->ORDER_STATUS_ID = $ORDER_STATUS_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_STATUS()
    {
      return $this->ORDER_STATUS;
    }

    /**
     * @param string $ORDER_STATUS
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_STATUS($ORDER_STATUS)
    {
      $this->ORDER_STATUS = $ORDER_STATUS;
      return $this;
    }

    /**
     * @return string
     */
    public function getAMAZON_PRIME()
    {
      return $this->AMAZON_PRIME;
    }

    /**
     * @param string $AMAZON_PRIME
     * @return \Visualsoft\OrderDetailsType
     */
    public function setAMAZON_PRIME($AMAZON_PRIME)
    {
      $this->AMAZON_PRIME = $AMAZON_PRIME;
      return $this;
    }

    /**
     * @return string
     */
    public function getIS_SPLIT_PARENT()
    {
      return $this->IS_SPLIT_PARENT;
    }

    /**
     * @param string $IS_SPLIT_PARENT
     * @return \Visualsoft\OrderDetailsType
     */
    public function setIS_SPLIT_PARENT($IS_SPLIT_PARENT)
    {
      $this->IS_SPLIT_PARENT = $IS_SPLIT_PARENT;
      return $this;
    }

    /**
     * @return int
     */
    public function getPARENT_ORDER_ID()
    {
      return $this->PARENT_ORDER_ID;
    }

    /**
     * @param int $PARENT_ORDER_ID
     * @return \Visualsoft\OrderDetailsType
     */
    public function setPARENT_ORDER_ID($PARENT_ORDER_ID)
    {
      $this->PARENT_ORDER_ID = $PARENT_ORDER_ID;
      return $this;
    }

    /**
     * @return int
     */
    public function getORDER_FRAUD_STATE_ID()
    {
      return $this->ORDER_FRAUD_STATE_ID;
    }

    /**
     * @param int $ORDER_FRAUD_STATE_ID
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_FRAUD_STATE_ID($ORDER_FRAUD_STATE_ID)
    {
      $this->ORDER_FRAUD_STATE_ID = $ORDER_FRAUD_STATE_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_DATE()
    {
      return $this->ORDER_DATE;
    }

    /**
     * @param string $ORDER_DATE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_DATE($ORDER_DATE)
    {
      $this->ORDER_DATE = $ORDER_DATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getUPDATED_DATE()
    {
      return $this->UPDATED_DATE;
    }

    /**
     * @param string $UPDATED_DATE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setUPDATED_DATE($UPDATED_DATE)
    {
      $this->UPDATED_DATE = $UPDATED_DATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getDISPATCH_DATE()
    {
      return $this->DISPATCH_DATE;
    }

    /**
     * @param string $DISPATCH_DATE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDISPATCH_DATE($DISPATCH_DATE)
    {
      $this->DISPATCH_DATE = $DISPATCH_DATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getDELIVERY_DATE()
    {
      return $this->DELIVERY_DATE;
    }

    /**
     * @param string $DELIVERY_DATE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDELIVERY_DATE($DELIVERY_DATE)
    {
      $this->DELIVERY_DATE = $DELIVERY_DATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getESTIMATED_DELIVERY_DATE()
    {
      return $this->ESTIMATED_DELIVERY_DATE;
    }

    /**
     * @param string $ESTIMATED_DELIVERY_DATE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setESTIMATED_DELIVERY_DATE($ESTIMATED_DELIVERY_DATE)
    {
      $this->ESTIMATED_DELIVERY_DATE = $ESTIMATED_DELIVERY_DATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getDOWNLOADED()
    {
      return $this->DOWNLOADED;
    }

    /**
     * @param string $DOWNLOADED
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDOWNLOADED($DOWNLOADED)
    {
      $this->DOWNLOADED = $DOWNLOADED;
      return $this;
    }

    /**
     * @return string
     */
    public function getDOWNLOADED_DATE()
    {
      return $this->DOWNLOADED_DATE;
    }

    /**
     * @param string $DOWNLOADED_DATE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDOWNLOADED_DATE($DOWNLOADED_DATE)
    {
      $this->DOWNLOADED_DATE = $DOWNLOADED_DATE;
      return $this;
    }

    /**
     * @return float
     */
    public function getPRODUCT_TOTAL_INC()
    {
      return $this->PRODUCT_TOTAL_INC;
    }

    /**
     * @param float $PRODUCT_TOTAL_INC
     * @return \Visualsoft\OrderDetailsType
     */
    public function setPRODUCT_TOTAL_INC($PRODUCT_TOTAL_INC)
    {
      $this->PRODUCT_TOTAL_INC = $PRODUCT_TOTAL_INC;
      return $this;
    }

    /**
     * @return float
     */
    public function getPRODUCT_TOTAL_EX()
    {
      return $this->PRODUCT_TOTAL_EX;
    }

    /**
     * @param float $PRODUCT_TOTAL_EX
     * @return \Visualsoft\OrderDetailsType
     */
    public function setPRODUCT_TOTAL_EX($PRODUCT_TOTAL_EX)
    {
      $this->PRODUCT_TOTAL_EX = $PRODUCT_TOTAL_EX;
      return $this;
    }

    /**
     * @return float
     */
    public function getPRODUCT_TOTAL_VAT()
    {
      return $this->PRODUCT_TOTAL_VAT;
    }

    /**
     * @param float $PRODUCT_TOTAL_VAT
     * @return \Visualsoft\OrderDetailsType
     */
    public function setPRODUCT_TOTAL_VAT($PRODUCT_TOTAL_VAT)
    {
      $this->PRODUCT_TOTAL_VAT = $PRODUCT_TOTAL_VAT;
      return $this;
    }

    /**
     * @return float
     */
    public function getSHIPPING_TOTAL_INC()
    {
      return $this->SHIPPING_TOTAL_INC;
    }

    /**
     * @param float $SHIPPING_TOTAL_INC
     * @return \Visualsoft\OrderDetailsType
     */
    public function setSHIPPING_TOTAL_INC($SHIPPING_TOTAL_INC)
    {
      $this->SHIPPING_TOTAL_INC = $SHIPPING_TOTAL_INC;
      return $this;
    }

    /**
     * @return float
     */
    public function getSHIPPING_TOTAL_EX()
    {
      return $this->SHIPPING_TOTAL_EX;
    }

    /**
     * @param float $SHIPPING_TOTAL_EX
     * @return \Visualsoft\OrderDetailsType
     */
    public function setSHIPPING_TOTAL_EX($SHIPPING_TOTAL_EX)
    {
      $this->SHIPPING_TOTAL_EX = $SHIPPING_TOTAL_EX;
      return $this;
    }

    /**
     * @return float
     */
    public function getSHIPPING_TOTAL_VAT()
    {
      return $this->SHIPPING_TOTAL_VAT;
    }

    /**
     * @param float $SHIPPING_TOTAL_VAT
     * @return \Visualsoft\OrderDetailsType
     */
    public function setSHIPPING_TOTAL_VAT($SHIPPING_TOTAL_VAT)
    {
      $this->SHIPPING_TOTAL_VAT = $SHIPPING_TOTAL_VAT;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_TOTAL_INC()
    {
      return $this->DISCOUNT_TOTAL_INC;
    }

    /**
     * @param float $DISCOUNT_TOTAL_INC
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDISCOUNT_TOTAL_INC($DISCOUNT_TOTAL_INC)
    {
      $this->DISCOUNT_TOTAL_INC = $DISCOUNT_TOTAL_INC;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_TOTAL_EX()
    {
      return $this->DISCOUNT_TOTAL_EX;
    }

    /**
     * @param float $DISCOUNT_TOTAL_EX
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDISCOUNT_TOTAL_EX($DISCOUNT_TOTAL_EX)
    {
      $this->DISCOUNT_TOTAL_EX = $DISCOUNT_TOTAL_EX;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_TOTAL_VAT()
    {
      return $this->DISCOUNT_TOTAL_VAT;
    }

    /**
     * @param float $DISCOUNT_TOTAL_VAT
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDISCOUNT_TOTAL_VAT($DISCOUNT_TOTAL_VAT)
    {
      $this->DISCOUNT_TOTAL_VAT = $DISCOUNT_TOTAL_VAT;
      return $this;
    }

    /**
     * @return float
     */
    public function getGRAND_TOTAL_INC()
    {
      return $this->GRAND_TOTAL_INC;
    }

    /**
     * @param float $GRAND_TOTAL_INC
     * @return \Visualsoft\OrderDetailsType
     */
    public function setGRAND_TOTAL_INC($GRAND_TOTAL_INC)
    {
      $this->GRAND_TOTAL_INC = $GRAND_TOTAL_INC;
      return $this;
    }

    /**
     * @return float
     */
    public function getGRAND_TOTAL_EX()
    {
      return $this->GRAND_TOTAL_EX;
    }

    /**
     * @param float $GRAND_TOTAL_EX
     * @return \Visualsoft\OrderDetailsType
     */
    public function setGRAND_TOTAL_EX($GRAND_TOTAL_EX)
    {
      $this->GRAND_TOTAL_EX = $GRAND_TOTAL_EX;
      return $this;
    }

    /**
     * @return float
     */
    public function getGRAND_TOTAL_VAT()
    {
      return $this->GRAND_TOTAL_VAT;
    }

    /**
     * @param float $GRAND_TOTAL_VAT
     * @return \Visualsoft\OrderDetailsType
     */
    public function setGRAND_TOTAL_VAT($GRAND_TOTAL_VAT)
    {
      $this->GRAND_TOTAL_VAT = $GRAND_TOTAL_VAT;
      return $this;
    }

    /**
     * @return string
     */
    public function getTAX_COLLECTION_ID()
    {
      return $this->TAX_COLLECTION_ID;
    }

    /**
     * @param string $TAX_COLLECTION_ID
     * @return \Visualsoft\OrderDetailsType
     */
    public function setTAX_COLLECTION_ID($TAX_COLLECTION_ID)
    {
      $this->TAX_COLLECTION_ID = $TAX_COLLECTION_ID;
      return $this;
    }

    /**
     * @return float
     */
    public function getCURRENCY_RATE_USED()
    {
      return $this->CURRENCY_RATE_USED;
    }

    /**
     * @param float $CURRENCY_RATE_USED
     * @return \Visualsoft\OrderDetailsType
     */
    public function setCURRENCY_RATE_USED($CURRENCY_RATE_USED)
    {
      $this->CURRENCY_RATE_USED = $CURRENCY_RATE_USED;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_CURRENCY()
    {
      return $this->ORDER_CURRENCY;
    }

    /**
     * @param string $ORDER_CURRENCY
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_CURRENCY($ORDER_CURRENCY)
    {
      $this->ORDER_CURRENCY = $ORDER_CURRENCY;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_CUSTOMER_COMMENTS()
    {
      return $this->ORDER_CUSTOMER_COMMENTS;
    }

    /**
     * @param string $ORDER_CUSTOMER_COMMENTS
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_CUSTOMER_COMMENTS($ORDER_CUSTOMER_COMMENTS)
    {
      $this->ORDER_CUSTOMER_COMMENTS = $ORDER_CUSTOMER_COMMENTS;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_NOTES()
    {
      return $this->ORDER_NOTES;
    }

    /**
     * @param string $ORDER_NOTES
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_NOTES($ORDER_NOTES)
    {
      $this->ORDER_NOTES = $ORDER_NOTES;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_TYPE()
    {
      return $this->ORDER_TYPE;
    }

    /**
     * @param string $ORDER_TYPE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_TYPE($ORDER_TYPE)
    {
      $this->ORDER_TYPE = $ORDER_TYPE;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_REFERER()
    {
      return $this->ORDER_REFERER;
    }

    /**
     * @param string $ORDER_REFERER
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_REFERER($ORDER_REFERER)
    {
      $this->ORDER_REFERER = $ORDER_REFERER;
      return $this;
    }

    /**
     * @return string
     */
    public function getDELIVERY_METHOD()
    {
      return $this->DELIVERY_METHOD;
    }

    /**
     * @param string $DELIVERY_METHOD
     * @return \Visualsoft\OrderDetailsType
     */
    public function setDELIVERY_METHOD($DELIVERY_METHOD)
    {
      $this->DELIVERY_METHOD = $DELIVERY_METHOD;
      return $this;
    }

    /**
     * @return float
     */
    public function getGIFTWRAP_TOTAL_INC()
    {
      return $this->GIFTWRAP_TOTAL_INC;
    }

    /**
     * @param float $GIFTWRAP_TOTAL_INC
     * @return \Visualsoft\OrderDetailsType
     */
    public function setGIFTWRAP_TOTAL_INC($GIFTWRAP_TOTAL_INC)
    {
      $this->GIFTWRAP_TOTAL_INC = $GIFTWRAP_TOTAL_INC;
      return $this;
    }

    /**
     * @return float
     */
    public function getGIFTWRAP_TOTAL_NET()
    {
      return $this->GIFTWRAP_TOTAL_NET;
    }

    /**
     * @param float $GIFTWRAP_TOTAL_NET
     * @return \Visualsoft\OrderDetailsType
     */
    public function setGIFTWRAP_TOTAL_NET($GIFTWRAP_TOTAL_NET)
    {
      $this->GIFTWRAP_TOTAL_NET = $GIFTWRAP_TOTAL_NET;
      return $this;
    }

    /**
     * @return float
     */
    public function getGIFTWRAP_TOTAL_VAT()
    {
      return $this->GIFTWRAP_TOTAL_VAT;
    }

    /**
     * @param float $GIFTWRAP_TOTAL_VAT
     * @return \Visualsoft\OrderDetailsType
     */
    public function setGIFTWRAP_TOTAL_VAT($GIFTWRAP_TOTAL_VAT)
    {
      $this->GIFTWRAP_TOTAL_VAT = $GIFTWRAP_TOTAL_VAT;
      return $this;
    }

    /**
     * @return int
     */
    public function getNUMBER_PRODUCTS()
    {
      return $this->NUMBER_PRODUCTS;
    }

    /**
     * @param int $NUMBER_PRODUCTS
     * @return \Visualsoft\OrderDetailsType
     */
    public function setNUMBER_PRODUCTS($NUMBER_PRODUCTS)
    {
      $this->NUMBER_PRODUCTS = $NUMBER_PRODUCTS;
      return $this;
    }

    /**
     * @return MULTICHANNEL_SOURCE
     */
    public function getMULTICHANNEL_SOURCE()
    {
      return $this->MULTICHANNEL_SOURCE;
    }

    /**
     * @param MULTICHANNEL_SOURCE $MULTICHANNEL_SOURCE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setMULTICHANNEL_SOURCE($MULTICHANNEL_SOURCE)
    {
      $this->MULTICHANNEL_SOURCE = $MULTICHANNEL_SOURCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOURIER_STOCK_SYSTEM_REFERENCE_CODE()
    {
      return $this->COURIER_STOCK_SYSTEM_REFERENCE_CODE;
    }

    /**
     * @param string $COURIER_STOCK_SYSTEM_REFERENCE_CODE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setCOURIER_STOCK_SYSTEM_REFERENCE_CODE($COURIER_STOCK_SYSTEM_REFERENCE_CODE)
    {
      $this->COURIER_STOCK_SYSTEM_REFERENCE_CODE = $COURIER_STOCK_SYSTEM_REFERENCE_CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getPO_NUMBER()
    {
      return $this->PO_NUMBER;
    }

    /**
     * @param string $PO_NUMBER
     * @return \Visualsoft\OrderDetailsType
     */
    public function setPO_NUMBER($PO_NUMBER)
    {
      $this->PO_NUMBER = $PO_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_DELIVERY_NOTES()
    {
      return $this->CUSTOMER_DELIVERY_NOTES;
    }

    /**
     * @param string $CUSTOMER_DELIVERY_NOTES
     * @return \Visualsoft\OrderDetailsType
     */
    public function setCUSTOMER_DELIVERY_NOTES($CUSTOMER_DELIVERY_NOTES)
    {
      $this->CUSTOMER_DELIVERY_NOTES = $CUSTOMER_DELIVERY_NOTES;
      return $this;
    }

    /**
     * @return string
     */
    public function getBRANCH_INTERNAL_REFERENCE()
    {
      return $this->BRANCH_INTERNAL_REFERENCE;
    }

    /**
     * @param string $BRANCH_INTERNAL_REFERENCE
     * @return \Visualsoft\OrderDetailsType
     */
    public function setBRANCH_INTERNAL_REFERENCE($BRANCH_INTERNAL_REFERENCE)
    {
      $this->BRANCH_INTERNAL_REFERENCE = $BRANCH_INTERNAL_REFERENCE;
      return $this;
    }

    /**
     * @return TRACKING_INFO
     */
    public function getTRACKING_INFO()
    {
      return $this->TRACKING_INFO;
    }

    /**
     * @param TRACKING_INFO $TRACKING_INFO
     * @return \Visualsoft\OrderDetailsType
     */
    public function setTRACKING_INFO($TRACKING_INFO)
    {
      $this->TRACKING_INFO = $TRACKING_INFO;
      return $this;
    }

    /**
     * @return string
     */
    public function getORDER_IS_GIFT()
    {
      return $this->ORDER_IS_GIFT;
    }

    /**
     * @param string $ORDER_IS_GIFT
     * @return \Visualsoft\OrderDetailsType
     */
    public function setORDER_IS_GIFT($ORDER_IS_GIFT)
    {
      $this->ORDER_IS_GIFT = $ORDER_IS_GIFT;
      return $this;
    }

}
