<?php

namespace Visualsoft;

class ModifyNewsletterSubscriberType
{

    /**
     * @var NonEmptyStringType $email_address
     */
    protected $email_address = null;

    /**
     * @var int $subscriber_id
     */
    protected $subscriber_id = null;

    /**
     * @var subscriber_group_ids $subscriber_group_ids
     */
    protected $subscriber_group_ids = null;

    /**
     * @var string $firstname
     */
    protected $firstname = null;

    /**
     * @var string $lastname
     */
    protected $lastname = null;

    /**
     * @var string $dateofbirth
     */
    protected $dateofbirth = null;

    /**
     * @var string $gender
     */
    protected $gender = null;

    /**
     * @var boolean $unsubscribe
     */
    protected $unsubscribe = null;

    /**
     * @var boolean $disengaged
     */
    protected $disengaged = null;

    /**
     * @var boolean $delete
     */
    protected $delete = null;

    /**
     * @param NonEmptyStringType $email_address
     * @param int $subscriber_id
     */
    public function __construct($email_address, $subscriber_id)
    {
      $this->email_address = $email_address;
      $this->subscriber_id = $subscriber_id;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getEmail_address()
    {
      return $this->email_address;
    }

    /**
     * @param NonEmptyStringType $email_address
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setEmail_address($email_address)
    {
      $this->email_address = $email_address;
      return $this;
    }

    /**
     * @return int
     */
    public function getSubscriber_id()
    {
      return $this->subscriber_id;
    }

    /**
     * @param int $subscriber_id
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setSubscriber_id($subscriber_id)
    {
      $this->subscriber_id = $subscriber_id;
      return $this;
    }

    /**
     * @return subscriber_group_ids
     */
    public function getSubscriber_group_ids()
    {
      return $this->subscriber_group_ids;
    }

    /**
     * @param subscriber_group_ids $subscriber_group_ids
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setSubscriber_group_ids($subscriber_group_ids)
    {
      $this->subscriber_group_ids = $subscriber_group_ids;
      return $this;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
      return $this->firstname;
    }

    /**
     * @param string $firstname
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setFirstname($firstname)
    {
      $this->firstname = $firstname;
      return $this;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
      return $this->lastname;
    }

    /**
     * @param string $lastname
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setLastname($lastname)
    {
      $this->lastname = $lastname;
      return $this;
    }

    /**
     * @return string
     */
    public function getDateofbirth()
    {
      return $this->dateofbirth;
    }

    /**
     * @param string $dateofbirth
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setDateofbirth($dateofbirth)
    {
      $this->dateofbirth = $dateofbirth;
      return $this;
    }

    /**
     * @return string
     */
    public function getGender()
    {
      return $this->gender;
    }

    /**
     * @param string $gender
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setGender($gender)
    {
      $this->gender = $gender;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getUnsubscribe()
    {
      return $this->unsubscribe;
    }

    /**
     * @param boolean $unsubscribe
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setUnsubscribe($unsubscribe)
    {
      $this->unsubscribe = $unsubscribe;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDisengaged()
    {
      return $this->disengaged;
    }

    /**
     * @param boolean $disengaged
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setDisengaged($disengaged)
    {
      $this->disengaged = $disengaged;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDelete()
    {
      return $this->delete;
    }

    /**
     * @param boolean $delete
     * @return \Visualsoft\ModifyNewsletterSubscriberType
     */
    public function setDelete($delete)
    {
      $this->delete = $delete;
      return $this;
    }

}
