<?php

namespace Visualsoft;

class EwalletLogType
{

    /**
     * @var string $DATE_ADDED
     */
    protected $DATE_ADDED = null;

    /**
     * @var string $CHANGE_TYPE
     */
    protected $CHANGE_TYPE = null;

    /**
     * @var float $CHANGE_AMOUNT
     */
    protected $CHANGE_AMOUNT = null;

    /**
     * @var float $START_AMOUNT
     */
    protected $START_AMOUNT = null;

    /**
     * @var float $FINAL_AMOUNT
     */
    protected $FINAL_AMOUNT = null;

    /**
     * @var string $LINKED_ORDER_ID
     */
    protected $LINKED_ORDER_ID = null;

    /**
     * @param string $DATE_ADDED
     * @param string $CHANGE_TYPE
     * @param float $CHANGE_AMOUNT
     * @param float $START_AMOUNT
     * @param float $FINAL_AMOUNT
     */
    public function __construct($DATE_ADDED, $CHANGE_TYPE, $CHANGE_AMOUNT, $START_AMOUNT, $FINAL_AMOUNT)
    {
      $this->DATE_ADDED = $DATE_ADDED;
      $this->CHANGE_TYPE = $CHANGE_TYPE;
      $this->CHANGE_AMOUNT = $CHANGE_AMOUNT;
      $this->START_AMOUNT = $START_AMOUNT;
      $this->FINAL_AMOUNT = $FINAL_AMOUNT;
    }

    /**
     * @return string
     */
    public function getDATE_ADDED()
    {
      return $this->DATE_ADDED;
    }

    /**
     * @param string $DATE_ADDED
     * @return \Visualsoft\EwalletLogType
     */
    public function setDATE_ADDED($DATE_ADDED)
    {
      $this->DATE_ADDED = $DATE_ADDED;
      return $this;
    }

    /**
     * @return string
     */
    public function getCHANGE_TYPE()
    {
      return $this->CHANGE_TYPE;
    }

    /**
     * @param string $CHANGE_TYPE
     * @return \Visualsoft\EwalletLogType
     */
    public function setCHANGE_TYPE($CHANGE_TYPE)
    {
      $this->CHANGE_TYPE = $CHANGE_TYPE;
      return $this;
    }

    /**
     * @return float
     */
    public function getCHANGE_AMOUNT()
    {
      return $this->CHANGE_AMOUNT;
    }

    /**
     * @param float $CHANGE_AMOUNT
     * @return \Visualsoft\EwalletLogType
     */
    public function setCHANGE_AMOUNT($CHANGE_AMOUNT)
    {
      $this->CHANGE_AMOUNT = $CHANGE_AMOUNT;
      return $this;
    }

    /**
     * @return float
     */
    public function getSTART_AMOUNT()
    {
      return $this->START_AMOUNT;
    }

    /**
     * @param float $START_AMOUNT
     * @return \Visualsoft\EwalletLogType
     */
    public function setSTART_AMOUNT($START_AMOUNT)
    {
      $this->START_AMOUNT = $START_AMOUNT;
      return $this;
    }

    /**
     * @return float
     */
    public function getFINAL_AMOUNT()
    {
      return $this->FINAL_AMOUNT;
    }

    /**
     * @param float $FINAL_AMOUNT
     * @return \Visualsoft\EwalletLogType
     */
    public function setFINAL_AMOUNT($FINAL_AMOUNT)
    {
      $this->FINAL_AMOUNT = $FINAL_AMOUNT;
      return $this;
    }

    /**
     * @return string
     */
    public function getLINKED_ORDER_ID()
    {
      return $this->LINKED_ORDER_ID;
    }

    /**
     * @param string $LINKED_ORDER_ID
     * @return \Visualsoft\EwalletLogType
     */
    public function setLINKED_ORDER_ID($LINKED_ORDER_ID)
    {
      $this->LINKED_ORDER_ID = $LINKED_ORDER_ID;
      return $this;
    }

}
