<?php

namespace Visualsoft;

class CustomerGroupType
{

    /**
     * @var int $CUSTOMER_GROUP_ID
     */
    protected $CUSTOMER_GROUP_ID = null;

    /**
     * @var string $NAME
     */
    protected $NAME = null;

    /**
     * @var int $PARENT_CUSTOMER_GROUP_ID
     */
    protected $PARENT_CUSTOMER_GROUP_ID = null;

    /**
     * @var float $CURRENT_BALANCE
     */
    protected $CURRENT_BALANCE = null;

    /**
     * @var float $CREDIT_LIMIT
     */
    protected $CREDIT_LIMIT = null;

    /**
     * @var string $PO_NUMBER_OPTIONAL
     */
    protected $PO_NUMBER_OPTIONAL = null;

    /**
     * @var string $REFERENCE
     */
    protected $REFERENCE = null;

    /**
     * @var string $SHOW_EX_VAT_PRICES
     */
    protected $SHOW_EX_VAT_PRICES = null;

    /**
     * @var string $GROUP_SHARE_ORDERS
     */
    protected $GROUP_SHARE_ORDERS = null;

    /**
     * @var float $MINIMUM_ORDER_VALUE
     */
    protected $MINIMUM_ORDER_VALUE = null;

    /**
     * @var string $IS_VATABLE
     */
    protected $IS_VATABLE = null;

    /**
     * @var string $ALLOW_DISCOUNTS
     */
    protected $ALLOW_DISCOUNTS = null;

    /**
     * @var int $APPLICABLE_CATEGORY_ID
     */
    protected $APPLICABLE_CATEGORY_ID = null;

    /**
     * @var string $VIEW_SAME_LEVEL_DATA
     */
    protected $VIEW_SAME_LEVEL_DATA = null;

    /**
     * @var string $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     */
    protected $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = null;

    /**
     * @var float $AVAILABLE_CREDIT
     */
    protected $AVAILABLE_CREDIT = null;

    /**
     * @var ArrayOfSimpleCustomers $CUSTOMERS
     */
    protected $CUSTOMERS = null;

    /**
     * @var TRADE_DISCOUNTS $TRADE_DISCOUNTS
     */
    protected $TRADE_DISCOUNTS = null;

    /**
     * @param int $CUSTOMER_GROUP_ID
     * @param string $NAME
     * @param int $PARENT_CUSTOMER_GROUP_ID
     * @param float $CURRENT_BALANCE
     * @param float $CREDIT_LIMIT
     * @param string $PO_NUMBER_OPTIONAL
     * @param string $REFERENCE
     * @param string $SHOW_EX_VAT_PRICES
     * @param string $GROUP_SHARE_ORDERS
     * @param float $MINIMUM_ORDER_VALUE
     * @param string $IS_VATABLE
     * @param string $ALLOW_DISCOUNTS
     * @param int $APPLICABLE_CATEGORY_ID
     * @param string $VIEW_SAME_LEVEL_DATA
     * @param string $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * @param float $AVAILABLE_CREDIT
     * @param ArrayOfSimpleCustomers $CUSTOMERS
     * @param TRADE_DISCOUNTS $TRADE_DISCOUNTS
     */
    public function __construct($CUSTOMER_GROUP_ID, $NAME, $PARENT_CUSTOMER_GROUP_ID, $CURRENT_BALANCE, $CREDIT_LIMIT, $PO_NUMBER_OPTIONAL, $REFERENCE, $SHOW_EX_VAT_PRICES, $GROUP_SHARE_ORDERS, $MINIMUM_ORDER_VALUE, $IS_VATABLE, $ALLOW_DISCOUNTS, $APPLICABLE_CATEGORY_ID, $VIEW_SAME_LEVEL_DATA, $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS, $AVAILABLE_CREDIT, $CUSTOMERS, $TRADE_DISCOUNTS)
    {
      $this->CUSTOMER_GROUP_ID = $CUSTOMER_GROUP_ID;
      $this->NAME = $NAME;
      $this->PARENT_CUSTOMER_GROUP_ID = $PARENT_CUSTOMER_GROUP_ID;
      $this->CURRENT_BALANCE = $CURRENT_BALANCE;
      $this->CREDIT_LIMIT = $CREDIT_LIMIT;
      $this->PO_NUMBER_OPTIONAL = $PO_NUMBER_OPTIONAL;
      $this->REFERENCE = $REFERENCE;
      $this->SHOW_EX_VAT_PRICES = $SHOW_EX_VAT_PRICES;
      $this->GROUP_SHARE_ORDERS = $GROUP_SHARE_ORDERS;
      $this->MINIMUM_ORDER_VALUE = $MINIMUM_ORDER_VALUE;
      $this->IS_VATABLE = $IS_VATABLE;
      $this->ALLOW_DISCOUNTS = $ALLOW_DISCOUNTS;
      $this->APPLICABLE_CATEGORY_ID = $APPLICABLE_CATEGORY_ID;
      $this->VIEW_SAME_LEVEL_DATA = $VIEW_SAME_LEVEL_DATA;
      $this->HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
      $this->AVAILABLE_CREDIT = $AVAILABLE_CREDIT;
      $this->CUSTOMERS = $CUSTOMERS;
      $this->TRADE_DISCOUNTS = $TRADE_DISCOUNTS;
    }

    /**
     * @return int
     */
    public function getCUSTOMER_GROUP_ID()
    {
      return $this->CUSTOMER_GROUP_ID;
    }

    /**
     * @param int $CUSTOMER_GROUP_ID
     * @return \Visualsoft\CustomerGroupType
     */
    public function setCUSTOMER_GROUP_ID($CUSTOMER_GROUP_ID)
    {
      $this->CUSTOMER_GROUP_ID = $CUSTOMER_GROUP_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getNAME()
    {
      return $this->NAME;
    }

    /**
     * @param string $NAME
     * @return \Visualsoft\CustomerGroupType
     */
    public function setNAME($NAME)
    {
      $this->NAME = $NAME;
      return $this;
    }

    /**
     * @return int
     */
    public function getPARENT_CUSTOMER_GROUP_ID()
    {
      return $this->PARENT_CUSTOMER_GROUP_ID;
    }

    /**
     * @param int $PARENT_CUSTOMER_GROUP_ID
     * @return \Visualsoft\CustomerGroupType
     */
    public function setPARENT_CUSTOMER_GROUP_ID($PARENT_CUSTOMER_GROUP_ID)
    {
      $this->PARENT_CUSTOMER_GROUP_ID = $PARENT_CUSTOMER_GROUP_ID;
      return $this;
    }

    /**
     * @return float
     */
    public function getCURRENT_BALANCE()
    {
      return $this->CURRENT_BALANCE;
    }

    /**
     * @param float $CURRENT_BALANCE
     * @return \Visualsoft\CustomerGroupType
     */
    public function setCURRENT_BALANCE($CURRENT_BALANCE)
    {
      $this->CURRENT_BALANCE = $CURRENT_BALANCE;
      return $this;
    }

    /**
     * @return float
     */
    public function getCREDIT_LIMIT()
    {
      return $this->CREDIT_LIMIT;
    }

    /**
     * @param float $CREDIT_LIMIT
     * @return \Visualsoft\CustomerGroupType
     */
    public function setCREDIT_LIMIT($CREDIT_LIMIT)
    {
      $this->CREDIT_LIMIT = $CREDIT_LIMIT;
      return $this;
    }

    /**
     * @return string
     */
    public function getPO_NUMBER_OPTIONAL()
    {
      return $this->PO_NUMBER_OPTIONAL;
    }

    /**
     * @param string $PO_NUMBER_OPTIONAL
     * @return \Visualsoft\CustomerGroupType
     */
    public function setPO_NUMBER_OPTIONAL($PO_NUMBER_OPTIONAL)
    {
      $this->PO_NUMBER_OPTIONAL = $PO_NUMBER_OPTIONAL;
      return $this;
    }

    /**
     * @return string
     */
    public function getREFERENCE()
    {
      return $this->REFERENCE;
    }

    /**
     * @param string $REFERENCE
     * @return \Visualsoft\CustomerGroupType
     */
    public function setREFERENCE($REFERENCE)
    {
      $this->REFERENCE = $REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSHOW_EX_VAT_PRICES()
    {
      return $this->SHOW_EX_VAT_PRICES;
    }

    /**
     * @param string $SHOW_EX_VAT_PRICES
     * @return \Visualsoft\CustomerGroupType
     */
    public function setSHOW_EX_VAT_PRICES($SHOW_EX_VAT_PRICES)
    {
      $this->SHOW_EX_VAT_PRICES = $SHOW_EX_VAT_PRICES;
      return $this;
    }

    /**
     * @return string
     */
    public function getGROUP_SHARE_ORDERS()
    {
      return $this->GROUP_SHARE_ORDERS;
    }

    /**
     * @param string $GROUP_SHARE_ORDERS
     * @return \Visualsoft\CustomerGroupType
     */
    public function setGROUP_SHARE_ORDERS($GROUP_SHARE_ORDERS)
    {
      $this->GROUP_SHARE_ORDERS = $GROUP_SHARE_ORDERS;
      return $this;
    }

    /**
     * @return float
     */
    public function getMINIMUM_ORDER_VALUE()
    {
      return $this->MINIMUM_ORDER_VALUE;
    }

    /**
     * @param float $MINIMUM_ORDER_VALUE
     * @return \Visualsoft\CustomerGroupType
     */
    public function setMINIMUM_ORDER_VALUE($MINIMUM_ORDER_VALUE)
    {
      $this->MINIMUM_ORDER_VALUE = $MINIMUM_ORDER_VALUE;
      return $this;
    }

    /**
     * @return string
     */
    public function getIS_VATABLE()
    {
      return $this->IS_VATABLE;
    }

    /**
     * @param string $IS_VATABLE
     * @return \Visualsoft\CustomerGroupType
     */
    public function setIS_VATABLE($IS_VATABLE)
    {
      $this->IS_VATABLE = $IS_VATABLE;
      return $this;
    }

    /**
     * @return string
     */
    public function getALLOW_DISCOUNTS()
    {
      return $this->ALLOW_DISCOUNTS;
    }

    /**
     * @param string $ALLOW_DISCOUNTS
     * @return \Visualsoft\CustomerGroupType
     */
    public function setALLOW_DISCOUNTS($ALLOW_DISCOUNTS)
    {
      $this->ALLOW_DISCOUNTS = $ALLOW_DISCOUNTS;
      return $this;
    }

    /**
     * @return int
     */
    public function getAPPLICABLE_CATEGORY_ID()
    {
      return $this->APPLICABLE_CATEGORY_ID;
    }

    /**
     * @param int $APPLICABLE_CATEGORY_ID
     * @return \Visualsoft\CustomerGroupType
     */
    public function setAPPLICABLE_CATEGORY_ID($APPLICABLE_CATEGORY_ID)
    {
      $this->APPLICABLE_CATEGORY_ID = $APPLICABLE_CATEGORY_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getVIEW_SAME_LEVEL_DATA()
    {
      return $this->VIEW_SAME_LEVEL_DATA;
    }

    /**
     * @param string $VIEW_SAME_LEVEL_DATA
     * @return \Visualsoft\CustomerGroupType
     */
    public function setVIEW_SAME_LEVEL_DATA($VIEW_SAME_LEVEL_DATA)
    {
      $this->VIEW_SAME_LEVEL_DATA = $VIEW_SAME_LEVEL_DATA;
      return $this;
    }

    /**
     * @return string
     */
    public function getHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS()
    {
      return $this->HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
    }

    /**
     * @param string $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * @return \Visualsoft\CustomerGroupType
     */
    public function setHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS($HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS)
    {
      $this->HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
      return $this;
    }

    /**
     * @return float
     */
    public function getAVAILABLE_CREDIT()
    {
      return $this->AVAILABLE_CREDIT;
    }

    /**
     * @param float $AVAILABLE_CREDIT
     * @return \Visualsoft\CustomerGroupType
     */
    public function setAVAILABLE_CREDIT($AVAILABLE_CREDIT)
    {
      $this->AVAILABLE_CREDIT = $AVAILABLE_CREDIT;
      return $this;
    }

    /**
     * @return ArrayOfSimpleCustomers
     */
    public function getCUSTOMERS()
    {
      return $this->CUSTOMERS;
    }

    /**
     * @param ArrayOfSimpleCustomers $CUSTOMERS
     * @return \Visualsoft\CustomerGroupType
     */
    public function setCUSTOMERS($CUSTOMERS)
    {
      $this->CUSTOMERS = $CUSTOMERS;
      return $this;
    }

    /**
     * @return TRADE_DISCOUNTS
     */
    public function getTRADE_DISCOUNTS()
    {
      return $this->TRADE_DISCOUNTS;
    }

    /**
     * @param TRADE_DISCOUNTS $TRADE_DISCOUNTS
     * @return \Visualsoft\CustomerGroupType
     */
    public function setTRADE_DISCOUNTS($TRADE_DISCOUNTS)
    {
      $this->TRADE_DISCOUNTS = $TRADE_DISCOUNTS;
      return $this;
    }

}
