<?php

namespace Visualsoft;

class CustomerExportType
{

    /**
     * @var int $CUSTOMER_ID
     */
    protected $CUSTOMER_ID = null;

    /**
     * @var int $WEBSITE_ID
     */
    protected $WEBSITE_ID = null;

    /**
     * @var string $CUSTOMER_ACCOUNT_NUMBER
     */
    protected $CUSTOMER_ACCOUNT_NUMBER = null;

    /**
     * @var string $INTERNAL_CUSTOMER_REFERENCE
     */
    protected $INTERNAL_CUSTOMER_REFERENCE = null;

    /**
     * @var string $EMAIL_ADDRESS
     */
    protected $EMAIL_ADDRESS = null;

    /**
     * @var string $DATE_OF_BIRTH
     */
    protected $DATE_OF_BIRTH = null;

    /**
     * @var string $CUSTOMER_OCCUPATION
     */
    protected $CUSTOMER_OCCUPATION = null;

    /**
     * @var string $HEARD_ABOUT
     */
    protected $HEARD_ABOUT = null;

    /**
     * @var string $CUSTOMER_NOTES
     */
    protected $CUSTOMER_NOTES = null;

    /**
     * @var string $IS_EXPRESS_CUSTOMER
     */
    protected $IS_EXPRESS_CUSTOMER = null;

    /**
     * @var AddressesType $ADDRESSES
     */
    protected $ADDRESSES = null;

    /**
     * @var CustomerEwalletType $EWALLET
     */
    protected $EWALLET = null;

    /**
     * @var CustomerDatesType $DATES
     */
    protected $DATES = null;

    /**
     * @var OptInsType $OPT_INS
     */
    protected $OPT_INS = null;

    /**
     * @var string $APPROVED
     */
    protected $APPROVED = null;

    /**
     * @var string $CUSTOMER_NIF
     */
    protected $CUSTOMER_NIF = null;

    /**
     * @var string $FREE_DELIVERY
     */
    protected $FREE_DELIVERY = null;

    /**
     * @var int $CUSTOMER_GROUP_ID
     */
    protected $CUSTOMER_GROUP_ID = null;

    /**
     * @var string $CUSTOMER_GROUP_NAME
     */
    protected $CUSTOMER_GROUP_NAME = null;

    /**
     * @var string $CURRENT_BALANCE
     */
    protected $CURRENT_BALANCE = null;

    /**
     * @var string $CREDIT_LIMIT
     */
    protected $CREDIT_LIMIT = null;

    /**
     * @var string $LOCK_TO_TRADE_ONLY
     */
    protected $LOCK_TO_TRADE_ONLY = null;

    /**
     * @var string $VAT_REGISTRATION_NUMBER
     */
    protected $VAT_REGISTRATION_NUMBER = null;

    /**
     * @var string $VAT_EXEMPT
     */
    protected $VAT_EXEMPT = null;

    /**
     * @var string $CUSTOMER_TYPE
     */
    protected $CUSTOMER_TYPE = null;

    /**
     * @var string $EXTERNAL_LOYALTY_PROGRAM_NUMBER
     */
    protected $EXTERNAL_LOYALTY_PROGRAM_NUMBER = null;

    /**
     * @var string $COMPANY_NUMBER
     */
    protected $COMPANY_NUMBER = null;

    /**
     * @var string $COMPANY_DOMAIN
     */
    protected $COMPANY_DOMAIN = null;

    /**
     * @var string $EORI_NUMBER
     */
    protected $EORI_NUMBER = null;

    /**
     * @param string $EMAIL_ADDRESS
     * @param AddressesType $ADDRESSES
     * @param CustomerEwalletType $EWALLET
     * @param CustomerDatesType $DATES
     * @param OptInsType $OPT_INS
     */
    public function __construct($EMAIL_ADDRESS, $ADDRESSES, $EWALLET, $DATES, $OPT_INS)
    {
      $this->EMAIL_ADDRESS = $EMAIL_ADDRESS;
      $this->ADDRESSES = $ADDRESSES;
      $this->EWALLET = $EWALLET;
      $this->DATES = $DATES;
      $this->OPT_INS = $OPT_INS;
    }

    /**
     * @return int
     */
    public function getCUSTOMER_ID()
    {
      return $this->CUSTOMER_ID;
    }

    /**
     * @param int $CUSTOMER_ID
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_ID($CUSTOMER_ID)
    {
      $this->CUSTOMER_ID = $CUSTOMER_ID;
      return $this;
    }

    /**
     * @return int
     */
    public function getWEBSITE_ID()
    {
      return $this->WEBSITE_ID;
    }

    /**
     * @param int $WEBSITE_ID
     * @return \Visualsoft\CustomerExportType
     */
    public function setWEBSITE_ID($WEBSITE_ID)
    {
      $this->WEBSITE_ID = $WEBSITE_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_ACCOUNT_NUMBER()
    {
      return $this->CUSTOMER_ACCOUNT_NUMBER;
    }

    /**
     * @param string $CUSTOMER_ACCOUNT_NUMBER
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_ACCOUNT_NUMBER($CUSTOMER_ACCOUNT_NUMBER)
    {
      $this->CUSTOMER_ACCOUNT_NUMBER = $CUSTOMER_ACCOUNT_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getINTERNAL_CUSTOMER_REFERENCE()
    {
      return $this->INTERNAL_CUSTOMER_REFERENCE;
    }

    /**
     * @param string $INTERNAL_CUSTOMER_REFERENCE
     * @return \Visualsoft\CustomerExportType
     */
    public function setINTERNAL_CUSTOMER_REFERENCE($INTERNAL_CUSTOMER_REFERENCE)
    {
      $this->INTERNAL_CUSTOMER_REFERENCE = $INTERNAL_CUSTOMER_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getEMAIL_ADDRESS()
    {
      return $this->EMAIL_ADDRESS;
    }

    /**
     * @param string $EMAIL_ADDRESS
     * @return \Visualsoft\CustomerExportType
     */
    public function setEMAIL_ADDRESS($EMAIL_ADDRESS)
    {
      $this->EMAIL_ADDRESS = $EMAIL_ADDRESS;
      return $this;
    }

    /**
     * @return string
     */
    public function getDATE_OF_BIRTH()
    {
      return $this->DATE_OF_BIRTH;
    }

    /**
     * @param string $DATE_OF_BIRTH
     * @return \Visualsoft\CustomerExportType
     */
    public function setDATE_OF_BIRTH($DATE_OF_BIRTH)
    {
      $this->DATE_OF_BIRTH = $DATE_OF_BIRTH;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_OCCUPATION()
    {
      return $this->CUSTOMER_OCCUPATION;
    }

    /**
     * @param string $CUSTOMER_OCCUPATION
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_OCCUPATION($CUSTOMER_OCCUPATION)
    {
      $this->CUSTOMER_OCCUPATION = $CUSTOMER_OCCUPATION;
      return $this;
    }

    /**
     * @return string
     */
    public function getHEARD_ABOUT()
    {
      return $this->HEARD_ABOUT;
    }

    /**
     * @param string $HEARD_ABOUT
     * @return \Visualsoft\CustomerExportType
     */
    public function setHEARD_ABOUT($HEARD_ABOUT)
    {
      $this->HEARD_ABOUT = $HEARD_ABOUT;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_NOTES()
    {
      return $this->CUSTOMER_NOTES;
    }

    /**
     * @param string $CUSTOMER_NOTES
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_NOTES($CUSTOMER_NOTES)
    {
      $this->CUSTOMER_NOTES = $CUSTOMER_NOTES;
      return $this;
    }

    /**
     * @return string
     */
    public function getIS_EXPRESS_CUSTOMER()
    {
      return $this->IS_EXPRESS_CUSTOMER;
    }

    /**
     * @param string $IS_EXPRESS_CUSTOMER
     * @return \Visualsoft\CustomerExportType
     */
    public function setIS_EXPRESS_CUSTOMER($IS_EXPRESS_CUSTOMER)
    {
      $this->IS_EXPRESS_CUSTOMER = $IS_EXPRESS_CUSTOMER;
      return $this;
    }

    /**
     * @return AddressesType
     */
    public function getADDRESSES()
    {
      return $this->ADDRESSES;
    }

    /**
     * @param AddressesType $ADDRESSES
     * @return \Visualsoft\CustomerExportType
     */
    public function setADDRESSES($ADDRESSES)
    {
      $this->ADDRESSES = $ADDRESSES;
      return $this;
    }

    /**
     * @return CustomerEwalletType
     */
    public function getEWALLET()
    {
      return $this->EWALLET;
    }

    /**
     * @param CustomerEwalletType $EWALLET
     * @return \Visualsoft\CustomerExportType
     */
    public function setEWALLET($EWALLET)
    {
      $this->EWALLET = $EWALLET;
      return $this;
    }

    /**
     * @return CustomerDatesType
     */
    public function getDATES()
    {
      return $this->DATES;
    }

    /**
     * @param CustomerDatesType $DATES
     * @return \Visualsoft\CustomerExportType
     */
    public function setDATES($DATES)
    {
      $this->DATES = $DATES;
      return $this;
    }

    /**
     * @return OptInsType
     */
    public function getOPT_INS()
    {
      return $this->OPT_INS;
    }

    /**
     * @param OptInsType $OPT_INS
     * @return \Visualsoft\CustomerExportType
     */
    public function setOPT_INS($OPT_INS)
    {
      $this->OPT_INS = $OPT_INS;
      return $this;
    }

    /**
     * @return string
     */
    public function getAPPROVED()
    {
      return $this->APPROVED;
    }

    /**
     * @param string $APPROVED
     * @return \Visualsoft\CustomerExportType
     */
    public function setAPPROVED($APPROVED)
    {
      $this->APPROVED = $APPROVED;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_NIF()
    {
      return $this->CUSTOMER_NIF;
    }

    /**
     * @param string $CUSTOMER_NIF
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_NIF($CUSTOMER_NIF)
    {
      $this->CUSTOMER_NIF = $CUSTOMER_NIF;
      return $this;
    }

    /**
     * @return string
     */
    public function getFREE_DELIVERY()
    {
      return $this->FREE_DELIVERY;
    }

    /**
     * @param string $FREE_DELIVERY
     * @return \Visualsoft\CustomerExportType
     */
    public function setFREE_DELIVERY($FREE_DELIVERY)
    {
      $this->FREE_DELIVERY = $FREE_DELIVERY;
      return $this;
    }

    /**
     * @return int
     */
    public function getCUSTOMER_GROUP_ID()
    {
      return $this->CUSTOMER_GROUP_ID;
    }

    /**
     * @param int $CUSTOMER_GROUP_ID
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_GROUP_ID($CUSTOMER_GROUP_ID)
    {
      $this->CUSTOMER_GROUP_ID = $CUSTOMER_GROUP_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_GROUP_NAME()
    {
      return $this->CUSTOMER_GROUP_NAME;
    }

    /**
     * @param string $CUSTOMER_GROUP_NAME
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_GROUP_NAME($CUSTOMER_GROUP_NAME)
    {
      $this->CUSTOMER_GROUP_NAME = $CUSTOMER_GROUP_NAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getCURRENT_BALANCE()
    {
      return $this->CURRENT_BALANCE;
    }

    /**
     * @param string $CURRENT_BALANCE
     * @return \Visualsoft\CustomerExportType
     */
    public function setCURRENT_BALANCE($CURRENT_BALANCE)
    {
      $this->CURRENT_BALANCE = $CURRENT_BALANCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCREDIT_LIMIT()
    {
      return $this->CREDIT_LIMIT;
    }

    /**
     * @param string $CREDIT_LIMIT
     * @return \Visualsoft\CustomerExportType
     */
    public function setCREDIT_LIMIT($CREDIT_LIMIT)
    {
      $this->CREDIT_LIMIT = $CREDIT_LIMIT;
      return $this;
    }

    /**
     * @return string
     */
    public function getLOCK_TO_TRADE_ONLY()
    {
      return $this->LOCK_TO_TRADE_ONLY;
    }

    /**
     * @param string $LOCK_TO_TRADE_ONLY
     * @return \Visualsoft\CustomerExportType
     */
    public function setLOCK_TO_TRADE_ONLY($LOCK_TO_TRADE_ONLY)
    {
      $this->LOCK_TO_TRADE_ONLY = $LOCK_TO_TRADE_ONLY;
      return $this;
    }

    /**
     * @return string
     */
    public function getVAT_REGISTRATION_NUMBER()
    {
      return $this->VAT_REGISTRATION_NUMBER;
    }

    /**
     * @param string $VAT_REGISTRATION_NUMBER
     * @return \Visualsoft\CustomerExportType
     */
    public function setVAT_REGISTRATION_NUMBER($VAT_REGISTRATION_NUMBER)
    {
      $this->VAT_REGISTRATION_NUMBER = $VAT_REGISTRATION_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getVAT_EXEMPT()
    {
      return $this->VAT_EXEMPT;
    }

    /**
     * @param string $VAT_EXEMPT
     * @return \Visualsoft\CustomerExportType
     */
    public function setVAT_EXEMPT($VAT_EXEMPT)
    {
      $this->VAT_EXEMPT = $VAT_EXEMPT;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_TYPE()
    {
      return $this->CUSTOMER_TYPE;
    }

    /**
     * @param string $CUSTOMER_TYPE
     * @return \Visualsoft\CustomerExportType
     */
    public function setCUSTOMER_TYPE($CUSTOMER_TYPE)
    {
      $this->CUSTOMER_TYPE = $CUSTOMER_TYPE;
      return $this;
    }

    /**
     * @return string
     */
    public function getEXTERNAL_LOYALTY_PROGRAM_NUMBER()
    {
      return $this->EXTERNAL_LOYALTY_PROGRAM_NUMBER;
    }

    /**
     * @param string $EXTERNAL_LOYALTY_PROGRAM_NUMBER
     * @return \Visualsoft\CustomerExportType
     */
    public function setEXTERNAL_LOYALTY_PROGRAM_NUMBER($EXTERNAL_LOYALTY_PROGRAM_NUMBER)
    {
      $this->EXTERNAL_LOYALTY_PROGRAM_NUMBER = $EXTERNAL_LOYALTY_PROGRAM_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOMPANY_NUMBER()
    {
      return $this->COMPANY_NUMBER;
    }

    /**
     * @param string $COMPANY_NUMBER
     * @return \Visualsoft\CustomerExportType
     */
    public function setCOMPANY_NUMBER($COMPANY_NUMBER)
    {
      $this->COMPANY_NUMBER = $COMPANY_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOMPANY_DOMAIN()
    {
      return $this->COMPANY_DOMAIN;
    }

    /**
     * @param string $COMPANY_DOMAIN
     * @return \Visualsoft\CustomerExportType
     */
    public function setCOMPANY_DOMAIN($COMPANY_DOMAIN)
    {
      $this->COMPANY_DOMAIN = $COMPANY_DOMAIN;
      return $this;
    }

    /**
     * @return string
     */
    public function getEORI_NUMBER()
    {
      return $this->EORI_NUMBER;
    }

    /**
     * @param string $EORI_NUMBER
     * @return \Visualsoft\CustomerExportType
     */
    public function setEORI_NUMBER($EORI_NUMBER)
    {
      $this->EORI_NUMBER = $EORI_NUMBER;
      return $this;
    }

}
