<?php

namespace Visualsoft;

class ComponentType
{

    /**
     * @var int $PRODUCT_ID
     */
    protected $PRODUCT_ID = null;

    /**
     * @var string $REFERENCE
     */
    protected $REFERENCE = null;

    /**
     * @var string $IMPORT_REFERENCE
     */
    protected $IMPORT_REFERENCE = null;

    /**
     * @var string $MODEL
     */
    protected $MODEL = null;

    /**
     * @var string $TITLE
     */
    protected $TITLE = null;

    /**
     * @var float $QUANTITY
     */
    protected $QUANTITY = null;

    /**
     * @var string $EAN
     */
    protected $EAN = null;

    /**
     * @var string $MPN
     */
    protected $MPN = null;

    /**
     * @var string $ISBN
     */
    protected $ISBN = null;

    /**
     * @var string $UPC
     */
    protected $UPC = null;

    /**
     * @var string $WEIGHT
     */
    protected $WEIGHT = null;

    /**
     * @var string $ITEM_IS_DROPSHIP
     */
    protected $ITEM_IS_DROPSHIP = null;

    /**
     * @param int $PRODUCT_ID
     * @param string $REFERENCE
     * @param string $IMPORT_REFERENCE
     * @param string $MODEL
     * @param string $TITLE
     * @param float $QUANTITY
     * @param string $EAN
     * @param string $MPN
     * @param string $ISBN
     * @param string $UPC
     * @param string $WEIGHT
     * @param string $ITEM_IS_DROPSHIP
     */
    public function __construct($PRODUCT_ID, $REFERENCE, $IMPORT_REFERENCE, $MODEL, $TITLE, $QUANTITY, $EAN, $MPN, $ISBN, $UPC, $WEIGHT, $ITEM_IS_DROPSHIP)
    {
      $this->PRODUCT_ID = $PRODUCT_ID;
      $this->REFERENCE = $REFERENCE;
      $this->IMPORT_REFERENCE = $IMPORT_REFERENCE;
      $this->MODEL = $MODEL;
      $this->TITLE = $TITLE;
      $this->QUANTITY = $QUANTITY;
      $this->EAN = $EAN;
      $this->MPN = $MPN;
      $this->ISBN = $ISBN;
      $this->UPC = $UPC;
      $this->WEIGHT = $WEIGHT;
      $this->ITEM_IS_DROPSHIP = $ITEM_IS_DROPSHIP;
    }

    /**
     * @return int
     */
    public function getPRODUCT_ID()
    {
      return $this->PRODUCT_ID;
    }

    /**
     * @param int $PRODUCT_ID
     * @return \Visualsoft\ComponentType
     */
    public function setPRODUCT_ID($PRODUCT_ID)
    {
      $this->PRODUCT_ID = $PRODUCT_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getREFERENCE()
    {
      return $this->REFERENCE;
    }

    /**
     * @param string $REFERENCE
     * @return \Visualsoft\ComponentType
     */
    public function setREFERENCE($REFERENCE)
    {
      $this->REFERENCE = $REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getIMPORT_REFERENCE()
    {
      return $this->IMPORT_REFERENCE;
    }

    /**
     * @param string $IMPORT_REFERENCE
     * @return \Visualsoft\ComponentType
     */
    public function setIMPORT_REFERENCE($IMPORT_REFERENCE)
    {
      $this->IMPORT_REFERENCE = $IMPORT_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getMODEL()
    {
      return $this->MODEL;
    }

    /**
     * @param string $MODEL
     * @return \Visualsoft\ComponentType
     */
    public function setMODEL($MODEL)
    {
      $this->MODEL = $MODEL;
      return $this;
    }

    /**
     * @return string
     */
    public function getTITLE()
    {
      return $this->TITLE;
    }

    /**
     * @param string $TITLE
     * @return \Visualsoft\ComponentType
     */
    public function setTITLE($TITLE)
    {
      $this->TITLE = $TITLE;
      return $this;
    }

    /**
     * @return float
     */
    public function getQUANTITY()
    {
      return $this->QUANTITY;
    }

    /**
     * @param float $QUANTITY
     * @return \Visualsoft\ComponentType
     */
    public function setQUANTITY($QUANTITY)
    {
      $this->QUANTITY = $QUANTITY;
      return $this;
    }

    /**
     * @return string
     */
    public function getEAN()
    {
      return $this->EAN;
    }

    /**
     * @param string $EAN
     * @return \Visualsoft\ComponentType
     */
    public function setEAN($EAN)
    {
      $this->EAN = $EAN;
      return $this;
    }

    /**
     * @return string
     */
    public function getMPN()
    {
      return $this->MPN;
    }

    /**
     * @param string $MPN
     * @return \Visualsoft\ComponentType
     */
    public function setMPN($MPN)
    {
      $this->MPN = $MPN;
      return $this;
    }

    /**
     * @return string
     */
    public function getISBN()
    {
      return $this->ISBN;
    }

    /**
     * @param string $ISBN
     * @return \Visualsoft\ComponentType
     */
    public function setISBN($ISBN)
    {
      $this->ISBN = $ISBN;
      return $this;
    }

    /**
     * @return string
     */
    public function getUPC()
    {
      return $this->UPC;
    }

    /**
     * @param string $UPC
     * @return \Visualsoft\ComponentType
     */
    public function setUPC($UPC)
    {
      $this->UPC = $UPC;
      return $this;
    }

    /**
     * @return string
     */
    public function getWEIGHT()
    {
      return $this->WEIGHT;
    }

    /**
     * @param string $WEIGHT
     * @return \Visualsoft\ComponentType
     */
    public function setWEIGHT($WEIGHT)
    {
      $this->WEIGHT = $WEIGHT;
      return $this;
    }

    /**
     * @return string
     */
    public function getITEM_IS_DROPSHIP()
    {
      return $this->ITEM_IS_DROPSHIP;
    }

    /**
     * @param string $ITEM_IS_DROPSHIP
     * @return \Visualsoft\ComponentType
     */
    public function setITEM_IS_DROPSHIP($ITEM_IS_DROPSHIP)
    {
      $this->ITEM_IS_DROPSHIP = $ITEM_IS_DROPSHIP;
      return $this;
    }

}
