<?php

namespace Visualsoft;

class ArrayOfWebsites implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var WebsiteType[] $WEBSITE
     */
    protected $WEBSITE = null;

    /**
     * @param WebsiteType[] $WEBSITE
     */
    public function __construct(array $WEBSITE)
    {
      $this->WEBSITE = $WEBSITE;
    }

    /**
     * @return WebsiteType[]
     */
    public function getWEBSITE()
    {
      return $this->WEBSITE;
    }

    /**
     * @param WebsiteType[] $WEBSITE
     * @return \Visualsoft\ArrayOfWebsites
     */
    public function setWEBSITE(array $WEBSITE)
    {
      $this->WEBSITE = $WEBSITE;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->WEBSITE[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return WebsiteType
     */
    public function offsetGet($offset)
    {
      return $this->WEBSITE[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param WebsiteType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->WEBSITE[] = $value;
      } else {
        $this->WEBSITE[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->WEBSITE[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return WebsiteType Return the current element
     */
    public function current()
    {
      return current($this->WEBSITE);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->WEBSITE);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->WEBSITE);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->WEBSITE);
    }

    /**
     * Countable implementation
     *
     * @return WebsiteType Return count of elements
     */
    public function count()
    {
      return count($this->WEBSITE);
    }

}
