<?php

namespace Visualsoft;

class ArrayOfTradeDiscounts implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TradeDiscountType[] $TRADE_DISCOUNT
     */
    protected $TRADE_DISCOUNT = null;

    /**
     * @param TradeDiscountType[] $TRADE_DISCOUNT
     */
    public function __construct(array $TRADE_DISCOUNT)
    {
      $this->TRADE_DISCOUNT = $TRADE_DISCOUNT;
    }

    /**
     * @return TradeDiscountType[]
     */
    public function getTRADE_DISCOUNT()
    {
      return $this->TRADE_DISCOUNT;
    }

    /**
     * @param TradeDiscountType[] $TRADE_DISCOUNT
     * @return \Visualsoft\ArrayOfTradeDiscounts
     */
    public function setTRADE_DISCOUNT(array $TRADE_DISCOUNT)
    {
      $this->TRADE_DISCOUNT = $TRADE_DISCOUNT;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TRADE_DISCOUNT[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TradeDiscountType
     */
    public function offsetGet($offset)
    {
      return $this->TRADE_DISCOUNT[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TradeDiscountType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TRADE_DISCOUNT[] = $value;
      } else {
        $this->TRADE_DISCOUNT[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TRADE_DISCOUNT[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TradeDiscountType Return the current element
     */
    public function current()
    {
      return current($this->TRADE_DISCOUNT);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TRADE_DISCOUNT);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TRADE_DISCOUNT);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TRADE_DISCOUNT);
    }

    /**
     * Countable implementation
     *
     * @return TradeDiscountType Return count of elements
     */
    public function count()
    {
      return count($this->TRADE_DISCOUNT);
    }

}
