<?php

namespace Visualsoft;

class ArrayOfSimpleCustomers implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SimpleCustomerType[] $CUSTOMER
     */
    protected $CUSTOMER = null;

    /**
     * @param SimpleCustomerType[] $CUSTOMER
     */
    public function __construct(array $CUSTOMER)
    {
      $this->CUSTOMER = $CUSTOMER;
    }

    /**
     * @return SimpleCustomerType[]
     */
    public function getCUSTOMER()
    {
      return $this->CUSTOMER;
    }

    /**
     * @param SimpleCustomerType[] $CUSTOMER
     * @return \Visualsoft\ArrayOfSimpleCustomers
     */
    public function setCUSTOMER(array $CUSTOMER)
    {
      $this->CUSTOMER = $CUSTOMER;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CUSTOMER[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SimpleCustomerType
     */
    public function offsetGet($offset)
    {
      return $this->CUSTOMER[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SimpleCustomerType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CUSTOMER[] = $value;
      } else {
        $this->CUSTOMER[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CUSTOMER[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SimpleCustomerType Return the current element
     */
    public function current()
    {
      return current($this->CUSTOMER);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CUSTOMER);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CUSTOMER);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CUSTOMER);
    }

    /**
     * Countable implementation
     *
     * @return SimpleCustomerType Return count of elements
     */
    public function count()
    {
      return count($this->CUSTOMER);
    }

}
