<?php
/**
 * StandardPrice
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 3.0 - BETA
 *
 * BETA endpoints for version 3.0 of the Vend API.
 *
 * The version of the OpenAPI document: 3.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend30\Model;

use \ArrayAccess;
use \Vend30\ObjectSerializer;

/**
 * StandardPrice Class Doc Comment
 *
 * @category Class
 * @description Pricing for default tax set for the product. For multiple outlets, StandardPrice will be specified if all are set to \&quot;Default Tax for this Outlet\&quot; and they are the same tax.
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class StandardPrice implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StandardPrice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tax_id' => 'string',
        'is_default' => 'bool',
        'tax_exclusive' => 'double',
        'tax_inclusive' => 'double',
        'loyalty_amount' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tax_id' => 'uuid',
        'is_default' => null,
        'tax_exclusive' => 'double',
        'tax_inclusive' => 'double',
        'loyalty_amount' => 'double'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tax_id' => 'tax_id',
        'is_default' => 'is_default',
        'tax_exclusive' => 'tax_exclusive',
        'tax_inclusive' => 'tax_inclusive',
        'loyalty_amount' => 'loyalty_amount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tax_id' => 'setTaxId',
        'is_default' => 'setIsDefault',
        'tax_exclusive' => 'setTaxExclusive',
        'tax_inclusive' => 'setTaxInclusive',
        'loyalty_amount' => 'setLoyaltyAmount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tax_id' => 'getTaxId',
        'is_default' => 'getIsDefault',
        'tax_exclusive' => 'getTaxExclusive',
        'tax_inclusive' => 'getTaxInclusive',
        'loyalty_amount' => 'getLoyaltyAmount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tax_id'] = $data['tax_id'] ?? null;
        $this->container['is_default'] = $data['is_default'] ?? null;
        $this->container['tax_exclusive'] = $data['tax_exclusive'] ?? null;
        $this->container['tax_inclusive'] = $data['tax_inclusive'] ?? null;
        $this->container['loyalty_amount'] = $data['loyalty_amount'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id The tax id for this product.
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        $this->container['tax_id'] = $tax_id;

        return $this;
    }

    /**
     * Gets is_default
     *
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->container['is_default'];
    }

    /**
     * Sets is_default
     *
     * @param bool|null $is_default Is this the default tax id for this product?
     *
     * @return self
     */
    public function setIsDefault($is_default)
    {
        $this->container['is_default'] = $is_default;

        return $this;
    }

    /**
     * Gets tax_exclusive
     *
     * @return double|null
     */
    public function getTaxExclusive()
    {
        return $this->container['tax_exclusive'];
    }

    /**
     * Sets tax_exclusive
     *
     * @param double|null $tax_exclusive The tax exclusive price for this product.
     *
     * @return self
     */
    public function setTaxExclusive($tax_exclusive)
    {
        $this->container['tax_exclusive'] = $tax_exclusive;

        return $this;
    }

    /**
     * Gets tax_inclusive
     *
     * @return double|null
     */
    public function getTaxInclusive()
    {
        return $this->container['tax_inclusive'];
    }

    /**
     * Sets tax_inclusive
     *
     * @param double|null $tax_inclusive The tax inclusive price for this product.
     *
     * @return self
     */
    public function setTaxInclusive($tax_inclusive)
    {
        $this->container['tax_inclusive'] = $tax_inclusive;

        return $this;
    }

    /**
     * Gets loyalty_amount
     *
     * @return double|null
     */
    public function getLoyaltyAmount()
    {
        return $this->container['loyalty_amount'];
    }

    /**
     * Sets loyalty_amount
     *
     * @param double|null $loyalty_amount The amount of loyalty the customer earns if they buy this product.
     *
     * @return self
     */
    public function setLoyaltyAmount($loyalty_amount)
    {
        $this->container['loyalty_amount'] = $loyalty_amount;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


