<?php
/**
 * ProductVariant
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 3.0 - BETA
 *
 * BETA endpoints for version 3.0 of the Vend API.
 *
 * The version of the OpenAPI document: 3.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend30\Model;

use \ArrayAccess;
use \Vend30\ObjectSerializer;

/**
 * ProductVariant Class Doc Comment
 *
 * @category Class
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ProductVariant implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductVariant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'is_active' => 'bool',
        'price_standard' => '\Vend30\Model\StandardPrice',
        'price_outlet' => '\Vend30\Model\OutletPrice',
        'variant_definitions' => '\Vend30\Model\ProductVariantDefintion[]',
        'images' => '\Vend30\Model\ProductImage[]',
        'primary_sku_code' => 'string',
        'product_codes' => '\Vend30\Model\ProductCode[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'name' => null,
        'is_active' => null,
        'price_standard' => null,
        'price_outlet' => null,
        'variant_definitions' => null,
        'images' => null,
        'primary_sku_code' => null,
        'product_codes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'is_active' => 'is_active',
        'price_standard' => 'price_standard',
        'price_outlet' => 'price_outlet',
        'variant_definitions' => 'variant_definitions',
        'images' => 'images',
        'primary_sku_code' => 'primary_sku_code',
        'product_codes' => 'product_codes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'is_active' => 'setIsActive',
        'price_standard' => 'setPriceStandard',
        'price_outlet' => 'setPriceOutlet',
        'variant_definitions' => 'setVariantDefinitions',
        'images' => 'setImages',
        'primary_sku_code' => 'setPrimarySkuCode',
        'product_codes' => 'setProductCodes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'is_active' => 'getIsActive',
        'price_standard' => 'getPriceStandard',
        'price_outlet' => 'getPriceOutlet',
        'variant_definitions' => 'getVariantDefinitions',
        'images' => 'getImages',
        'primary_sku_code' => 'getPrimarySkuCode',
        'product_codes' => 'getProductCodes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['is_active'] = $data['is_active'] ?? null;
        $this->container['price_standard'] = $data['price_standard'] ?? null;
        $this->container['price_outlet'] = $data['price_outlet'] ?? null;
        $this->container['variant_definitions'] = $data['variant_definitions'] ?? null;
        $this->container['images'] = $data['images'] ?? null;
        $this->container['primary_sku_code'] = $data['primary_sku_code'] ?? null;
        $this->container['product_codes'] = $data['product_codes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the product variant.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool|null $is_active Specifies whether this product is active or not.
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets price_standard
     *
     * @return \Vend30\Model\StandardPrice|null
     */
    public function getPriceStandard()
    {
        return $this->container['price_standard'];
    }

    /**
     * Sets price_standard
     *
     * @param \Vend30\Model\StandardPrice|null $price_standard price_standard
     *
     * @return self
     */
    public function setPriceStandard($price_standard)
    {
        $this->container['price_standard'] = $price_standard;

        return $this;
    }

    /**
     * Gets price_outlet
     *
     * @return \Vend30\Model\OutletPrice|null
     */
    public function getPriceOutlet()
    {
        return $this->container['price_outlet'];
    }

    /**
     * Sets price_outlet
     *
     * @param \Vend30\Model\OutletPrice|null $price_outlet price_outlet
     *
     * @return self
     */
    public function setPriceOutlet($price_outlet)
    {
        $this->container['price_outlet'] = $price_outlet;

        return $this;
    }

    /**
     * Gets variant_definitions
     *
     * @return \Vend30\Model\ProductVariantDefintion[]|null
     */
    public function getVariantDefinitions()
    {
        return $this->container['variant_definitions'];
    }

    /**
     * Sets variant_definitions
     *
     * @param \Vend30\Model\ProductVariantDefintion[]|null $variant_definitions variant_definitions
     *
     * @return self
     */
    public function setVariantDefinitions($variant_definitions)
    {
        $this->container['variant_definitions'] = $variant_definitions;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Vend30\Model\ProductImage[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Vend30\Model\ProductImage[]|null $images images
     *
     * @return self
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets primary_sku_code
     *
     * @return string|null
     */
    public function getPrimarySkuCode()
    {
        return $this->container['primary_sku_code'];
    }

    /**
     * Sets primary_sku_code
     *
     * @param string|null $primary_sku_code Primary code for this item.
     *
     * @return self
     */
    public function setPrimarySkuCode($primary_sku_code)
    {
        $this->container['primary_sku_code'] = $primary_sku_code;

        return $this;
    }

    /**
     * Gets product_codes
     *
     * @return \Vend30\Model\ProductCode[]|null
     */
    public function getProductCodes()
    {
        return $this->container['product_codes'];
    }

    /**
     * Sets product_codes
     *
     * @param \Vend30\Model\ProductCode[]|null $product_codes product_codes
     *
     * @return self
     */
    public function setProductCodes($product_codes)
    {
        $this->container['product_codes'] = $product_codes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


