<?php
/**
 * Product
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 3.0 - BETA
 *
 * BETA endpoints for version 3.0 of the Vend API.
 *
 * The version of the OpenAPI document: 3.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend30\Model;

use \ArrayAccess;
use \Vend30\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'classification' => '\Vend30\Model\ProductClassification',
        'name' => 'string',
        'description' => 'string',
        'is_active' => 'bool',
        'tracks_inventory' => 'bool',
        'version' => 'float',
        'created_at' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string',
        'product_type_id' => 'string',
        'brand_id' => 'string',
        'tag_ids' => 'string[]',
        'suppliers' => '\Vend30\Model\SupplierProduct[]',
        'sku_number' => 'string',
        'product_codes' => '\Vend30\Model\ProductCode[]',
        'account_code_sales' => 'string',
        'account_code_purchase' => 'string',
        'price_standard' => '\Vend30\Model\StandardPrice',
        'price_outlet' => '\Vend30\Model\OutletPrice',
        'images' => '\Vend30\Model\ProductImage[]',
        'variants' => '\Vend30\Model\ProductVariant[]',
        'composite_bom' => 'array<string,string>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'classification' => null,
        'name' => null,
        'description' => null,
        'is_active' => null,
        'tracks_inventory' => null,
        'version' => null,
        'created_at' => null,
        'updated_at' => null,
        'deleted_at' => null,
        'product_type_id' => 'uuid',
        'brand_id' => 'uuid',
        'tag_ids' => 'uuid',
        'suppliers' => null,
        'sku_number' => null,
        'product_codes' => null,
        'account_code_sales' => null,
        'account_code_purchase' => null,
        'price_standard' => null,
        'price_outlet' => null,
        'images' => null,
        'variants' => null,
        'composite_bom' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'classification' => 'classification',
        'name' => 'name',
        'description' => 'description',
        'is_active' => 'is_active',
        'tracks_inventory' => 'tracks_inventory',
        'version' => 'version',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'product_type_id' => 'product_type_id',
        'brand_id' => 'brand_id',
        'tag_ids' => 'tag_ids',
        'suppliers' => 'suppliers',
        'sku_number' => 'sku_number',
        'product_codes' => 'product_codes',
        'account_code_sales' => 'account_code_sales',
        'account_code_purchase' => 'account_code_purchase',
        'price_standard' => 'price_standard',
        'price_outlet' => 'price_outlet',
        'images' => 'images',
        'variants' => 'variants',
        'composite_bom' => 'composite_bom'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'classification' => 'setClassification',
        'name' => 'setName',
        'description' => 'setDescription',
        'is_active' => 'setIsActive',
        'tracks_inventory' => 'setTracksInventory',
        'version' => 'setVersion',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'product_type_id' => 'setProductTypeId',
        'brand_id' => 'setBrandId',
        'tag_ids' => 'setTagIds',
        'suppliers' => 'setSuppliers',
        'sku_number' => 'setSkuNumber',
        'product_codes' => 'setProductCodes',
        'account_code_sales' => 'setAccountCodeSales',
        'account_code_purchase' => 'setAccountCodePurchase',
        'price_standard' => 'setPriceStandard',
        'price_outlet' => 'setPriceOutlet',
        'images' => 'setImages',
        'variants' => 'setVariants',
        'composite_bom' => 'setCompositeBom'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'classification' => 'getClassification',
        'name' => 'getName',
        'description' => 'getDescription',
        'is_active' => 'getIsActive',
        'tracks_inventory' => 'getTracksInventory',
        'version' => 'getVersion',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'product_type_id' => 'getProductTypeId',
        'brand_id' => 'getBrandId',
        'tag_ids' => 'getTagIds',
        'suppliers' => 'getSuppliers',
        'sku_number' => 'getSkuNumber',
        'product_codes' => 'getProductCodes',
        'account_code_sales' => 'getAccountCodeSales',
        'account_code_purchase' => 'getAccountCodePurchase',
        'price_standard' => 'getPriceStandard',
        'price_outlet' => 'getPriceOutlet',
        'images' => 'getImages',
        'variants' => 'getVariants',
        'composite_bom' => 'getCompositeBom'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['classification'] = $data['classification'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['is_active'] = $data['is_active'] ?? null;
        $this->container['tracks_inventory'] = $data['tracks_inventory'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['product_type_id'] = $data['product_type_id'] ?? null;
        $this->container['brand_id'] = $data['brand_id'] ?? null;
        $this->container['tag_ids'] = $data['tag_ids'] ?? null;
        $this->container['suppliers'] = $data['suppliers'] ?? null;
        $this->container['sku_number'] = $data['sku_number'] ?? null;
        $this->container['product_codes'] = $data['product_codes'] ?? null;
        $this->container['account_code_sales'] = $data['account_code_sales'] ?? null;
        $this->container['account_code_purchase'] = $data['account_code_purchase'] ?? null;
        $this->container['price_standard'] = $data['price_standard'] ?? null;
        $this->container['price_outlet'] = $data['price_outlet'] ?? null;
        $this->container['images'] = $data['images'] ?? null;
        $this->container['variants'] = $data['variants'] ?? null;
        $this->container['composite_bom'] = $data['composite_bom'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The auto-generated id for this product.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets classification
     *
     * @return \Vend30\Model\ProductClassification|null
     */
    public function getClassification()
    {
        return $this->container['classification'];
    }

    /**
     * Sets classification
     *
     * @param \Vend30\Model\ProductClassification|null $classification classification
     *
     * @return self
     */
    public function setClassification($classification)
    {
        $this->container['classification'] = $classification;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the product.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The description of the product.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool|null $is_active Whether the product is active or not.
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets tracks_inventory
     *
     * @return bool|null
     */
    public function getTracksInventory()
    {
        return $this->container['tracks_inventory'];
    }

    /**
     * Sets tracks_inventory
     *
     * @param bool|null $tracks_inventory Whether to track inventory for this product or not.
     *
     * @return self
     */
    public function setTracksInventory($tracks_inventory)
    {
        $this->container['tracks_inventory'] = $tracks_inventory;

        return $this;
    }

    /**
     * Gets version
     *
     * @return float|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param float|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at The datetime the product was created at.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at The datetime the product was last updated.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at The datetime the product was deleted at.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets product_type_id
     *
     * @return string|null
     */
    public function getProductTypeId()
    {
        return $this->container['product_type_id'];
    }

    /**
     * Sets product_type_id
     *
     * @param string|null $product_type_id The product type.
     *
     * @return self
     */
    public function setProductTypeId($product_type_id)
    {
        $this->container['product_type_id'] = $product_type_id;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param string|null $brand_id The product brand.
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets tag_ids
     *
     * @return string[]|null
     */
    public function getTagIds()
    {
        return $this->container['tag_ids'];
    }

    /**
     * Sets tag_ids
     *
     * @param string[]|null $tag_ids The tags associated with this product.
     *
     * @return self
     */
    public function setTagIds($tag_ids)
    {
        $this->container['tag_ids'] = $tag_ids;

        return $this;
    }

    /**
     * Gets suppliers
     *
     * @return \Vend30\Model\SupplierProduct[]|null
     */
    public function getSuppliers()
    {
        return $this->container['suppliers'];
    }

    /**
     * Sets suppliers
     *
     * @param \Vend30\Model\SupplierProduct[]|null $suppliers The supplier(s) for this product.
     *
     * @return self
     */
    public function setSuppliers($suppliers)
    {
        $this->container['suppliers'] = $suppliers;

        return $this;
    }

    /**
     * Gets sku_number
     *
     * @return string|null
     */
    public function getSkuNumber()
    {
        return $this->container['sku_number'];
    }

    /**
     * Sets sku_number
     *
     * @param string|null $sku_number The SKU for this product.
     *
     * @return self
     */
    public function setSkuNumber($sku_number)
    {
        $this->container['sku_number'] = $sku_number;

        return $this;
    }

    /**
     * Gets product_codes
     *
     * @return \Vend30\Model\ProductCode[]|null
     */
    public function getProductCodes()
    {
        return $this->container['product_codes'];
    }

    /**
     * Sets product_codes
     *
     * @param \Vend30\Model\ProductCode[]|null $product_codes The product code(s) for this product.
     *
     * @return self
     */
    public function setProductCodes($product_codes)
    {
        $this->container['product_codes'] = $product_codes;

        return $this;
    }

    /**
     * Gets account_code_sales
     *
     * @return string|null
     */
    public function getAccountCodeSales()
    {
        return $this->container['account_code_sales'];
    }

    /**
     * Sets account_code_sales
     *
     * @param string|null $account_code_sales Code used to associate sales of the product with a specific account. When POSTing it should be delivered as `account_code`.
     *
     * @return self
     */
    public function setAccountCodeSales($account_code_sales)
    {
        $this->container['account_code_sales'] = $account_code_sales;

        return $this;
    }

    /**
     * Gets account_code_purchase
     *
     * @return string|null
     */
    public function getAccountCodePurchase()
    {
        return $this->container['account_code_purchase'];
    }

    /**
     * Sets account_code_purchase
     *
     * @param string|null $account_code_purchase Code used to associate purchase (cost) of the product with a specific account.
     *
     * @return self
     */
    public function setAccountCodePurchase($account_code_purchase)
    {
        $this->container['account_code_purchase'] = $account_code_purchase;

        return $this;
    }

    /**
     * Gets price_standard
     *
     * @return \Vend30\Model\StandardPrice|null
     */
    public function getPriceStandard()
    {
        return $this->container['price_standard'];
    }

    /**
     * Sets price_standard
     *
     * @param \Vend30\Model\StandardPrice|null $price_standard price_standard
     *
     * @return self
     */
    public function setPriceStandard($price_standard)
    {
        $this->container['price_standard'] = $price_standard;

        return $this;
    }

    /**
     * Gets price_outlet
     *
     * @return \Vend30\Model\OutletPrice|null
     */
    public function getPriceOutlet()
    {
        return $this->container['price_outlet'];
    }

    /**
     * Sets price_outlet
     *
     * @param \Vend30\Model\OutletPrice|null $price_outlet price_outlet
     *
     * @return self
     */
    public function setPriceOutlet($price_outlet)
    {
        $this->container['price_outlet'] = $price_outlet;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Vend30\Model\ProductImage[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Vend30\Model\ProductImage[]|null $images An array of images associated with this product.
     *
     * @return self
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets variants
     *
     * @return \Vend30\Model\ProductVariant[]|null
     */
    public function getVariants()
    {
        return $this->container['variants'];
    }

    /**
     * Sets variants
     *
     * @param \Vend30\Model\ProductVariant[]|null $variants A list of available variant types for this product (e.g. color, size, etc).
     *
     * @return self
     */
    public function setVariants($variants)
    {
        $this->container['variants'] = $variants;

        return $this;
    }

    /**
     * Gets composite_bom
     *
     * @return array<string,string>|null
     */
    public function getCompositeBom()
    {
        return $this->container['composite_bom'];
    }

    /**
     * Sets composite_bom
     *
     * @param array<string,string>|null $composite_bom composite_bom
     *
     * @return self
     */
    public function setCompositeBom($composite_bom)
    {
        $this->container['composite_bom'] = $composite_bom;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


