<?php
/**
 * OutletPrice
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 3.0 - BETA
 *
 * BETA endpoints for version 3.0 of the Vend API.
 *
 * The version of the OpenAPI document: 3.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend30\Model;

use \ArrayAccess;
use \Vend30\ObjectSerializer;

/**
 * OutletPrice Class Doc Comment
 *
 * @category Class
 * @description Pricing for non-default tax set for the product.  If any of the taxes are set to a non-default tax or explictly set other than \&quot;Default Tax for this Outlet\&quot;, OutetlPrice will be specified.
 * @package  Vend30
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class OutletPrice implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OutletPrice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tax_exclusive' => 'double',
        'loyalty_amount' => 'double',
        'outlets' => '\Vend30\Model\OutletSpecificPrice[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tax_exclusive' => 'double',
        'loyalty_amount' => 'double',
        'outlets' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tax_exclusive' => 'tax_exclusive',
        'loyalty_amount' => 'loyalty_amount',
        'outlets' => 'outlets'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tax_exclusive' => 'setTaxExclusive',
        'loyalty_amount' => 'setLoyaltyAmount',
        'outlets' => 'setOutlets'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tax_exclusive' => 'getTaxExclusive',
        'loyalty_amount' => 'getLoyaltyAmount',
        'outlets' => 'getOutlets'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tax_exclusive'] = $data['tax_exclusive'] ?? null;
        $this->container['loyalty_amount'] = $data['loyalty_amount'] ?? null;
        $this->container['outlets'] = $data['outlets'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tax_exclusive
     *
     * @return double|null
     */
    public function getTaxExclusive()
    {
        return $this->container['tax_exclusive'];
    }

    /**
     * Sets tax_exclusive
     *
     * @param double|null $tax_exclusive The tax exclusive amount for the product at this outlet.
     *
     * @return self
     */
    public function setTaxExclusive($tax_exclusive)
    {
        $this->container['tax_exclusive'] = $tax_exclusive;

        return $this;
    }

    /**
     * Gets loyalty_amount
     *
     * @return double|null
     */
    public function getLoyaltyAmount()
    {
        return $this->container['loyalty_amount'];
    }

    /**
     * Sets loyalty_amount
     *
     * @param double|null $loyalty_amount The amount of loyalty the customer will get if they buy this product.
     *
     * @return self
     */
    public function setLoyaltyAmount($loyalty_amount)
    {
        $this->container['loyalty_amount'] = $loyalty_amount;

        return $this;
    }

    /**
     * Gets outlets
     *
     * @return \Vend30\Model\OutletSpecificPrice[]|null
     */
    public function getOutlets()
    {
        return $this->container['outlets'];
    }

    /**
     * Sets outlets
     *
     * @param \Vend30\Model\OutletSpecificPrice[]|null $outlets outlets
     *
     * @return self
     */
    public function setOutlets($outlets)
    {
        $this->container['outlets'] = $outlets;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


