# Vend30\ProductsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/3.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getProduct()**](ProductsApi.md#getProduct) | **GET** /products/{id} | Get Product
[**listProducts()**](ProductsApi.md#listProducts) | **GET** /products | List Products


## `getProduct()`

```php
getProduct($id): \Vend30\Model\ProductResponse
```

Get Product

Returns the given product.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend30\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend30\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend30\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string | The product id

try {
    $result = $apiInstance->getProduct($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| The product id |

### Return type

[**\Vend30\Model\ProductResponse**](../Model/ProductResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listProducts()`

```php
listProducts($since_version, $page_size, $include_deleted): \Vend30\Model\ProductCollectionResponse
```

List Products

Returns a list of products

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend30\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend30\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend30\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$since_version = 56; // int | Only show the products with version number greater than the value of since_version.
$page_size = 56; // int | The number of products to show per page.
$include_deleted = True; // bool | Whether to include deleted products or not.

try {
    $result = $apiInstance->listProducts($since_version, $page_size, $include_deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->listProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **since_version** | **int**| Only show the products with version number greater than the value of since_version. | [optional]
 **page_size** | **int**| The number of products to show per page. | [optional]
 **include_deleted** | **bool**| Whether to include deleted products or not. | [optional]

### Return type

[**\Vend30\Model\ProductCollectionResponse**](../Model/ProductCollectionResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
