# OpenAPIClient-php

BETA endpoints for version 3.0 of the Vend API.

For more information, please visit [https://developers.retail.lightspeed.app/](https://developers.retail.lightspeed.app/).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/vend2.0.git"
    }
  ],
  "require": {
    "talisman/vend2.0": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: personal_token
$config = Vend30\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend30\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend30\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string | The product id

try {
    $result = $apiInstance->getProduct($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProduct: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://domain_prefix.retail.lightspeed.app/api/3.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ProductsApi* | [**getProduct**](docs/Api/ProductsApi.md#getproduct) | **GET** /products/{id} | Get Product
*ProductsApi* | [**listProducts**](docs/Api/ProductsApi.md#listproducts) | **GET** /products | List Products

## Models

- [ImageProvider](docs/Model/ImageProvider.md)
- [ImageSizes](docs/Model/ImageSizes.md)
- [OutletPrice](docs/Model/OutletPrice.md)
- [OutletSpecificPrice](docs/Model/OutletSpecificPrice.md)
- [Product](docs/Model/Product.md)
- [ProductClassification](docs/Model/ProductClassification.md)
- [ProductCode](docs/Model/ProductCode.md)
- [ProductCollectionResponse](docs/Model/ProductCollectionResponse.md)
- [ProductImage](docs/Model/ProductImage.md)
- [ProductResponse](docs/Model/ProductResponse.md)
- [ProductVariant](docs/Model/ProductVariant.md)
- [ProductVariantDefintion](docs/Model/ProductVariantDefintion.md)
- [StandardPrice](docs/Model/StandardPrice.md)
- [SupplierProduct](docs/Model/SupplierProduct.md)

## Authorization

### personal_token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

api@vendhq.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `3.0`
    - Package version: `3.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
