<?php
/**
 * ProductCommon
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend21
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * vend
 *
 * Vend 2.1 API
 *
 * The version of the OpenAPI document: 2.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend21\Model;

use \ArrayAccess;
use \Vend21\ObjectSerializer;

/**
 * ProductCommon Class Doc Comment
 *
 * @category Class
 * @package  Vend21
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ProductCommon implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductCommon';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'account_code_sale' => 'string',
        'account_code_purchase' => 'string',
        'track_inventory' => 'bool',
        'brand_id' => 'string',
        'product_category_id' => 'string',
        'product_suppliers' => '\Vend21\Model\Supplier[]',
        'variant_attributes' => '\Vend21\Model\Attribute[]',
        'description' => 'string',
        'tag_ids' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'account_code_sale' => null,
        'account_code_purchase' => null,
        'track_inventory' => null,
        'brand_id' => null,
        'product_category_id' => null,
        'product_suppliers' => null,
        'variant_attributes' => null,
        'description' => null,
        'tag_ids' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'account_code_sale' => 'account_code_sale',
        'account_code_purchase' => 'account_code_purchase',
        'track_inventory' => 'track_inventory',
        'brand_id' => 'brand_id',
        'product_category_id' => 'product_category_id',
        'product_suppliers' => 'product_suppliers',
        'variant_attributes' => 'variant_attributes',
        'description' => 'description',
        'tag_ids' => 'tag_ids'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'account_code_sale' => 'setAccountCodeSale',
        'account_code_purchase' => 'setAccountCodePurchase',
        'track_inventory' => 'setTrackInventory',
        'brand_id' => 'setBrandId',
        'product_category_id' => 'setProductCategoryId',
        'product_suppliers' => 'setProductSuppliers',
        'variant_attributes' => 'setVariantAttributes',
        'description' => 'setDescription',
        'tag_ids' => 'setTagIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'account_code_sale' => 'getAccountCodeSale',
        'account_code_purchase' => 'getAccountCodePurchase',
        'track_inventory' => 'getTrackInventory',
        'brand_id' => 'getBrandId',
        'product_category_id' => 'getProductCategoryId',
        'product_suppliers' => 'getProductSuppliers',
        'variant_attributes' => 'getVariantAttributes',
        'description' => 'getDescription',
        'tag_ids' => 'getTagIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['account_code_sale'] = $data['account_code_sale'] ?? null;
        $this->container['account_code_purchase'] = $data['account_code_purchase'] ?? null;
        $this->container['track_inventory'] = $data['track_inventory'] ?? null;
        $this->container['brand_id'] = $data['brand_id'] ?? null;
        $this->container['product_category_id'] = $data['product_category_id'] ?? null;
        $this->container['product_suppliers'] = $data['product_suppliers'] ?? null;
        $this->container['variant_attributes'] = $data['variant_attributes'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['tag_ids'] = $data['tag_ids'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets account_code_sale
     *
     * @return string|null
     */
    public function getAccountCodeSale()
    {
        return $this->container['account_code_sale'];
    }

    /**
     * Sets account_code_sale
     *
     * @param string|null $account_code_sale account_code_sale
     *
     * @return self
     */
    public function setAccountCodeSale($account_code_sale)
    {
        $this->container['account_code_sale'] = $account_code_sale;

        return $this;
    }

    /**
     * Gets account_code_purchase
     *
     * @return string|null
     */
    public function getAccountCodePurchase()
    {
        return $this->container['account_code_purchase'];
    }

    /**
     * Sets account_code_purchase
     *
     * @param string|null $account_code_purchase account_code_purchase
     *
     * @return self
     */
    public function setAccountCodePurchase($account_code_purchase)
    {
        $this->container['account_code_purchase'] = $account_code_purchase;

        return $this;
    }

    /**
     * Gets track_inventory
     *
     * @return bool|null
     */
    public function getTrackInventory()
    {
        return $this->container['track_inventory'];
    }

    /**
     * Sets track_inventory
     *
     * @param bool|null $track_inventory track_inventory
     *
     * @return self
     */
    public function setTrackInventory($track_inventory)
    {
        $this->container['track_inventory'] = $track_inventory;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param string|null $brand_id brand_id
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets product_category_id
     *
     * @return string|null
     */
    public function getProductCategoryId()
    {
        return $this->container['product_category_id'];
    }

    /**
     * Sets product_category_id
     *
     * @param string|null $product_category_id product_category_id
     *
     * @return self
     */
    public function setProductCategoryId($product_category_id)
    {
        $this->container['product_category_id'] = $product_category_id;

        return $this;
    }

    /**
     * Gets product_suppliers
     *
     * @return \Vend21\Model\Supplier[]|null
     */
    public function getProductSuppliers()
    {
        return $this->container['product_suppliers'];
    }

    /**
     * Sets product_suppliers
     *
     * @param \Vend21\Model\Supplier[]|null $product_suppliers product_suppliers
     *
     * @return self
     */
    public function setProductSuppliers($product_suppliers)
    {
        $this->container['product_suppliers'] = $product_suppliers;

        return $this;
    }

    /**
     * Gets variant_attributes
     *
     * @return \Vend21\Model\Attribute[]|null
     */
    public function getVariantAttributes()
    {
        return $this->container['variant_attributes'];
    }

    /**
     * Sets variant_attributes
     *
     * @param \Vend21\Model\Attribute[]|null $variant_attributes variant_attributes
     *
     * @return self
     */
    public function setVariantAttributes($variant_attributes)
    {
        $this->container['variant_attributes'] = $variant_attributes;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets tag_ids
     *
     * @return string[]|null
     */
    public function getTagIds()
    {
        return $this->container['tag_ids'];
    }

    /**
     * Sets tag_ids
     *
     * @param string[]|null $tag_ids tag_ids
     *
     * @return self
     */
    public function setTagIds($tag_ids)
    {
        $this->container['tag_ids'] = $tag_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


