<?php
/**
 * Inventory
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend21
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * vend
 *
 * Vend 2.1 API
 *
 * The version of the OpenAPI document: 2.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend21\Model;

use \ArrayAccess;
use \Vend21\ObjectSerializer;

/**
 * Inventory Class Doc Comment
 *
 * @category Class
 * @package  Vend21
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Inventory implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Inventory';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'outlet_id' => 'string',
        'current_amount' => 'int',
        'reorder_amount' => 'int',
        'reorder_point' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'outlet_id' => null,
        'current_amount' => null,
        'reorder_amount' => null,
        'reorder_point' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'outlet_id' => 'outlet_id',
        'current_amount' => 'current_amount',
        'reorder_amount' => 'reorder_amount',
        'reorder_point' => 'reorder_point'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'outlet_id' => 'setOutletId',
        'current_amount' => 'setCurrentAmount',
        'reorder_amount' => 'setReorderAmount',
        'reorder_point' => 'setReorderPoint'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'outlet_id' => 'getOutletId',
        'current_amount' => 'getCurrentAmount',
        'reorder_amount' => 'getReorderAmount',
        'reorder_point' => 'getReorderPoint'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['current_amount'] = $data['current_amount'] ?? null;
        $this->container['reorder_amount'] = $data['reorder_amount'] ?? null;
        $this->container['reorder_point'] = $data['reorder_point'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets outlet_id
     *
     * @return string|null
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string|null $outlet_id outlet_id
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets current_amount
     *
     * @return int|null
     */
    public function getCurrentAmount()
    {
        return $this->container['current_amount'];
    }

    /**
     * Sets current_amount
     *
     * @param int|null $current_amount current_amount
     *
     * @return self
     */
    public function setCurrentAmount($current_amount)
    {
        $this->container['current_amount'] = $current_amount;

        return $this;
    }

    /**
     * Gets reorder_amount
     *
     * @return int|null
     */
    public function getReorderAmount()
    {
        return $this->container['reorder_amount'];
    }

    /**
     * Sets reorder_amount
     *
     * @param int|null $reorder_amount reorder_amount
     *
     * @return self
     */
    public function setReorderAmount($reorder_amount)
    {
        $this->container['reorder_amount'] = $reorder_amount;

        return $this;
    }

    /**
     * Gets reorder_point
     *
     * @return int|null
     */
    public function getReorderPoint()
    {
        return $this->container['reorder_point'];
    }

    /**
     * Sets reorder_point
     *
     * @param int|null $reorder_point reorder_point
     *
     * @return self
     */
    public function setReorderPoint($reorder_point)
    {
        $this->container['reorder_point'] = $reorder_point;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


