# Vend21\ProductApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createVariant()**](ProductApi.md#createVariant) | **POST** /products | Create a single variant
[**updateProduct()**](ProductApi.md#updateProduct) | **PUT** /products/{id} | 


## `createVariant()`

```php
createVariant($variant)
```

Create a single variant



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Vend21\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$variant = new \Vend21\Model\Variant(); // \Vend21\Model\Variant

try {
    $apiInstance->createVariant($variant);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->createVariant: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **variant** | [**\Vend21\Model\Variant**](../Model/Variant.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProduct()`

```php
updateProduct($id, $product): \Vend21\Model\Product
```





### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Vend21\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$product = new \Vend21\Model\Product(); // \Vend21\Model\Product

try {
    $result = $apiInstance->updateProduct($id, $product);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->updateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  |
 **product** | [**\Vend21\Model\Product**](../Model/Product.md)|  | [optional]

### Return type

[**\Vend21\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
