# OpenAPIClient-php

Vend 2.1 API


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/vend2.0.git"
    }
  ],
  "require": {
    "talisman/vend2.0": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Vend21\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$variant = new \Vend21\Model\Variant(); // \Vend21\Model\Variant

try {
    $apiInstance->createVariant($variant);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->createVariant: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://domain_prefix.retail.lightspeed.app/api/2.1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ProductApi* | [**createVariant**](docs/Api/ProductApi.md#createvariant) | **POST** /products | Create a single variant
*ProductApi* | [**updateProduct**](docs/Api/ProductApi.md#updateproduct) | **PUT** /products/{id} | 

## Models

- [AllOutletTax](docs/Model/AllOutletTax.md)
- [Attribute](docs/Model/Attribute.md)
- [Code](docs/Model/Code.md)
- [Inventory](docs/Model/Inventory.md)
- [OutletTax](docs/Model/OutletTax.md)
- [Packaging](docs/Model/Packaging.md)
- [Product](docs/Model/Product.md)
- [ProductCode](docs/Model/ProductCode.md)
- [ProductCommon](docs/Model/ProductCommon.md)
- [ProductDetails](docs/Model/ProductDetails.md)
- [Supplier](docs/Model/Supplier.md)
- [Tax](docs/Model/Tax.md)
- [Variant](docs/Model/Variant.md)
- [VariantAttributeValue](docs/Model/VariantAttributeValue.md)
- [VariantCommon](docs/Model/VariantCommon.md)
- [VariantDetails](docs/Model/VariantDetails.md)

## Authorization
All endpoints do not require authorization.
## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `2.1`
    - Package version: `2.1`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
