<?php
/**
 * UserImages
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * UserImages Class Doc Comment
 *
 * @category Class
 * @description On object containing URLs for different sizes of the user’s avatar.
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class UserImages implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UserImages';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ss' => 'string',
        'standard' => 'string',
        'st' => 'string',
        'original' => 'string',
        'thumb' => 'string',
        'sl' => 'string',
        'sm' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ss' => null,
        'standard' => null,
        'st' => null,
        'original' => null,
        'thumb' => null,
        'sl' => null,
        'sm' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ss' => 'ss',
        'standard' => 'standard',
        'st' => 'st',
        'original' => 'original',
        'thumb' => 'thumb',
        'sl' => 'sl',
        'sm' => 'sm'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ss' => 'setSs',
        'standard' => 'setStandard',
        'st' => 'setSt',
        'original' => 'setOriginal',
        'thumb' => 'setThumb',
        'sl' => 'setSl',
        'sm' => 'setSm'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ss' => 'getSs',
        'standard' => 'getStandard',
        'st' => 'getSt',
        'original' => 'getOriginal',
        'thumb' => 'getThumb',
        'sl' => 'getSl',
        'sm' => 'getSm'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['ss'] = $data['ss'] ?? null;
        $this->container['standard'] = $data['standard'] ?? null;
        $this->container['st'] = $data['st'] ?? null;
        $this->container['original'] = $data['original'] ?? null;
        $this->container['thumb'] = $data['thumb'] ?? null;
        $this->container['sl'] = $data['sl'] ?? null;
        $this->container['sm'] = $data['sm'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ss
     *
     * @return string|null
     */
    public function getSs()
    {
        return $this->container['ss'];
    }

    /**
     * Sets ss
     *
     * @param string|null $ss ss
     *
     * @return self
     */
    public function setSs($ss)
    {
        $this->container['ss'] = $ss;

        return $this;
    }

    /**
     * Gets standard
     *
     * @return string|null
     */
    public function getStandard()
    {
        return $this->container['standard'];
    }

    /**
     * Sets standard
     *
     * @param string|null $standard standard
     *
     * @return self
     */
    public function setStandard($standard)
    {
        $this->container['standard'] = $standard;

        return $this;
    }

    /**
     * Gets st
     *
     * @return string|null
     */
    public function getSt()
    {
        return $this->container['st'];
    }

    /**
     * Sets st
     *
     * @param string|null $st st
     *
     * @return self
     */
    public function setSt($st)
    {
        $this->container['st'] = $st;

        return $this;
    }

    /**
     * Gets original
     *
     * @return string|null
     */
    public function getOriginal()
    {
        return $this->container['original'];
    }

    /**
     * Sets original
     *
     * @param string|null $original original
     *
     * @return self
     */
    public function setOriginal($original)
    {
        $this->container['original'] = $original;

        return $this;
    }

    /**
     * Gets thumb
     *
     * @return string|null
     */
    public function getThumb()
    {
        return $this->container['thumb'];
    }

    /**
     * Sets thumb
     *
     * @param string|null $thumb thumb
     *
     * @return self
     */
    public function setThumb($thumb)
    {
        $this->container['thumb'] = $thumb;

        return $this;
    }

    /**
     * Gets sl
     *
     * @return string|null
     */
    public function getSl()
    {
        return $this->container['sl'];
    }

    /**
     * Sets sl
     *
     * @param string|null $sl sl
     *
     * @return self
     */
    public function setSl($sl)
    {
        $this->container['sl'] = $sl;

        return $this;
    }

    /**
     * Gets sm
     *
     * @return string|null
     */
    public function getSm()
    {
        return $this->container['sm'];
    }

    /**
     * Sets sm
     *
     * @param string|null $sm sm
     *
     * @return self
     */
    public function setSm($sm)
    {
        $this->container['sm'] = $sm;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


