<?php
/**
 * User
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * User Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class User implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'User';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'username' => 'string',
        'display_name' => 'string',
        'email' => 'string',
        'email_verified_at' => 'string',
        'restricted_outlet_id' => 'string',
        'restricted_outlet_ids' => 'string[]',
        'account_type' => 'string',
        'created_at' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string',
        'seen_at' => 'string',
        'target_daily' => 'float',
        'target_weekly' => 'float',
        'target_monthly' => 'float',
        'version' => 'int',
        'is_primary_user' => 'bool',
        'image_source' => 'string',
        'images' => '\Vend20\Model\UserImages'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'username' => null,
        'display_name' => null,
        'email' => 'email',
        'email_verified_at' => null,
        'restricted_outlet_id' => null,
        'restricted_outlet_ids' => 'uuid',
        'account_type' => null,
        'created_at' => null,
        'updated_at' => null,
        'deleted_at' => null,
        'seen_at' => null,
        'target_daily' => null,
        'target_weekly' => null,
        'target_monthly' => null,
        'version' => 'int64',
        'is_primary_user' => null,
        'image_source' => null,
        'images' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'username' => 'username',
        'display_name' => 'display_name',
        'email' => 'email',
        'email_verified_at' => 'email_verified_at',
        'restricted_outlet_id' => 'restricted_outlet_id',
        'restricted_outlet_ids' => 'restricted_outlet_ids',
        'account_type' => 'account_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'seen_at' => 'seen_at',
        'target_daily' => 'target_daily',
        'target_weekly' => 'target_weekly',
        'target_monthly' => 'target_monthly',
        'version' => 'version',
        'is_primary_user' => 'is_primary_user',
        'image_source' => 'image_source',
        'images' => 'images'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'username' => 'setUsername',
        'display_name' => 'setDisplayName',
        'email' => 'setEmail',
        'email_verified_at' => 'setEmailVerifiedAt',
        'restricted_outlet_id' => 'setRestrictedOutletId',
        'restricted_outlet_ids' => 'setRestrictedOutletIds',
        'account_type' => 'setAccountType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'seen_at' => 'setSeenAt',
        'target_daily' => 'setTargetDaily',
        'target_weekly' => 'setTargetWeekly',
        'target_monthly' => 'setTargetMonthly',
        'version' => 'setVersion',
        'is_primary_user' => 'setIsPrimaryUser',
        'image_source' => 'setImageSource',
        'images' => 'setImages'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'username' => 'getUsername',
        'display_name' => 'getDisplayName',
        'email' => 'getEmail',
        'email_verified_at' => 'getEmailVerifiedAt',
        'restricted_outlet_id' => 'getRestrictedOutletId',
        'restricted_outlet_ids' => 'getRestrictedOutletIds',
        'account_type' => 'getAccountType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'seen_at' => 'getSeenAt',
        'target_daily' => 'getTargetDaily',
        'target_weekly' => 'getTargetWeekly',
        'target_monthly' => 'getTargetMonthly',
        'version' => 'getVersion',
        'is_primary_user' => 'getIsPrimaryUser',
        'image_source' => 'getImageSource',
        'images' => 'getImages'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ACCOUNT_TYPE_CASHIER = 'cashier';
    public const ACCOUNT_TYPE_MANAGER = 'manager';
    public const ACCOUNT_TYPE_ADMIN = 'admin';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAccountTypeAllowableValues()
    {
        return [
            self::ACCOUNT_TYPE_CASHIER,
            self::ACCOUNT_TYPE_MANAGER,
            self::ACCOUNT_TYPE_ADMIN,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['username'] = $data['username'] ?? null;
        $this->container['display_name'] = $data['display_name'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['email_verified_at'] = $data['email_verified_at'] ?? null;
        $this->container['restricted_outlet_id'] = $data['restricted_outlet_id'] ?? null;
        $this->container['restricted_outlet_ids'] = $data['restricted_outlet_ids'] ?? null;
        $this->container['account_type'] = $data['account_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['seen_at'] = $data['seen_at'] ?? null;
        $this->container['target_daily'] = $data['target_daily'] ?? null;
        $this->container['target_weekly'] = $data['target_weekly'] ?? null;
        $this->container['target_monthly'] = $data['target_monthly'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['is_primary_user'] = $data['is_primary_user'] ?? null;
        $this->container['image_source'] = $data['image_source'] ?? null;
        $this->container['images'] = $data['images'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['username'] === null) {
            $invalidProperties[] = "'username' can't be null";
        }
        if ($this->container['account_type'] === null) {
            $invalidProperties[] = "'account_type' can't be null";
        }
        $allowedValues = $this->getAccountTypeAllowableValues();
        if (!is_null($this->container['account_type']) && !in_array($this->container['account_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'account_type', must be one of '%s'",
                $this->container['account_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        if ($this->container['updated_at'] === null) {
            $invalidProperties[] = "'updated_at' can't be null";
        }
        if ($this->container['version'] === null) {
            $invalidProperties[] = "'version' can't be null";
        }
        if ($this->container['is_primary_user'] === null) {
            $invalidProperties[] = "'is_primary_user' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets username
     *
     * @return string
     */
    public function getUsername()
    {
        return $this->container['username'];
    }

    /**
     * Sets username
     *
     * @param string $username User's username used for login.
     *
     * @return self
     */
    public function setUsername($username)
    {
        $this->container['username'] = $username;

        return $this;
    }

    /**
     * Gets display_name
     *
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->container['display_name'];
    }

    /**
     * Sets display_name
     *
     * @param string|null $display_name Full user's name to be used for display in the UI.
     *
     * @return self
     */
    public function setDisplayName($display_name)
    {
        $this->container['display_name'] = $display_name;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email User's email address.
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets email_verified_at
     *
     * @return string|null
     */
    public function getEmailVerifiedAt()
    {
        return $this->container['email_verified_at'];
    }

    /**
     * Sets email_verified_at
     *
     * @param string|null $email_verified_at The timestamp of users email verification.
     *
     * @return self
     */
    public function setEmailVerifiedAt($email_verified_at)
    {
        $this->container['email_verified_at'] = $email_verified_at;

        return $this;
    }

    /**
     * Gets restricted_outlet_id
     *
     * @return string|null
     */
    public function getRestrictedOutletId()
    {
        return $this->container['restricted_outlet_id'];
    }

    /**
     * Sets restricted_outlet_id
     *
     * @param string|null $restricted_outlet_id **deprecated** Use the `restricted_outlet_ids` instead.
     *
     * @return self
     */
    public function setRestrictedOutletId($restricted_outlet_id)
    {
        $this->container['restricted_outlet_id'] = $restricted_outlet_id;

        return $this;
    }

    /**
     * Gets restricted_outlet_ids
     *
     * @return string[]|null
     */
    public function getRestrictedOutletIds()
    {
        return $this->container['restricted_outlet_ids'];
    }

    /**
     * Sets restricted_outlet_ids
     *
     * @param string[]|null $restricted_outlet_ids A list of outlet IDs the user is associated with
     *
     * @return self
     */
    public function setRestrictedOutletIds($restricted_outlet_ids)
    {
        $this->container['restricted_outlet_ids'] = $restricted_outlet_ids;

        return $this;
    }

    /**
     * Gets account_type
     *
     * @return string
     */
    public function getAccountType()
    {
        return $this->container['account_type'];
    }

    /**
     * Sets account_type
     *
     * @param string $account_type User's account type.
     *
     * @return self
     */
    public function setAccountType($account_type)
    {
        $allowedValues = $this->getAccountTypeAllowableValues();
        if (!in_array($account_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'account_type', must be one of '%s'",
                    $account_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['account_type'] = $account_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at Creation timestamp in UTC.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string $updated_at Last update timestamp in UTC.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets seen_at
     *
     * @return string|null
     */
    public function getSeenAt()
    {
        return $this->container['seen_at'];
    }

    /**
     * Sets seen_at
     *
     * @param string|null $seen_at The timestamp of the user's last activity in the system.
     *
     * @return self
     */
    public function setSeenAt($seen_at)
    {
        $this->container['seen_at'] = $seen_at;

        return $this;
    }

    /**
     * Gets target_daily
     *
     * @return float|null
     */
    public function getTargetDaily()
    {
        return $this->container['target_daily'];
    }

    /**
     * Sets target_daily
     *
     * @param float|null $target_daily Daily sales target for the user.
     *
     * @return self
     */
    public function setTargetDaily($target_daily)
    {
        $this->container['target_daily'] = $target_daily;

        return $this;
    }

    /**
     * Gets target_weekly
     *
     * @return float|null
     */
    public function getTargetWeekly()
    {
        return $this->container['target_weekly'];
    }

    /**
     * Sets target_weekly
     *
     * @param float|null $target_weekly Weekly sales target for the user.
     *
     * @return self
     */
    public function setTargetWeekly($target_weekly)
    {
        $this->container['target_weekly'] = $target_weekly;

        return $this;
    }

    /**
     * Gets target_monthly
     *
     * @return float|null
     */
    public function getTargetMonthly()
    {
        return $this->container['target_monthly'];
    }

    /**
     * Sets target_monthly
     *
     * @param float|null $target_monthly Monthly sales target for the user.
     *
     * @return self
     */
    public function setTargetMonthly($target_monthly)
    {
        $this->container['target_monthly'] = $target_monthly;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets is_primary_user
     *
     * @return bool
     */
    public function getIsPrimaryUser()
    {
        return $this->container['is_primary_user'];
    }

    /**
     * Sets is_primary_user
     *
     * @param bool $is_primary_user Indicated whether this user is the primary user for the account.
     *
     * @return self
     */
    public function setIsPrimaryUser($is_primary_user)
    {
        $this->container['is_primary_user'] = $is_primary_user;

        return $this;
    }

    /**
     * Gets image_source
     *
     * @return string|null
     */
    public function getImageSource()
    {
        return $this->container['image_source'];
    }

    /**
     * Sets image_source
     *
     * @param string|null $image_source URL of the default-sized user's avatar.
     *
     * @return self
     */
    public function setImageSource($image_source)
    {
        $this->container['image_source'] = $image_source;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Vend20\Model\UserImages|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Vend20\Model\UserImages|null $images images
     *
     * @return self
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


