<?php
/**
 * SearchResponseOneOf
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * SearchResponseOneOf Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SearchResponseOneOf implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SearchResponseOneOf';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'handle' => 'string',
        'sku' => 'string',
        'source' => 'string',
        'source_id' => 'string',
        'source_variant_id' => 'string',
        'active' => 'bool',
        'has_inventory' => 'bool',
        'is_composite' => 'bool',
        'has_variants' => 'bool',
        'variant_parent_id' => 'string',
        'variant_name' => 'string',
        'variant_options' => '\Vend20\Model\VariantOption[]',
        'variant_count' => 'int',
        'price_including_tax' => 'float',
        'price_excluding_tax' => 'float',
        'supply_price' => 'double',
        'supplier_id' => 'string',
        'supplier_code' => 'string',
        'supplier' => '\Vend20\Model\Supplier',
        'product_type_id' => 'string',
        'type' => '\Vend20\Model\ProductTypeSample',
        'brand_id' => 'string',
        'brand' => '\Vend20\Model\BrandSample',
        'tag_ids' => 'string[]',
        'categories' => '\Vend20\Model\Tag[]',
        'attributes' => '\Vend20\Model\Attribute[]',
        'image_url' => 'string',
        'image_thumbnail_url' => 'string',
        'images' => '\Vend20\Model\ImageSample[]',
        'account_code' => 'string',
        'account_code_purchase' => 'string',
        'button_order' => 'int',
        'created_at' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string',
        'version' => 'int',
        'product_codes' => '\Vend20\Model\ProductCode[]',
        'outlet_id' => 'string',
        'register_id' => 'string',
        'user_id' => 'string',
        'customer_id' => 'string',
        'invoice_number' => 'string',
        'invoice_sequence' => 'double',
        'status' => 'string',
        'note' => 'string',
        'short_code' => 'string',
        'return_for' => 'string',
        'total_price' => 'double',
        'total_tax' => 'double',
        'total_loyalty' => 'double',
        'sale_date' => 'string',
        'taxes' => '\Vend20\Model\SaleTax[]',
        'line_items' => '\Vend20\Model\LineItem[]',
        'payments' => '\Vend20\Model\Payment[]',
        'adjustments' => '\Vend20\Model\Adjustment[]',
        'first_name' => 'string',
        'last_name' => 'string',
        'customer_code' => 'string',
        'customer_group_id' => 'string',
        'enable_loyalty' => 'bool',
        'email' => 'string',
        'gender' => 'string',
        'date_of_birth' => 'string',
        'company_name' => 'string',
        'do_not_email' => 'bool',
        'phone' => 'string',
        'mobile' => 'string',
        'fax' => 'string',
        'twitter' => 'string',
        'website' => 'string',
        'physical_address_1' => 'string',
        'physical_address_2' => 'string',
        'physical_suburb' => 'string',
        'physical_city' => 'string',
        'physical_postcode' => 'string',
        'physical_state' => 'string',
        'physical_country_id' => 'string',
        'postal_address_1' => 'string',
        'postal_address_2' => 'string',
        'postal_suburb' => 'string',
        'postal_city' => 'string',
        'postal_postcode' => 'string',
        'postal_state' => 'string',
        'postal_country_id' => 'string',
        'custom_field_1' => 'string',
        'custom_field_2' => 'string',
        'custom_field_3' => 'string',
        'custom_field_4' => 'string',
        'year_to_date' => 'double',
        'balance' => 'double',
        'loyalty_balance' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'description' => null,
        'handle' => null,
        'sku' => null,
        'source' => null,
        'source_id' => null,
        'source_variant_id' => null,
        'active' => null,
        'has_inventory' => null,
        'is_composite' => null,
        'has_variants' => null,
        'variant_parent_id' => 'UUID',
        'variant_name' => null,
        'variant_options' => null,
        'variant_count' => null,
        'price_including_tax' => null,
        'price_excluding_tax' => null,
        'supply_price' => 'double',
        'supplier_id' => 'UUID',
        'supplier_code' => null,
        'supplier' => null,
        'product_type_id' => 'UUID',
        'type' => null,
        'brand_id' => 'UUID',
        'brand' => null,
        'tag_ids' => 'UUID',
        'categories' => null,
        'attributes' => null,
        'image_url' => null,
        'image_thumbnail_url' => null,
        'images' => null,
        'account_code' => null,
        'account_code_purchase' => null,
        'button_order' => null,
        'created_at' => null,
        'updated_at' => null,
        'deleted_at' => null,
        'version' => 'int64',
        'product_codes' => null,
        'outlet_id' => null,
        'register_id' => null,
        'user_id' => null,
        'customer_id' => null,
        'invoice_number' => null,
        'invoice_sequence' => 'double',
        'status' => null,
        'note' => null,
        'short_code' => null,
        'return_for' => null,
        'total_price' => 'double',
        'total_tax' => 'double',
        'total_loyalty' => 'double',
        'sale_date' => null,
        'taxes' => null,
        'line_items' => null,
        'payments' => null,
        'adjustments' => null,
        'first_name' => null,
        'last_name' => null,
        'customer_code' => null,
        'customer_group_id' => null,
        'enable_loyalty' => null,
        'email' => null,
        'gender' => null,
        'date_of_birth' => null,
        'company_name' => null,
        'do_not_email' => null,
        'phone' => null,
        'mobile' => null,
        'fax' => null,
        'twitter' => null,
        'website' => null,
        'physical_address_1' => null,
        'physical_address_2' => null,
        'physical_suburb' => null,
        'physical_city' => null,
        'physical_postcode' => null,
        'physical_state' => null,
        'physical_country_id' => null,
        'postal_address_1' => null,
        'postal_address_2' => null,
        'postal_suburb' => null,
        'postal_city' => null,
        'postal_postcode' => null,
        'postal_state' => null,
        'postal_country_id' => null,
        'custom_field_1' => null,
        'custom_field_2' => null,
        'custom_field_3' => null,
        'custom_field_4' => null,
        'year_to_date' => 'double',
        'balance' => 'double',
        'loyalty_balance' => 'double'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'handle' => 'handle',
        'sku' => 'sku',
        'source' => 'source',
        'source_id' => 'source_id',
        'source_variant_id' => 'source_variant_id',
        'active' => 'active',
        'has_inventory' => 'has_inventory',
        'is_composite' => 'is_composite',
        'has_variants' => 'has_variants',
        'variant_parent_id' => 'variant_parent_id',
        'variant_name' => 'variant_name',
        'variant_options' => 'variant_options',
        'variant_count' => 'variant_count',
        'price_including_tax' => 'price_including_tax',
        'price_excluding_tax' => 'price_excluding_tax',
        'supply_price' => 'supply_price',
        'supplier_id' => 'supplier_id',
        'supplier_code' => 'supplier_code',
        'supplier' => 'supplier',
        'product_type_id' => 'product_type_id',
        'type' => 'type',
        'brand_id' => 'brand_id',
        'brand' => 'brand',
        'tag_ids' => 'tag_ids',
        'categories' => 'categories',
        'attributes' => 'attributes',
        'image_url' => 'image_url',
        'image_thumbnail_url' => 'image_thumbnail_url',
        'images' => 'images',
        'account_code' => 'account_code',
        'account_code_purchase' => 'account_code_purchase',
        'button_order' => 'button_order',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'version' => 'version',
        'product_codes' => 'product_codes',
        'outlet_id' => 'outlet_id',
        'register_id' => 'register_id',
        'user_id' => 'user_id',
        'customer_id' => 'customer_id',
        'invoice_number' => 'invoice_number',
        'invoice_sequence' => 'invoice_sequence',
        'status' => 'status',
        'note' => 'note',
        'short_code' => 'short_code',
        'return_for' => 'return_for',
        'total_price' => 'total_price',
        'total_tax' => 'total_tax',
        'total_loyalty' => 'total_loyalty',
        'sale_date' => 'sale_date',
        'taxes' => 'taxes',
        'line_items' => 'line_items',
        'payments' => 'payments',
        'adjustments' => 'adjustments',
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'customer_code' => 'customer_code',
        'customer_group_id' => 'customer_group_id',
        'enable_loyalty' => 'enable_loyalty',
        'email' => 'email',
        'gender' => 'gender',
        'date_of_birth' => 'date_of_birth',
        'company_name' => 'company_name',
        'do_not_email' => 'do_not_email',
        'phone' => 'phone',
        'mobile' => 'mobile',
        'fax' => 'fax',
        'twitter' => 'twitter',
        'website' => 'website',
        'physical_address_1' => 'physical_address_1',
        'physical_address_2' => 'physical_address_2',
        'physical_suburb' => 'physical_suburb',
        'physical_city' => 'physical_city',
        'physical_postcode' => 'physical_postcode',
        'physical_state' => 'physical_state',
        'physical_country_id' => 'physical_country_id',
        'postal_address_1' => 'postal_address_1',
        'postal_address_2' => 'postal_address_2',
        'postal_suburb' => 'postal_suburb',
        'postal_city' => 'postal_city',
        'postal_postcode' => 'postal_postcode',
        'postal_state' => 'postal_state',
        'postal_country_id' => 'postal_country_id',
        'custom_field_1' => 'custom_field_1',
        'custom_field_2' => 'custom_field_2',
        'custom_field_3' => 'custom_field_3',
        'custom_field_4' => 'custom_field_4',
        'year_to_date' => 'year_to_date',
        'balance' => 'balance',
        'loyalty_balance' => 'loyalty_balance'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'handle' => 'setHandle',
        'sku' => 'setSku',
        'source' => 'setSource',
        'source_id' => 'setSourceId',
        'source_variant_id' => 'setSourceVariantId',
        'active' => 'setActive',
        'has_inventory' => 'setHasInventory',
        'is_composite' => 'setIsComposite',
        'has_variants' => 'setHasVariants',
        'variant_parent_id' => 'setVariantParentId',
        'variant_name' => 'setVariantName',
        'variant_options' => 'setVariantOptions',
        'variant_count' => 'setVariantCount',
        'price_including_tax' => 'setPriceIncludingTax',
        'price_excluding_tax' => 'setPriceExcludingTax',
        'supply_price' => 'setSupplyPrice',
        'supplier_id' => 'setSupplierId',
        'supplier_code' => 'setSupplierCode',
        'supplier' => 'setSupplier',
        'product_type_id' => 'setProductTypeId',
        'type' => 'setType',
        'brand_id' => 'setBrandId',
        'brand' => 'setBrand',
        'tag_ids' => 'setTagIds',
        'categories' => 'setCategories',
        'attributes' => 'setAttributes',
        'image_url' => 'setImageUrl',
        'image_thumbnail_url' => 'setImageThumbnailUrl',
        'images' => 'setImages',
        'account_code' => 'setAccountCode',
        'account_code_purchase' => 'setAccountCodePurchase',
        'button_order' => 'setButtonOrder',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'version' => 'setVersion',
        'product_codes' => 'setProductCodes',
        'outlet_id' => 'setOutletId',
        'register_id' => 'setRegisterId',
        'user_id' => 'setUserId',
        'customer_id' => 'setCustomerId',
        'invoice_number' => 'setInvoiceNumber',
        'invoice_sequence' => 'setInvoiceSequence',
        'status' => 'setStatus',
        'note' => 'setNote',
        'short_code' => 'setShortCode',
        'return_for' => 'setReturnFor',
        'total_price' => 'setTotalPrice',
        'total_tax' => 'setTotalTax',
        'total_loyalty' => 'setTotalLoyalty',
        'sale_date' => 'setSaleDate',
        'taxes' => 'setTaxes',
        'line_items' => 'setLineItems',
        'payments' => 'setPayments',
        'adjustments' => 'setAdjustments',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'customer_code' => 'setCustomerCode',
        'customer_group_id' => 'setCustomerGroupId',
        'enable_loyalty' => 'setEnableLoyalty',
        'email' => 'setEmail',
        'gender' => 'setGender',
        'date_of_birth' => 'setDateOfBirth',
        'company_name' => 'setCompanyName',
        'do_not_email' => 'setDoNotEmail',
        'phone' => 'setPhone',
        'mobile' => 'setMobile',
        'fax' => 'setFax',
        'twitter' => 'setTwitter',
        'website' => 'setWebsite',
        'physical_address_1' => 'setPhysicalAddress1',
        'physical_address_2' => 'setPhysicalAddress2',
        'physical_suburb' => 'setPhysicalSuburb',
        'physical_city' => 'setPhysicalCity',
        'physical_postcode' => 'setPhysicalPostcode',
        'physical_state' => 'setPhysicalState',
        'physical_country_id' => 'setPhysicalCountryId',
        'postal_address_1' => 'setPostalAddress1',
        'postal_address_2' => 'setPostalAddress2',
        'postal_suburb' => 'setPostalSuburb',
        'postal_city' => 'setPostalCity',
        'postal_postcode' => 'setPostalPostcode',
        'postal_state' => 'setPostalState',
        'postal_country_id' => 'setPostalCountryId',
        'custom_field_1' => 'setCustomField1',
        'custom_field_2' => 'setCustomField2',
        'custom_field_3' => 'setCustomField3',
        'custom_field_4' => 'setCustomField4',
        'year_to_date' => 'setYearToDate',
        'balance' => 'setBalance',
        'loyalty_balance' => 'setLoyaltyBalance'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'handle' => 'getHandle',
        'sku' => 'getSku',
        'source' => 'getSource',
        'source_id' => 'getSourceId',
        'source_variant_id' => 'getSourceVariantId',
        'active' => 'getActive',
        'has_inventory' => 'getHasInventory',
        'is_composite' => 'getIsComposite',
        'has_variants' => 'getHasVariants',
        'variant_parent_id' => 'getVariantParentId',
        'variant_name' => 'getVariantName',
        'variant_options' => 'getVariantOptions',
        'variant_count' => 'getVariantCount',
        'price_including_tax' => 'getPriceIncludingTax',
        'price_excluding_tax' => 'getPriceExcludingTax',
        'supply_price' => 'getSupplyPrice',
        'supplier_id' => 'getSupplierId',
        'supplier_code' => 'getSupplierCode',
        'supplier' => 'getSupplier',
        'product_type_id' => 'getProductTypeId',
        'type' => 'getType',
        'brand_id' => 'getBrandId',
        'brand' => 'getBrand',
        'tag_ids' => 'getTagIds',
        'categories' => 'getCategories',
        'attributes' => 'getAttributes',
        'image_url' => 'getImageUrl',
        'image_thumbnail_url' => 'getImageThumbnailUrl',
        'images' => 'getImages',
        'account_code' => 'getAccountCode',
        'account_code_purchase' => 'getAccountCodePurchase',
        'button_order' => 'getButtonOrder',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'version' => 'getVersion',
        'product_codes' => 'getProductCodes',
        'outlet_id' => 'getOutletId',
        'register_id' => 'getRegisterId',
        'user_id' => 'getUserId',
        'customer_id' => 'getCustomerId',
        'invoice_number' => 'getInvoiceNumber',
        'invoice_sequence' => 'getInvoiceSequence',
        'status' => 'getStatus',
        'note' => 'getNote',
        'short_code' => 'getShortCode',
        'return_for' => 'getReturnFor',
        'total_price' => 'getTotalPrice',
        'total_tax' => 'getTotalTax',
        'total_loyalty' => 'getTotalLoyalty',
        'sale_date' => 'getSaleDate',
        'taxes' => 'getTaxes',
        'line_items' => 'getLineItems',
        'payments' => 'getPayments',
        'adjustments' => 'getAdjustments',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'customer_code' => 'getCustomerCode',
        'customer_group_id' => 'getCustomerGroupId',
        'enable_loyalty' => 'getEnableLoyalty',
        'email' => 'getEmail',
        'gender' => 'getGender',
        'date_of_birth' => 'getDateOfBirth',
        'company_name' => 'getCompanyName',
        'do_not_email' => 'getDoNotEmail',
        'phone' => 'getPhone',
        'mobile' => 'getMobile',
        'fax' => 'getFax',
        'twitter' => 'getTwitter',
        'website' => 'getWebsite',
        'physical_address_1' => 'getPhysicalAddress1',
        'physical_address_2' => 'getPhysicalAddress2',
        'physical_suburb' => 'getPhysicalSuburb',
        'physical_city' => 'getPhysicalCity',
        'physical_postcode' => 'getPhysicalPostcode',
        'physical_state' => 'getPhysicalState',
        'physical_country_id' => 'getPhysicalCountryId',
        'postal_address_1' => 'getPostalAddress1',
        'postal_address_2' => 'getPostalAddress2',
        'postal_suburb' => 'getPostalSuburb',
        'postal_city' => 'getPostalCity',
        'postal_postcode' => 'getPostalPostcode',
        'postal_state' => 'getPostalState',
        'postal_country_id' => 'getPostalCountryId',
        'custom_field_1' => 'getCustomField1',
        'custom_field_2' => 'getCustomField2',
        'custom_field_3' => 'getCustomField3',
        'custom_field_4' => 'getCustomField4',
        'year_to_date' => 'getYearToDate',
        'balance' => 'getBalance',
        'loyalty_balance' => 'getLoyaltyBalance'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATUS_SAVED = 'SAVED';
    public const STATUS_CLOSED = 'CLOSED';
    public const STATUS_ONACCOUNT = 'ONACCOUNT';
    public const STATUS_LAYBY = 'LAYBY';
    public const STATUS_ONACCOUNT_CLOSED = 'ONACCOUNT_CLOSED';
    public const STATUS_LAYBY_CLOSED = 'LAYBY_CLOSED';
    public const STATUS_AWAITING_DISPATCH = 'AWAITING_DISPATCH';
    public const STATUS_AWAITING_PICKUP = 'AWAITING_PICKUP';
    public const STATUS_DISPATCHED_CLOSED = 'DISPATCHED_CLOSED';
    public const STATUS_PICKED_UP_CLOSED = 'PICKED_UP_CLOSED';
    public const STATUS_VOIDED = 'VOIDED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_SAVED,
            self::STATUS_CLOSED,
            self::STATUS_ONACCOUNT,
            self::STATUS_LAYBY,
            self::STATUS_ONACCOUNT_CLOSED,
            self::STATUS_LAYBY_CLOSED,
            self::STATUS_AWAITING_DISPATCH,
            self::STATUS_AWAITING_PICKUP,
            self::STATUS_DISPATCHED_CLOSED,
            self::STATUS_PICKED_UP_CLOSED,
            self::STATUS_VOIDED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['handle'] = $data['handle'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['source'] = $data['source'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['source_variant_id'] = $data['source_variant_id'] ?? null;
        $this->container['active'] = $data['active'] ?? null;
        $this->container['has_inventory'] = $data['has_inventory'] ?? null;
        $this->container['is_composite'] = $data['is_composite'] ?? null;
        $this->container['has_variants'] = $data['has_variants'] ?? null;
        $this->container['variant_parent_id'] = $data['variant_parent_id'] ?? null;
        $this->container['variant_name'] = $data['variant_name'] ?? null;
        $this->container['variant_options'] = $data['variant_options'] ?? null;
        $this->container['variant_count'] = $data['variant_count'] ?? null;
        $this->container['price_including_tax'] = $data['price_including_tax'] ?? null;
        $this->container['price_excluding_tax'] = $data['price_excluding_tax'] ?? null;
        $this->container['supply_price'] = $data['supply_price'] ?? null;
        $this->container['supplier_id'] = $data['supplier_id'] ?? null;
        $this->container['supplier_code'] = $data['supplier_code'] ?? null;
        $this->container['supplier'] = $data['supplier'] ?? null;
        $this->container['product_type_id'] = $data['product_type_id'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['brand_id'] = $data['brand_id'] ?? null;
        $this->container['brand'] = $data['brand'] ?? null;
        $this->container['tag_ids'] = $data['tag_ids'] ?? null;
        $this->container['categories'] = $data['categories'] ?? null;
        $this->container['attributes'] = $data['attributes'] ?? null;
        $this->container['image_url'] = $data['image_url'] ?? null;
        $this->container['image_thumbnail_url'] = $data['image_thumbnail_url'] ?? null;
        $this->container['images'] = $data['images'] ?? null;
        $this->container['account_code'] = $data['account_code'] ?? null;
        $this->container['account_code_purchase'] = $data['account_code_purchase'] ?? null;
        $this->container['button_order'] = $data['button_order'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['product_codes'] = $data['product_codes'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['register_id'] = $data['register_id'] ?? null;
        $this->container['user_id'] = $data['user_id'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['invoice_number'] = $data['invoice_number'] ?? null;
        $this->container['invoice_sequence'] = $data['invoice_sequence'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['note'] = $data['note'] ?? null;
        $this->container['short_code'] = $data['short_code'] ?? null;
        $this->container['return_for'] = $data['return_for'] ?? null;
        $this->container['total_price'] = $data['total_price'] ?? null;
        $this->container['total_tax'] = $data['total_tax'] ?? null;
        $this->container['total_loyalty'] = $data['total_loyalty'] ?? null;
        $this->container['sale_date'] = $data['sale_date'] ?? null;
        $this->container['taxes'] = $data['taxes'] ?? null;
        $this->container['line_items'] = $data['line_items'] ?? null;
        $this->container['payments'] = $data['payments'] ?? null;
        $this->container['adjustments'] = $data['adjustments'] ?? null;
        $this->container['first_name'] = $data['first_name'] ?? null;
        $this->container['last_name'] = $data['last_name'] ?? null;
        $this->container['customer_code'] = $data['customer_code'] ?? null;
        $this->container['customer_group_id'] = $data['customer_group_id'] ?? null;
        $this->container['enable_loyalty'] = $data['enable_loyalty'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['gender'] = $data['gender'] ?? null;
        $this->container['date_of_birth'] = $data['date_of_birth'] ?? null;
        $this->container['company_name'] = $data['company_name'] ?? null;
        $this->container['do_not_email'] = $data['do_not_email'] ?? false;
        $this->container['phone'] = $data['phone'] ?? null;
        $this->container['mobile'] = $data['mobile'] ?? null;
        $this->container['fax'] = $data['fax'] ?? null;
        $this->container['twitter'] = $data['twitter'] ?? null;
        $this->container['website'] = $data['website'] ?? null;
        $this->container['physical_address_1'] = $data['physical_address_1'] ?? null;
        $this->container['physical_address_2'] = $data['physical_address_2'] ?? null;
        $this->container['physical_suburb'] = $data['physical_suburb'] ?? null;
        $this->container['physical_city'] = $data['physical_city'] ?? null;
        $this->container['physical_postcode'] = $data['physical_postcode'] ?? null;
        $this->container['physical_state'] = $data['physical_state'] ?? null;
        $this->container['physical_country_id'] = $data['physical_country_id'] ?? null;
        $this->container['postal_address_1'] = $data['postal_address_1'] ?? null;
        $this->container['postal_address_2'] = $data['postal_address_2'] ?? null;
        $this->container['postal_suburb'] = $data['postal_suburb'] ?? null;
        $this->container['postal_city'] = $data['postal_city'] ?? null;
        $this->container['postal_postcode'] = $data['postal_postcode'] ?? null;
        $this->container['postal_state'] = $data['postal_state'] ?? null;
        $this->container['postal_country_id'] = $data['postal_country_id'] ?? null;
        $this->container['custom_field_1'] = $data['custom_field_1'] ?? null;
        $this->container['custom_field_2'] = $data['custom_field_2'] ?? null;
        $this->container['custom_field_3'] = $data['custom_field_3'] ?? null;
        $this->container['custom_field_4'] = $data['custom_field_4'] ?? null;
        $this->container['year_to_date'] = $data['year_to_date'] ?? null;
        $this->container['balance'] = $data['balance'] ?? null;
        $this->container['loyalty_balance'] = $data['loyalty_balance'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['handle'] === null) {
            $invalidProperties[] = "'handle' can't be null";
        }
        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['first_name'] === null) {
            $invalidProperties[] = "'first_name' can't be null";
        }
        if ($this->container['last_name'] === null) {
            $invalidProperties[] = "'last_name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Customers full name. **deprecated**
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description A detailed description of the Product. **Note** Can contain HTML.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets handle
     *
     * @return string
     */
    public function getHandle()
    {
        return $this->container['handle'];
    }

    /**
     * Sets handle
     *
     * @param string $handle Product handle. **Note:** Variants share the same handle.
     *
     * @return self
     */
    public function setHandle($handle)
    {
        $this->container['handle'] = $handle;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku Product sku. **Note:** Should be unique, but it's not verified while posting.
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source Origin of the sale. USER for sales created in Vend client apps, SHOPIFY for sale synced from Shopify by the integration, ECOMMERCE for sales coming from Vend Ecommerce.
     *
     * @return self
     */
    public function setSource($source)
    {
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id External ID for sales coming from other systems
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_variant_id
     *
     * @return string|null
     */
    public function getSourceVariantId()
    {
        return $this->container['source_variant_id'];
    }

    /**
     * Sets source_variant_id
     *
     * @param string|null $source_variant_id Secondary external reference ID.
     *
     * @return self
     */
    public function setSourceVariantId($source_variant_id)
    {
        $this->container['source_variant_id'] = $source_variant_id;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Indicated whether the Product is active.
     *
     * @return self
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets has_inventory
     *
     * @return bool|null
     */
    public function getHasInventory()
    {
        return $this->container['has_inventory'];
    }

    /**
     * Sets has_inventory
     *
     * @param bool|null $has_inventory Indicates whether inventory is being tracked for the Product.
     *
     * @return self
     */
    public function setHasInventory($has_inventory)
    {
        $this->container['has_inventory'] = $has_inventory;

        return $this;
    }

    /**
     * Gets is_composite
     *
     * @return bool|null
     */
    public function getIsComposite()
    {
        return $this->container['is_composite'];
    }

    /**
     * Sets is_composite
     *
     * @param bool|null $is_composite Indicates whether the Product is a composite one.
     *
     * @return self
     */
    public function setIsComposite($is_composite)
    {
        $this->container['is_composite'] = $is_composite;

        return $this;
    }

    /**
     * Gets has_variants
     *
     * @return bool|null
     */
    public function getHasVariants()
    {
        return $this->container['has_variants'];
    }

    /**
     * Sets has_variants
     *
     * @param bool|null $has_variants Indicated whether product has variants.
     *
     * @return self
     */
    public function setHasVariants($has_variants)
    {
        $this->container['has_variants'] = $has_variants;

        return $this;
    }

    /**
     * Gets variant_parent_id
     *
     * @return string|null
     */
    public function getVariantParentId()
    {
        return $this->container['variant_parent_id'];
    }

    /**
     * Sets variant_parent_id
     *
     * @param string|null $variant_parent_id This value is set if a Product is a variant of another Product.
     *
     * @return self
     */
    public function setVariantParentId($variant_parent_id)
    {
        $this->container['variant_parent_id'] = $variant_parent_id;

        return $this;
    }

    /**
     * Gets variant_name
     *
     * @return string|null
     */
    public function getVariantName()
    {
        return $this->container['variant_name'];
    }

    /**
     * Sets variant_name
     *
     * @param string|null $variant_name The name of the variant product.
     *
     * @return self
     */
    public function setVariantName($variant_name)
    {
        $this->container['variant_name'] = $variant_name;

        return $this;
    }

    /**
     * Gets variant_options
     *
     * @return \Vend20\Model\VariantOption[]|null
     */
    public function getVariantOptions()
    {
        return $this->container['variant_options'];
    }

    /**
     * Sets variant_options
     *
     * @param \Vend20\Model\VariantOption[]|null $variant_options A list of variant option objects.
     *
     * @return self
     */
    public function setVariantOptions($variant_options)
    {
        $this->container['variant_options'] = $variant_options;

        return $this;
    }

    /**
     * Gets variant_count
     *
     * @return int|null
     */
    public function getVariantCount()
    {
        return $this->container['variant_count'];
    }

    /**
     * Sets variant_count
     *
     * @param int|null $variant_count The number of variants for this product.
     *
     * @return self
     */
    public function setVariantCount($variant_count)
    {
        $this->container['variant_count'] = $variant_count;

        return $this;
    }

    /**
     * Gets price_including_tax
     *
     * @return float|null
     */
    public function getPriceIncludingTax()
    {
        return $this->container['price_including_tax'];
    }

    /**
     * Sets price_including_tax
     *
     * @param float|null $price_including_tax The price including all the relevant taxes.
     *
     * @return self
     */
    public function setPriceIncludingTax($price_including_tax)
    {
        $this->container['price_including_tax'] = $price_including_tax;

        return $this;
    }

    /**
     * Gets price_excluding_tax
     *
     * @return float|null
     */
    public function getPriceExcludingTax()
    {
        return $this->container['price_excluding_tax'];
    }

    /**
     * Sets price_excluding_tax
     *
     * @param float|null $price_excluding_tax The price before tax is added.
     *
     * @return self
     */
    public function setPriceExcludingTax($price_excluding_tax)
    {
        $this->container['price_excluding_tax'] = $price_excluding_tax;

        return $this;
    }

    /**
     * Gets supply_price
     *
     * @return double|null
     */
    public function getSupplyPrice()
    {
        return $this->container['supply_price'];
    }

    /**
     * Sets supply_price
     *
     * @param double|null $supply_price Default supply price,
     *
     * @return self
     */
    public function setSupplyPrice($supply_price)
    {
        $this->container['supply_price'] = $supply_price;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param string|null $supplier_id The supplier ID.
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code Supplier code.
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Vend20\Model\Supplier|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Vend20\Model\Supplier|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets product_type_id
     *
     * @return string|null
     */
    public function getProductTypeId()
    {
        return $this->container['product_type_id'];
    }

    /**
     * Sets product_type_id
     *
     * @param string|null $product_type_id The product type.
     *
     * @return self
     */
    public function setProductTypeId($product_type_id)
    {
        $this->container['product_type_id'] = $product_type_id;

        return $this;
    }

    /**
     * Gets type
     *
     * @return \Vend20\Model\ProductTypeSample|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param \Vend20\Model\ProductTypeSample|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param string|null $brand_id The brand ID.
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return \Vend20\Model\BrandSample|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param \Vend20\Model\BrandSample|null $brand brand
     *
     * @return self
     */
    public function setBrand($brand)
    {
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets tag_ids
     *
     * @return string[]|null
     */
    public function getTagIds()
    {
        return $this->container['tag_ids'];
    }

    /**
     * Sets tag_ids
     *
     * @param string[]|null $tag_ids An array of tag IDs associated with this product.
     *
     * @return self
     */
    public function setTagIds($tag_ids)
    {
        $this->container['tag_ids'] = $tag_ids;

        return $this;
    }

    /**
     * Gets categories
     *
     * @return \Vend20\Model\Tag[]|null
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     *
     * @param \Vend20\Model\Tag[]|null $categories A list of tag objects.
     *
     * @return self
     */
    public function setCategories($categories)
    {
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Vend20\Model\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Vend20\Model\Attribute[]|null $attributes A list of attributes
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url image_url
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets image_thumbnail_url
     *
     * @return string|null
     */
    public function getImageThumbnailUrl()
    {
        return $this->container['image_thumbnail_url'];
    }

    /**
     * Sets image_thumbnail_url
     *
     * @param string|null $image_thumbnail_url image_thumbnail_url
     *
     * @return self
     */
    public function setImageThumbnailUrl($image_thumbnail_url)
    {
        $this->container['image_thumbnail_url'] = $image_thumbnail_url;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Vend20\Model\ImageSample[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Vend20\Model\ImageSample[]|null $images A list of image objects.
     *
     * @return self
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets account_code
     *
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->container['account_code'];
    }

    /**
     * Sets account_code
     *
     * @param string|null $account_code ???
     *
     * @return self
     */
    public function setAccountCode($account_code)
    {
        $this->container['account_code'] = $account_code;

        return $this;
    }

    /**
     * Gets account_code_purchase
     *
     * @return string|null
     */
    public function getAccountCodePurchase()
    {
        return $this->container['account_code_purchase'];
    }

    /**
     * Sets account_code_purchase
     *
     * @param string|null $account_code_purchase ???
     *
     * @return self
     */
    public function setAccountCodePurchase($account_code_purchase)
    {
        $this->container['account_code_purchase'] = $account_code_purchase;

        return $this;
    }

    /**
     * Gets button_order
     *
     * @return int|null
     */
    public function getButtonOrder()
    {
        return $this->container['button_order'];
    }

    /**
     * Sets button_order
     *
     * @param int|null $button_order ???
     *
     * @return self
     */
    public function setButtonOrder($button_order)
    {
        $this->container['button_order'] = $button_order;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Creation timestamp in UTC.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Last update timestamp in UTC.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets product_codes
     *
     * @return \Vend20\Model\ProductCode[]|null
     */
    public function getProductCodes()
    {
        return $this->container['product_codes'];
    }

    /**
     * Sets product_codes
     *
     * @param \Vend20\Model\ProductCode[]|null $product_codes product_codes
     *
     * @return self
     */
    public function setProductCodes($product_codes)
    {
        $this->container['product_codes'] = $product_codes;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string|null
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string|null $outlet_id Valid outlet ID for the retailer.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return string|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param string|null $register_id Valid register ID for the retailer.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return string|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param string|null $user_id Valid user ID for the retailer.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id Valid customer ID for the retailer.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number Invoice number which if provided, should use the prefix and suffix defined for the register.
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets invoice_sequence
     *
     * @return double|null
     */
    public function getInvoiceSequence()
    {
        return $this->container['invoice_sequence'];
    }

    /**
     * Sets invoice_sequence
     *
     * @param double|null $invoice_sequence Optionally provided value.
     *
     * @return self
     */
    public function setInvoiceSequence($invoice_sequence)
    {
        $this->container['invoice_sequence'] = $invoice_sequence;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Status of the sale.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note Customer note.
     *
     * @return self
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets short_code
     *
     * @return string|null
     */
    public function getShortCode()
    {
        return $this->container['short_code'];
    }

    /**
     * Sets short_code
     *
     * @param string|null $short_code 6 character code used in the loyalty system. ???
     *
     * @return self
     */
    public function setShortCode($short_code)
    {
        $this->container['short_code'] = $short_code;

        return $this;
    }

    /**
     * Gets return_for
     *
     * @return string|null
     */
    public function getReturnFor()
    {
        return $this->container['return_for'];
    }

    /**
     * Sets return_for
     *
     * @param string|null $return_for Reference ID to a different sale if this sale was created as a return.
     *
     * @return self
     */
    public function setReturnFor($return_for)
    {
        $this->container['return_for'] = $return_for;

        return $this;
    }

    /**
     * Gets total_price
     *
     * @return double|null
     */
    public function getTotalPrice()
    {
        return $this->container['total_price'];
    }

    /**
     * Sets total_price
     *
     * @param double|null $total_price Total (tax exclusive) price of the sale
     *
     * @return self
     */
    public function setTotalPrice($total_price)
    {
        $this->container['total_price'] = $total_price;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return double|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param double|null $total_tax Total tax.
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets total_loyalty
     *
     * @return double|null
     */
    public function getTotalLoyalty()
    {
        return $this->container['total_loyalty'];
    }

    /**
     * Sets total_loyalty
     *
     * @param double|null $total_loyalty Total incurred loyalty.
     *
     * @return self
     */
    public function setTotalLoyalty($total_loyalty)
    {
        $this->container['total_loyalty'] = $total_loyalty;

        return $this;
    }

    /**
     * Gets sale_date
     *
     * @return string|null
     */
    public function getSaleDate()
    {
        return $this->container['sale_date'];
    }

    /**
     * Sets sale_date
     *
     * @param string|null $sale_date Sale timestamp in UTC.
     *
     * @return self
     */
    public function setSaleDate($sale_date)
    {
        $this->container['sale_date'] = $sale_date;

        return $this;
    }

    /**
     * Gets taxes
     *
     * @return \Vend20\Model\SaleTax[]|null
     */
    public function getTaxes()
    {
        return $this->container['taxes'];
    }

    /**
     * Sets taxes
     *
     * @param \Vend20\Model\SaleTax[]|null $taxes Collection of taxes.
     *
     * @return self
     */
    public function setTaxes($taxes)
    {
        $this->container['taxes'] = $taxes;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Vend20\Model\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Vend20\Model\LineItem[]|null $line_items Collection of line items.
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets payments
     *
     * @return \Vend20\Model\Payment[]|null
     */
    public function getPayments()
    {
        return $this->container['payments'];
    }

    /**
     * Sets payments
     *
     * @param \Vend20\Model\Payment[]|null $payments Collection of payments.
     *
     * @return self
     */
    public function setPayments($payments)
    {
        $this->container['payments'] = $payments;

        return $this;
    }

    /**
     * Gets adjustments
     *
     * @return \Vend20\Model\Adjustment[]|null
     */
    public function getAdjustments()
    {
        return $this->container['adjustments'];
    }

    /**
     * Sets adjustments
     *
     * @param \Vend20\Model\Adjustment[]|null $adjustments Collection of adjustments.
     *
     * @return self
     */
    public function setAdjustments($adjustments)
    {
        $this->container['adjustments'] = $adjustments;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string $first_name Customer's first name.
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string $last_name Customer 's last name.
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets customer_code
     *
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->container['customer_code'];
    }

    /**
     * Sets customer_code
     *
     * @param string|null $customer_code Customer code used for claiming loyalty.
     *
     * @return self
     */
    public function setCustomerCode($customer_code)
    {
        $this->container['customer_code'] = $customer_code;

        return $this;
    }

    /**
     * Gets customer_group_id
     *
     * @return string|null
     */
    public function getCustomerGroupId()
    {
        return $this->container['customer_group_id'];
    }

    /**
     * Sets customer_group_id
     *
     * @param string|null $customer_group_id Customer group ID.
     *
     * @return self
     */
    public function setCustomerGroupId($customer_group_id)
    {
        $this->container['customer_group_id'] = $customer_group_id;

        return $this;
    }

    /**
     * Gets enable_loyalty
     *
     * @return bool|null
     */
    public function getEnableLoyalty()
    {
        return $this->container['enable_loyalty'];
    }

    /**
     * Sets enable_loyalty
     *
     * @param bool|null $enable_loyalty enable_loyalty
     *
     * @return self
     */
    public function setEnableLoyalty($enable_loyalty)
    {
        $this->container['enable_loyalty'] = $enable_loyalty;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email Customer's email address.
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets gender
     *
     * @return string|null
     */
    public function getGender()
    {
        return $this->container['gender'];
    }

    /**
     * Sets gender
     *
     * @param string|null $gender Customer's gender. Can be `M`, `F` or null.
     *
     * @return self
     */
    public function setGender($gender)
    {
        $this->container['gender'] = $gender;

        return $this;
    }

    /**
     * Gets date_of_birth
     *
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->container['date_of_birth'];
    }

    /**
     * Sets date_of_birth
     *
     * @param string|null $date_of_birth Birthday.
     *
     * @return self
     */
    public function setDateOfBirth($date_of_birth)
    {
        $this->container['date_of_birth'] = $date_of_birth;

        return $this;
    }

    /**
     * Gets company_name
     *
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->container['company_name'];
    }

    /**
     * Sets company_name
     *
     * @param string|null $company_name Company name.
     *
     * @return self
     */
    public function setCompanyName($company_name)
    {
        $this->container['company_name'] = $company_name;

        return $this;
    }

    /**
     * Gets do_not_email
     *
     * @return bool|null
     */
    public function getDoNotEmail()
    {
        return $this->container['do_not_email'];
    }

    /**
     * Sets do_not_email
     *
     * @param bool|null $do_not_email Indicates whether the customer opted out of email communications.
     *
     * @return self
     */
    public function setDoNotEmail($do_not_email)
    {
        $this->container['do_not_email'] = $do_not_email;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone Phone no.
     *
     * @return self
     */
    public function setPhone($phone)
    {
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets mobile
     *
     * @return string|null
     */
    public function getMobile()
    {
        return $this->container['mobile'];
    }

    /**
     * Sets mobile
     *
     * @param string|null $mobile Mobile phone no.
     *
     * @return self
     */
    public function setMobile($mobile)
    {
        $this->container['mobile'] = $mobile;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax Fax no.
     *
     * @return self
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets twitter
     *
     * @return string|null
     */
    public function getTwitter()
    {
        return $this->container['twitter'];
    }

    /**
     * Sets twitter
     *
     * @param string|null $twitter Twitter handle.
     *
     * @return self
     */
    public function setTwitter($twitter)
    {
        $this->container['twitter'] = $twitter;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website Website URL.
     *
     * @return self
     */
    public function setWebsite($website)
    {
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets physical_address_1
     *
     * @return string|null
     */
    public function getPhysicalAddress1()
    {
        return $this->container['physical_address_1'];
    }

    /**
     * Sets physical_address_1
     *
     * @param string|null $physical_address_1 Physical address, line 1.
     *
     * @return self
     */
    public function setPhysicalAddress1($physical_address_1)
    {
        $this->container['physical_address_1'] = $physical_address_1;

        return $this;
    }

    /**
     * Gets physical_address_2
     *
     * @return string|null
     */
    public function getPhysicalAddress2()
    {
        return $this->container['physical_address_2'];
    }

    /**
     * Sets physical_address_2
     *
     * @param string|null $physical_address_2 Physical address, line 2.
     *
     * @return self
     */
    public function setPhysicalAddress2($physical_address_2)
    {
        $this->container['physical_address_2'] = $physical_address_2;

        return $this;
    }

    /**
     * Gets physical_suburb
     *
     * @return string|null
     */
    public function getPhysicalSuburb()
    {
        return $this->container['physical_suburb'];
    }

    /**
     * Sets physical_suburb
     *
     * @param string|null $physical_suburb Physical address, suburb.
     *
     * @return self
     */
    public function setPhysicalSuburb($physical_suburb)
    {
        $this->container['physical_suburb'] = $physical_suburb;

        return $this;
    }

    /**
     * Gets physical_city
     *
     * @return string|null
     */
    public function getPhysicalCity()
    {
        return $this->container['physical_city'];
    }

    /**
     * Sets physical_city
     *
     * @param string|null $physical_city Physical address, city.
     *
     * @return self
     */
    public function setPhysicalCity($physical_city)
    {
        $this->container['physical_city'] = $physical_city;

        return $this;
    }

    /**
     * Gets physical_postcode
     *
     * @return string|null
     */
    public function getPhysicalPostcode()
    {
        return $this->container['physical_postcode'];
    }

    /**
     * Sets physical_postcode
     *
     * @param string|null $physical_postcode Physical address, post code.
     *
     * @return self
     */
    public function setPhysicalPostcode($physical_postcode)
    {
        $this->container['physical_postcode'] = $physical_postcode;

        return $this;
    }

    /**
     * Gets physical_state
     *
     * @return string|null
     */
    public function getPhysicalState()
    {
        return $this->container['physical_state'];
    }

    /**
     * Sets physical_state
     *
     * @param string|null $physical_state Physical address, state.
     *
     * @return self
     */
    public function setPhysicalState($physical_state)
    {
        $this->container['physical_state'] = $physical_state;

        return $this;
    }

    /**
     * Gets physical_country_id
     *
     * @return string|null
     */
    public function getPhysicalCountryId()
    {
        return $this->container['physical_country_id'];
    }

    /**
     * Sets physical_country_id
     *
     * @param string|null $physical_country_id Physical address, country code.
     *
     * @return self
     */
    public function setPhysicalCountryId($physical_country_id)
    {
        $this->container['physical_country_id'] = $physical_country_id;

        return $this;
    }

    /**
     * Gets postal_address_1
     *
     * @return string|null
     */
    public function getPostalAddress1()
    {
        return $this->container['postal_address_1'];
    }

    /**
     * Sets postal_address_1
     *
     * @param string|null $postal_address_1 Postal address, line 1.
     *
     * @return self
     */
    public function setPostalAddress1($postal_address_1)
    {
        $this->container['postal_address_1'] = $postal_address_1;

        return $this;
    }

    /**
     * Gets postal_address_2
     *
     * @return string|null
     */
    public function getPostalAddress2()
    {
        return $this->container['postal_address_2'];
    }

    /**
     * Sets postal_address_2
     *
     * @param string|null $postal_address_2 Postal address, line 2.
     *
     * @return self
     */
    public function setPostalAddress2($postal_address_2)
    {
        $this->container['postal_address_2'] = $postal_address_2;

        return $this;
    }

    /**
     * Gets postal_suburb
     *
     * @return string|null
     */
    public function getPostalSuburb()
    {
        return $this->container['postal_suburb'];
    }

    /**
     * Sets postal_suburb
     *
     * @param string|null $postal_suburb Postal address, suburb.
     *
     * @return self
     */
    public function setPostalSuburb($postal_suburb)
    {
        $this->container['postal_suburb'] = $postal_suburb;

        return $this;
    }

    /**
     * Gets postal_city
     *
     * @return string|null
     */
    public function getPostalCity()
    {
        return $this->container['postal_city'];
    }

    /**
     * Sets postal_city
     *
     * @param string|null $postal_city Postal address, city.
     *
     * @return self
     */
    public function setPostalCity($postal_city)
    {
        $this->container['postal_city'] = $postal_city;

        return $this;
    }

    /**
     * Gets postal_postcode
     *
     * @return string|null
     */
    public function getPostalPostcode()
    {
        return $this->container['postal_postcode'];
    }

    /**
     * Sets postal_postcode
     *
     * @param string|null $postal_postcode Postal address, post code.
     *
     * @return self
     */
    public function setPostalPostcode($postal_postcode)
    {
        $this->container['postal_postcode'] = $postal_postcode;

        return $this;
    }

    /**
     * Gets postal_state
     *
     * @return string|null
     */
    public function getPostalState()
    {
        return $this->container['postal_state'];
    }

    /**
     * Sets postal_state
     *
     * @param string|null $postal_state Postal address, state.
     *
     * @return self
     */
    public function setPostalState($postal_state)
    {
        $this->container['postal_state'] = $postal_state;

        return $this;
    }

    /**
     * Gets postal_country_id
     *
     * @return string|null
     */
    public function getPostalCountryId()
    {
        return $this->container['postal_country_id'];
    }

    /**
     * Sets postal_country_id
     *
     * @param string|null $postal_country_id Postal address, country code.
     *
     * @return self
     */
    public function setPostalCountryId($postal_country_id)
    {
        $this->container['postal_country_id'] = $postal_country_id;

        return $this;
    }

    /**
     * Gets custom_field_1
     *
     * @return string|null
     */
    public function getCustomField1()
    {
        return $this->container['custom_field_1'];
    }

    /**
     * Sets custom_field_1
     *
     * @param string|null $custom_field_1 Custom field 1. Can be used to store random data.
     *
     * @return self
     */
    public function setCustomField1($custom_field_1)
    {
        $this->container['custom_field_1'] = $custom_field_1;

        return $this;
    }

    /**
     * Gets custom_field_2
     *
     * @return string|null
     */
    public function getCustomField2()
    {
        return $this->container['custom_field_2'];
    }

    /**
     * Sets custom_field_2
     *
     * @param string|null $custom_field_2 Custom field 2.
     *
     * @return self
     */
    public function setCustomField2($custom_field_2)
    {
        $this->container['custom_field_2'] = $custom_field_2;

        return $this;
    }

    /**
     * Gets custom_field_3
     *
     * @return string|null
     */
    public function getCustomField3()
    {
        return $this->container['custom_field_3'];
    }

    /**
     * Sets custom_field_3
     *
     * @param string|null $custom_field_3 Custom field 3.
     *
     * @return self
     */
    public function setCustomField3($custom_field_3)
    {
        $this->container['custom_field_3'] = $custom_field_3;

        return $this;
    }

    /**
     * Gets custom_field_4
     *
     * @return string|null
     */
    public function getCustomField4()
    {
        return $this->container['custom_field_4'];
    }

    /**
     * Sets custom_field_4
     *
     * @param string|null $custom_field_4 Custom field 4.
     *
     * @return self
     */
    public function setCustomField4($custom_field_4)
    {
        $this->container['custom_field_4'] = $custom_field_4;

        return $this;
    }

    /**
     * Gets year_to_date
     *
     * @return double|null
     */
    public function getYearToDate()
    {
        return $this->container['year_to_date'];
    }

    /**
     * Sets year_to_date
     *
     * @param double|null $year_to_date Customer's spending this year.
     *
     * @return self
     */
    public function setYearToDate($year_to_date)
    {
        $this->container['year_to_date'] = $year_to_date;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return double|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param double|null $balance Customer's unpaid balance.
     *
     * @return self
     */
    public function setBalance($balance)
    {
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets loyalty_balance
     *
     * @return double|null
     */
    public function getLoyaltyBalance()
    {
        return $this->container['loyalty_balance'];
    }

    /**
     * Sets loyalty_balance
     *
     * @param double|null $loyalty_balance Customer's loyalty balance.
     *
     * @return self
     */
    public function setLoyaltyBalance($loyalty_balance)
    {
        $this->container['loyalty_balance'] = $loyalty_balance;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


