<?php
/**
 * Sale
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Sale Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Sale implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Sale';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'outlet_id' => 'string',
        'register_id' => 'string',
        'user_id' => 'string',
        'customer_id' => 'string',
        'invoice_number' => 'string',
        'invoice_sequence' => 'double',
        'source' => 'string',
        'source_id' => 'string',
        'status' => 'string',
        'note' => 'string',
        'short_code' => 'string',
        'return_for' => 'string',
        'total_price' => 'double',
        'total_tax' => 'double',
        'total_loyalty' => 'double',
        'sale_date' => 'string',
        'created_at' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string',
        'version' => 'int',
        'taxes' => '\Vend20\Model\SaleTax[]',
        'line_items' => '\Vend20\Model\LineItem[]',
        'payments' => '\Vend20\Model\Payment[]',
        'adjustments' => '\Vend20\Model\Adjustment[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'outlet_id' => null,
        'register_id' => null,
        'user_id' => null,
        'customer_id' => null,
        'invoice_number' => null,
        'invoice_sequence' => 'double',
        'source' => null,
        'source_id' => null,
        'status' => null,
        'note' => null,
        'short_code' => null,
        'return_for' => null,
        'total_price' => 'double',
        'total_tax' => 'double',
        'total_loyalty' => 'double',
        'sale_date' => null,
        'created_at' => null,
        'updated_at' => null,
        'deleted_at' => null,
        'version' => 'int64',
        'taxes' => null,
        'line_items' => null,
        'payments' => null,
        'adjustments' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'outlet_id' => 'outlet_id',
        'register_id' => 'register_id',
        'user_id' => 'user_id',
        'customer_id' => 'customer_id',
        'invoice_number' => 'invoice_number',
        'invoice_sequence' => 'invoice_sequence',
        'source' => 'source',
        'source_id' => 'source_id',
        'status' => 'status',
        'note' => 'note',
        'short_code' => 'short_code',
        'return_for' => 'return_for',
        'total_price' => 'total_price',
        'total_tax' => 'total_tax',
        'total_loyalty' => 'total_loyalty',
        'sale_date' => 'sale_date',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'version' => 'version',
        'taxes' => 'taxes',
        'line_items' => 'line_items',
        'payments' => 'payments',
        'adjustments' => 'adjustments'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'outlet_id' => 'setOutletId',
        'register_id' => 'setRegisterId',
        'user_id' => 'setUserId',
        'customer_id' => 'setCustomerId',
        'invoice_number' => 'setInvoiceNumber',
        'invoice_sequence' => 'setInvoiceSequence',
        'source' => 'setSource',
        'source_id' => 'setSourceId',
        'status' => 'setStatus',
        'note' => 'setNote',
        'short_code' => 'setShortCode',
        'return_for' => 'setReturnFor',
        'total_price' => 'setTotalPrice',
        'total_tax' => 'setTotalTax',
        'total_loyalty' => 'setTotalLoyalty',
        'sale_date' => 'setSaleDate',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'version' => 'setVersion',
        'taxes' => 'setTaxes',
        'line_items' => 'setLineItems',
        'payments' => 'setPayments',
        'adjustments' => 'setAdjustments'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'outlet_id' => 'getOutletId',
        'register_id' => 'getRegisterId',
        'user_id' => 'getUserId',
        'customer_id' => 'getCustomerId',
        'invoice_number' => 'getInvoiceNumber',
        'invoice_sequence' => 'getInvoiceSequence',
        'source' => 'getSource',
        'source_id' => 'getSourceId',
        'status' => 'getStatus',
        'note' => 'getNote',
        'short_code' => 'getShortCode',
        'return_for' => 'getReturnFor',
        'total_price' => 'getTotalPrice',
        'total_tax' => 'getTotalTax',
        'total_loyalty' => 'getTotalLoyalty',
        'sale_date' => 'getSaleDate',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'version' => 'getVersion',
        'taxes' => 'getTaxes',
        'line_items' => 'getLineItems',
        'payments' => 'getPayments',
        'adjustments' => 'getAdjustments'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATUS_SAVED = 'SAVED';
    public const STATUS_CLOSED = 'CLOSED';
    public const STATUS_ONACCOUNT = 'ONACCOUNT';
    public const STATUS_LAYBY = 'LAYBY';
    public const STATUS_ONACCOUNT_CLOSED = 'ONACCOUNT_CLOSED';
    public const STATUS_LAYBY_CLOSED = 'LAYBY_CLOSED';
    public const STATUS_AWAITING_DISPATCH = 'AWAITING_DISPATCH';
    public const STATUS_AWAITING_PICKUP = 'AWAITING_PICKUP';
    public const STATUS_DISPATCHED_CLOSED = 'DISPATCHED_CLOSED';
    public const STATUS_PICKED_UP_CLOSED = 'PICKED_UP_CLOSED';
    public const STATUS_VOIDED = 'VOIDED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_SAVED,
            self::STATUS_CLOSED,
            self::STATUS_ONACCOUNT,
            self::STATUS_LAYBY,
            self::STATUS_ONACCOUNT_CLOSED,
            self::STATUS_LAYBY_CLOSED,
            self::STATUS_AWAITING_DISPATCH,
            self::STATUS_AWAITING_PICKUP,
            self::STATUS_DISPATCHED_CLOSED,
            self::STATUS_PICKED_UP_CLOSED,
            self::STATUS_VOIDED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['register_id'] = $data['register_id'] ?? null;
        $this->container['user_id'] = $data['user_id'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['invoice_number'] = $data['invoice_number'] ?? null;
        $this->container['invoice_sequence'] = $data['invoice_sequence'] ?? null;
        $this->container['source'] = $data['source'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['note'] = $data['note'] ?? null;
        $this->container['short_code'] = $data['short_code'] ?? null;
        $this->container['return_for'] = $data['return_for'] ?? null;
        $this->container['total_price'] = $data['total_price'] ?? null;
        $this->container['total_tax'] = $data['total_tax'] ?? null;
        $this->container['total_loyalty'] = $data['total_loyalty'] ?? null;
        $this->container['sale_date'] = $data['sale_date'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['taxes'] = $data['taxes'] ?? null;
        $this->container['line_items'] = $data['line_items'] ?? null;
        $this->container['payments'] = $data['payments'] ?? null;
        $this->container['adjustments'] = $data['adjustments'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string|null
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string|null $outlet_id Valid outlet ID for the retailer.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return string|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param string|null $register_id Valid register ID for the retailer.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return string|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param string|null $user_id Valid user ID for the retailer.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id Valid customer ID for the retailer.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number Invoice number which if provided, should use the prefix and suffix defined for the register.
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets invoice_sequence
     *
     * @return double|null
     */
    public function getInvoiceSequence()
    {
        return $this->container['invoice_sequence'];
    }

    /**
     * Sets invoice_sequence
     *
     * @param double|null $invoice_sequence Optionally provided value.
     *
     * @return self
     */
    public function setInvoiceSequence($invoice_sequence)
    {
        $this->container['invoice_sequence'] = $invoice_sequence;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source Origin of the sale. USER for sales created in Vend client apps, SHOPIFY for sale synced from Shopify by the integration, ECOMMERCE for sales coming from Vend Ecommerce.
     *
     * @return self
     */
    public function setSource($source)
    {
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id External ID for sales coming from other systems
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Status of the sale.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note Sale Note.
     *
     * @return self
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets short_code
     *
     * @return string|null
     */
    public function getShortCode()
    {
        return $this->container['short_code'];
    }

    /**
     * Sets short_code
     *
     * @param string|null $short_code 6 character code used in the loyalty system. ???
     *
     * @return self
     */
    public function setShortCode($short_code)
    {
        $this->container['short_code'] = $short_code;

        return $this;
    }

    /**
     * Gets return_for
     *
     * @return string|null
     */
    public function getReturnFor()
    {
        return $this->container['return_for'];
    }

    /**
     * Sets return_for
     *
     * @param string|null $return_for Reference ID to a different sale if this sale was created as a return.
     *
     * @return self
     */
    public function setReturnFor($return_for)
    {
        $this->container['return_for'] = $return_for;

        return $this;
    }

    /**
     * Gets total_price
     *
     * @return double|null
     */
    public function getTotalPrice()
    {
        return $this->container['total_price'];
    }

    /**
     * Sets total_price
     *
     * @param double|null $total_price Total (tax exclusive) price of the sale
     *
     * @return self
     */
    public function setTotalPrice($total_price)
    {
        $this->container['total_price'] = $total_price;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return double|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param double|null $total_tax Total tax.
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets total_loyalty
     *
     * @return double|null
     */
    public function getTotalLoyalty()
    {
        return $this->container['total_loyalty'];
    }

    /**
     * Sets total_loyalty
     *
     * @param double|null $total_loyalty Total incurred loyalty.
     *
     * @return self
     */
    public function setTotalLoyalty($total_loyalty)
    {
        $this->container['total_loyalty'] = $total_loyalty;

        return $this;
    }

    /**
     * Gets sale_date
     *
     * @return string|null
     */
    public function getSaleDate()
    {
        return $this->container['sale_date'];
    }

    /**
     * Sets sale_date
     *
     * @param string|null $sale_date Sale timestamp in UTC.
     *
     * @return self
     */
    public function setSaleDate($sale_date)
    {
        $this->container['sale_date'] = $sale_date;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Creation timestamp in UTC.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Last update timestamp in UTC.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets taxes
     *
     * @return \Vend20\Model\SaleTax[]|null
     */
    public function getTaxes()
    {
        return $this->container['taxes'];
    }

    /**
     * Sets taxes
     *
     * @param \Vend20\Model\SaleTax[]|null $taxes Collection of taxes.
     *
     * @return self
     */
    public function setTaxes($taxes)
    {
        $this->container['taxes'] = $taxes;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Vend20\Model\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Vend20\Model\LineItem[]|null $line_items Collection of line items.
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets payments
     *
     * @return \Vend20\Model\Payment[]|null
     */
    public function getPayments()
    {
        return $this->container['payments'];
    }

    /**
     * Sets payments
     *
     * @param \Vend20\Model\Payment[]|null $payments Collection of payments.
     *
     * @return self
     */
    public function setPayments($payments)
    {
        $this->container['payments'] = $payments;

        return $this;
    }

    /**
     * Gets adjustments
     *
     * @return \Vend20\Model\Adjustment[]|null
     */
    public function getAdjustments()
    {
        return $this->container['adjustments'];
    }

    /**
     * Sets adjustments
     *
     * @param \Vend20\Model\Adjustment[]|null $adjustments Collection of adjustments.
     *
     * @return self
     */
    public function setAdjustments($adjustments)
    {
        $this->container['adjustments'] = $adjustments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


