<?php
/**
 * Retailer
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Retailer Class Doc Comment
 *
 * @category Class
 * @description A Retailer record.
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Retailer implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Retailer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'domain_prefix' => 'string',
        'store_url' => 'string',
        'account_status' => 'string',
        'account_type' => 'string',
        'name' => 'string',
        'version' => 'string',
        'discount_product_id' => 'string',
        'no_tax_group_id' => 'string',
        'loyalty' => '\Vend20\Model\RetailerLoyalty',
        'sku_sequence' => '\Vend20\Model\RetailerSkuSequence',
        'culture' => 'string',
        'timezone' => 'object',
        'tax_exclusive' => 'bool',
        'country' => 'string',
        'currency' => '\Vend20\Model\RetailerCurrency',
        'store_credit' => 'bool',
        'gift_cards' => '\Vend20\Model\RetailerGiftCards',
        'created_at' => 'string',
        'activated_at' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'domain_prefix' => null,
        'store_url' => null,
        'account_status' => null,
        'account_type' => null,
        'name' => null,
        'version' => null,
        'discount_product_id' => 'uuid',
        'no_tax_group_id' => 'uuid',
        'loyalty' => null,
        'sku_sequence' => null,
        'culture' => null,
        'timezone' => null,
        'tax_exclusive' => null,
        'country' => null,
        'currency' => null,
        'store_credit' => null,
        'gift_cards' => null,
        'created_at' => null,
        'activated_at' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'domain_prefix' => 'domain_prefix',
        'store_url' => 'store_url',
        'account_status' => 'account_status',
        'account_type' => 'account_type',
        'name' => 'name',
        'version' => 'version',
        'discount_product_id' => 'discount_product_id',
        'no_tax_group_id' => 'no_tax_group_id',
        'loyalty' => 'loyalty',
        'sku_sequence' => 'sku_sequence',
        'culture' => 'culture',
        'timezone' => 'timezone',
        'tax_exclusive' => 'tax_exclusive',
        'country' => 'country',
        'currency' => 'currency',
        'store_credit' => 'store_credit',
        'gift_cards' => 'gift_cards',
        'created_at' => 'created_at',
        'activated_at' => 'activated_at'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'domain_prefix' => 'setDomainPrefix',
        'store_url' => 'setStoreUrl',
        'account_status' => 'setAccountStatus',
        'account_type' => 'setAccountType',
        'name' => 'setName',
        'version' => 'setVersion',
        'discount_product_id' => 'setDiscountProductId',
        'no_tax_group_id' => 'setNoTaxGroupId',
        'loyalty' => 'setLoyalty',
        'sku_sequence' => 'setSkuSequence',
        'culture' => 'setCulture',
        'timezone' => 'setTimezone',
        'tax_exclusive' => 'setTaxExclusive',
        'country' => 'setCountry',
        'currency' => 'setCurrency',
        'store_credit' => 'setStoreCredit',
        'gift_cards' => 'setGiftCards',
        'created_at' => 'setCreatedAt',
        'activated_at' => 'setActivatedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'domain_prefix' => 'getDomainPrefix',
        'store_url' => 'getStoreUrl',
        'account_status' => 'getAccountStatus',
        'account_type' => 'getAccountType',
        'name' => 'getName',
        'version' => 'getVersion',
        'discount_product_id' => 'getDiscountProductId',
        'no_tax_group_id' => 'getNoTaxGroupId',
        'loyalty' => 'getLoyalty',
        'sku_sequence' => 'getSkuSequence',
        'culture' => 'getCulture',
        'timezone' => 'getTimezone',
        'tax_exclusive' => 'getTaxExclusive',
        'country' => 'getCountry',
        'currency' => 'getCurrency',
        'store_credit' => 'getStoreCredit',
        'gift_cards' => 'getGiftCards',
        'created_at' => 'getCreatedAt',
        'activated_at' => 'getActivatedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['domain_prefix'] = $data['domain_prefix'] ?? null;
        $this->container['store_url'] = $data['store_url'] ?? null;
        $this->container['account_status'] = $data['account_status'] ?? null;
        $this->container['account_type'] = $data['account_type'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['discount_product_id'] = $data['discount_product_id'] ?? null;
        $this->container['no_tax_group_id'] = $data['no_tax_group_id'] ?? null;
        $this->container['loyalty'] = $data['loyalty'] ?? null;
        $this->container['sku_sequence'] = $data['sku_sequence'] ?? null;
        $this->container['culture'] = $data['culture'] ?? null;
        $this->container['timezone'] = $data['timezone'] ?? null;
        $this->container['tax_exclusive'] = $data['tax_exclusive'] ?? null;
        $this->container['country'] = $data['country'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['store_credit'] = $data['store_credit'] ?? null;
        $this->container['gift_cards'] = $data['gift_cards'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['activated_at'] = $data['activated_at'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets domain_prefix
     *
     * @return string|null
     */
    public function getDomainPrefix()
    {
        return $this->container['domain_prefix'];
    }

    /**
     * Sets domain_prefix
     *
     * @param string|null $domain_prefix The subdomain of vendhq.com for this retailer.
     *
     * @return self
     */
    public function setDomainPrefix($domain_prefix)
    {
        $this->container['domain_prefix'] = $domain_prefix;

        return $this;
    }

    /**
     * Gets store_url
     *
     * @return string|null
     */
    public function getStoreUrl()
    {
        return $this->container['store_url'];
    }

    /**
     * Sets store_url
     *
     * @param string|null $store_url URL for the store itself.
     *
     * @return self
     */
    public function setStoreUrl($store_url)
    {
        $this->container['store_url'] = $store_url;

        return $this;
    }

    /**
     * Gets account_status
     *
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->container['account_status'];
    }

    /**
     * Sets account_status
     *
     * @param string|null $account_status Status of this account.
     *
     * @return self
     */
    public function setAccountStatus($account_status)
    {
        $this->container['account_status'] = $account_status;

        return $this;
    }

    /**
     * Gets account_type
     *
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->container['account_type'];
    }

    /**
     * Sets account_type
     *
     * @param string|null $account_type Type of this account.
     *
     * @return self
     */
    public function setAccountType($account_type)
    {
        $this->container['account_type'] = $account_type;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Unique name for this Retailer.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets version
     *
     * @return string|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param string|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets discount_product_id
     *
     * @return string|null
     */
    public function getDiscountProductId()
    {
        return $this->container['discount_product_id'];
    }

    /**
     * Sets discount_product_id
     *
     * @param string|null $discount_product_id A reference to the default discount product used for sale-level discounts.
     *
     * @return self
     */
    public function setDiscountProductId($discount_product_id)
    {
        $this->container['discount_product_id'] = $discount_product_id;

        return $this;
    }

    /**
     * Gets no_tax_group_id
     *
     * @return string|null
     */
    public function getNoTaxGroupId()
    {
        return $this->container['no_tax_group_id'];
    }

    /**
     * Sets no_tax_group_id
     *
     * @param string|null $no_tax_group_id A reference to the default 0% rate tax used for tax-free line items.
     *
     * @return self
     */
    public function setNoTaxGroupId($no_tax_group_id)
    {
        $this->container['no_tax_group_id'] = $no_tax_group_id;

        return $this;
    }

    /**
     * Gets loyalty
     *
     * @return \Vend20\Model\RetailerLoyalty|null
     */
    public function getLoyalty()
    {
        return $this->container['loyalty'];
    }

    /**
     * Sets loyalty
     *
     * @param \Vend20\Model\RetailerLoyalty|null $loyalty loyalty
     *
     * @return self
     */
    public function setLoyalty($loyalty)
    {
        $this->container['loyalty'] = $loyalty;

        return $this;
    }

    /**
     * Gets sku_sequence
     *
     * @return \Vend20\Model\RetailerSkuSequence|null
     */
    public function getSkuSequence()
    {
        return $this->container['sku_sequence'];
    }

    /**
     * Sets sku_sequence
     *
     * @param \Vend20\Model\RetailerSkuSequence|null $sku_sequence sku_sequence
     *
     * @return self
     */
    public function setSkuSequence($sku_sequence)
    {
        $this->container['sku_sequence'] = $sku_sequence;

        return $this;
    }

    /**
     * Gets culture
     *
     * @return string|null
     */
    public function getCulture()
    {
        return $this->container['culture'];
    }

    /**
     * Sets culture
     *
     * @param string|null $culture Culture (language name) for this Retailer.
     *
     * @return self
     */
    public function setCulture($culture)
    {
        $this->container['culture'] = $culture;

        return $this;
    }

    /**
     * Gets timezone
     *
     * @return object|null
     */
    public function getTimezone()
    {
        return $this->container['timezone'];
    }

    /**
     * Sets timezone
     *
     * @param object|null $timezone Default Timezone for retailer - e.g. Pacific/Auckland. NOTE: timezones can vary between Outlets.
     *
     * @return self
     */
    public function setTimezone($timezone)
    {
        $this->container['timezone'] = $timezone;

        return $this;
    }

    /**
     * Gets tax_exclusive
     *
     * @return bool|null
     */
    public function getTaxExclusive()
    {
        return $this->container['tax_exclusive'];
    }

    /**
     * Sets tax_exclusive
     *
     * @param bool|null $tax_exclusive Whether Prices should be interpreted as Tax-Exclusive.
     *
     * @return self
     */
    public function setTaxExclusive($tax_exclusive)
    {
        $this->container['tax_exclusive'] = $tax_exclusive;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country 2-letter country code for this Retailer.
     *
     * @return self
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Vend20\Model\RetailerCurrency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Vend20\Model\RetailerCurrency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets store_credit
     *
     * @return bool|null
     */
    public function getStoreCredit()
    {
        return $this->container['store_credit'];
    }

    /**
     * Sets store_credit
     *
     * @param bool|null $store_credit Whether the Retailer has enabled Store Credit.
     *
     * @return self
     */
    public function setStoreCredit($store_credit)
    {
        $this->container['store_credit'] = $store_credit;

        return $this;
    }

    /**
     * Gets gift_cards
     *
     * @return \Vend20\Model\RetailerGiftCards|null
     */
    public function getGiftCards()
    {
        return $this->container['gift_cards'];
    }

    /**
     * Sets gift_cards
     *
     * @param \Vend20\Model\RetailerGiftCards|null $gift_cards gift_cards
     *
     * @return self
     */
    public function setGiftCards($gift_cards)
    {
        $this->container['gift_cards'] = $gift_cards;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Creation timestamp, e.g. '2019-08-15T23:05:28Z'
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets activated_at
     *
     * @return string|null
     */
    public function getActivatedAt()
    {
        return $this->container['activated_at'];
    }

    /**
     * Sets activated_at
     *
     * @param string|null $activated_at Activation timestamp, e.g. '2019-08-15T23:05:28Z'. This field can be null, e.g. for 'demo' retailers.
     *
     * @return self
     */
    public function setActivatedAt($activated_at)
    {
        $this->container['activated_at'] = $activated_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


