<?php
/**
 * Register
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Register Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Register implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Register';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'outlet_id' => 'string',
        'ask_for_note_on_save' => 'double',
        'print_note_on_receipt' => 'bool',
        'ask_for_user_on_sale' => 'bool',
        'show_discounts_on_receipts' => 'bool',
        'print_receipt' => 'bool',
        'email_receipt' => 'bool',
        'invoice_prefix' => 'string',
        'invoice_suffix' => 'string',
        'invoice_sequence' => 'double',
        'button_layout_id' => 'string',
        'is_open' => 'bool',
        'receipt_template_id' => 'string',
        'register_open_time' => 'string',
        'register_close_time' => 'string',
        'register_open_sequence_id' => 'string',
        'cash_managed_payment_type_id' => 'string',
        'deleted_at' => 'string',
        'version' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'outlet_id' => null,
        'ask_for_note_on_save' => 'double',
        'print_note_on_receipt' => null,
        'ask_for_user_on_sale' => null,
        'show_discounts_on_receipts' => null,
        'print_receipt' => null,
        'email_receipt' => null,
        'invoice_prefix' => null,
        'invoice_suffix' => null,
        'invoice_sequence' => 'double',
        'button_layout_id' => null,
        'is_open' => null,
        'receipt_template_id' => null,
        'register_open_time' => null,
        'register_close_time' => null,
        'register_open_sequence_id' => null,
        'cash_managed_payment_type_id' => null,
        'deleted_at' => null,
        'version' => 'int64'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'outlet_id' => 'outlet_id',
        'ask_for_note_on_save' => 'ask_for_note_on_save',
        'print_note_on_receipt' => 'print_note_on_receipt',
        'ask_for_user_on_sale' => 'ask_for_user_on_sale',
        'show_discounts_on_receipts' => 'show_discounts_on_receipts',
        'print_receipt' => 'print_receipt',
        'email_receipt' => 'email_receipt',
        'invoice_prefix' => 'invoice_prefix',
        'invoice_suffix' => 'invoice_suffix',
        'invoice_sequence' => 'invoice_sequence',
        'button_layout_id' => 'button_layout_id',
        'is_open' => 'is_open',
        'receipt_template_id' => 'receipt_template_id',
        'register_open_time' => 'register_open_time',
        'register_close_time' => 'register_close_time',
        'register_open_sequence_id' => 'register_open_sequence_id',
        'cash_managed_payment_type_id' => 'cash_managed_payment_type_id',
        'deleted_at' => 'deleted_at',
        'version' => 'version'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'outlet_id' => 'setOutletId',
        'ask_for_note_on_save' => 'setAskForNoteOnSave',
        'print_note_on_receipt' => 'setPrintNoteOnReceipt',
        'ask_for_user_on_sale' => 'setAskForUserOnSale',
        'show_discounts_on_receipts' => 'setShowDiscountsOnReceipts',
        'print_receipt' => 'setPrintReceipt',
        'email_receipt' => 'setEmailReceipt',
        'invoice_prefix' => 'setInvoicePrefix',
        'invoice_suffix' => 'setInvoiceSuffix',
        'invoice_sequence' => 'setInvoiceSequence',
        'button_layout_id' => 'setButtonLayoutId',
        'is_open' => 'setIsOpen',
        'receipt_template_id' => 'setReceiptTemplateId',
        'register_open_time' => 'setRegisterOpenTime',
        'register_close_time' => 'setRegisterCloseTime',
        'register_open_sequence_id' => 'setRegisterOpenSequenceId',
        'cash_managed_payment_type_id' => 'setCashManagedPaymentTypeId',
        'deleted_at' => 'setDeletedAt',
        'version' => 'setVersion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'outlet_id' => 'getOutletId',
        'ask_for_note_on_save' => 'getAskForNoteOnSave',
        'print_note_on_receipt' => 'getPrintNoteOnReceipt',
        'ask_for_user_on_sale' => 'getAskForUserOnSale',
        'show_discounts_on_receipts' => 'getShowDiscountsOnReceipts',
        'print_receipt' => 'getPrintReceipt',
        'email_receipt' => 'getEmailReceipt',
        'invoice_prefix' => 'getInvoicePrefix',
        'invoice_suffix' => 'getInvoiceSuffix',
        'invoice_sequence' => 'getInvoiceSequence',
        'button_layout_id' => 'getButtonLayoutId',
        'is_open' => 'getIsOpen',
        'receipt_template_id' => 'getReceiptTemplateId',
        'register_open_time' => 'getRegisterOpenTime',
        'register_close_time' => 'getRegisterCloseTime',
        'register_open_sequence_id' => 'getRegisterOpenSequenceId',
        'cash_managed_payment_type_id' => 'getCashManagedPaymentTypeId',
        'deleted_at' => 'getDeletedAt',
        'version' => 'getVersion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['ask_for_note_on_save'] = $data['ask_for_note_on_save'] ?? null;
        $this->container['print_note_on_receipt'] = $data['print_note_on_receipt'] ?? null;
        $this->container['ask_for_user_on_sale'] = $data['ask_for_user_on_sale'] ?? null;
        $this->container['show_discounts_on_receipts'] = $data['show_discounts_on_receipts'] ?? null;
        $this->container['print_receipt'] = $data['print_receipt'] ?? null;
        $this->container['email_receipt'] = $data['email_receipt'] ?? null;
        $this->container['invoice_prefix'] = $data['invoice_prefix'] ?? null;
        $this->container['invoice_suffix'] = $data['invoice_suffix'] ?? null;
        $this->container['invoice_sequence'] = $data['invoice_sequence'] ?? null;
        $this->container['button_layout_id'] = $data['button_layout_id'] ?? null;
        $this->container['is_open'] = $data['is_open'] ?? null;
        $this->container['receipt_template_id'] = $data['receipt_template_id'] ?? null;
        $this->container['register_open_time'] = $data['register_open_time'] ?? null;
        $this->container['register_close_time'] = $data['register_close_time'] ?? null;
        $this->container['register_open_sequence_id'] = $data['register_open_sequence_id'] ?? null;
        $this->container['cash_managed_payment_type_id'] = $data['cash_managed_payment_type_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The Register name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string|null
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string|null $outlet_id A valid ID of an Outlet that this register is associated with.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets ask_for_note_on_save
     *
     * @return double|null
     */
    public function getAskForNoteOnSave()
    {
        return $this->container['ask_for_note_on_save'];
    }

    /**
     * Sets ask_for_note_on_save
     *
     * @param double|null $ask_for_note_on_save `0` for **Never**, `1` for **On Save/Layby/Account/Return**, `2` for **Always**.
     *
     * @return self
     */
    public function setAskForNoteOnSave($ask_for_note_on_save)
    {
        $this->container['ask_for_note_on_save'] = $ask_for_note_on_save;

        return $this;
    }

    /**
     * Gets print_note_on_receipt
     *
     * @return bool|null
     */
    public function getPrintNoteOnReceipt()
    {
        return $this->container['print_note_on_receipt'];
    }

    /**
     * Sets print_note_on_receipt
     *
     * @param bool|null $print_note_on_receipt print_note_on_receipt
     *
     * @return self
     */
    public function setPrintNoteOnReceipt($print_note_on_receipt)
    {
        $this->container['print_note_on_receipt'] = $print_note_on_receipt;

        return $this;
    }

    /**
     * Gets ask_for_user_on_sale
     *
     * @return bool|null
     */
    public function getAskForUserOnSale()
    {
        return $this->container['ask_for_user_on_sale'];
    }

    /**
     * Sets ask_for_user_on_sale
     *
     * @param bool|null $ask_for_user_on_sale ask_for_user_on_sale
     *
     * @return self
     */
    public function setAskForUserOnSale($ask_for_user_on_sale)
    {
        $this->container['ask_for_user_on_sale'] = $ask_for_user_on_sale;

        return $this;
    }

    /**
     * Gets show_discounts_on_receipts
     *
     * @return bool|null
     */
    public function getShowDiscountsOnReceipts()
    {
        return $this->container['show_discounts_on_receipts'];
    }

    /**
     * Sets show_discounts_on_receipts
     *
     * @param bool|null $show_discounts_on_receipts show_discounts_on_receipts
     *
     * @return self
     */
    public function setShowDiscountsOnReceipts($show_discounts_on_receipts)
    {
        $this->container['show_discounts_on_receipts'] = $show_discounts_on_receipts;

        return $this;
    }

    /**
     * Gets print_receipt
     *
     * @return bool|null
     */
    public function getPrintReceipt()
    {
        return $this->container['print_receipt'];
    }

    /**
     * Sets print_receipt
     *
     * @param bool|null $print_receipt Indicates whether a receipt should be printed after a sale.
     *
     * @return self
     */
    public function setPrintReceipt($print_receipt)
    {
        $this->container['print_receipt'] = $print_receipt;

        return $this;
    }

    /**
     * Gets email_receipt
     *
     * @return bool|null
     */
    public function getEmailReceipt()
    {
        return $this->container['email_receipt'];
    }

    /**
     * Sets email_receipt
     *
     * @param bool|null $email_receipt Indicates whether a receipt should be emailed after a sale.
     *
     * @return self
     */
    public function setEmailReceipt($email_receipt)
    {
        $this->container['email_receipt'] = $email_receipt;

        return $this;
    }

    /**
     * Gets invoice_prefix
     *
     * @return string|null
     */
    public function getInvoicePrefix()
    {
        return $this->container['invoice_prefix'];
    }

    /**
     * Sets invoice_prefix
     *
     * @param string|null $invoice_prefix Invoice number prefix.
     *
     * @return self
     */
    public function setInvoicePrefix($invoice_prefix)
    {
        $this->container['invoice_prefix'] = $invoice_prefix;

        return $this;
    }

    /**
     * Gets invoice_suffix
     *
     * @return string|null
     */
    public function getInvoiceSuffix()
    {
        return $this->container['invoice_suffix'];
    }

    /**
     * Sets invoice_suffix
     *
     * @param string|null $invoice_suffix Invoice number suffix.
     *
     * @return self
     */
    public function setInvoiceSuffix($invoice_suffix)
    {
        $this->container['invoice_suffix'] = $invoice_suffix;

        return $this;
    }

    /**
     * Gets invoice_sequence
     *
     * @return double|null
     */
    public function getInvoiceSequence()
    {
        return $this->container['invoice_sequence'];
    }

    /**
     * Sets invoice_sequence
     *
     * @param double|null $invoice_sequence The numeric part of the last issued invoice.
     *
     * @return self
     */
    public function setInvoiceSequence($invoice_sequence)
    {
        $this->container['invoice_sequence'] = $invoice_sequence;

        return $this;
    }

    /**
     * Gets button_layout_id
     *
     * @return string|null
     */
    public function getButtonLayoutId()
    {
        return $this->container['button_layout_id'];
    }

    /**
     * Sets button_layout_id
     *
     * @param string|null $button_layout_id Register ID.
     *
     * @return self
     */
    public function setButtonLayoutId($button_layout_id)
    {
        $this->container['button_layout_id'] = $button_layout_id;

        return $this;
    }

    /**
     * Gets is_open
     *
     * @return bool|null
     */
    public function getIsOpen()
    {
        return $this->container['is_open'];
    }

    /**
     * Sets is_open
     *
     * @param bool|null $is_open Indicates if the Register is currently open.
     *
     * @return self
     */
    public function setIsOpen($is_open)
    {
        $this->container['is_open'] = $is_open;

        return $this;
    }

    /**
     * Gets receipt_template_id
     *
     * @return string|null
     */
    public function getReceiptTemplateId()
    {
        return $this->container['receipt_template_id'];
    }

    /**
     * Sets receipt_template_id
     *
     * @param string|null $receipt_template_id Default receipt template ID used for this register.
     *
     * @return self
     */
    public function setReceiptTemplateId($receipt_template_id)
    {
        $this->container['receipt_template_id'] = $receipt_template_id;

        return $this;
    }

    /**
     * Gets register_open_time
     *
     * @return string|null
     */
    public function getRegisterOpenTime()
    {
        return $this->container['register_open_time'];
    }

    /**
     * Sets register_open_time
     *
     * @param string|null $register_open_time Date/time when the register was open. Always in UTC.
     *
     * @return self
     */
    public function setRegisterOpenTime($register_open_time)
    {
        $this->container['register_open_time'] = $register_open_time;

        return $this;
    }

    /**
     * Gets register_close_time
     *
     * @return string|null
     */
    public function getRegisterCloseTime()
    {
        return $this->container['register_close_time'];
    }

    /**
     * Sets register_close_time
     *
     * @param string|null $register_close_time Date/time when the register was closed. Null if currently open.
     *
     * @return self
     */
    public function setRegisterCloseTime($register_close_time)
    {
        $this->container['register_close_time'] = $register_close_time;

        return $this;
    }

    /**
     * Gets register_open_sequence_id
     *
     * @return string|null
     */
    public function getRegisterOpenSequenceId()
    {
        return $this->container['register_open_sequence_id'];
    }

    /**
     * Sets register_open_sequence_id
     *
     * @param string|null $register_open_sequence_id **internal** The ID of the current register closure object.
     *
     * @return self
     */
    public function setRegisterOpenSequenceId($register_open_sequence_id)
    {
        $this->container['register_open_sequence_id'] = $register_open_sequence_id;

        return $this;
    }

    /**
     * Gets cash_managed_payment_type_id
     *
     * @return string|null
     */
    public function getCashManagedPaymentTypeId()
    {
        return $this->container['cash_managed_payment_type_id'];
    }

    /**
     * Sets cash_managed_payment_type_id
     *
     * @param string|null $cash_managed_payment_type_id **internal** The ID of the payment type used for cash management transactions in this regsiter.
     *
     * @return self
     */
    public function setCashManagedPaymentTypeId($cash_managed_payment_type_id)
    {
        $this->container['cash_managed_payment_type_id'] = $cash_managed_payment_type_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


