<?php
/**
 * Promotion
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Promotion Class Doc Comment
 *
 * @category Class
 * @description A Promotion defines rules and actions for discounting products as part of a sales promotion.
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Promotion implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Promotion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'start_time' => 'string',
        'end_time' => 'string',
        'condition' => '\Vend20\Model\Condition',
        'action' => '\Vend20\Model\Action',
        'loyalty_multiplier' => 'double',
        'outlet_ids' => 'string[]',
        'channels' => 'string[]',
        'customer_group_ids' => 'string[]',
        'status' => 'string',
        'use_promo_code' => 'bool',
        'add_promo_code' => '\Vend20\Model\PromoCode[]',
        'promo_code_summary' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'description' => null,
        'start_time' => null,
        'end_time' => null,
        'condition' => null,
        'action' => null,
        'loyalty_multiplier' => 'double',
        'outlet_ids' => null,
        'channels' => null,
        'customer_group_ids' => null,
        'status' => null,
        'use_promo_code' => null,
        'add_promo_code' => null,
        'promo_code_summary' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'start_time' => 'start_time',
        'end_time' => 'end_time',
        'condition' => 'condition',
        'action' => 'action',
        'loyalty_multiplier' => 'loyalty_multiplier',
        'outlet_ids' => 'outlet_ids',
        'channels' => 'channels',
        'customer_group_ids' => 'customer_group_ids',
        'status' => 'status',
        'use_promo_code' => 'use_promo_code',
        'add_promo_code' => 'add_promo_code',
        'promo_code_summary' => 'promo_code_summary'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'start_time' => 'setStartTime',
        'end_time' => 'setEndTime',
        'condition' => 'setCondition',
        'action' => 'setAction',
        'loyalty_multiplier' => 'setLoyaltyMultiplier',
        'outlet_ids' => 'setOutletIds',
        'channels' => 'setChannels',
        'customer_group_ids' => 'setCustomerGroupIds',
        'status' => 'setStatus',
        'use_promo_code' => 'setUsePromoCode',
        'add_promo_code' => 'setAddPromoCode',
        'promo_code_summary' => 'setPromoCodeSummary'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'start_time' => 'getStartTime',
        'end_time' => 'getEndTime',
        'condition' => 'getCondition',
        'action' => 'getAction',
        'loyalty_multiplier' => 'getLoyaltyMultiplier',
        'outlet_ids' => 'getOutletIds',
        'channels' => 'getChannels',
        'customer_group_ids' => 'getCustomerGroupIds',
        'status' => 'getStatus',
        'use_promo_code' => 'getUsePromoCode',
        'add_promo_code' => 'getAddPromoCode',
        'promo_code_summary' => 'getPromoCodeSummary'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['start_time'] = $data['start_time'] ?? null;
        $this->container['end_time'] = $data['end_time'] ?? null;
        $this->container['condition'] = $data['condition'] ?? null;
        $this->container['action'] = $data['action'] ?? null;
        $this->container['loyalty_multiplier'] = $data['loyalty_multiplier'] ?? null;
        $this->container['outlet_ids'] = $data['outlet_ids'] ?? null;
        $this->container['channels'] = $data['channels'] ?? null;
        $this->container['customer_group_ids'] = $data['customer_group_ids'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['use_promo_code'] = $data['use_promo_code'] ?? null;
        $this->container['add_promo_code'] = $data['add_promo_code'] ?? null;
        $this->container['promo_code_summary'] = $data['promo_code_summary'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['start_time'] === null) {
            $invalidProperties[] = "'start_time' can't be null";
        }
        if ($this->container['condition'] === null) {
            $invalidProperties[] = "'condition' can't be null";
        }
        if ($this->container['action'] === null) {
            $invalidProperties[] = "'action' can't be null";
        }
        if ($this->container['use_promo_code'] === null) {
            $invalidProperties[] = "'use_promo_code' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name of the promotion.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description A short description for the promotion.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets start_time
     *
     * @return string
     */
    public function getStartTime()
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time
     *
     * @param string $start_time The time the promotion begins, in UTC, e.g. `2006-01-02T15:04:05`.
     *
     * @return self
     */
    public function setStartTime($start_time)
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }

    /**
     * Gets end_time
     *
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time
     *
     * @param string|null $end_time The time the promotion ends, in UTC, e.g. `2006-01-02T15:04:05`.
     *
     * @return self
     */
    public function setEndTime($end_time)
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return \Vend20\Model\Condition
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param \Vend20\Model\Condition $condition condition
     *
     * @return self
     */
    public function setCondition($condition)
    {
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets action
     *
     * @return \Vend20\Model\Action
     */
    public function getAction()
    {
        return $this->container['action'];
    }

    /**
     * Sets action
     *
     * @param \Vend20\Model\Action $action action
     *
     * @return self
     */
    public function setAction($action)
    {
        $this->container['action'] = $action;

        return $this;
    }

    /**
     * Gets loyalty_multiplier
     *
     * @return double|null
     */
    public function getLoyaltyMultiplier()
    {
        return $this->container['loyalty_multiplier'];
    }

    /**
     * Sets loyalty_multiplier
     *
     * @param double|null $loyalty_multiplier The loyalty multiplier for the promotion.
     *
     * @return self
     */
    public function setLoyaltyMultiplier($loyalty_multiplier)
    {
        $this->container['loyalty_multiplier'] = $loyalty_multiplier;

        return $this;
    }

    /**
     * Gets outlet_ids
     *
     * @return string[]|null
     */
    public function getOutletIds()
    {
        return $this->container['outlet_ids'];
    }

    /**
     * Sets outlet_ids
     *
     * @param string[]|null $outlet_ids A list of outlet IDs for the promotion.
     *
     * @return self
     */
    public function setOutletIds($outlet_ids)
    {
        $this->container['outlet_ids'] = $outlet_ids;

        return $this;
    }

    /**
     * Gets channels
     *
     * @return string[]|null
     */
    public function getChannels()
    {
        return $this->container['channels'];
    }

    /**
     * Sets channels
     *
     * @param string[]|null $channels A list of outlet IDs for the promotion.
     *
     * @return self
     */
    public function setChannels($channels)
    {
        $this->container['channels'] = $channels;

        return $this;
    }

    /**
     * Gets customer_group_ids
     *
     * @return string[]|null
     */
    public function getCustomerGroupIds()
    {
        return $this->container['customer_group_ids'];
    }

    /**
     * Sets customer_group_ids
     *
     * @param string[]|null $customer_group_ids A list of outlet IDs for the promotion.
     *
     * @return self
     */
    public function setCustomerGroupIds($customer_group_ids)
    {
        $this->container['customer_group_ids'] = $customer_group_ids;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The status of the promotion.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets use_promo_code
     *
     * @return bool
     */
    public function getUsePromoCode()
    {
        return $this->container['use_promo_code'];
    }

    /**
     * Sets use_promo_code
     *
     * @param bool $use_promo_code Whether or not this promotion uses promo codes.
     *
     * @return self
     */
    public function setUsePromoCode($use_promo_code)
    {
        $this->container['use_promo_code'] = $use_promo_code;

        return $this;
    }

    /**
     * Gets add_promo_code
     *
     * @return \Vend20\Model\PromoCode[]|null
     */
    public function getAddPromoCode()
    {
        return $this->container['add_promo_code'];
    }

    /**
     * Sets add_promo_code
     *
     * @param \Vend20\Model\PromoCode[]|null $add_promo_code A list of promo codes to associate with this promotion.
     *
     * @return self
     */
    public function setAddPromoCode($add_promo_code)
    {
        $this->container['add_promo_code'] = $add_promo_code;

        return $this;
    }

    /**
     * Gets promo_code_summary
     *
     * @return string|null
     */
    public function getPromoCodeSummary()
    {
        return $this->container['promo_code_summary'];
    }

    /**
     * Sets promo_code_summary
     *
     * @param string|null $promo_code_summary A summary of the added promo codes added.
     *
     * @return self
     */
    public function setPromoCodeSummary($promo_code_summary)
    {
        $this->container['promo_code_summary'] = $promo_code_summary;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


