<?php
/**
 * ProductVariant
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * ProductVariant Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ProductVariant implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductVariant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sku' => 'string',
        'product_codes' => '\Vend20\Model\ProductCode[]',
        'price_including_tax' => 'float',
        'price_excluding_tax' => 'float',
        'supply_price' => 'float',
        'supplier_code' => 'string',
        'product_suppliers' => '\Vend20\Model\ProductSupplier[]',
        'images' => '\Vend20\Model\ProductImage[]',
        'weight' => 'float',
        'weight_unit' => 'string',
        'length' => 'float',
        'width' => 'float',
        'height' => 'float',
        'dimensions_unit' => 'string',
        'inventory' => '\Vend20\Model\ProductInventory[]',
        'all_outlets_tax' => '\Vend20\Model\AllOutletTax',
        'outlet_taxes' => '\Vend20\Model\OutletTax[]',
        'variant_definitions' => '\Vend20\Model\VariantDefinition'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sku' => null,
        'product_codes' => null,
        'price_including_tax' => null,
        'price_excluding_tax' => null,
        'supply_price' => null,
        'supplier_code' => null,
        'product_suppliers' => null,
        'images' => null,
        'weight' => null,
        'weight_unit' => null,
        'length' => null,
        'width' => null,
        'height' => null,
        'dimensions_unit' => null,
        'inventory' => null,
        'all_outlets_tax' => null,
        'outlet_taxes' => null,
        'variant_definitions' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sku' => 'sku',
        'product_codes' => 'product_codes',
        'price_including_tax' => 'price_including_tax',
        'price_excluding_tax' => 'price_excluding_tax',
        'supply_price' => 'supply_price',
        'supplier_code' => 'supplier_code',
        'product_suppliers' => 'product_suppliers',
        'images' => 'images',
        'weight' => 'weight',
        'weight_unit' => 'weight_unit',
        'length' => 'length',
        'width' => 'width',
        'height' => 'height',
        'dimensions_unit' => 'dimensions_unit',
        'inventory' => 'inventory',
        'all_outlets_tax' => 'all_outlets_tax',
        'outlet_taxes' => 'outlet_taxes',
        'variant_definitions' => 'variant_definitions'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sku' => 'setSku',
        'product_codes' => 'setProductCodes',
        'price_including_tax' => 'setPriceIncludingTax',
        'price_excluding_tax' => 'setPriceExcludingTax',
        'supply_price' => 'setSupplyPrice',
        'supplier_code' => 'setSupplierCode',
        'product_suppliers' => 'setProductSuppliers',
        'images' => 'setImages',
        'weight' => 'setWeight',
        'weight_unit' => 'setWeightUnit',
        'length' => 'setLength',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'dimensions_unit' => 'setDimensionsUnit',
        'inventory' => 'setInventory',
        'all_outlets_tax' => 'setAllOutletsTax',
        'outlet_taxes' => 'setOutletTaxes',
        'variant_definitions' => 'setVariantDefinitions'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sku' => 'getSku',
        'product_codes' => 'getProductCodes',
        'price_including_tax' => 'getPriceIncludingTax',
        'price_excluding_tax' => 'getPriceExcludingTax',
        'supply_price' => 'getSupplyPrice',
        'supplier_code' => 'getSupplierCode',
        'product_suppliers' => 'getProductSuppliers',
        'images' => 'getImages',
        'weight' => 'getWeight',
        'weight_unit' => 'getWeightUnit',
        'length' => 'getLength',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'dimensions_unit' => 'getDimensionsUnit',
        'inventory' => 'getInventory',
        'all_outlets_tax' => 'getAllOutletsTax',
        'outlet_taxes' => 'getOutletTaxes',
        'variant_definitions' => 'getVariantDefinitions'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['product_codes'] = $data['product_codes'] ?? null;
        $this->container['price_including_tax'] = $data['price_including_tax'] ?? null;
        $this->container['price_excluding_tax'] = $data['price_excluding_tax'] ?? null;
        $this->container['supply_price'] = $data['supply_price'] ?? null;
        $this->container['supplier_code'] = $data['supplier_code'] ?? null;
        $this->container['product_suppliers'] = $data['product_suppliers'] ?? null;
        $this->container['images'] = $data['images'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['weight_unit'] = $data['weight_unit'] ?? null;
        $this->container['length'] = $data['length'] ?? null;
        $this->container['width'] = $data['width'] ?? null;
        $this->container['height'] = $data['height'] ?? null;
        $this->container['dimensions_unit'] = $data['dimensions_unit'] ?? null;
        $this->container['inventory'] = $data['inventory'] ?? null;
        $this->container['all_outlets_tax'] = $data['all_outlets_tax'] ?? null;
        $this->container['outlet_taxes'] = $data['outlet_taxes'] ?? null;
        $this->container['variant_definitions'] = $data['variant_definitions'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets product_codes
     *
     * @return \Vend20\Model\ProductCode[]|null
     */
    public function getProductCodes()
    {
        return $this->container['product_codes'];
    }

    /**
     * Sets product_codes
     *
     * @param \Vend20\Model\ProductCode[]|null $product_codes product_codes
     *
     * @return self
     */
    public function setProductCodes($product_codes)
    {
        $this->container['product_codes'] = $product_codes;

        return $this;
    }

    /**
     * Gets price_including_tax
     *
     * @return float|null
     */
    public function getPriceIncludingTax()
    {
        return $this->container['price_including_tax'];
    }

    /**
     * Sets price_including_tax
     *
     * @param float|null $price_including_tax price_including_tax
     *
     * @return self
     */
    public function setPriceIncludingTax($price_including_tax)
    {
        $this->container['price_including_tax'] = $price_including_tax;

        return $this;
    }

    /**
     * Gets price_excluding_tax
     *
     * @return float|null
     */
    public function getPriceExcludingTax()
    {
        return $this->container['price_excluding_tax'];
    }

    /**
     * Sets price_excluding_tax
     *
     * @param float|null $price_excluding_tax price_excluding_tax
     *
     * @return self
     */
    public function setPriceExcludingTax($price_excluding_tax)
    {
        $this->container['price_excluding_tax'] = $price_excluding_tax;

        return $this;
    }

    /**
     * Gets supply_price
     *
     * @return float|null
     */
    public function getSupplyPrice()
    {
        return $this->container['supply_price'];
    }

    /**
     * Sets supply_price
     *
     * @param float|null $supply_price supply_price
     *
     * @return self
     */
    public function setSupplyPrice($supply_price)
    {
        $this->container['supply_price'] = $supply_price;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code supplier_code
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets product_suppliers
     *
     * @return \Vend20\Model\ProductSupplier[]|null
     */
    public function getProductSuppliers()
    {
        return $this->container['product_suppliers'];
    }

    /**
     * Sets product_suppliers
     *
     * @param \Vend20\Model\ProductSupplier[]|null $product_suppliers product_suppliers
     *
     * @return self
     */
    public function setProductSuppliers($product_suppliers)
    {
        $this->container['product_suppliers'] = $product_suppliers;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Vend20\Model\ProductImage[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Vend20\Model\ProductImage[]|null $images images
     *
     * @return self
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets weight_unit
     *
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->container['weight_unit'];
    }

    /**
     * Sets weight_unit
     *
     * @param string|null $weight_unit weight_unit
     *
     * @return self
     */
    public function setWeightUnit($weight_unit)
    {
        $this->container['weight_unit'] = $weight_unit;

        return $this;
    }

    /**
     * Gets length
     *
     * @return float|null
     */
    public function getLength()
    {
        return $this->container['length'];
    }

    /**
     * Sets length
     *
     * @param float|null $length length
     *
     * @return self
     */
    public function setLength($length)
    {
        $this->container['length'] = $length;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets dimensions_unit
     *
     * @return string|null
     */
    public function getDimensionsUnit()
    {
        return $this->container['dimensions_unit'];
    }

    /**
     * Sets dimensions_unit
     *
     * @param string|null $dimensions_unit dimensions_unit
     *
     * @return self
     */
    public function setDimensionsUnit($dimensions_unit)
    {
        $this->container['dimensions_unit'] = $dimensions_unit;

        return $this;
    }

    /**
     * Gets inventory
     *
     * @return \Vend20\Model\ProductInventory[]|null
     */
    public function getInventory()
    {
        return $this->container['inventory'];
    }

    /**
     * Sets inventory
     *
     * @param \Vend20\Model\ProductInventory[]|null $inventory inventory
     *
     * @return self
     */
    public function setInventory($inventory)
    {
        $this->container['inventory'] = $inventory;

        return $this;
    }

    /**
     * Gets all_outlets_tax
     *
     * @return \Vend20\Model\AllOutletTax|null
     */
    public function getAllOutletsTax()
    {
        return $this->container['all_outlets_tax'];
    }

    /**
     * Sets all_outlets_tax
     *
     * @param \Vend20\Model\AllOutletTax|null $all_outlets_tax all_outlets_tax
     *
     * @return self
     */
    public function setAllOutletsTax($all_outlets_tax)
    {
        $this->container['all_outlets_tax'] = $all_outlets_tax;

        return $this;
    }

    /**
     * Gets outlet_taxes
     *
     * @return \Vend20\Model\OutletTax[]|null
     */
    public function getOutletTaxes()
    {
        return $this->container['outlet_taxes'];
    }

    /**
     * Sets outlet_taxes
     *
     * @param \Vend20\Model\OutletTax[]|null $outlet_taxes outlet_taxes
     *
     * @return self
     */
    public function setOutletTaxes($outlet_taxes)
    {
        $this->container['outlet_taxes'] = $outlet_taxes;

        return $this;
    }

    /**
     * Gets variant_definitions
     *
     * @return \Vend20\Model\VariantDefinition|null
     */
    public function getVariantDefinitions()
    {
        return $this->container['variant_definitions'];
    }

    /**
     * Sets variant_definitions
     *
     * @param \Vend20\Model\VariantDefinition|null $variant_definitions variant_definitions
     *
     * @return self
     */
    public function setVariantDefinitions($variant_definitions)
    {
        $this->container['variant_definitions'] = $variant_definitions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


