<?php
/**
 * ProductBase
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * ProductBase Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ProductBase implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductBase';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'description' => 'string',
        'handle' => 'string',
        'sku' => 'string',
        'source' => 'string',
        'source_id' => 'string',
        'source_variant_id' => 'string',
        'is_active' => 'bool',
        'price_including_tax' => 'float',
        'price_excluding_tax' => 'float',
        'supply_price' => 'double',
        'supplier_id' => 'string',
        'supplier_code' => 'string',
        'product_type_id' => 'string',
        'tag_ids' => 'string[]',
        'attributes' => '\Vend20\Model\Attribute[]',
        'images' => '\Vend20\Model\ProductImage[]',
        'account_code' => 'string',
        'account_code_purchase' => 'string',
        'loyalty_amount' => 'float',
        'product_codes' => '\Vend20\Model\ProductCode[]',
        'product_suppliers' => '\Vend20\Model\ProductSupplier[]',
        'inventory' => '\Vend20\Model\ProductInventory[]',
        'weight' => 'float',
        'weight_unit' => 'string',
        'length' => 'float',
        'width' => 'float',
        'height' => 'float',
        'dimensions_unit' => 'string',
        'all_outlets_tax' => '\Vend20\Model\AllOutletTax',
        'outlet_taxes' => '\Vend20\Model\OutletTax[]',
        'variants' => '\Vend20\Model\ProductVariant[]',
        'product_category_id' => 'string',
        'brand_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'description' => null,
        'handle' => null,
        'sku' => null,
        'source' => null,
        'source_id' => null,
        'source_variant_id' => null,
        'is_active' => null,
        'price_including_tax' => null,
        'price_excluding_tax' => null,
        'supply_price' => 'double',
        'supplier_id' => 'UUID',
        'supplier_code' => null,
        'product_type_id' => 'UUID',
        'tag_ids' => 'UUID',
        'attributes' => null,
        'images' => null,
        'account_code' => null,
        'account_code_purchase' => null,
        'loyalty_amount' => null,
        'product_codes' => null,
        'product_suppliers' => null,
        'inventory' => null,
        'weight' => null,
        'weight_unit' => null,
        'length' => null,
        'width' => null,
        'height' => null,
        'dimensions_unit' => null,
        'all_outlets_tax' => null,
        'outlet_taxes' => null,
        'variants' => null,
        'product_category_id' => null,
        'brand_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'description' => 'description',
        'handle' => 'handle',
        'sku' => 'sku',
        'source' => 'source',
        'source_id' => 'source_id',
        'source_variant_id' => 'source_variant_id',
        'is_active' => 'is_active',
        'price_including_tax' => 'price_including_tax',
        'price_excluding_tax' => 'price_excluding_tax',
        'supply_price' => 'supply_price',
        'supplier_id' => 'supplier_id',
        'supplier_code' => 'supplier_code',
        'product_type_id' => 'product_type_id',
        'tag_ids' => 'tag_ids',
        'attributes' => 'attributes',
        'images' => 'images',
        'account_code' => 'account_code',
        'account_code_purchase' => 'account_code_purchase',
        'loyalty_amount' => 'loyalty_amount',
        'product_codes' => 'product_codes',
        'product_suppliers' => 'product_suppliers',
        'inventory' => 'inventory',
        'weight' => 'weight',
        'weight_unit' => 'weight_unit',
        'length' => 'length',
        'width' => 'width',
        'height' => 'height',
        'dimensions_unit' => 'dimensions_unit',
        'all_outlets_tax' => 'all_outlets_tax',
        'outlet_taxes' => 'outlet_taxes',
        'variants' => 'variants',
        'product_category_id' => 'product_category_id',
        'brand_id' => 'brand_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'description' => 'setDescription',
        'handle' => 'setHandle',
        'sku' => 'setSku',
        'source' => 'setSource',
        'source_id' => 'setSourceId',
        'source_variant_id' => 'setSourceVariantId',
        'is_active' => 'setIsActive',
        'price_including_tax' => 'setPriceIncludingTax',
        'price_excluding_tax' => 'setPriceExcludingTax',
        'supply_price' => 'setSupplyPrice',
        'supplier_id' => 'setSupplierId',
        'supplier_code' => 'setSupplierCode',
        'product_type_id' => 'setProductTypeId',
        'tag_ids' => 'setTagIds',
        'attributes' => 'setAttributes',
        'images' => 'setImages',
        'account_code' => 'setAccountCode',
        'account_code_purchase' => 'setAccountCodePurchase',
        'loyalty_amount' => 'setLoyaltyAmount',
        'product_codes' => 'setProductCodes',
        'product_suppliers' => 'setProductSuppliers',
        'inventory' => 'setInventory',
        'weight' => 'setWeight',
        'weight_unit' => 'setWeightUnit',
        'length' => 'setLength',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'dimensions_unit' => 'setDimensionsUnit',
        'all_outlets_tax' => 'setAllOutletsTax',
        'outlet_taxes' => 'setOutletTaxes',
        'variants' => 'setVariants',
        'product_category_id' => 'setProductCategoryId',
        'brand_id' => 'setBrandId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'description' => 'getDescription',
        'handle' => 'getHandle',
        'sku' => 'getSku',
        'source' => 'getSource',
        'source_id' => 'getSourceId',
        'source_variant_id' => 'getSourceVariantId',
        'is_active' => 'getIsActive',
        'price_including_tax' => 'getPriceIncludingTax',
        'price_excluding_tax' => 'getPriceExcludingTax',
        'supply_price' => 'getSupplyPrice',
        'supplier_id' => 'getSupplierId',
        'supplier_code' => 'getSupplierCode',
        'product_type_id' => 'getProductTypeId',
        'tag_ids' => 'getTagIds',
        'attributes' => 'getAttributes',
        'images' => 'getImages',
        'account_code' => 'getAccountCode',
        'account_code_purchase' => 'getAccountCodePurchase',
        'loyalty_amount' => 'getLoyaltyAmount',
        'product_codes' => 'getProductCodes',
        'product_suppliers' => 'getProductSuppliers',
        'inventory' => 'getInventory',
        'weight' => 'getWeight',
        'weight_unit' => 'getWeightUnit',
        'length' => 'getLength',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'dimensions_unit' => 'getDimensionsUnit',
        'all_outlets_tax' => 'getAllOutletsTax',
        'outlet_taxes' => 'getOutletTaxes',
        'variants' => 'getVariants',
        'product_category_id' => 'getProductCategoryId',
        'brand_id' => 'getBrandId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['handle'] = $data['handle'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['source'] = $data['source'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['source_variant_id'] = $data['source_variant_id'] ?? null;
        $this->container['is_active'] = $data['is_active'] ?? null;
        $this->container['price_including_tax'] = $data['price_including_tax'] ?? null;
        $this->container['price_excluding_tax'] = $data['price_excluding_tax'] ?? null;
        $this->container['supply_price'] = $data['supply_price'] ?? null;
        $this->container['supplier_id'] = $data['supplier_id'] ?? null;
        $this->container['supplier_code'] = $data['supplier_code'] ?? null;
        $this->container['product_type_id'] = $data['product_type_id'] ?? null;
        $this->container['tag_ids'] = $data['tag_ids'] ?? null;
        $this->container['attributes'] = $data['attributes'] ?? null;
        $this->container['images'] = $data['images'] ?? null;
        $this->container['account_code'] = $data['account_code'] ?? null;
        $this->container['account_code_purchase'] = $data['account_code_purchase'] ?? null;
        $this->container['loyalty_amount'] = $data['loyalty_amount'] ?? null;
        $this->container['product_codes'] = $data['product_codes'] ?? null;
        $this->container['product_suppliers'] = $data['product_suppliers'] ?? null;
        $this->container['inventory'] = $data['inventory'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['weight_unit'] = $data['weight_unit'] ?? null;
        $this->container['length'] = $data['length'] ?? null;
        $this->container['width'] = $data['width'] ?? null;
        $this->container['height'] = $data['height'] ?? null;
        $this->container['dimensions_unit'] = $data['dimensions_unit'] ?? null;
        $this->container['all_outlets_tax'] = $data['all_outlets_tax'] ?? null;
        $this->container['outlet_taxes'] = $data['outlet_taxes'] ?? null;
        $this->container['variants'] = $data['variants'] ?? null;
        $this->container['product_category_id'] = $data['product_category_id'] ?? null;
        $this->container['brand_id'] = $data['brand_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['handle'] === null) {
            $invalidProperties[] = "'handle' can't be null";
        }
        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Product name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description A detailed description of the Product. **Note** Can contain HTML.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets handle
     *
     * @return string
     */
    public function getHandle()
    {
        return $this->container['handle'];
    }

    /**
     * Sets handle
     *
     * @param string $handle Product handle. **Note:** Variants share the same handle.
     *
     * @return self
     */
    public function setHandle($handle)
    {
        $this->container['handle'] = $handle;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku Product sku. **Note:** Should be unique, but it's not verified while posting.
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source Indicates the origin of the product. Can be USER, SYSTEM, SHOPIFY.
     *
     * @return self
     */
    public function setSource($source)
    {
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id External reference ID.
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_variant_id
     *
     * @return string|null
     */
    public function getSourceVariantId()
    {
        return $this->container['source_variant_id'];
    }

    /**
     * Sets source_variant_id
     *
     * @param string|null $source_variant_id Secondary external reference ID.
     *
     * @return self
     */
    public function setSourceVariantId($source_variant_id)
    {
        $this->container['source_variant_id'] = $source_variant_id;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool|null $is_active Indicated whether the Product is active.
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets price_including_tax
     *
     * @return float|null
     */
    public function getPriceIncludingTax()
    {
        return $this->container['price_including_tax'];
    }

    /**
     * Sets price_including_tax
     *
     * @param float|null $price_including_tax The price including all the relevant taxes.
     *
     * @return self
     */
    public function setPriceIncludingTax($price_including_tax)
    {
        $this->container['price_including_tax'] = $price_including_tax;

        return $this;
    }

    /**
     * Gets price_excluding_tax
     *
     * @return float|null
     */
    public function getPriceExcludingTax()
    {
        return $this->container['price_excluding_tax'];
    }

    /**
     * Sets price_excluding_tax
     *
     * @param float|null $price_excluding_tax The price before tax is added.
     *
     * @return self
     */
    public function setPriceExcludingTax($price_excluding_tax)
    {
        $this->container['price_excluding_tax'] = $price_excluding_tax;

        return $this;
    }

    /**
     * Gets supply_price
     *
     * @return double|null
     */
    public function getSupplyPrice()
    {
        return $this->container['supply_price'];
    }

    /**
     * Sets supply_price
     *
     * @param double|null $supply_price Default supply price,
     *
     * @return self
     */
    public function setSupplyPrice($supply_price)
    {
        $this->container['supply_price'] = $supply_price;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param string|null $supplier_id The supplier ID.
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code Supplier code.
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets product_type_id
     *
     * @return string|null
     */
    public function getProductTypeId()
    {
        return $this->container['product_type_id'];
    }

    /**
     * Sets product_type_id
     *
     * @param string|null $product_type_id The product type.
     *
     * @return self
     */
    public function setProductTypeId($product_type_id)
    {
        $this->container['product_type_id'] = $product_type_id;

        return $this;
    }

    /**
     * Gets tag_ids
     *
     * @return string[]|null
     */
    public function getTagIds()
    {
        return $this->container['tag_ids'];
    }

    /**
     * Sets tag_ids
     *
     * @param string[]|null $tag_ids An array of tag IDs associated with this product.
     *
     * @return self
     */
    public function setTagIds($tag_ids)
    {
        $this->container['tag_ids'] = $tag_ids;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Vend20\Model\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Vend20\Model\Attribute[]|null $attributes A list of attributes
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Vend20\Model\ProductImage[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Vend20\Model\ProductImage[]|null $images A list of image objects.
     *
     * @return self
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets account_code
     *
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->container['account_code'];
    }

    /**
     * Sets account_code
     *
     * @param string|null $account_code The code used to attribute the sales of the product to a specific account for the Xero integration
     *
     * @return self
     */
    public function setAccountCode($account_code)
    {
        $this->container['account_code'] = $account_code;

        return $this;
    }

    /**
     * Gets account_code_purchase
     *
     * @return string|null
     */
    public function getAccountCodePurchase()
    {
        return $this->container['account_code_purchase'];
    }

    /**
     * Sets account_code_purchase
     *
     * @param string|null $account_code_purchase The code used to attribute the purchase of the product to a specific account for the Xero integration
     *
     * @return self
     */
    public function setAccountCodePurchase($account_code_purchase)
    {
        $this->container['account_code_purchase'] = $account_code_purchase;

        return $this;
    }

    /**
     * Gets loyalty_amount
     *
     * @return float|null
     */
    public function getLoyaltyAmount()
    {
        return $this->container['loyalty_amount'];
    }

    /**
     * Sets loyalty_amount
     *
     * @param float|null $loyalty_amount The amount of loyalty the customer receives buying this item.
     *
     * @return self
     */
    public function setLoyaltyAmount($loyalty_amount)
    {
        $this->container['loyalty_amount'] = $loyalty_amount;

        return $this;
    }

    /**
     * Gets product_codes
     *
     * @return \Vend20\Model\ProductCode[]|null
     */
    public function getProductCodes()
    {
        return $this->container['product_codes'];
    }

    /**
     * Sets product_codes
     *
     * @param \Vend20\Model\ProductCode[]|null $product_codes product_codes
     *
     * @return self
     */
    public function setProductCodes($product_codes)
    {
        $this->container['product_codes'] = $product_codes;

        return $this;
    }

    /**
     * Gets product_suppliers
     *
     * @return \Vend20\Model\ProductSupplier[]|null
     */
    public function getProductSuppliers()
    {
        return $this->container['product_suppliers'];
    }

    /**
     * Sets product_suppliers
     *
     * @param \Vend20\Model\ProductSupplier[]|null $product_suppliers product_suppliers
     *
     * @return self
     */
    public function setProductSuppliers($product_suppliers)
    {
        $this->container['product_suppliers'] = $product_suppliers;

        return $this;
    }

    /**
     * Gets inventory
     *
     * @return \Vend20\Model\ProductInventory[]|null
     */
    public function getInventory()
    {
        return $this->container['inventory'];
    }

    /**
     * Sets inventory
     *
     * @param \Vend20\Model\ProductInventory[]|null $inventory inventory
     *
     * @return self
     */
    public function setInventory($inventory)
    {
        $this->container['inventory'] = $inventory;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets weight_unit
     *
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->container['weight_unit'];
    }

    /**
     * Sets weight_unit
     *
     * @param string|null $weight_unit weight_unit
     *
     * @return self
     */
    public function setWeightUnit($weight_unit)
    {
        $this->container['weight_unit'] = $weight_unit;

        return $this;
    }

    /**
     * Gets length
     *
     * @return float|null
     */
    public function getLength()
    {
        return $this->container['length'];
    }

    /**
     * Sets length
     *
     * @param float|null $length length
     *
     * @return self
     */
    public function setLength($length)
    {
        $this->container['length'] = $length;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets dimensions_unit
     *
     * @return string|null
     */
    public function getDimensionsUnit()
    {
        return $this->container['dimensions_unit'];
    }

    /**
     * Sets dimensions_unit
     *
     * @param string|null $dimensions_unit dimensions_unit
     *
     * @return self
     */
    public function setDimensionsUnit($dimensions_unit)
    {
        $this->container['dimensions_unit'] = $dimensions_unit;

        return $this;
    }

    /**
     * Gets all_outlets_tax
     *
     * @return \Vend20\Model\AllOutletTax|null
     */
    public function getAllOutletsTax()
    {
        return $this->container['all_outlets_tax'];
    }

    /**
     * Sets all_outlets_tax
     *
     * @param \Vend20\Model\AllOutletTax|null $all_outlets_tax all_outlets_tax
     *
     * @return self
     */
    public function setAllOutletsTax($all_outlets_tax)
    {
        $this->container['all_outlets_tax'] = $all_outlets_tax;

        return $this;
    }

    /**
     * Gets outlet_taxes
     *
     * @return \Vend20\Model\OutletTax[]|null
     */
    public function getOutletTaxes()
    {
        return $this->container['outlet_taxes'];
    }

    /**
     * Sets outlet_taxes
     *
     * @param \Vend20\Model\OutletTax[]|null $outlet_taxes outlet_taxes
     *
     * @return self
     */
    public function setOutletTaxes($outlet_taxes)
    {
        $this->container['outlet_taxes'] = $outlet_taxes;

        return $this;
    }

    /**
     * Gets variants
     *
     * @return \Vend20\Model\ProductVariant[]|null
     */
    public function getVariants()
    {
        return $this->container['variants'];
    }

    /**
     * Sets variants
     *
     * @param \Vend20\Model\ProductVariant[]|null $variants variants
     *
     * @return self
     */
    public function setVariants($variants)
    {
        $this->container['variants'] = $variants;

        return $this;
    }

    /**
     * Gets product_category_id
     *
     * @return string|null
     */
    public function getProductCategoryId()
    {
        return $this->container['product_category_id'];
    }

    /**
     * Sets product_category_id
     *
     * @param string|null $product_category_id product_category_id
     *
     * @return self
     */
    public function setProductCategoryId($product_category_id)
    {
        $this->container['product_category_id'] = $product_category_id;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param string|null $brand_id brand_id
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


