<?php
/**
 * Product
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'handle' => 'string',
        'sku' => 'string',
        'source' => 'string',
        'source_id' => 'string',
        'source_variant_id' => 'string',
        'active' => 'bool',
        'has_inventory' => 'bool',
        'is_composite' => 'bool',
        'has_variants' => 'bool',
        'variant_parent_id' => 'string',
        'variant_name' => 'string',
        'variant_options' => '\Vend20\Model\VariantOption[]',
        'variant_count' => 'int',
        'price_including_tax' => 'float',
        'price_excluding_tax' => 'float',
        'supply_price' => 'double',
        'supplier_id' => 'string',
        'supplier_code' => 'string',
        'supplier' => '\Vend20\Model\Supplier',
        'product_type_id' => 'string',
        'type' => '\Vend20\Model\ProductTypeSample',
        'brand_id' => 'string',
        'brand' => '\Vend20\Model\BrandSample',
        'tag_ids' => 'string[]',
        'categories' => '\Vend20\Model\Tag[]',
        'attributes' => '\Vend20\Model\Attribute[]',
        'image_url' => 'string',
        'image_thumbnail_url' => 'string',
        'images' => '\Vend20\Model\ImageSample[]',
        'account_code' => 'string',
        'account_code_purchase' => 'string',
        'button_order' => 'int',
        'created_at' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string',
        'version' => 'int',
        'product_codes' => '\Vend20\Model\ProductCode[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'UUID',
        'name' => null,
        'description' => null,
        'handle' => null,
        'sku' => null,
        'source' => null,
        'source_id' => null,
        'source_variant_id' => null,
        'active' => null,
        'has_inventory' => null,
        'is_composite' => null,
        'has_variants' => null,
        'variant_parent_id' => 'UUID',
        'variant_name' => null,
        'variant_options' => null,
        'variant_count' => null,
        'price_including_tax' => null,
        'price_excluding_tax' => null,
        'supply_price' => 'double',
        'supplier_id' => 'UUID',
        'supplier_code' => null,
        'supplier' => null,
        'product_type_id' => 'UUID',
        'type' => null,
        'brand_id' => 'UUID',
        'brand' => null,
        'tag_ids' => 'UUID',
        'categories' => null,
        'attributes' => null,
        'image_url' => null,
        'image_thumbnail_url' => null,
        'images' => null,
        'account_code' => null,
        'account_code_purchase' => null,
        'button_order' => null,
        'created_at' => null,
        'updated_at' => null,
        'deleted_at' => null,
        'version' => 'int64',
        'product_codes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'handle' => 'handle',
        'sku' => 'sku',
        'source' => 'source',
        'source_id' => 'source_id',
        'source_variant_id' => 'source_variant_id',
        'active' => 'active',
        'has_inventory' => 'has_inventory',
        'is_composite' => 'is_composite',
        'has_variants' => 'has_variants',
        'variant_parent_id' => 'variant_parent_id',
        'variant_name' => 'variant_name',
        'variant_options' => 'variant_options',
        'variant_count' => 'variant_count',
        'price_including_tax' => 'price_including_tax',
        'price_excluding_tax' => 'price_excluding_tax',
        'supply_price' => 'supply_price',
        'supplier_id' => 'supplier_id',
        'supplier_code' => 'supplier_code',
        'supplier' => 'supplier',
        'product_type_id' => 'product_type_id',
        'type' => 'type',
        'brand_id' => 'brand_id',
        'brand' => 'brand',
        'tag_ids' => 'tag_ids',
        'categories' => 'categories',
        'attributes' => 'attributes',
        'image_url' => 'image_url',
        'image_thumbnail_url' => 'image_thumbnail_url',
        'images' => 'images',
        'account_code' => 'account_code',
        'account_code_purchase' => 'account_code_purchase',
        'button_order' => 'button_order',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'version' => 'version',
        'product_codes' => 'product_codes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'handle' => 'setHandle',
        'sku' => 'setSku',
        'source' => 'setSource',
        'source_id' => 'setSourceId',
        'source_variant_id' => 'setSourceVariantId',
        'active' => 'setActive',
        'has_inventory' => 'setHasInventory',
        'is_composite' => 'setIsComposite',
        'has_variants' => 'setHasVariants',
        'variant_parent_id' => 'setVariantParentId',
        'variant_name' => 'setVariantName',
        'variant_options' => 'setVariantOptions',
        'variant_count' => 'setVariantCount',
        'price_including_tax' => 'setPriceIncludingTax',
        'price_excluding_tax' => 'setPriceExcludingTax',
        'supply_price' => 'setSupplyPrice',
        'supplier_id' => 'setSupplierId',
        'supplier_code' => 'setSupplierCode',
        'supplier' => 'setSupplier',
        'product_type_id' => 'setProductTypeId',
        'type' => 'setType',
        'brand_id' => 'setBrandId',
        'brand' => 'setBrand',
        'tag_ids' => 'setTagIds',
        'categories' => 'setCategories',
        'attributes' => 'setAttributes',
        'image_url' => 'setImageUrl',
        'image_thumbnail_url' => 'setImageThumbnailUrl',
        'images' => 'setImages',
        'account_code' => 'setAccountCode',
        'account_code_purchase' => 'setAccountCodePurchase',
        'button_order' => 'setButtonOrder',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'version' => 'setVersion',
        'product_codes' => 'setProductCodes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'handle' => 'getHandle',
        'sku' => 'getSku',
        'source' => 'getSource',
        'source_id' => 'getSourceId',
        'source_variant_id' => 'getSourceVariantId',
        'active' => 'getActive',
        'has_inventory' => 'getHasInventory',
        'is_composite' => 'getIsComposite',
        'has_variants' => 'getHasVariants',
        'variant_parent_id' => 'getVariantParentId',
        'variant_name' => 'getVariantName',
        'variant_options' => 'getVariantOptions',
        'variant_count' => 'getVariantCount',
        'price_including_tax' => 'getPriceIncludingTax',
        'price_excluding_tax' => 'getPriceExcludingTax',
        'supply_price' => 'getSupplyPrice',
        'supplier_id' => 'getSupplierId',
        'supplier_code' => 'getSupplierCode',
        'supplier' => 'getSupplier',
        'product_type_id' => 'getProductTypeId',
        'type' => 'getType',
        'brand_id' => 'getBrandId',
        'brand' => 'getBrand',
        'tag_ids' => 'getTagIds',
        'categories' => 'getCategories',
        'attributes' => 'getAttributes',
        'image_url' => 'getImageUrl',
        'image_thumbnail_url' => 'getImageThumbnailUrl',
        'images' => 'getImages',
        'account_code' => 'getAccountCode',
        'account_code_purchase' => 'getAccountCodePurchase',
        'button_order' => 'getButtonOrder',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'version' => 'getVersion',
        'product_codes' => 'getProductCodes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['handle'] = $data['handle'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['source'] = $data['source'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['source_variant_id'] = $data['source_variant_id'] ?? null;
        $this->container['active'] = $data['active'] ?? null;
        $this->container['has_inventory'] = $data['has_inventory'] ?? null;
        $this->container['is_composite'] = $data['is_composite'] ?? null;
        $this->container['has_variants'] = $data['has_variants'] ?? null;
        $this->container['variant_parent_id'] = $data['variant_parent_id'] ?? null;
        $this->container['variant_name'] = $data['variant_name'] ?? null;
        $this->container['variant_options'] = $data['variant_options'] ?? null;
        $this->container['variant_count'] = $data['variant_count'] ?? null;
        $this->container['price_including_tax'] = $data['price_including_tax'] ?? null;
        $this->container['price_excluding_tax'] = $data['price_excluding_tax'] ?? null;
        $this->container['supply_price'] = $data['supply_price'] ?? null;
        $this->container['supplier_id'] = $data['supplier_id'] ?? null;
        $this->container['supplier_code'] = $data['supplier_code'] ?? null;
        $this->container['supplier'] = $data['supplier'] ?? null;
        $this->container['product_type_id'] = $data['product_type_id'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['brand_id'] = $data['brand_id'] ?? null;
        $this->container['brand'] = $data['brand'] ?? null;
        $this->container['tag_ids'] = $data['tag_ids'] ?? null;
        $this->container['categories'] = $data['categories'] ?? null;
        $this->container['attributes'] = $data['attributes'] ?? null;
        $this->container['image_url'] = $data['image_url'] ?? null;
        $this->container['image_thumbnail_url'] = $data['image_thumbnail_url'] ?? null;
        $this->container['images'] = $data['images'] ?? null;
        $this->container['account_code'] = $data['account_code'] ?? null;
        $this->container['account_code_purchase'] = $data['account_code_purchase'] ?? null;
        $this->container['button_order'] = $data['button_order'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['product_codes'] = $data['product_codes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['handle'] === null) {
            $invalidProperties[] = "'handle' can't be null";
        }
        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Product name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description A detailed description of the Product. **Note** Can contain HTML.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets handle
     *
     * @return string
     */
    public function getHandle()
    {
        return $this->container['handle'];
    }

    /**
     * Sets handle
     *
     * @param string $handle Product handle. **Note:** Variants share the same handle.
     *
     * @return self
     */
    public function setHandle($handle)
    {
        $this->container['handle'] = $handle;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku Product sku. **Note:** Should be unique, but it's not verified while posting.
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source Indicates the origin of the product. Can be USER, SYSTEM, SHOPIFY.
     *
     * @return self
     */
    public function setSource($source)
    {
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id External reference ID.
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_variant_id
     *
     * @return string|null
     */
    public function getSourceVariantId()
    {
        return $this->container['source_variant_id'];
    }

    /**
     * Sets source_variant_id
     *
     * @param string|null $source_variant_id Secondary external reference ID.
     *
     * @return self
     */
    public function setSourceVariantId($source_variant_id)
    {
        $this->container['source_variant_id'] = $source_variant_id;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Indicated whether the Product is active.
     *
     * @return self
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets has_inventory
     *
     * @return bool|null
     */
    public function getHasInventory()
    {
        return $this->container['has_inventory'];
    }

    /**
     * Sets has_inventory
     *
     * @param bool|null $has_inventory Indicates whether inventory is being tracked for the Product.
     *
     * @return self
     */
    public function setHasInventory($has_inventory)
    {
        $this->container['has_inventory'] = $has_inventory;

        return $this;
    }

    /**
     * Gets is_composite
     *
     * @return bool|null
     */
    public function getIsComposite()
    {
        return $this->container['is_composite'];
    }

    /**
     * Sets is_composite
     *
     * @param bool|null $is_composite Indicates whether the Product is a composite one.
     *
     * @return self
     */
    public function setIsComposite($is_composite)
    {
        $this->container['is_composite'] = $is_composite;

        return $this;
    }

    /**
     * Gets has_variants
     *
     * @return bool|null
     */
    public function getHasVariants()
    {
        return $this->container['has_variants'];
    }

    /**
     * Sets has_variants
     *
     * @param bool|null $has_variants Indicated whether product has variants.
     *
     * @return self
     */
    public function setHasVariants($has_variants)
    {
        $this->container['has_variants'] = $has_variants;

        return $this;
    }

    /**
     * Gets variant_parent_id
     *
     * @return string|null
     */
    public function getVariantParentId()
    {
        return $this->container['variant_parent_id'];
    }

    /**
     * Sets variant_parent_id
     *
     * @param string|null $variant_parent_id This value is set if a Product is a variant of another Product.
     *
     * @return self
     */
    public function setVariantParentId($variant_parent_id)
    {
        $this->container['variant_parent_id'] = $variant_parent_id;

        return $this;
    }

    /**
     * Gets variant_name
     *
     * @return string|null
     */
    public function getVariantName()
    {
        return $this->container['variant_name'];
    }

    /**
     * Sets variant_name
     *
     * @param string|null $variant_name The name of the variant product.
     *
     * @return self
     */
    public function setVariantName($variant_name)
    {
        $this->container['variant_name'] = $variant_name;

        return $this;
    }

    /**
     * Gets variant_options
     *
     * @return \Vend20\Model\VariantOption[]|null
     */
    public function getVariantOptions()
    {
        return $this->container['variant_options'];
    }

    /**
     * Sets variant_options
     *
     * @param \Vend20\Model\VariantOption[]|null $variant_options A list of variant option objects.
     *
     * @return self
     */
    public function setVariantOptions($variant_options)
    {
        $this->container['variant_options'] = $variant_options;

        return $this;
    }

    /**
     * Gets variant_count
     *
     * @return int|null
     */
    public function getVariantCount()
    {
        return $this->container['variant_count'];
    }

    /**
     * Sets variant_count
     *
     * @param int|null $variant_count The number of variants for this product.
     *
     * @return self
     */
    public function setVariantCount($variant_count)
    {
        $this->container['variant_count'] = $variant_count;

        return $this;
    }

    /**
     * Gets price_including_tax
     *
     * @return float|null
     */
    public function getPriceIncludingTax()
    {
        return $this->container['price_including_tax'];
    }

    /**
     * Sets price_including_tax
     *
     * @param float|null $price_including_tax The price including all the relevant taxes.
     *
     * @return self
     */
    public function setPriceIncludingTax($price_including_tax)
    {
        $this->container['price_including_tax'] = $price_including_tax;

        return $this;
    }

    /**
     * Gets price_excluding_tax
     *
     * @return float|null
     */
    public function getPriceExcludingTax()
    {
        return $this->container['price_excluding_tax'];
    }

    /**
     * Sets price_excluding_tax
     *
     * @param float|null $price_excluding_tax The price before tax is added.
     *
     * @return self
     */
    public function setPriceExcludingTax($price_excluding_tax)
    {
        $this->container['price_excluding_tax'] = $price_excluding_tax;

        return $this;
    }

    /**
     * Gets supply_price
     *
     * @return double|null
     */
    public function getSupplyPrice()
    {
        return $this->container['supply_price'];
    }

    /**
     * Sets supply_price
     *
     * @param double|null $supply_price Default supply price,
     *
     * @return self
     */
    public function setSupplyPrice($supply_price)
    {
        $this->container['supply_price'] = $supply_price;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param string|null $supplier_id The supplier ID.
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code Supplier code.
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Vend20\Model\Supplier|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Vend20\Model\Supplier|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets product_type_id
     *
     * @return string|null
     */
    public function getProductTypeId()
    {
        return $this->container['product_type_id'];
    }

    /**
     * Sets product_type_id
     *
     * @param string|null $product_type_id The product type.
     *
     * @return self
     */
    public function setProductTypeId($product_type_id)
    {
        $this->container['product_type_id'] = $product_type_id;

        return $this;
    }

    /**
     * Gets type
     *
     * @return \Vend20\Model\ProductTypeSample|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param \Vend20\Model\ProductTypeSample|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param string|null $brand_id The brand ID.
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return \Vend20\Model\BrandSample|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param \Vend20\Model\BrandSample|null $brand brand
     *
     * @return self
     */
    public function setBrand($brand)
    {
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets tag_ids
     *
     * @return string[]|null
     */
    public function getTagIds()
    {
        return $this->container['tag_ids'];
    }

    /**
     * Sets tag_ids
     *
     * @param string[]|null $tag_ids An array of tag IDs associated with this product.
     *
     * @return self
     */
    public function setTagIds($tag_ids)
    {
        $this->container['tag_ids'] = $tag_ids;

        return $this;
    }

    /**
     * Gets categories
     *
     * @return \Vend20\Model\Tag[]|null
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     *
     * @param \Vend20\Model\Tag[]|null $categories A list of tag objects.
     *
     * @return self
     */
    public function setCategories($categories)
    {
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Vend20\Model\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Vend20\Model\Attribute[]|null $attributes A list of attributes
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url image_url
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets image_thumbnail_url
     *
     * @return string|null
     */
    public function getImageThumbnailUrl()
    {
        return $this->container['image_thumbnail_url'];
    }

    /**
     * Sets image_thumbnail_url
     *
     * @param string|null $image_thumbnail_url image_thumbnail_url
     *
     * @return self
     */
    public function setImageThumbnailUrl($image_thumbnail_url)
    {
        $this->container['image_thumbnail_url'] = $image_thumbnail_url;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Vend20\Model\ImageSample[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Vend20\Model\ImageSample[]|null $images A list of image objects.
     *
     * @return self
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets account_code
     *
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->container['account_code'];
    }

    /**
     * Sets account_code
     *
     * @param string|null $account_code ???
     *
     * @return self
     */
    public function setAccountCode($account_code)
    {
        $this->container['account_code'] = $account_code;

        return $this;
    }

    /**
     * Gets account_code_purchase
     *
     * @return string|null
     */
    public function getAccountCodePurchase()
    {
        return $this->container['account_code_purchase'];
    }

    /**
     * Sets account_code_purchase
     *
     * @param string|null $account_code_purchase ???
     *
     * @return self
     */
    public function setAccountCodePurchase($account_code_purchase)
    {
        $this->container['account_code_purchase'] = $account_code_purchase;

        return $this;
    }

    /**
     * Gets button_order
     *
     * @return int|null
     */
    public function getButtonOrder()
    {
        return $this->container['button_order'];
    }

    /**
     * Sets button_order
     *
     * @param int|null $button_order ???
     *
     * @return self
     */
    public function setButtonOrder($button_order)
    {
        $this->container['button_order'] = $button_order;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Creation timestamp in UTC.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Last update timestamp in UTC.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets product_codes
     *
     * @return \Vend20\Model\ProductCode[]|null
     */
    public function getProductCodes()
    {
        return $this->container['product_codes'];
    }

    /**
     * Sets product_codes
     *
     * @param \Vend20\Model\ProductCode[]|null $product_codes product_codes
     *
     * @return self
     */
    public function setProductCodes($product_codes)
    {
        $this->container['product_codes'] = $product_codes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


