<?php
/**
 * PriceBookProduct
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * PriceBookProduct Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PriceBookProduct implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PriceBookProduct';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'product_id' => 'string',
        'price_book_id' => 'string',
        'default_display_price' => 'double',
        'price' => 'double',
        'retail_tax' => 'double',
        'loyalty_value' => 'double',
        'tax_id' => 'string',
        'rounding' => 'string',
        'adjustment_type' => 'string',
        'adjustment' => 'double',
        'discount' => 'double',
        'min_units' => 'double',
        'max_units' => 'double',
        'created_at' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'product_id' => null,
        'price_book_id' => null,
        'default_display_price' => 'double',
        'price' => 'double',
        'retail_tax' => 'double',
        'loyalty_value' => 'double',
        'tax_id' => null,
        'rounding' => null,
        'adjustment_type' => null,
        'adjustment' => 'double',
        'discount' => 'double',
        'min_units' => 'double',
        'max_units' => 'double',
        'created_at' => null,
        'updated_at' => null,
        'deleted_at' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'product_id' => 'product_id',
        'price_book_id' => 'price_book_id',
        'default_display_price' => 'default_display_price',
        'price' => 'price',
        'retail_tax' => 'retail_tax',
        'loyalty_value' => 'loyalty_value',
        'tax_id' => 'tax_id',
        'rounding' => 'rounding',
        'adjustment_type' => 'adjustment_type',
        'adjustment' => 'adjustment',
        'discount' => 'discount',
        'min_units' => 'min_units',
        'max_units' => 'max_units',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'product_id' => 'setProductId',
        'price_book_id' => 'setPriceBookId',
        'default_display_price' => 'setDefaultDisplayPrice',
        'price' => 'setPrice',
        'retail_tax' => 'setRetailTax',
        'loyalty_value' => 'setLoyaltyValue',
        'tax_id' => 'setTaxId',
        'rounding' => 'setRounding',
        'adjustment_type' => 'setAdjustmentType',
        'adjustment' => 'setAdjustment',
        'discount' => 'setDiscount',
        'min_units' => 'setMinUnits',
        'max_units' => 'setMaxUnits',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'product_id' => 'getProductId',
        'price_book_id' => 'getPriceBookId',
        'default_display_price' => 'getDefaultDisplayPrice',
        'price' => 'getPrice',
        'retail_tax' => 'getRetailTax',
        'loyalty_value' => 'getLoyaltyValue',
        'tax_id' => 'getTaxId',
        'rounding' => 'getRounding',
        'adjustment_type' => 'getAdjustmentType',
        'adjustment' => 'getAdjustment',
        'discount' => 'getDiscount',
        'min_units' => 'getMinUnits',
        'max_units' => 'getMaxUnits',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['price_book_id'] = $data['price_book_id'] ?? null;
        $this->container['default_display_price'] = $data['default_display_price'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['retail_tax'] = $data['retail_tax'] ?? null;
        $this->container['loyalty_value'] = $data['loyalty_value'] ?? null;
        $this->container['tax_id'] = $data['tax_id'] ?? null;
        $this->container['rounding'] = $data['rounding'] ?? null;
        $this->container['adjustment_type'] = $data['adjustment_type'] ?? null;
        $this->container['adjustment'] = $data['adjustment'] ?? null;
        $this->container['discount'] = $data['discount'] ?? null;
        $this->container['min_units'] = $data['min_units'] ?? null;
        $this->container['max_units'] = $data['max_units'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['product_id'] === null) {
            $invalidProperties[] = "'product_id' can't be null";
        }
        if ($this->container['price'] === null) {
            $invalidProperties[] = "'price' can't be null";
        }
        if ($this->container['tax_id'] === null) {
            $invalidProperties[] = "'tax_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return string
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string $product_id The ID of the associated product.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets price_book_id
     *
     * @return string|null
     */
    public function getPriceBookId()
    {
        return $this->container['price_book_id'];
    }

    /**
     * Sets price_book_id
     *
     * @param string|null $price_book_id The ID of the Price Book this product belongs to.
     *
     * @return self
     */
    public function setPriceBookId($price_book_id)
    {
        $this->container['price_book_id'] = $price_book_id;

        return $this;
    }

    /**
     * Gets default_display_price
     *
     * @return double|null
     */
    public function getDefaultDisplayPrice()
    {
        return $this->container['default_display_price'];
    }

    /**
     * Sets default_display_price
     *
     * @param double|null $default_display_price The default display price
     *
     * @return self
     */
    public function setDefaultDisplayPrice($default_display_price)
    {
        $this->container['default_display_price'] = $default_display_price;

        return $this;
    }

    /**
     * Gets price
     *
     * @return double
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double $price The Retail price of the product.
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets retail_tax
     *
     * @return double|null
     */
    public function getRetailTax()
    {
        return $this->container['retail_tax'];
    }

    /**
     * Sets retail_tax
     *
     * @param double|null $retail_tax The retail tax
     *
     * @return self
     */
    public function setRetailTax($retail_tax)
    {
        $this->container['retail_tax'] = $retail_tax;

        return $this;
    }

    /**
     * Gets loyalty_value
     *
     * @return double|null
     */
    public function getLoyaltyValue()
    {
        return $this->container['loyalty_value'];
    }

    /**
     * Sets loyalty_value
     *
     * @param double|null $loyalty_value Price Book defined loyalty value.
     *
     * @return self
     */
    public function setLoyaltyValue($loyalty_value)
    {
        $this->container['loyalty_value'] = $loyalty_value;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string $tax_id The id for the tax rate
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        $this->container['tax_id'] = $tax_id;

        return $this;
    }

    /**
     * Gets rounding
     *
     * @return string|null
     */
    public function getRounding()
    {
        return $this->container['rounding'];
    }

    /**
     * Sets rounding
     *
     * @param string|null $rounding The format for the rounding
     *
     * @return self
     */
    public function setRounding($rounding)
    {
        $this->container['rounding'] = $rounding;

        return $this;
    }

    /**
     * Gets adjustment_type
     *
     * @return string|null
     */
    public function getAdjustmentType()
    {
        return $this->container['adjustment_type'];
    }

    /**
     * Sets adjustment_type
     *
     * @param string|null $adjustment_type The adjustment type
     *
     * @return self
     */
    public function setAdjustmentType($adjustment_type)
    {
        $this->container['adjustment_type'] = $adjustment_type;

        return $this;
    }

    /**
     * Gets adjustment
     *
     * @return double|null
     */
    public function getAdjustment()
    {
        return $this->container['adjustment'];
    }

    /**
     * Sets adjustment
     *
     * @param double|null $adjustment The adjustment amount
     *
     * @return self
     */
    public function setAdjustment($adjustment)
    {
        $this->container['adjustment'] = $adjustment;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return double|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param double|null $discount The discount amount
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets min_units
     *
     * @return double|null
     */
    public function getMinUnits()
    {
        return $this->container['min_units'];
    }

    /**
     * Sets min_units
     *
     * @param double|null $min_units The minimum number of items for which this price will be used.
     *
     * @return self
     */
    public function setMinUnits($min_units)
    {
        $this->container['min_units'] = $min_units;

        return $this;
    }

    /**
     * Gets max_units
     *
     * @return double|null
     */
    public function getMaxUnits()
    {
        return $this->container['max_units'];
    }

    /**
     * Sets max_units
     *
     * @param double|null $max_units The maximum number of items for which this price will be used.
     *
     * @return self
     */
    public function setMaxUnits($max_units)
    {
        $this->container['max_units'] = $max_units;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Creation timestamp in UTC.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Last update timestamp in UTC.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


