<?php
/**
 * PriceBook
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * PriceBook Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PriceBook implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PriceBook';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'customer_group_id' => 'string',
        'id' => 'string',
        'valid_from' => 'string',
        'valid_to' => 'string',
        'restrict_to_platform_key' => 'string',
        'outlet_id' => 'string',
        'restrict_to_platform_label' => 'string',
        'customer_group' => '\Vend20\Model\CustomerGroup',
        'version' => 'int',
        'deleted_at' => 'string',
        'created_at' => 'string',
        'updated_at' => 'string',
        'outlet' => '\Vend20\Model\Outlet'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'customer_group_id' => null,
        'id' => null,
        'valid_from' => null,
        'valid_to' => null,
        'restrict_to_platform_key' => null,
        'outlet_id' => null,
        'restrict_to_platform_label' => null,
        'customer_group' => null,
        'version' => 'int64',
        'deleted_at' => null,
        'created_at' => null,
        'updated_at' => null,
        'outlet' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'customer_group_id' => 'customer_group_id',
        'id' => 'id',
        'valid_from' => 'valid_from',
        'valid_to' => 'valid_to',
        'restrict_to_platform_key' => 'restrict_to_platform_key',
        'outlet_id' => 'outlet_id',
        'restrict_to_platform_label' => 'restrict_to_platform_label',
        'customer_group' => 'customer_group',
        'version' => 'version',
        'deleted_at' => 'deleted_at',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'outlet' => 'outlet'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'customer_group_id' => 'setCustomerGroupId',
        'id' => 'setId',
        'valid_from' => 'setValidFrom',
        'valid_to' => 'setValidTo',
        'restrict_to_platform_key' => 'setRestrictToPlatformKey',
        'outlet_id' => 'setOutletId',
        'restrict_to_platform_label' => 'setRestrictToPlatformLabel',
        'customer_group' => 'setCustomerGroup',
        'version' => 'setVersion',
        'deleted_at' => 'setDeletedAt',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'outlet' => 'setOutlet'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'customer_group_id' => 'getCustomerGroupId',
        'id' => 'getId',
        'valid_from' => 'getValidFrom',
        'valid_to' => 'getValidTo',
        'restrict_to_platform_key' => 'getRestrictToPlatformKey',
        'outlet_id' => 'getOutletId',
        'restrict_to_platform_label' => 'getRestrictToPlatformLabel',
        'customer_group' => 'getCustomerGroup',
        'version' => 'getVersion',
        'deleted_at' => 'getDeletedAt',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'outlet' => 'getOutlet'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['customer_group_id'] = $data['customer_group_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['valid_from'] = $data['valid_from'] ?? null;
        $this->container['valid_to'] = $data['valid_to'] ?? null;
        $this->container['restrict_to_platform_key'] = $data['restrict_to_platform_key'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['restrict_to_platform_label'] = $data['restrict_to_platform_label'] ?? null;
        $this->container['customer_group'] = $data['customer_group'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['outlet'] = $data['outlet'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['customer_group_id'] === null) {
            $invalidProperties[] = "'customer_group_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Price Book name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets customer_group_id
     *
     * @return string
     */
    public function getCustomerGroupId()
    {
        return $this->container['customer_group_id'];
    }

    /**
     * Sets customer_group_id
     *
     * @param string $customer_group_id The ID of the customer group
     *
     * @return self
     */
    public function setCustomerGroupId($customer_group_id)
    {
        $this->container['customer_group_id'] = $customer_group_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets valid_from
     *
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->container['valid_from'];
    }

    /**
     * Sets valid_from
     *
     * @param string|null $valid_from The date when the Price Book becomes valid (active).
     *
     * @return self
     */
    public function setValidFrom($valid_from)
    {
        $this->container['valid_from'] = $valid_from;

        return $this;
    }

    /**
     * Gets valid_to
     *
     * @return string|null
     */
    public function getValidTo()
    {
        return $this->container['valid_to'];
    }

    /**
     * Sets valid_to
     *
     * @param string|null $valid_to The date when the Price Book becomes invalid (inactive).
     *
     * @return self
     */
    public function setValidTo($valid_to)
    {
        $this->container['valid_to'] = $valid_to;

        return $this;
    }

    /**
     * Gets restrict_to_platform_key
     *
     * @return string|null
     */
    public function getRestrictToPlatformKey()
    {
        return $this->container['restrict_to_platform_key'];
    }

    /**
     * Sets restrict_to_platform_key
     *
     * @param string|null $restrict_to_platform_key `\"0\"` - all platforms, `\"1\"` - in store, `\"2\"` - ecommerce.
     *
     * @return self
     */
    public function setRestrictToPlatformKey($restrict_to_platform_key)
    {
        $this->container['restrict_to_platform_key'] = $restrict_to_platform_key;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string|null
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string|null $outlet_id The ID of an outlet for which the Price Book should be used.+ type: GENERAL (string) - Internal value. Safe to ignore.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets restrict_to_platform_label
     *
     * @return string|null
     */
    public function getRestrictToPlatformLabel()
    {
        return $this->container['restrict_to_platform_label'];
    }

    /**
     * Sets restrict_to_platform_label
     *
     * @param string|null $restrict_to_platform_label One of `In Store`, `Ecommerce`, `All Platforms`.
     *
     * @return self
     */
    public function setRestrictToPlatformLabel($restrict_to_platform_label)
    {
        $this->container['restrict_to_platform_label'] = $restrict_to_platform_label;

        return $this;
    }

    /**
     * Gets customer_group
     *
     * @return \Vend20\Model\CustomerGroup|null
     */
    public function getCustomerGroup()
    {
        return $this->container['customer_group'];
    }

    /**
     * Sets customer_group
     *
     * @param \Vend20\Model\CustomerGroup|null $customer_group customer_group
     *
     * @return self
     */
    public function setCustomerGroup($customer_group)
    {
        $this->container['customer_group'] = $customer_group;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Created timestamp in UTC.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Updated timestamp in UTC.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets outlet
     *
     * @return \Vend20\Model\Outlet|null
     */
    public function getOutlet()
    {
        return $this->container['outlet'];
    }

    /**
     * Sets outlet
     *
     * @param \Vend20\Model\Outlet|null $outlet outlet
     *
     * @return self
     */
    public function setOutlet($outlet)
    {
        $this->container['outlet'] = $outlet;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


