<?php
/**
 * Outlet
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Outlet Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Outlet implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Outlet';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'time_zone' => 'string',
        'default_tax_id' => 'string',
        'currency' => 'string',
        'currency_symbol' => 'string',
        'display_prices' => 'string',
        'physical_address_1' => 'string',
        'physical_address_2' => 'string',
        'physical_suburb' => 'string',
        'physical_city' => 'string',
        'physical_postcode' => 'string',
        'physical_state' => 'string',
        'physical_country_id' => 'string',
        'attributes' => '\Vend20\Model\Attribute[]',
        'deleted_at' => 'string',
        'version' => 'int',
        'email' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'time_zone' => null,
        'default_tax_id' => null,
        'currency' => null,
        'currency_symbol' => null,
        'display_prices' => null,
        'physical_address_1' => null,
        'physical_address_2' => null,
        'physical_suburb' => null,
        'physical_city' => null,
        'physical_postcode' => null,
        'physical_state' => null,
        'physical_country_id' => null,
        'attributes' => null,
        'deleted_at' => null,
        'version' => 'int64',
        'email' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'time_zone' => 'time_zone',
        'default_tax_id' => 'default_tax_id',
        'currency' => 'currency',
        'currency_symbol' => 'currency_symbol',
        'display_prices' => 'display_prices',
        'physical_address_1' => 'physical_address_1',
        'physical_address_2' => 'physical_address_2',
        'physical_suburb' => 'physical_suburb',
        'physical_city' => 'physical_city',
        'physical_postcode' => 'physical_postcode',
        'physical_state' => 'physical_state',
        'physical_country_id' => 'physical_country_id',
        'attributes' => 'attributes',
        'deleted_at' => 'deleted_at',
        'version' => 'version',
        'email' => 'email'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'time_zone' => 'setTimeZone',
        'default_tax_id' => 'setDefaultTaxId',
        'currency' => 'setCurrency',
        'currency_symbol' => 'setCurrencySymbol',
        'display_prices' => 'setDisplayPrices',
        'physical_address_1' => 'setPhysicalAddress1',
        'physical_address_2' => 'setPhysicalAddress2',
        'physical_suburb' => 'setPhysicalSuburb',
        'physical_city' => 'setPhysicalCity',
        'physical_postcode' => 'setPhysicalPostcode',
        'physical_state' => 'setPhysicalState',
        'physical_country_id' => 'setPhysicalCountryId',
        'attributes' => 'setAttributes',
        'deleted_at' => 'setDeletedAt',
        'version' => 'setVersion',
        'email' => 'setEmail'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'time_zone' => 'getTimeZone',
        'default_tax_id' => 'getDefaultTaxId',
        'currency' => 'getCurrency',
        'currency_symbol' => 'getCurrencySymbol',
        'display_prices' => 'getDisplayPrices',
        'physical_address_1' => 'getPhysicalAddress1',
        'physical_address_2' => 'getPhysicalAddress2',
        'physical_suburb' => 'getPhysicalSuburb',
        'physical_city' => 'getPhysicalCity',
        'physical_postcode' => 'getPhysicalPostcode',
        'physical_state' => 'getPhysicalState',
        'physical_country_id' => 'getPhysicalCountryId',
        'attributes' => 'getAttributes',
        'deleted_at' => 'getDeletedAt',
        'version' => 'getVersion',
        'email' => 'getEmail'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['time_zone'] = $data['time_zone'] ?? null;
        $this->container['default_tax_id'] = $data['default_tax_id'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['currency_symbol'] = $data['currency_symbol'] ?? null;
        $this->container['display_prices'] = $data['display_prices'] ?? null;
        $this->container['physical_address_1'] = $data['physical_address_1'] ?? null;
        $this->container['physical_address_2'] = $data['physical_address_2'] ?? null;
        $this->container['physical_suburb'] = $data['physical_suburb'] ?? null;
        $this->container['physical_city'] = $data['physical_city'] ?? null;
        $this->container['physical_postcode'] = $data['physical_postcode'] ?? null;
        $this->container['physical_state'] = $data['physical_state'] ?? null;
        $this->container['physical_country_id'] = $data['physical_country_id'] ?? null;
        $this->container['attributes'] = $data['attributes'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The outlet name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets time_zone
     *
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->container['time_zone'];
    }

    /**
     * Sets time_zone
     *
     * @param string|null $time_zone Outlet timezone. **read only**
     *
     * @return self
     */
    public function setTimeZone($time_zone)
    {
        $this->container['time_zone'] = $time_zone;

        return $this;
    }

    /**
     * Gets default_tax_id
     *
     * @return string|null
     */
    public function getDefaultTaxId()
    {
        return $this->container['default_tax_id'];
    }

    /**
     * Sets default_tax_id
     *
     * @param string|null $default_tax_id Default tax id used for sales in this outlet. **deprecated**
     *
     * @return self
     */
    public function setDefaultTaxId($default_tax_id)
    {
        $this->container['default_tax_id'] = $default_tax_id;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency Currency name.
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets currency_symbol
     *
     * @return string|null
     */
    public function getCurrencySymbol()
    {
        return $this->container['currency_symbol'];
    }

    /**
     * Sets currency_symbol
     *
     * @param string|null $currency_symbol Currency symbol.
     *
     * @return self
     */
    public function setCurrencySymbol($currency_symbol)
    {
        $this->container['currency_symbol'] = $currency_symbol;

        return $this;
    }

    /**
     * Gets display_prices
     *
     * @return string|null
     */
    public function getDisplayPrices()
    {
        return $this->container['display_prices'];
    }

    /**
     * Sets display_prices
     *
     * @param string|null $display_prices Indicates whether prices in this outlet should be displayed as tax-inclusive.
     *
     * @return self
     */
    public function setDisplayPrices($display_prices)
    {
        $this->container['display_prices'] = $display_prices;

        return $this;
    }

    /**
     * Gets physical_address_1
     *
     * @return string|null
     */
    public function getPhysicalAddress1()
    {
        return $this->container['physical_address_1'];
    }

    /**
     * Sets physical_address_1
     *
     * @param string|null $physical_address_1 Physical address, line 1.
     *
     * @return self
     */
    public function setPhysicalAddress1($physical_address_1)
    {
        $this->container['physical_address_1'] = $physical_address_1;

        return $this;
    }

    /**
     * Gets physical_address_2
     *
     * @return string|null
     */
    public function getPhysicalAddress2()
    {
        return $this->container['physical_address_2'];
    }

    /**
     * Sets physical_address_2
     *
     * @param string|null $physical_address_2 Physical address, line 2.
     *
     * @return self
     */
    public function setPhysicalAddress2($physical_address_2)
    {
        $this->container['physical_address_2'] = $physical_address_2;

        return $this;
    }

    /**
     * Gets physical_suburb
     *
     * @return string|null
     */
    public function getPhysicalSuburb()
    {
        return $this->container['physical_suburb'];
    }

    /**
     * Sets physical_suburb
     *
     * @param string|null $physical_suburb Physical address, suburb.
     *
     * @return self
     */
    public function setPhysicalSuburb($physical_suburb)
    {
        $this->container['physical_suburb'] = $physical_suburb;

        return $this;
    }

    /**
     * Gets physical_city
     *
     * @return string|null
     */
    public function getPhysicalCity()
    {
        return $this->container['physical_city'];
    }

    /**
     * Sets physical_city
     *
     * @param string|null $physical_city Physical address, city.
     *
     * @return self
     */
    public function setPhysicalCity($physical_city)
    {
        $this->container['physical_city'] = $physical_city;

        return $this;
    }

    /**
     * Gets physical_postcode
     *
     * @return string|null
     */
    public function getPhysicalPostcode()
    {
        return $this->container['physical_postcode'];
    }

    /**
     * Sets physical_postcode
     *
     * @param string|null $physical_postcode Physical address, post code.
     *
     * @return self
     */
    public function setPhysicalPostcode($physical_postcode)
    {
        $this->container['physical_postcode'] = $physical_postcode;

        return $this;
    }

    /**
     * Gets physical_state
     *
     * @return string|null
     */
    public function getPhysicalState()
    {
        return $this->container['physical_state'];
    }

    /**
     * Sets physical_state
     *
     * @param string|null $physical_state Physical address, state.
     *
     * @return self
     */
    public function setPhysicalState($physical_state)
    {
        $this->container['physical_state'] = $physical_state;

        return $this;
    }

    /**
     * Gets physical_country_id
     *
     * @return string|null
     */
    public function getPhysicalCountryId()
    {
        return $this->container['physical_country_id'];
    }

    /**
     * Sets physical_country_id
     *
     * @param string|null $physical_country_id Physical address, country code.
     *
     * @return self
     */
    public function setPhysicalCountryId($physical_country_id)
    {
        $this->container['physical_country_id'] = $physical_country_id;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Vend20\Model\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Vend20\Model\Attribute[]|null $attributes The outlet attributes such as `low_stock_warning`, `order_reference`, `order_reference_prefix`, `return_reference`, `return_reference_prefix`.
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email Specified email for the outlet.
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


