<?php
/**
 * LineItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * LineItem Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class LineItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'LineItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'tax_id' => 'string',
        'discount_total' => 'double',
        'is_return' => 'bool',
        'cost' => 'double',
        'cost_total' => 'double',
        'price_total' => 'double',
        'tax' => 'double',
        'tax_total' => 'double',
        'product_id' => 'string',
        'quantity' => 'double',
        'price' => 'double',
        'tax_components' => '\Vend20\Model\LineItemTaxComponent[]',
        'discount' => 'double',
        'loyalty_value' => 'double',
        'price_set' => 'bool',
        'sequence' => 'double',
        'note' => 'string',
        'status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'tax_id' => null,
        'discount_total' => 'double',
        'is_return' => null,
        'cost' => 'double',
        'cost_total' => 'double',
        'price_total' => 'double',
        'tax' => 'double',
        'tax_total' => 'double',
        'product_id' => null,
        'quantity' => 'double',
        'price' => 'double',
        'tax_components' => null,
        'discount' => 'double',
        'loyalty_value' => 'double',
        'price_set' => null,
        'sequence' => 'double',
        'note' => null,
        'status' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'tax_id' => 'tax_id',
        'discount_total' => 'discount_total',
        'is_return' => 'is_return',
        'cost' => 'cost',
        'cost_total' => 'cost_total',
        'price_total' => 'price_total',
        'tax' => 'tax',
        'tax_total' => 'tax_total',
        'product_id' => 'product_id',
        'quantity' => 'quantity',
        'price' => 'price',
        'tax_components' => 'tax_components',
        'discount' => 'discount',
        'loyalty_value' => 'loyalty_value',
        'price_set' => 'price_set',
        'sequence' => 'sequence',
        'note' => 'note',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'tax_id' => 'setTaxId',
        'discount_total' => 'setDiscountTotal',
        'is_return' => 'setIsReturn',
        'cost' => 'setCost',
        'cost_total' => 'setCostTotal',
        'price_total' => 'setPriceTotal',
        'tax' => 'setTax',
        'tax_total' => 'setTaxTotal',
        'product_id' => 'setProductId',
        'quantity' => 'setQuantity',
        'price' => 'setPrice',
        'tax_components' => 'setTaxComponents',
        'discount' => 'setDiscount',
        'loyalty_value' => 'setLoyaltyValue',
        'price_set' => 'setPriceSet',
        'sequence' => 'setSequence',
        'note' => 'setNote',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'tax_id' => 'getTaxId',
        'discount_total' => 'getDiscountTotal',
        'is_return' => 'getIsReturn',
        'cost' => 'getCost',
        'cost_total' => 'getCostTotal',
        'price_total' => 'getPriceTotal',
        'tax' => 'getTax',
        'tax_total' => 'getTaxTotal',
        'product_id' => 'getProductId',
        'quantity' => 'getQuantity',
        'price' => 'getPrice',
        'tax_components' => 'getTaxComponents',
        'discount' => 'getDiscount',
        'loyalty_value' => 'getLoyaltyValue',
        'price_set' => 'getPriceSet',
        'sequence' => 'getSequence',
        'note' => 'getNote',
        'status' => 'getStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['tax_id'] = $data['tax_id'] ?? null;
        $this->container['discount_total'] = $data['discount_total'] ?? null;
        $this->container['is_return'] = $data['is_return'] ?? null;
        $this->container['cost'] = $data['cost'] ?? null;
        $this->container['cost_total'] = $data['cost_total'] ?? null;
        $this->container['price_total'] = $data['price_total'] ?? null;
        $this->container['tax'] = $data['tax'] ?? null;
        $this->container['tax_total'] = $data['tax_total'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['tax_components'] = $data['tax_components'] ?? null;
        $this->container['discount'] = $data['discount'] ?? null;
        $this->container['loyalty_value'] = $data['loyalty_value'] ?? null;
        $this->container['price_set'] = $data['price_set'] ?? null;
        $this->container['sequence'] = $data['sequence'] ?? null;
        $this->container['note'] = $data['note'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The ID of the line item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id ???
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        $this->container['tax_id'] = $tax_id;

        return $this;
    }

    /**
     * Gets discount_total
     *
     * @return double|null
     */
    public function getDiscountTotal()
    {
        return $this->container['discount_total'];
    }

    /**
     * Sets discount_total
     *
     * @param double|null $discount_total Total discount for the line item.
     *
     * @return self
     */
    public function setDiscountTotal($discount_total)
    {
        $this->container['discount_total'] = $discount_total;

        return $this;
    }

    /**
     * Gets is_return
     *
     * @return bool|null
     */
    public function getIsReturn()
    {
        return $this->container['is_return'];
    }

    /**
     * Sets is_return
     *
     * @param bool|null $is_return Indicates whether this line item is a return from another sale (referenced by `return_for` on the main sale object).
     *
     * @return self
     */
    public function setIsReturn($is_return)
    {
        $this->container['is_return'] = $is_return;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return double|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param double|null $cost Unit cost for the line item.
     *
     * @return self
     */
    public function setCost($cost)
    {
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets cost_total
     *
     * @return double|null
     */
    public function getCostTotal()
    {
        return $this->container['cost_total'];
    }

    /**
     * Sets cost_total
     *
     * @param double|null $cost_total Total cost for the line item.
     *
     * @return self
     */
    public function setCostTotal($cost_total)
    {
        $this->container['cost_total'] = $cost_total;

        return $this;
    }

    /**
     * Gets price_total
     *
     * @return double|null
     */
    public function getPriceTotal()
    {
        return $this->container['price_total'];
    }

    /**
     * Sets price_total
     *
     * @param double|null $price_total Total price for the line item.
     *
     * @return self
     */
    public function setPriceTotal($price_total)
    {
        $this->container['price_total'] = $price_total;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return double|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param double|null $tax Unit tax for the line item. **deprecated** ???
     *
     * @return self
     */
    public function setTax($tax)
    {
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return double|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param double|null $tax_total Total tax value.
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return string|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string|null $product_id Valid product ID.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return double|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param double|null $quantity Quantity of product units included in the sale.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets price
     *
     * @return double|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double|null $price Unit price for the product.
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets tax_components
     *
     * @return \Vend20\Model\LineItemTaxComponent[]|null
     */
    public function getTaxComponents()
    {
        return $this->container['tax_components'];
    }

    /**
     * Sets tax_components
     *
     * @param \Vend20\Model\LineItemTaxComponent[]|null $tax_components Collection of tax components associated with the line item.
     *
     * @return self
     */
    public function setTaxComponents($tax_components)
    {
        $this->container['tax_components'] = $tax_components;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return double|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param double|null $discount Discount. ??? Unit? Should that be even posted?
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets loyalty_value
     *
     * @return double|null
     */
    public function getLoyaltyValue()
    {
        return $this->container['loyalty_value'];
    }

    /**
     * Sets loyalty_value
     *
     * @param double|null $loyalty_value The value that should be added to associated customer's loyalty balance.
     *
     * @return self
     */
    public function setLoyaltyValue($loyalty_value)
    {
        $this->container['loyalty_value'] = $loyalty_value;

        return $this;
    }

    /**
     * Gets price_set
     *
     * @return bool|null
     */
    public function getPriceSet()
    {
        return $this->container['price_set'];
    }

    /**
     * Sets price_set
     *
     * @param bool|null $price_set Indicates whether the price was set manually. Using `true` means that the value will never be refreshed from the Price Book when reloaded (sale retrieved from parked sales).
     *
     * @return self
     */
    public function setPriceSet($price_set)
    {
        $this->container['price_set'] = $price_set;

        return $this;
    }

    /**
     * Gets sequence
     *
     * @return double|null
     */
    public function getSequence()
    {
        return $this->container['sequence'];
    }

    /**
     * Sets sequence
     *
     * @param double|null $sequence Order of the line item in the sale.
     *
     * @return self
     */
    public function setSequence($sequence)
    {
        $this->container['sequence'] = $sequence;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note Line item note.
     *
     * @return self
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Line item status. ???
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


