<?php
/**
 * DiscountLineItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * DiscountLineItem Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class DiscountLineItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DiscountLineItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'handle' => 'string',
        'product_id' => 'string',
        'product_brand_id' => 'string',
        'product_supplier_id' => 'string',
        'product_type_id' => 'string',
        'product_tag_ids' => 'string[]',
        'variant_parent_id' => 'string',
        'quantity' => 'int',
        'unit_price' => 'double',
        'price_adjusted' => 'bool',
        'confirmed' => 'bool',
        'loyalty_value' => 'double',
        'explicit_loyalty_value' => 'bool',
        'unit_discount' => 'double',
        'unit_tax_discount' => 'double',
        'promotion_ids' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'handle' => null,
        'product_id' => null,
        'product_brand_id' => null,
        'product_supplier_id' => null,
        'product_type_id' => null,
        'product_tag_ids' => null,
        'variant_parent_id' => null,
        'quantity' => null,
        'unit_price' => 'double',
        'price_adjusted' => null,
        'confirmed' => null,
        'loyalty_value' => 'double',
        'explicit_loyalty_value' => null,
        'unit_discount' => 'double',
        'unit_tax_discount' => 'double',
        'promotion_ids' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'handle' => 'handle',
        'product_id' => 'product_id',
        'product_brand_id' => 'product_brand_id',
        'product_supplier_id' => 'product_supplier_id',
        'product_type_id' => 'product_type_id',
        'product_tag_ids' => 'product_tag_ids',
        'variant_parent_id' => 'variant_parent_id',
        'quantity' => 'quantity',
        'unit_price' => 'unit_price',
        'price_adjusted' => 'price_adjusted',
        'confirmed' => 'confirmed',
        'loyalty_value' => 'loyalty_value',
        'explicit_loyalty_value' => 'explicit_loyalty_value',
        'unit_discount' => 'unit_discount',
        'unit_tax_discount' => 'unit_tax_discount',
        'promotion_ids' => 'promotion_ids'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'handle' => 'setHandle',
        'product_id' => 'setProductId',
        'product_brand_id' => 'setProductBrandId',
        'product_supplier_id' => 'setProductSupplierId',
        'product_type_id' => 'setProductTypeId',
        'product_tag_ids' => 'setProductTagIds',
        'variant_parent_id' => 'setVariantParentId',
        'quantity' => 'setQuantity',
        'unit_price' => 'setUnitPrice',
        'price_adjusted' => 'setPriceAdjusted',
        'confirmed' => 'setConfirmed',
        'loyalty_value' => 'setLoyaltyValue',
        'explicit_loyalty_value' => 'setExplicitLoyaltyValue',
        'unit_discount' => 'setUnitDiscount',
        'unit_tax_discount' => 'setUnitTaxDiscount',
        'promotion_ids' => 'setPromotionIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'handle' => 'getHandle',
        'product_id' => 'getProductId',
        'product_brand_id' => 'getProductBrandId',
        'product_supplier_id' => 'getProductSupplierId',
        'product_type_id' => 'getProductTypeId',
        'product_tag_ids' => 'getProductTagIds',
        'variant_parent_id' => 'getVariantParentId',
        'quantity' => 'getQuantity',
        'unit_price' => 'getUnitPrice',
        'price_adjusted' => 'getPriceAdjusted',
        'confirmed' => 'getConfirmed',
        'loyalty_value' => 'getLoyaltyValue',
        'explicit_loyalty_value' => 'getExplicitLoyaltyValue',
        'unit_discount' => 'getUnitDiscount',
        'unit_tax_discount' => 'getUnitTaxDiscount',
        'promotion_ids' => 'getPromotionIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['handle'] = $data['handle'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['product_brand_id'] = $data['product_brand_id'] ?? null;
        $this->container['product_supplier_id'] = $data['product_supplier_id'] ?? null;
        $this->container['product_type_id'] = $data['product_type_id'] ?? null;
        $this->container['product_tag_ids'] = $data['product_tag_ids'] ?? null;
        $this->container['variant_parent_id'] = $data['variant_parent_id'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['unit_price'] = $data['unit_price'] ?? null;
        $this->container['price_adjusted'] = $data['price_adjusted'] ?? null;
        $this->container['confirmed'] = $data['confirmed'] ?? null;
        $this->container['loyalty_value'] = $data['loyalty_value'] ?? null;
        $this->container['explicit_loyalty_value'] = $data['explicit_loyalty_value'] ?? null;
        $this->container['unit_discount'] = $data['unit_discount'] ?? null;
        $this->container['unit_tax_discount'] = $data['unit_tax_discount'] ?? null;
        $this->container['promotion_ids'] = $data['promotion_ids'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['handle'] === null) {
            $invalidProperties[] = "'handle' can't be null";
        }
        if ($this->container['product_id'] === null) {
            $invalidProperties[] = "'product_id' can't be null";
        }
        if ($this->container['product_brand_id'] === null) {
            $invalidProperties[] = "'product_brand_id' can't be null";
        }
        if ($this->container['product_supplier_id'] === null) {
            $invalidProperties[] = "'product_supplier_id' can't be null";
        }
        if ($this->container['product_type_id'] === null) {
            $invalidProperties[] = "'product_type_id' can't be null";
        }
        if ($this->container['product_tag_ids'] === null) {
            $invalidProperties[] = "'product_tag_ids' can't be null";
        }
        if ($this->container['quantity'] === null) {
            $invalidProperties[] = "'quantity' can't be null";
        }
        if ($this->container['unit_price'] === null) {
            $invalidProperties[] = "'unit_price' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Line item ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets handle
     *
     * @return string
     */
    public function getHandle()
    {
        return $this->container['handle'];
    }

    /**
     * Sets handle
     *
     * @param string $handle Handle.
     *
     * @return self
     */
    public function setHandle($handle)
    {
        $this->container['handle'] = $handle;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return string
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string $product_id Product ID
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets product_brand_id
     *
     * @return string
     */
    public function getProductBrandId()
    {
        return $this->container['product_brand_id'];
    }

    /**
     * Sets product_brand_id
     *
     * @param string $product_brand_id Product Brand ID.
     *
     * @return self
     */
    public function setProductBrandId($product_brand_id)
    {
        $this->container['product_brand_id'] = $product_brand_id;

        return $this;
    }

    /**
     * Gets product_supplier_id
     *
     * @return string
     */
    public function getProductSupplierId()
    {
        return $this->container['product_supplier_id'];
    }

    /**
     * Sets product_supplier_id
     *
     * @param string $product_supplier_id Product Supplier ID.
     *
     * @return self
     */
    public function setProductSupplierId($product_supplier_id)
    {
        $this->container['product_supplier_id'] = $product_supplier_id;

        return $this;
    }

    /**
     * Gets product_type_id
     *
     * @return string
     */
    public function getProductTypeId()
    {
        return $this->container['product_type_id'];
    }

    /**
     * Sets product_type_id
     *
     * @param string $product_type_id Product Type ID.
     *
     * @return self
     */
    public function setProductTypeId($product_type_id)
    {
        $this->container['product_type_id'] = $product_type_id;

        return $this;
    }

    /**
     * Gets product_tag_ids
     *
     * @return string[]
     */
    public function getProductTagIds()
    {
        return $this->container['product_tag_ids'];
    }

    /**
     * Sets product_tag_ids
     *
     * @param string[] $product_tag_ids Product Tag IDs.
     *
     * @return self
     */
    public function setProductTagIds($product_tag_ids)
    {
        $this->container['product_tag_ids'] = $product_tag_ids;

        return $this;
    }

    /**
     * Gets variant_parent_id
     *
     * @return string|null
     */
    public function getVariantParentId()
    {
        return $this->container['variant_parent_id'];
    }

    /**
     * Sets variant_parent_id
     *
     * @param string|null $variant_parent_id Product variant parent ID
     *
     * @return self
     */
    public function setVariantParentId($variant_parent_id)
    {
        $this->container['variant_parent_id'] = $variant_parent_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int $quantity Quantity of the line item.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets unit_price
     *
     * @return double
     */
    public function getUnitPrice()
    {
        return $this->container['unit_price'];
    }

    /**
     * Sets unit_price
     *
     * @param double $unit_price The unit price for the line item.
     *
     * @return self
     */
    public function setUnitPrice($unit_price)
    {
        $this->container['unit_price'] = $unit_price;

        return $this;
    }

    /**
     * Gets price_adjusted
     *
     * @return bool|null
     */
    public function getPriceAdjusted()
    {
        return $this->container['price_adjusted'];
    }

    /**
     * Sets price_adjusted
     *
     * @param bool|null $price_adjusted Indicator to suggest that the price has been adjusted manually, such as through a discount.
     *
     * @return self
     */
    public function setPriceAdjusted($price_adjusted)
    {
        $this->container['price_adjusted'] = $price_adjusted;

        return $this;
    }

    /**
     * Gets confirmed
     *
     * @return bool|null
     */
    public function getConfirmed()
    {
        return $this->container['confirmed'];
    }

    /**
     * Sets confirmed
     *
     * @param bool|null $confirmed Whether the line item is confirmed as part of a layby or on account sale.
     *
     * @return self
     */
    public function setConfirmed($confirmed)
    {
        $this->container['confirmed'] = $confirmed;

        return $this;
    }

    /**
     * Gets loyalty_value
     *
     * @return double|null
     */
    public function getLoyaltyValue()
    {
        return $this->container['loyalty_value'];
    }

    /**
     * Sets loyalty_value
     *
     * @param double|null $loyalty_value The line item's loyalty value
     *
     * @return self
     */
    public function setLoyaltyValue($loyalty_value)
    {
        $this->container['loyalty_value'] = $loyalty_value;

        return $this;
    }

    /**
     * Gets explicit_loyalty_value
     *
     * @return bool|null
     */
    public function getExplicitLoyaltyValue()
    {
        return $this->container['explicit_loyalty_value'];
    }

    /**
     * Sets explicit_loyalty_value
     *
     * @param bool|null $explicit_loyalty_value Whether loyalty was explicitly set in the product or it just uses the default outlet ratio.
     *
     * @return self
     */
    public function setExplicitLoyaltyValue($explicit_loyalty_value)
    {
        $this->container['explicit_loyalty_value'] = $explicit_loyalty_value;

        return $this;
    }

    /**
     * Gets unit_discount
     *
     * @return double|null
     */
    public function getUnitDiscount()
    {
        return $this->container['unit_discount'];
    }

    /**
     * Sets unit_discount
     *
     * @param double|null $unit_discount The line item's unit discount
     *
     * @return self
     */
    public function setUnitDiscount($unit_discount)
    {
        $this->container['unit_discount'] = $unit_discount;

        return $this;
    }

    /**
     * Gets unit_tax_discount
     *
     * @return double|null
     */
    public function getUnitTaxDiscount()
    {
        return $this->container['unit_tax_discount'];
    }

    /**
     * Sets unit_tax_discount
     *
     * @param double|null $unit_tax_discount The line item's unit tax discount
     *
     * @return self
     */
    public function setUnitTaxDiscount($unit_tax_discount)
    {
        $this->container['unit_tax_discount'] = $unit_tax_discount;

        return $this;
    }

    /**
     * Gets promotion_ids
     *
     * @return string[]|null
     */
    public function getPromotionIds()
    {
        return $this->container['promotion_ids'];
    }

    /**
     * Sets promotion_ids
     *
     * @param string[]|null $promotion_ids List of promotion IDs applied to this line item.
     *
     * @return self
     */
    public function setPromotionIds($promotion_ids)
    {
        $this->container['promotion_ids'] = $promotion_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


