<?php
/**
 * Consignment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Consignment Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Consignment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Consignment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'outlet_id' => 'string',
        'name' => 'string',
        'consignment_date' => 'string',
        'due_at' => 'string',
        'received_at' => 'string',
        'type' => 'string',
        'status' => 'string',
        'supplier_id' => 'string',
        'source_outlet_id' => 'string',
        'supplier_invoice' => 'string',
        'reference' => 'string',
        'total_count_gain' => 'double',
        'total_cost_gain' => 'double',
        'total_count_loss' => 'double',
        'total_cost_loss' => 'double',
        'created_at' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string',
        'version' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'outlet_id' => 'uuid',
        'name' => null,
        'consignment_date' => null,
        'due_at' => null,
        'received_at' => null,
        'type' => null,
        'status' => null,
        'supplier_id' => 'uuid',
        'source_outlet_id' => 'uuid',
        'supplier_invoice' => null,
        'reference' => null,
        'total_count_gain' => 'double',
        'total_cost_gain' => 'double',
        'total_count_loss' => 'double',
        'total_cost_loss' => 'double',
        'created_at' => null,
        'updated_at' => null,
        'deleted_at' => null,
        'version' => 'int64'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'outlet_id' => 'outlet_id',
        'name' => 'name',
        'consignment_date' => 'consignment_date',
        'due_at' => 'due_at',
        'received_at' => 'received_at',
        'type' => 'type',
        'status' => 'status',
        'supplier_id' => 'supplier_id',
        'source_outlet_id' => 'source_outlet_id',
        'supplier_invoice' => 'supplier_invoice',
        'reference' => 'reference',
        'total_count_gain' => 'total_count_gain',
        'total_cost_gain' => 'total_cost_gain',
        'total_count_loss' => 'total_count_loss',
        'total_cost_loss' => 'total_cost_loss',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'version' => 'version'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'outlet_id' => 'setOutletId',
        'name' => 'setName',
        'consignment_date' => 'setConsignmentDate',
        'due_at' => 'setDueAt',
        'received_at' => 'setReceivedAt',
        'type' => 'setType',
        'status' => 'setStatus',
        'supplier_id' => 'setSupplierId',
        'source_outlet_id' => 'setSourceOutletId',
        'supplier_invoice' => 'setSupplierInvoice',
        'reference' => 'setReference',
        'total_count_gain' => 'setTotalCountGain',
        'total_cost_gain' => 'setTotalCostGain',
        'total_count_loss' => 'setTotalCountLoss',
        'total_cost_loss' => 'setTotalCostLoss',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'version' => 'setVersion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'outlet_id' => 'getOutletId',
        'name' => 'getName',
        'consignment_date' => 'getConsignmentDate',
        'due_at' => 'getDueAt',
        'received_at' => 'getReceivedAt',
        'type' => 'getType',
        'status' => 'getStatus',
        'supplier_id' => 'getSupplierId',
        'source_outlet_id' => 'getSourceOutletId',
        'supplier_invoice' => 'getSupplierInvoice',
        'reference' => 'getReference',
        'total_count_gain' => 'getTotalCountGain',
        'total_cost_gain' => 'getTotalCostGain',
        'total_count_loss' => 'getTotalCountLoss',
        'total_cost_loss' => 'getTotalCostLoss',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'version' => 'getVersion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_SUPPLIER = 'SUPPLIER';
    public const TYPE_OUTLET = 'OUTLET';
    public const TYPE_STOCKTAKE = 'STOCKTAKE';
    public const TYPE__RETURN = 'RETURN';
    public const STATUS_OPEN = 'OPEN';
    public const STATUS_SENT = 'SENT';
    public const STATUS_DISPATCHED = 'DISPATCHED';
    public const STATUS_RECEIVED = 'RECEIVED';
    public const STATUS_STOCKTAKE_IN_PROGRESS = 'STOCKTAKE_IN_PROGRESS';
    public const STATUS_STOCKTAKE_SCHEDULED = 'STOCKTAKE_SCHEDULED';
    public const STATUS_STOCKTAKE_IN_PROGRESS_PROCESSED = 'STOCKTAKE_IN_PROGRESS_PROCESSED';
    public const STATUS_STOCKTAKE_COMPLETE = 'STOCKTAKE_COMPLETE';
    public const STATUS_CLOSED = 'CLOSED';
    public const STATUS_CANCELLED = 'CANCELLED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_SUPPLIER,
            self::TYPE_OUTLET,
            self::TYPE_STOCKTAKE,
            self::TYPE__RETURN,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_OPEN,
            self::STATUS_SENT,
            self::STATUS_DISPATCHED,
            self::STATUS_RECEIVED,
            self::STATUS_STOCKTAKE_IN_PROGRESS,
            self::STATUS_STOCKTAKE_SCHEDULED,
            self::STATUS_STOCKTAKE_IN_PROGRESS_PROCESSED,
            self::STATUS_STOCKTAKE_COMPLETE,
            self::STATUS_CLOSED,
            self::STATUS_CANCELLED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['consignment_date'] = $data['consignment_date'] ?? null;
        $this->container['due_at'] = $data['due_at'] ?? null;
        $this->container['received_at'] = $data['received_at'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['supplier_id'] = $data['supplier_id'] ?? null;
        $this->container['source_outlet_id'] = $data['source_outlet_id'] ?? null;
        $this->container['supplier_invoice'] = $data['supplier_invoice'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['total_count_gain'] = $data['total_count_gain'] ?? null;
        $this->container['total_cost_gain'] = $data['total_cost_gain'] ?? null;
        $this->container['total_count_loss'] = $data['total_count_loss'] ?? null;
        $this->container['total_cost_loss'] = $data['total_cost_loss'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['outlet_id'] === null) {
            $invalidProperties[] = "'outlet_id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string $outlet_id A valid ID of an outlet where stock will be received.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Tue 29 Nov 2016 (string) - Consignment name. For orders, the note field in the UI will be the name value.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets consignment_date
     *
     * @return string|null
     */
    public function getConsignmentDate()
    {
        return $this->container['consignment_date'];
    }

    /**
     * Sets consignment_date
     *
     * @param string|null $consignment_date 11-28T19:02:15+00:00 (timestamp) - Consignment creation date.
     *
     * @return self
     */
    public function setConsignmentDate($consignment_date)
    {
        $this->container['consignment_date'] = $consignment_date;

        return $this;
    }

    /**
     * Gets due_at
     *
     * @return string|null
     */
    public function getDueAt()
    {
        return $this->container['due_at'];
    }

    /**
     * Sets due_at
     *
     * @param string|null $due_at 11-30T19:08:541+00:00 (timestamp) - Due date.
     *
     * @return self
     */
    public function setDueAt($due_at)
    {
        $this->container['due_at'] = $due_at;

        return $this;
    }

    /**
     * Gets received_at
     *
     * @return string|null
     */
    public function getReceivedAt()
    {
        return $this->container['received_at'];
    }

    /**
     * Sets received_at
     *
     * @param string|null $received_at 11-30T19:08:541+00:00 (timestamp) - The date when consignment was received.
     *
     * @return self
     */
    public function setReceivedAt($received_at)
    {
        $this->container['received_at'] = $received_at;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type One of `SUPPLIER`, `OUTLET`, `STOCKTAKE`, `RETURN`.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status * Supplier Order: One of `OPEN`, `SENT`, `DISPATCHED`, `RECEIVED`, `CANCELLED`  * Outlet Transfer: One of `OPEN`, `SENT`, `RECEIVED`, `CANCELLED`  * Return Order: One of `OPEN`, `SENT`, `CANCELLED`  * Stocktake: One of `STOCKTAKE_SCHEDULED`, `STOCKTAKE_IN_PROGRESS`, `STOCKTAKE_IN_PROGRESS_PROCESSED`, `STOCKTAKE_COMPLETE`, `CLOSED`, `CANCELLED`  This is not a definitive list and may be extended in future
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param string|null $supplier_id a valid supplier ID.
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets source_outlet_id
     *
     * @return string|null
     */
    public function getSourceOutletId()
    {
        return $this->container['source_outlet_id'];
    }

    /**
     * Sets source_outlet_id
     *
     * @param string|null $source_outlet_id A valid ID of an outlet where stock will come from. **Stock transfers only**.
     *
     * @return self
     */
    public function setSourceOutletId($source_outlet_id)
    {
        $this->container['source_outlet_id'] = $source_outlet_id;

        return $this;
    }

    /**
     * Gets supplier_invoice
     *
     * @return string|null
     */
    public function getSupplierInvoice()
    {
        return $this->container['supplier_invoice'];
    }

    /**
     * Sets supplier_invoice
     *
     * @param string|null $supplier_invoice Supplier invoice number.
     *
     * @return self
     */
    public function setSupplierInvoice($supplier_invoice)
    {
        $this->container['supplier_invoice'] = $supplier_invoice;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference Order number.+ `total_count_gain` (number)
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets total_count_gain
     *
     * @return double|null
     */
    public function getTotalCountGain()
    {
        return $this->container['total_count_gain'];
    }

    /**
     * Sets total_count_gain
     *
     * @param double|null $total_count_gain The number of items over the expected level.
     *
     * @return self
     */
    public function setTotalCountGain($total_count_gain)
    {
        $this->container['total_count_gain'] = $total_count_gain;

        return $this;
    }

    /**
     * Gets total_cost_gain
     *
     * @return double|null
     */
    public function getTotalCostGain()
    {
        return $this->container['total_cost_gain'];
    }

    /**
     * Sets total_cost_gain
     *
     * @param double|null $total_cost_gain The cost of items over the expected level.
     *
     * @return self
     */
    public function setTotalCostGain($total_cost_gain)
    {
        $this->container['total_cost_gain'] = $total_cost_gain;

        return $this;
    }

    /**
     * Gets total_count_loss
     *
     * @return double|null
     */
    public function getTotalCountLoss()
    {
        return $this->container['total_count_loss'];
    }

    /**
     * Sets total_count_loss
     *
     * @param double|null $total_count_loss The number of items below the expected level.
     *
     * @return self
     */
    public function setTotalCountLoss($total_count_loss)
    {
        $this->container['total_count_loss'] = $total_count_loss;

        return $this;
    }

    /**
     * Gets total_cost_loss
     *
     * @return double|null
     */
    public function getTotalCostLoss()
    {
        return $this->container['total_cost_loss'];
    }

    /**
     * Sets total_cost_loss
     *
     * @param double|null $total_cost_loss The cost of items below the expected level.
     *
     * @return self
     */
    public function setTotalCostLoss($total_cost_loss)
    {
        $this->container['total_cost_loss'] = $total_cost_loss;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Creation timestamp in UTC.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Last update timestamp in UTC.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp in UTC.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets version
     *
     * @return int|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param int|null $version Auto-incrementing object version number.
     *
     * @return self
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


