<?php
/**
 * Channel
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Model;

use \ArrayAccess;
use \Vend20\ObjectSerializer;

/**
 * Channel Class Doc Comment
 *
 * @category Class
 * @description An object representing a single channel.
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Channel implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Channel';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'store_url' => 'string',
        'channel_type' => 'string',
        'register_id' => 'string',
        'payment_type_id' => 'string',
        'inventory_outlet_ids' => 'string[]',
        'created_at' => '\DateTime',
        'sales_last_imported_at' => '\DateTime',
        'products_last_imported_at' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'store_url' => null,
        'channel_type' => null,
        'register_id' => null,
        'payment_type_id' => null,
        'inventory_outlet_ids' => null,
        'created_at' => 'date-time',
        'sales_last_imported_at' => 'date-time',
        'products_last_imported_at' => 'date-time'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'store_url' => 'store_url',
        'channel_type' => 'channel_type',
        'register_id' => 'register_id',
        'payment_type_id' => 'payment_type_id',
        'inventory_outlet_ids' => 'inventory_outlet_ids',
        'created_at' => 'created_at',
        'sales_last_imported_at' => 'sales_last_imported_at',
        'products_last_imported_at' => 'products_last_imported_at'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'store_url' => 'setStoreUrl',
        'channel_type' => 'setChannelType',
        'register_id' => 'setRegisterId',
        'payment_type_id' => 'setPaymentTypeId',
        'inventory_outlet_ids' => 'setInventoryOutletIds',
        'created_at' => 'setCreatedAt',
        'sales_last_imported_at' => 'setSalesLastImportedAt',
        'products_last_imported_at' => 'setProductsLastImportedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'store_url' => 'getStoreUrl',
        'channel_type' => 'getChannelType',
        'register_id' => 'getRegisterId',
        'payment_type_id' => 'getPaymentTypeId',
        'inventory_outlet_ids' => 'getInventoryOutletIds',
        'created_at' => 'getCreatedAt',
        'sales_last_imported_at' => 'getSalesLastImportedAt',
        'products_last_imported_at' => 'getProductsLastImportedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CHANNEL_TYPE_WOOCOMMERCE = 'woocommerce';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getChannelTypeAllowableValues()
    {
        return [
            self::CHANNEL_TYPE_WOOCOMMERCE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['store_url'] = $data['store_url'] ?? null;
        $this->container['channel_type'] = $data['channel_type'] ?? null;
        $this->container['register_id'] = $data['register_id'] ?? null;
        $this->container['payment_type_id'] = $data['payment_type_id'] ?? null;
        $this->container['inventory_outlet_ids'] = $data['inventory_outlet_ids'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['sales_last_imported_at'] = $data['sales_last_imported_at'] ?? null;
        $this->container['products_last_imported_at'] = $data['products_last_imported_at'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['store_url'] === null) {
            $invalidProperties[] = "'store_url' can't be null";
        }
        if ($this->container['channel_type'] === null) {
            $invalidProperties[] = "'channel_type' can't be null";
        }
        $allowedValues = $this->getChannelTypeAllowableValues();
        if (!is_null($this->container['channel_type']) && !in_array($this->container['channel_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'channel_type', must be one of '%s'",
                $this->container['channel_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['register_id'] === null) {
            $invalidProperties[] = "'register_id' can't be null";
        }
        if ($this->container['payment_type_id'] === null) {
            $invalidProperties[] = "'payment_type_id' can't be null";
        }
        if ($this->container['inventory_outlet_ids'] === null) {
            $invalidProperties[] = "'inventory_outlet_ids' can't be null";
        }
        if ($this->container['sales_last_imported_at'] === null) {
            $invalidProperties[] = "'sales_last_imported_at' can't be null";
        }
        if ($this->container['products_last_imported_at'] === null) {
            $invalidProperties[] = "'products_last_imported_at' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets store_url
     *
     * @return string
     */
    public function getStoreUrl()
    {
        return $this->container['store_url'];
    }

    /**
     * Sets store_url
     *
     * @param string $store_url The store identifier.
     *
     * @return self
     */
    public function setStoreUrl($store_url)
    {
        $this->container['store_url'] = $store_url;

        return $this;
    }

    /**
     * Gets channel_type
     *
     * @return string
     */
    public function getChannelType()
    {
        return $this->container['channel_type'];
    }

    /**
     * Sets channel_type
     *
     * @param string $channel_type The type of channel this is.
     *
     * @return self
     */
    public function setChannelType($channel_type)
    {
        $allowedValues = $this->getChannelTypeAllowableValues();
        if (!in_array($channel_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'channel_type', must be one of '%s'",
                    $channel_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['channel_type'] = $channel_type;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return string
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param string $register_id The Vend register id that sales will be associated to.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets payment_type_id
     *
     * @return string
     */
    public function getPaymentTypeId()
    {
        return $this->container['payment_type_id'];
    }

    /**
     * Sets payment_type_id
     *
     * @param string $payment_type_id The Vend payment type id that sale payments will be associated to.
     *
     * @return self
     */
    public function setPaymentTypeId($payment_type_id)
    {
        $this->container['payment_type_id'] = $payment_type_id;

        return $this;
    }

    /**
     * Gets inventory_outlet_ids
     *
     * @return string[]
     */
    public function getInventoryOutletIds()
    {
        return $this->container['inventory_outlet_ids'];
    }

    /**
     * Sets inventory_outlet_ids
     *
     * @param string[] $inventory_outlet_ids The Vend outlet ids that count towards inventory.
     *
     * @return self
     */
    public function setInventoryOutletIds($inventory_outlet_ids)
    {
        $this->container['inventory_outlet_ids'] = $inventory_outlet_ids;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at An RFC3339 representation of the time at which the channel was created.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets sales_last_imported_at
     *
     * @return \DateTime
     */
    public function getSalesLastImportedAt()
    {
        return $this->container['sales_last_imported_at'];
    }

    /**
     * Sets sales_last_imported_at
     *
     * @param \DateTime $sales_last_imported_at An RFC3339 representation of the time at which sales were last imported.
     *
     * @return self
     */
    public function setSalesLastImportedAt($sales_last_imported_at)
    {
        $this->container['sales_last_imported_at'] = $sales_last_imported_at;

        return $this;
    }

    /**
     * Gets products_last_imported_at
     *
     * @return \DateTime
     */
    public function getProductsLastImportedAt()
    {
        return $this->container['products_last_imported_at'];
    }

    /**
     * Sets products_last_imported_at
     *
     * @param \DateTime $products_last_imported_at An RFC3339 representation of the time at which products were last imported.
     *
     * @return self
     */
    public function setProductsLastImportedAt($products_last_imported_at)
    {
        $this->container['products_last_imported_at'] = $products_last_imported_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


