<?php
/**
 * FulfillmentApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Vend20\ApiException;
use Vend20\Configuration;
use Vend20\HeaderSelector;
use Vend20\ObjectSerializer;

/**
 * FulfillmentApi Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FulfillmentApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation fulfillSale
     *
     * Fulfil a sale
     *
     * @param  string $sale_id Valid sale ID. (required)
     * @param  \Vend20\Model\FulfillSaleRequest $fulfill_sale_request fulfill_sale_request (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\FulfillmentResponse
     */
    public function fulfillSale($sale_id, $fulfill_sale_request)
    {
        list($response) = $this->fulfillSaleWithHttpInfo($sale_id, $fulfill_sale_request);
        return $response;
    }

    /**
     * Operation fulfillSaleWithHttpInfo
     *
     * Fulfil a sale
     *
     * @param  string $sale_id Valid sale ID. (required)
     * @param  \Vend20\Model\FulfillSaleRequest $fulfill_sale_request (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\FulfillmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function fulfillSaleWithHttpInfo($sale_id, $fulfill_sale_request)
    {
        $request = $this->fulfillSaleRequest($sale_id, $fulfill_sale_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\FulfillmentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\FulfillmentResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\FulfillmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\FulfillmentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\FulfillmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation fulfillSaleAsync
     *
     * Fulfil a sale
     *
     * @param  string $sale_id Valid sale ID. (required)
     * @param  \Vend20\Model\FulfillSaleRequest $fulfill_sale_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fulfillSaleAsync($sale_id, $fulfill_sale_request)
    {
        return $this->fulfillSaleAsyncWithHttpInfo($sale_id, $fulfill_sale_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fulfillSaleAsyncWithHttpInfo
     *
     * Fulfil a sale
     *
     * @param  string $sale_id Valid sale ID. (required)
     * @param  \Vend20\Model\FulfillSaleRequest $fulfill_sale_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function fulfillSaleAsyncWithHttpInfo($sale_id, $fulfill_sale_request)
    {
        $returnType = '\Vend20\Model\FulfillmentResponse';
        $request = $this->fulfillSaleRequest($sale_id, $fulfill_sale_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fulfillSale'
     *
     * @param  string $sale_id Valid sale ID. (required)
     * @param  \Vend20\Model\FulfillSaleRequest $fulfill_sale_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fulfillSaleRequest($sale_id, $fulfill_sale_request)
    {
        // verify the required parameter 'sale_id' is set
        if ($sale_id === null || (is_array($sale_id) && count($sale_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sale_id when calling fulfillSale'
            );
        }
        // verify the required parameter 'fulfill_sale_request' is set
        if ($fulfill_sale_request === null || (is_array($fulfill_sale_request) && count($fulfill_sale_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fulfill_sale_request when calling fulfillSale'
            );
        }

        $resourcePath = '/sales/{sale_id}/fulfill';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($sale_id !== null) {
            $resourcePath = str_replace(
                '{' . 'sale_id' . '}',
                ObjectSerializer::toPathValue($sale_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($fulfill_sale_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($fulfill_sale_request));
            } else {
                $httpBody = $fulfill_sale_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFulfillmentsBySaleID
     *
     * List Sale Fulfillments
     *
     * @param  string $sale_id Valid sale ID. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\FulfillmentsResponse
     */
    public function getFulfillmentsBySaleID($sale_id)
    {
        list($response) = $this->getFulfillmentsBySaleIDWithHttpInfo($sale_id);
        return $response;
    }

    /**
     * Operation getFulfillmentsBySaleIDWithHttpInfo
     *
     * List Sale Fulfillments
     *
     * @param  string $sale_id Valid sale ID. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\FulfillmentsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFulfillmentsBySaleIDWithHttpInfo($sale_id)
    {
        $request = $this->getFulfillmentsBySaleIDRequest($sale_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\FulfillmentsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\FulfillmentsResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\FulfillmentsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\FulfillmentsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\FulfillmentsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getFulfillmentsBySaleIDAsync
     *
     * List Sale Fulfillments
     *
     * @param  string $sale_id Valid sale ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentsBySaleIDAsync($sale_id)
    {
        return $this->getFulfillmentsBySaleIDAsyncWithHttpInfo($sale_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getFulfillmentsBySaleIDAsyncWithHttpInfo
     *
     * List Sale Fulfillments
     *
     * @param  string $sale_id Valid sale ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFulfillmentsBySaleIDAsyncWithHttpInfo($sale_id)
    {
        $returnType = '\Vend20\Model\FulfillmentsResponse';
        $request = $this->getFulfillmentsBySaleIDRequest($sale_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFulfillmentsBySaleID'
     *
     * @param  string $sale_id Valid sale ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFulfillmentsBySaleIDRequest($sale_id)
    {
        // verify the required parameter 'sale_id' is set
        if ($sale_id === null || (is_array($sale_id) && count($sale_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sale_id when calling getFulfillmentsBySaleID'
            );
        }

        $resourcePath = '/sales/{sale_id}/fulfillments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($sale_id !== null) {
            $resourcePath = str_replace(
                '{' . 'sale_id' . '}',
                ObjectSerializer::toPathValue($sale_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getfulfillments
     *
     * Get Fulfillments Summary
     *
     * @param  string[] $outlet_id Filter by outlet IDs (can be specified multiple times, e.g. ?outlet_id&#x3D;1234&amp;outlet_id&#x3D;5678) (optional)
     * @param  string[] $sale_id Filter by sale IDs (can be specified multiple times, e.g. ?sale_id&#x3D;1234&amp;sale_id&#x3D;5678) (optional)
     * @param  string[] $fulfillment_type Filter by fulfillment types (can be specified multiple times, e.g. ?fulfillment_type&#x3D;PICKUP&amp;fulfillment_type&#x3D;DISPATCH) (optional)
     * @param  string[] $fulfillment_state Filter by fulfillment states (can be specified multiple times, e.g. ?fulfillment_state&#x3D;OPEN&amp;fulfillment_state&#x3D;STARTED) (optional)
     * @param  int $page_number Page number for pagination (1-based) (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\FulfilmentSummaryResponse
     */
    public function getfulfillments($outlet_id = null, $sale_id = null, $fulfillment_type = null, $fulfillment_state = null, $page_number = null, $page_size = null)
    {
        list($response) = $this->getfulfillmentsWithHttpInfo($outlet_id, $sale_id, $fulfillment_type, $fulfillment_state, $page_number, $page_size);
        return $response;
    }

    /**
     * Operation getfulfillmentsWithHttpInfo
     *
     * Get Fulfillments Summary
     *
     * @param  string[] $outlet_id Filter by outlet IDs (can be specified multiple times, e.g. ?outlet_id&#x3D;1234&amp;outlet_id&#x3D;5678) (optional)
     * @param  string[] $sale_id Filter by sale IDs (can be specified multiple times, e.g. ?sale_id&#x3D;1234&amp;sale_id&#x3D;5678) (optional)
     * @param  string[] $fulfillment_type Filter by fulfillment types (can be specified multiple times, e.g. ?fulfillment_type&#x3D;PICKUP&amp;fulfillment_type&#x3D;DISPATCH) (optional)
     * @param  string[] $fulfillment_state Filter by fulfillment states (can be specified multiple times, e.g. ?fulfillment_state&#x3D;OPEN&amp;fulfillment_state&#x3D;STARTED) (optional)
     * @param  int $page_number Page number for pagination (1-based) (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\FulfilmentSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getfulfillmentsWithHttpInfo($outlet_id = null, $sale_id = null, $fulfillment_type = null, $fulfillment_state = null, $page_number = null, $page_size = null)
    {
        $request = $this->getfulfillmentsRequest($outlet_id, $sale_id, $fulfillment_type, $fulfillment_state, $page_number, $page_size);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\FulfilmentSummaryResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\FulfilmentSummaryResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\FulfilmentSummaryResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\FulfilmentSummaryResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\FulfilmentSummaryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getfulfillmentsAsync
     *
     * Get Fulfillments Summary
     *
     * @param  string[] $outlet_id Filter by outlet IDs (can be specified multiple times, e.g. ?outlet_id&#x3D;1234&amp;outlet_id&#x3D;5678) (optional)
     * @param  string[] $sale_id Filter by sale IDs (can be specified multiple times, e.g. ?sale_id&#x3D;1234&amp;sale_id&#x3D;5678) (optional)
     * @param  string[] $fulfillment_type Filter by fulfillment types (can be specified multiple times, e.g. ?fulfillment_type&#x3D;PICKUP&amp;fulfillment_type&#x3D;DISPATCH) (optional)
     * @param  string[] $fulfillment_state Filter by fulfillment states (can be specified multiple times, e.g. ?fulfillment_state&#x3D;OPEN&amp;fulfillment_state&#x3D;STARTED) (optional)
     * @param  int $page_number Page number for pagination (1-based) (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getfulfillmentsAsync($outlet_id = null, $sale_id = null, $fulfillment_type = null, $fulfillment_state = null, $page_number = null, $page_size = null)
    {
        return $this->getfulfillmentsAsyncWithHttpInfo($outlet_id, $sale_id, $fulfillment_type, $fulfillment_state, $page_number, $page_size)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getfulfillmentsAsyncWithHttpInfo
     *
     * Get Fulfillments Summary
     *
     * @param  string[] $outlet_id Filter by outlet IDs (can be specified multiple times, e.g. ?outlet_id&#x3D;1234&amp;outlet_id&#x3D;5678) (optional)
     * @param  string[] $sale_id Filter by sale IDs (can be specified multiple times, e.g. ?sale_id&#x3D;1234&amp;sale_id&#x3D;5678) (optional)
     * @param  string[] $fulfillment_type Filter by fulfillment types (can be specified multiple times, e.g. ?fulfillment_type&#x3D;PICKUP&amp;fulfillment_type&#x3D;DISPATCH) (optional)
     * @param  string[] $fulfillment_state Filter by fulfillment states (can be specified multiple times, e.g. ?fulfillment_state&#x3D;OPEN&amp;fulfillment_state&#x3D;STARTED) (optional)
     * @param  int $page_number Page number for pagination (1-based) (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getfulfillmentsAsyncWithHttpInfo($outlet_id = null, $sale_id = null, $fulfillment_type = null, $fulfillment_state = null, $page_number = null, $page_size = null)
    {
        $returnType = '\Vend20\Model\FulfilmentSummaryResponse';
        $request = $this->getfulfillmentsRequest($outlet_id, $sale_id, $fulfillment_type, $fulfillment_state, $page_number, $page_size);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getfulfillments'
     *
     * @param  string[] $outlet_id Filter by outlet IDs (can be specified multiple times, e.g. ?outlet_id&#x3D;1234&amp;outlet_id&#x3D;5678) (optional)
     * @param  string[] $sale_id Filter by sale IDs (can be specified multiple times, e.g. ?sale_id&#x3D;1234&amp;sale_id&#x3D;5678) (optional)
     * @param  string[] $fulfillment_type Filter by fulfillment types (can be specified multiple times, e.g. ?fulfillment_type&#x3D;PICKUP&amp;fulfillment_type&#x3D;DISPATCH) (optional)
     * @param  string[] $fulfillment_state Filter by fulfillment states (can be specified multiple times, e.g. ?fulfillment_state&#x3D;OPEN&amp;fulfillment_state&#x3D;STARTED) (optional)
     * @param  int $page_number Page number for pagination (1-based) (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getfulfillmentsRequest($outlet_id = null, $sale_id = null, $fulfillment_type = null, $fulfillment_state = null, $page_number = null, $page_size = null)
    {
        if ($page_number !== null && $page_number < 1) {
            throw new \InvalidArgumentException('invalid value for "$page_number" when calling FulfillmentApi.getfulfillments, must be bigger than or equal to 1.');
        }

        if ($page_size !== null && $page_size > 100) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling FulfillmentApi.getfulfillments, must be smaller than or equal to 100.');
        }
        if ($page_size !== null && $page_size < 1) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling FulfillmentApi.getfulfillments, must be bigger than or equal to 1.');
        }


        $resourcePath = '/fulfillments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outlet_id,
            'outlet_id', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sale_id,
            'sale_id', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fulfillment_type,
            'fulfillment_type', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fulfillment_state,
            'fulfillment_state', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'page_number', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
