<?php
/**
 * ConsignmentsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Vend20\ApiException;
use Vend20\Configuration;
use Vend20\HeaderSelector;
use Vend20\ObjectSerializer;

/**
 * ConsignmentsApi Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ConsignmentsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createConsignment
     *
     * Create an consignment
     *
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request consignment_request (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\ConsignmentResponse
     */
    public function createConsignment($consignment_request)
    {
        list($response) = $this->createConsignmentWithHttpInfo($consignment_request);
        return $response;
    }

    /**
     * Operation createConsignmentWithHttpInfo
     *
     * Create an consignment
     *
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\ConsignmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConsignmentWithHttpInfo($consignment_request)
    {
        $request = $this->createConsignmentRequest($consignment_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\Vend20\Model\ConsignmentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\ConsignmentResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\ConsignmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\ConsignmentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\ConsignmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createConsignmentAsync
     *
     * Create an consignment
     *
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createConsignmentAsync($consignment_request)
    {
        return $this->createConsignmentAsyncWithHttpInfo($consignment_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createConsignmentAsyncWithHttpInfo
     *
     * Create an consignment
     *
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createConsignmentAsyncWithHttpInfo($consignment_request)
    {
        $returnType = '\Vend20\Model\ConsignmentResponse';
        $request = $this->createConsignmentRequest($consignment_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createConsignment'
     *
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createConsignmentRequest($consignment_request)
    {
        // verify the required parameter 'consignment_request' is set
        if ($consignment_request === null || (is_array($consignment_request) && count($consignment_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_request when calling createConsignment'
            );
        }

        $resourcePath = '/consignments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($consignment_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($consignment_request));
            } else {
                $httpBody = $consignment_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteConsignmentByID
     *
     * Delete a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteConsignmentByID($consignment_id)
    {
        $this->deleteConsignmentByIDWithHttpInfo($consignment_id);
    }

    /**
     * Operation deleteConsignmentByIDWithHttpInfo
     *
     * Delete a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteConsignmentByIDWithHttpInfo($consignment_id)
    {
        $request = $this->deleteConsignmentByIDRequest($consignment_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteConsignmentByIDAsync
     *
     * Delete a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteConsignmentByIDAsync($consignment_id)
    {
        return $this->deleteConsignmentByIDAsyncWithHttpInfo($consignment_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteConsignmentByIDAsyncWithHttpInfo
     *
     * Delete a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteConsignmentByIDAsyncWithHttpInfo($consignment_id)
    {
        $returnType = '';
        $request = $this->deleteConsignmentByIDRequest($consignment_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteConsignmentByID'
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteConsignmentByIDRequest($consignment_id)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling deleteConsignmentByID'
            );
        }

        $resourcePath = '/consignments/{consignment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getConsignmentByID
     *
     * Get a single consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\ConsignmentResponse
     */
    public function getConsignmentByID($consignment_id)
    {
        list($response) = $this->getConsignmentByIDWithHttpInfo($consignment_id);
        return $response;
    }

    /**
     * Operation getConsignmentByIDWithHttpInfo
     *
     * Get a single consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\ConsignmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsignmentByIDWithHttpInfo($consignment_id)
    {
        $request = $this->getConsignmentByIDRequest($consignment_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\ConsignmentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\ConsignmentResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\ConsignmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\ConsignmentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\ConsignmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getConsignmentByIDAsync
     *
     * Get a single consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getConsignmentByIDAsync($consignment_id)
    {
        return $this->getConsignmentByIDAsyncWithHttpInfo($consignment_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getConsignmentByIDAsyncWithHttpInfo
     *
     * Get a single consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getConsignmentByIDAsyncWithHttpInfo($consignment_id)
    {
        $returnType = '\Vend20\Model\ConsignmentResponse';
        $request = $this->getConsignmentByIDRequest($consignment_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getConsignmentByID'
     *
     * @param  string $consignment_id The consignment id to use. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getConsignmentByIDRequest($consignment_id)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling getConsignmentByID'
            );
        }

        $resourcePath = '/consignments/{consignment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listConsignmentTotals
     *
     * Get consignment totals
     *
     * @param  string $consignment_id The consignment id (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\ConsignmentTotalsResponse
     */
    public function listConsignmentTotals($consignment_id)
    {
        list($response) = $this->listConsignmentTotalsWithHttpInfo($consignment_id);
        return $response;
    }

    /**
     * Operation listConsignmentTotalsWithHttpInfo
     *
     * Get consignment totals
     *
     * @param  string $consignment_id The consignment id (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\ConsignmentTotalsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listConsignmentTotalsWithHttpInfo($consignment_id)
    {
        $request = $this->listConsignmentTotalsRequest($consignment_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\ConsignmentTotalsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\ConsignmentTotalsResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\ConsignmentTotalsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\ConsignmentTotalsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\ConsignmentTotalsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listConsignmentTotalsAsync
     *
     * Get consignment totals
     *
     * @param  string $consignment_id The consignment id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listConsignmentTotalsAsync($consignment_id)
    {
        return $this->listConsignmentTotalsAsyncWithHttpInfo($consignment_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listConsignmentTotalsAsyncWithHttpInfo
     *
     * Get consignment totals
     *
     * @param  string $consignment_id The consignment id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listConsignmentTotalsAsyncWithHttpInfo($consignment_id)
    {
        $returnType = '\Vend20\Model\ConsignmentTotalsResponse';
        $request = $this->listConsignmentTotalsRequest($consignment_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listConsignmentTotals'
     *
     * @param  string $consignment_id The consignment id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listConsignmentTotalsRequest($consignment_id)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling listConsignmentTotals'
            );
        }

        $resourcePath = '/consignments/{consignment_id}/totals';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listConsignments
     *
     * List consignments
     *
     * @param  string $type type (optional)
     * @param  string $status status (optional)
     * @param  string $outlet_id outlet_id (optional)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\Consignment[]
     */
    public function listConsignments($type = null, $status = null, $outlet_id = null, $after = null, $before = null, $page_size = null)
    {
        list($response) = $this->listConsignmentsWithHttpInfo($type, $status, $outlet_id, $after, $before, $page_size);
        return $response;
    }

    /**
     * Operation listConsignmentsWithHttpInfo
     *
     * List consignments
     *
     * @param  string $type (optional)
     * @param  string $status (optional)
     * @param  string $outlet_id (optional)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\Consignment[], HTTP status code, HTTP response headers (array of strings)
     */
    public function listConsignmentsWithHttpInfo($type = null, $status = null, $outlet_id = null, $after = null, $before = null, $page_size = null)
    {
        $request = $this->listConsignmentsRequest($type, $status, $outlet_id, $after, $before, $page_size);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\Consignment[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\Consignment[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\Consignment[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\Consignment[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\Consignment[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listConsignmentsAsync
     *
     * List consignments
     *
     * @param  string $type (optional)
     * @param  string $status (optional)
     * @param  string $outlet_id (optional)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listConsignmentsAsync($type = null, $status = null, $outlet_id = null, $after = null, $before = null, $page_size = null)
    {
        return $this->listConsignmentsAsyncWithHttpInfo($type, $status, $outlet_id, $after, $before, $page_size)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listConsignmentsAsyncWithHttpInfo
     *
     * List consignments
     *
     * @param  string $type (optional)
     * @param  string $status (optional)
     * @param  string $outlet_id (optional)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listConsignmentsAsyncWithHttpInfo($type = null, $status = null, $outlet_id = null, $after = null, $before = null, $page_size = null)
    {
        $returnType = '\Vend20\Model\Consignment[]';
        $request = $this->listConsignmentsRequest($type, $status, $outlet_id, $after, $before, $page_size);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listConsignments'
     *
     * @param  string $type (optional)
     * @param  string $status (optional)
     * @param  string $outlet_id (optional)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listConsignmentsRequest($type = null, $status = null, $outlet_id = null, $after = null, $before = null, $page_size = null)
    {
        if ($page_size !== null && $page_size > 100) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling ConsignmentsApi.listConsignments, must be smaller than or equal to 100.');
        }
        if ($page_size !== null && $page_size < 1) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling ConsignmentsApi.listConsignments, must be bigger than or equal to 1.');
        }


        $resourcePath = '/consignments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $type,
            'type', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'status', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outlet_id,
            'outlet_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateConsignmentByID
     *
     * Update a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request consignment_request (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\ConsignmentResponse
     */
    public function updateConsignmentByID($consignment_id, $consignment_request)
    {
        list($response) = $this->updateConsignmentByIDWithHttpInfo($consignment_id, $consignment_request);
        return $response;
    }

    /**
     * Operation updateConsignmentByIDWithHttpInfo
     *
     * Update a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\ConsignmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateConsignmentByIDWithHttpInfo($consignment_id, $consignment_request)
    {
        $request = $this->updateConsignmentByIDRequest($consignment_id, $consignment_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\ConsignmentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\ConsignmentResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\ConsignmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\ConsignmentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\ConsignmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateConsignmentByIDAsync
     *
     * Update a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateConsignmentByIDAsync($consignment_id, $consignment_request)
    {
        return $this->updateConsignmentByIDAsyncWithHttpInfo($consignment_id, $consignment_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateConsignmentByIDAsyncWithHttpInfo
     *
     * Update a consignment
     *
     * @param  string $consignment_id The consignment id to use. (required)
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateConsignmentByIDAsyncWithHttpInfo($consignment_id, $consignment_request)
    {
        $returnType = '\Vend20\Model\ConsignmentResponse';
        $request = $this->updateConsignmentByIDRequest($consignment_id, $consignment_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateConsignmentByID'
     *
     * @param  string $consignment_id The consignment id to use. (required)
     * @param  \Vend20\Model\ConsignmentRequest $consignment_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateConsignmentByIDRequest($consignment_id, $consignment_request)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling updateConsignmentByID'
            );
        }
        // verify the required parameter 'consignment_request' is set
        if ($consignment_request === null || (is_array($consignment_request) && count($consignment_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_request when calling updateConsignmentByID'
            );
        }

        $resourcePath = '/consignments/{consignment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($consignment_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($consignment_request));
            } else {
                $httpBody = $consignment_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
