<?php
/**
 * ConsignmentProductsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 2.0
 *
 * Early release of version 2.0 of the Vend API.
 *
 * The version of the OpenAPI document: 2.0
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend20\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Vend20\ApiException;
use Vend20\Configuration;
use Vend20\HeaderSelector;
use Vend20\ObjectSerializer;

/**
 * ConsignmentProductsApi Class Doc Comment
 *
 * @category Class
 * @package  Vend20
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ConsignmentProductsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createConsignmentProduct
     *
     * Add a product to a consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product consignment_product (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\InventoryCountItemResponse
     */
    public function createConsignmentProduct($consignment_id, $consignment_product = null)
    {
        list($response) = $this->createConsignmentProductWithHttpInfo($consignment_id, $consignment_product);
        return $response;
    }

    /**
     * Operation createConsignmentProductWithHttpInfo
     *
     * Add a product to a consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\InventoryCountItemResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConsignmentProductWithHttpInfo($consignment_id, $consignment_product = null)
    {
        $request = $this->createConsignmentProductRequest($consignment_id, $consignment_product);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\InventoryCountItemResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\InventoryCountItemResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\InventoryCountItemResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\InventoryCountItemResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\InventoryCountItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createConsignmentProductAsync
     *
     * Add a product to a consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createConsignmentProductAsync($consignment_id, $consignment_product = null)
    {
        return $this->createConsignmentProductAsyncWithHttpInfo($consignment_id, $consignment_product)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createConsignmentProductAsyncWithHttpInfo
     *
     * Add a product to a consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createConsignmentProductAsyncWithHttpInfo($consignment_id, $consignment_product = null)
    {
        $returnType = '\Vend20\Model\InventoryCountItemResponse';
        $request = $this->createConsignmentProductRequest($consignment_id, $consignment_product);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createConsignmentProduct'
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createConsignmentProductRequest($consignment_id, $consignment_product = null)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling createConsignmentProduct'
            );
        }

        $resourcePath = '/consignments/{consignment_id}/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($consignment_product)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($consignment_product));
            } else {
                $httpBody = $consignment_product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOrUpdateConsignmentProducts
     *
     * Bulk update consignment products
     *
     * @param  string $consignment_id The id of the consignment (required)
     * @param  \Vend20\Model\ConsignmentProduct[] $consignment_product consignment_product (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createOrUpdateConsignmentProducts($consignment_id, $consignment_product)
    {
        $this->createOrUpdateConsignmentProductsWithHttpInfo($consignment_id, $consignment_product);
    }

    /**
     * Operation createOrUpdateConsignmentProductsWithHttpInfo
     *
     * Bulk update consignment products
     *
     * @param  string $consignment_id The id of the consignment (required)
     * @param  \Vend20\Model\ConsignmentProduct[] $consignment_product (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrUpdateConsignmentProductsWithHttpInfo($consignment_id, $consignment_product)
    {
        $request = $this->createOrUpdateConsignmentProductsRequest($consignment_id, $consignment_product);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createOrUpdateConsignmentProductsAsync
     *
     * Bulk update consignment products
     *
     * @param  string $consignment_id The id of the consignment (required)
     * @param  \Vend20\Model\ConsignmentProduct[] $consignment_product (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrUpdateConsignmentProductsAsync($consignment_id, $consignment_product)
    {
        return $this->createOrUpdateConsignmentProductsAsyncWithHttpInfo($consignment_id, $consignment_product)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrUpdateConsignmentProductsAsyncWithHttpInfo
     *
     * Bulk update consignment products
     *
     * @param  string $consignment_id The id of the consignment (required)
     * @param  \Vend20\Model\ConsignmentProduct[] $consignment_product (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrUpdateConsignmentProductsAsyncWithHttpInfo($consignment_id, $consignment_product)
    {
        $returnType = '';
        $request = $this->createOrUpdateConsignmentProductsRequest($consignment_id, $consignment_product);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrUpdateConsignmentProducts'
     *
     * @param  string $consignment_id The id of the consignment (required)
     * @param  \Vend20\Model\ConsignmentProduct[] $consignment_product (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrUpdateConsignmentProductsRequest($consignment_id, $consignment_product)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling createOrUpdateConsignmentProducts'
            );
        }
        // verify the required parameter 'consignment_product' is set
        if ($consignment_product === null || (is_array($consignment_product) && count($consignment_product) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_product when calling createOrUpdateConsignmentProducts'
            );
        }

        $resourcePath = '/consignments/{consignment_id}/bulk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($consignment_product)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($consignment_product));
            } else {
                $httpBody = $consignment_product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteProductFromConsignment
     *
     * Delete an item from a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteProductFromConsignment($consignment_id, $product_id)
    {
        $this->deleteProductFromConsignmentWithHttpInfo($consignment_id, $product_id);
    }

    /**
     * Operation deleteProductFromConsignmentWithHttpInfo
     *
     * Delete an item from a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductFromConsignmentWithHttpInfo($consignment_id, $product_id)
    {
        $request = $this->deleteProductFromConsignmentRequest($consignment_id, $product_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteProductFromConsignmentAsync
     *
     * Delete an item from a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductFromConsignmentAsync($consignment_id, $product_id)
    {
        return $this->deleteProductFromConsignmentAsyncWithHttpInfo($consignment_id, $product_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteProductFromConsignmentAsyncWithHttpInfo
     *
     * Delete an item from a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductFromConsignmentAsyncWithHttpInfo($consignment_id, $product_id)
    {
        $returnType = '';
        $request = $this->deleteProductFromConsignmentRequest($consignment_id, $product_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteProductFromConsignment'
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteProductFromConsignmentRequest($consignment_id, $product_id)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling deleteProductFromConsignment'
            );
        }
        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling deleteProductFromConsignment'
            );
        }

        $resourcePath = '/consignments/{consignment_id}/products/{product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }
        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listProductsByConsignmentID
     *
     * List all products for a specific consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\ConsignmentProductCollection
     */
    public function listProductsByConsignmentID($consignment_id, $after = null, $before = null, $page_size = null)
    {
        list($response) = $this->listProductsByConsignmentIDWithHttpInfo($consignment_id, $after, $before, $page_size);
        return $response;
    }

    /**
     * Operation listProductsByConsignmentIDWithHttpInfo
     *
     * List all products for a specific consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\ConsignmentProductCollection, HTTP status code, HTTP response headers (array of strings)
     */
    public function listProductsByConsignmentIDWithHttpInfo($consignment_id, $after = null, $before = null, $page_size = null)
    {
        $request = $this->listProductsByConsignmentIDRequest($consignment_id, $after, $before, $page_size);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\ConsignmentProductCollection' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\ConsignmentProductCollection' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\ConsignmentProductCollection', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\ConsignmentProductCollection';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\ConsignmentProductCollection',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listProductsByConsignmentIDAsync
     *
     * List all products for a specific consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listProductsByConsignmentIDAsync($consignment_id, $after = null, $before = null, $page_size = null)
    {
        return $this->listProductsByConsignmentIDAsyncWithHttpInfo($consignment_id, $after, $before, $page_size)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listProductsByConsignmentIDAsyncWithHttpInfo
     *
     * List all products for a specific consignment
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listProductsByConsignmentIDAsyncWithHttpInfo($consignment_id, $after = null, $before = null, $page_size = null)
    {
        $returnType = '\Vend20\Model\ConsignmentProductCollection';
        $request = $this->listProductsByConsignmentIDRequest($consignment_id, $after, $before, $page_size);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listProductsByConsignmentID'
     *
     * @param  string $consignment_id The consignment id to add a product to. (required)
     * @param  int $after The lower limit for the version numbers to be included in the response. (optional)
     * @param  int $before The upper limit for the version numbers to be included in the response. (optional)
     * @param  int $page_size The maximum number of items to be returned in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listProductsByConsignmentIDRequest($consignment_id, $after = null, $before = null, $page_size = null)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling listProductsByConsignmentID'
            );
        }
        if ($page_size !== null && $page_size > 100) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling ConsignmentProductsApi.listProductsByConsignmentID, must be smaller than or equal to 100.');
        }
        if ($page_size !== null && $page_size < 1) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling ConsignmentProductsApi.listProductsByConsignmentID, must be bigger than or equal to 1.');
        }


        $resourcePath = '/consignments/{consignment_id}/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateProductInConsignment
     *
     * Update a product in a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product consignment_product (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend20\Model\ConsignmentProductResponse
     */
    public function updateProductInConsignment($consignment_id, $product_id, $consignment_product = null)
    {
        list($response) = $this->updateProductInConsignmentWithHttpInfo($consignment_id, $product_id, $consignment_product);
        return $response;
    }

    /**
     * Operation updateProductInConsignmentWithHttpInfo
     *
     * Update a product in a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \Vend20\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend20\Model\ConsignmentProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductInConsignmentWithHttpInfo($consignment_id, $product_id, $consignment_product = null)
    {
        $request = $this->updateProductInConsignmentRequest($consignment_id, $product_id, $consignment_product);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend20\Model\ConsignmentProductResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend20\Model\ConsignmentProductResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend20\Model\ConsignmentProductResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend20\Model\ConsignmentProductResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend20\Model\ConsignmentProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateProductInConsignmentAsync
     *
     * Update a product in a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductInConsignmentAsync($consignment_id, $product_id, $consignment_product = null)
    {
        return $this->updateProductInConsignmentAsyncWithHttpInfo($consignment_id, $product_id, $consignment_product)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateProductInConsignmentAsyncWithHttpInfo
     *
     * Update a product in a consignment
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateProductInConsignmentAsyncWithHttpInfo($consignment_id, $product_id, $consignment_product = null)
    {
        $returnType = '\Vend20\Model\ConsignmentProductResponse';
        $request = $this->updateProductInConsignmentRequest($consignment_id, $product_id, $consignment_product);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateProductInConsignment'
     *
     * @param  string $consignment_id The consignment id to be updated. (required)
     * @param  string $product_id The product id of the product to be added to the consignment. (required)
     * @param  \Vend20\Model\ConsignmentProduct $consignment_product (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateProductInConsignmentRequest($consignment_id, $product_id, $consignment_product = null)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling updateProductInConsignment'
            );
        }
        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling updateProductInConsignment'
            );
        }

        $resourcePath = '/consignments/{consignment_id}/products/{product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_id' . '}',
                ObjectSerializer::toPathValue($consignment_id),
                $resourcePath
            );
        }
        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($consignment_product)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($consignment_product));
            } else {
                $httpBody = $consignment_product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
