# # SearchResponseOneOf

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | Auto-generated object ID. | [optional]
**name** | **string** | Customers full name. **deprecated** |
**description** | **string** | A detailed description of the Product. **Note** Can contain HTML. | [optional]
**handle** | **string** | Product handle. **Note:** Variants share the same handle. |
**sku** | **string** | Product sku. **Note:** Should be unique, but it&#39;s not verified while posting. |
**source** | **string** | Origin of the sale. USER for sales created in Vend client apps, SHOPIFY for sale synced from Shopify by the integration, ECOMMERCE for sales coming from Vend Ecommerce. | [optional]
**source_id** | **string** | External ID for sales coming from other systems | [optional]
**source_variant_id** | **string** | Secondary external reference ID. | [optional]
**active** | **bool** | Indicated whether the Product is active. | [optional]
**has_inventory** | **bool** | Indicates whether inventory is being tracked for the Product. | [optional]
**is_composite** | **bool** | Indicates whether the Product is a composite one. | [optional]
**has_variants** | **bool** | Indicated whether product has variants. | [optional]
**variant_parent_id** | **string** | This value is set if a Product is a variant of another Product. | [optional]
**variant_name** | **string** | The name of the variant product. | [optional]
**variant_options** | [**\Vend20\Model\VariantOption[]**](VariantOption.md) | A list of variant option objects. | [optional]
**variant_count** | **int** | The number of variants for this product. | [optional]
**price_including_tax** | **float** | The price including all the relevant taxes. | [optional]
**price_excluding_tax** | **float** | The price before tax is added. | [optional]
**supply_price** | **double** | Default supply price, | [optional]
**supplier_id** | **string** | The supplier ID. | [optional]
**supplier_code** | **string** | Supplier code. | [optional]
**supplier** | [**\Vend20\Model\Supplier**](Supplier.md) |  | [optional]
**product_type_id** | **string** | The product type. | [optional]
**type** | [**\Vend20\Model\ProductTypeSample**](ProductTypeSample.md) |  | [optional]
**brand_id** | **string** | The brand ID. | [optional]
**brand** | [**\Vend20\Model\BrandSample**](BrandSample.md) |  | [optional]
**tag_ids** | **string[]** | An array of tag IDs associated with this product. | [optional]
**categories** | [**\Vend20\Model\Tag[]**](Tag.md) | A list of tag objects. | [optional]
**attributes** | [**\Vend20\Model\Attribute[]**](Attribute.md) | A list of attributes | [optional]
**image_url** | **string** |  | [optional]
**image_thumbnail_url** | **string** |  | [optional]
**images** | [**\Vend20\Model\ImageSample[]**](ImageSample.md) | A list of image objects. | [optional]
**account_code** | **string** | ??? | [optional]
**account_code_purchase** | **string** | ??? | [optional]
**button_order** | **int** | ??? | [optional]
**created_at** | **string** | Creation timestamp in UTC. | [optional]
**updated_at** | **string** | Last update timestamp in UTC. | [optional]
**deleted_at** | **string** | Deletion timestamp in UTC. | [optional]
**version** | **int** | Auto-incrementing object version number. | [optional]
**product_codes** | [**\Vend20\Model\ProductCode[]**](ProductCode.md) |  | [optional]
**outlet_id** | **string** | Valid outlet ID for the retailer. | [optional]
**register_id** | **string** | Valid register ID for the retailer. | [optional]
**user_id** | **string** | Valid user ID for the retailer. | [optional]
**customer_id** | **string** | Valid customer ID for the retailer. | [optional]
**invoice_number** | **string** | Invoice number which if provided, should use the prefix and suffix defined for the register. | [optional]
**invoice_sequence** | **double** | Optionally provided value. | [optional]
**status** | **string** | Status of the sale. | [optional]
**note** | **string** | Customer note. | [optional]
**short_code** | **string** | 6 character code used in the loyalty system. ??? | [optional]
**return_for** | **string** | Reference ID to a different sale if this sale was created as a return. | [optional]
**total_price** | **double** | Total (tax exclusive) price of the sale | [optional]
**total_tax** | **double** | Total tax. | [optional]
**total_loyalty** | **double** | Total incurred loyalty. | [optional]
**sale_date** | **string** | Sale timestamp in UTC. | [optional]
**taxes** | [**\Vend20\Model\SaleTax[]**](SaleTax.md) | Collection of taxes. | [optional]
**line_items** | [**\Vend20\Model\LineItem[]**](LineItem.md) | Collection of line items. | [optional]
**payments** | [**\Vend20\Model\Payment[]**](Payment.md) | Collection of payments. | [optional]
**adjustments** | [**\Vend20\Model\Adjustment[]**](Adjustment.md) | Collection of adjustments. | [optional]
**first_name** | **string** | Customer&#39;s first name. |
**last_name** | **string** | Customer &#39;s last name. |
**customer_code** | **string** | Customer code used for claiming loyalty. | [optional]
**customer_group_id** | **string** | Customer group ID. | [optional]
**enable_loyalty** | **bool** |  | [optional]
**email** | **string** | Customer&#39;s email address. | [optional]
**gender** | **string** | Customer&#39;s gender. Can be &#x60;M&#x60;, &#x60;F&#x60; or null. | [optional]
**date_of_birth** | **string** | Birthday. | [optional]
**company_name** | **string** | Company name. | [optional]
**do_not_email** | **bool** | Indicates whether the customer opted out of email communications. | [optional] [default to false]
**phone** | **string** | Phone no. | [optional]
**mobile** | **string** | Mobile phone no. | [optional]
**fax** | **string** | Fax no. | [optional]
**twitter** | **string** | Twitter handle. | [optional]
**website** | **string** | Website URL. | [optional]
**physical_address_1** | **string** | Physical address, line 1. | [optional]
**physical_address_2** | **string** | Physical address, line 2. | [optional]
**physical_suburb** | **string** | Physical address, suburb. | [optional]
**physical_city** | **string** | Physical address, city. | [optional]
**physical_postcode** | **string** | Physical address, post code. | [optional]
**physical_state** | **string** | Physical address, state. | [optional]
**physical_country_id** | **string** | Physical address, country code. | [optional]
**postal_address_1** | **string** | Postal address, line 1. | [optional]
**postal_address_2** | **string** | Postal address, line 2. | [optional]
**postal_suburb** | **string** | Postal address, suburb. | [optional]
**postal_city** | **string** | Postal address, city. | [optional]
**postal_postcode** | **string** | Postal address, post code. | [optional]
**postal_state** | **string** | Postal address, state. | [optional]
**postal_country_id** | **string** | Postal address, country code. | [optional]
**custom_field_1** | **string** | Custom field 1. Can be used to store random data. | [optional]
**custom_field_2** | **string** | Custom field 2. | [optional]
**custom_field_3** | **string** | Custom field 3. | [optional]
**custom_field_4** | **string** | Custom field 4. | [optional]
**year_to_date** | **double** | Customer&#39;s spending this year. | [optional]
**balance** | **double** | Customer&#39;s unpaid balance. | [optional]
**loyalty_balance** | **double** | Customer&#39;s loyalty balance. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
