# # ProductBase

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **string** | Product name. |
**description** | **string** | A detailed description of the Product. **Note** Can contain HTML. | [optional]
**handle** | **string** | Product handle. **Note:** Variants share the same handle. |
**sku** | **string** | Product sku. **Note:** Should be unique, but it&#39;s not verified while posting. |
**source** | **string** | Indicates the origin of the product. Can be USER, SYSTEM, SHOPIFY. | [optional]
**source_id** | **string** | External reference ID. | [optional]
**source_variant_id** | **string** | Secondary external reference ID. | [optional]
**is_active** | **bool** | Indicated whether the Product is active. | [optional]
**price_including_tax** | **float** | The price including all the relevant taxes. | [optional]
**price_excluding_tax** | **float** | The price before tax is added. | [optional]
**supply_price** | **double** | Default supply price, | [optional]
**supplier_id** | **string** | The supplier ID. | [optional]
**supplier_code** | **string** | Supplier code. | [optional]
**product_type_id** | **string** | The product type. | [optional]
**tag_ids** | **string[]** | An array of tag IDs associated with this product. | [optional]
**attributes** | [**\Vend20\Model\Attribute[]**](Attribute.md) | A list of attributes | [optional]
**images** | [**\Vend20\Model\ProductImage[]**](ProductImage.md) | A list of image objects. | [optional]
**account_code** | **string** | The code used to attribute the sales of the product to a specific account for the Xero integration | [optional]
**account_code_purchase** | **string** | The code used to attribute the purchase of the product to a specific account for the Xero integration | [optional]
**loyalty_amount** | **float** | The amount of loyalty the customer receives buying this item. | [optional]
**product_codes** | [**\Vend20\Model\ProductCode[]**](ProductCode.md) |  | [optional]
**product_suppliers** | [**\Vend20\Model\ProductSupplier[]**](ProductSupplier.md) |  | [optional]
**inventory** | [**\Vend20\Model\ProductInventory[]**](ProductInventory.md) |  | [optional]
**weight** | **float** |  | [optional]
**weight_unit** | **string** |  | [optional]
**length** | **float** |  | [optional]
**width** | **float** |  | [optional]
**height** | **float** |  | [optional]
**dimensions_unit** | **string** |  | [optional]
**all_outlets_tax** | [**\Vend20\Model\AllOutletTax**](AllOutletTax.md) |  | [optional]
**outlet_taxes** | [**\Vend20\Model\OutletTax[]**](OutletTax.md) |  | [optional]
**variants** | [**\Vend20\Model\ProductVariant[]**](ProductVariant.md) |  | [optional]
**product_category_id** | **string** |  | [optional]
**brand_id** | **string** |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
