# # Product

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | Auto-generated object ID. | [optional]
**name** | **string** | Product name. |
**description** | **string** | A detailed description of the Product. **Note** Can contain HTML. | [optional]
**handle** | **string** | Product handle. **Note:** Variants share the same handle. |
**sku** | **string** | Product sku. **Note:** Should be unique, but it&#39;s not verified while posting. |
**source** | **string** | Indicates the origin of the product. Can be USER, SYSTEM, SHOPIFY. | [optional]
**source_id** | **string** | External reference ID. | [optional]
**source_variant_id** | **string** | Secondary external reference ID. | [optional]
**active** | **bool** | Indicated whether the Product is active. | [optional]
**has_inventory** | **bool** | Indicates whether inventory is being tracked for the Product. | [optional]
**is_composite** | **bool** | Indicates whether the Product is a composite one. | [optional]
**has_variants** | **bool** | Indicated whether product has variants. | [optional]
**variant_parent_id** | **string** | This value is set if a Product is a variant of another Product. | [optional]
**variant_name** | **string** | The name of the variant product. | [optional]
**variant_options** | [**\Vend20\Model\VariantOption[]**](VariantOption.md) | A list of variant option objects. | [optional]
**variant_count** | **int** | The number of variants for this product. | [optional]
**price_including_tax** | **float** | The price including all the relevant taxes. | [optional]
**price_excluding_tax** | **float** | The price before tax is added. | [optional]
**supply_price** | **double** | Default supply price, | [optional]
**supplier_id** | **string** | The supplier ID. | [optional]
**supplier_code** | **string** | Supplier code. | [optional]
**supplier** | [**\Vend20\Model\Supplier**](Supplier.md) |  | [optional]
**product_type_id** | **string** | The product type. | [optional]
**type** | [**\Vend20\Model\ProductTypeSample**](ProductTypeSample.md) |  | [optional]
**brand_id** | **string** | The brand ID. | [optional]
**brand** | [**\Vend20\Model\BrandSample**](BrandSample.md) |  | [optional]
**tag_ids** | **string[]** | An array of tag IDs associated with this product. | [optional]
**categories** | [**\Vend20\Model\Tag[]**](Tag.md) | A list of tag objects. | [optional]
**attributes** | [**\Vend20\Model\Attribute[]**](Attribute.md) | A list of attributes | [optional]
**image_url** | **string** |  | [optional]
**image_thumbnail_url** | **string** |  | [optional]
**images** | [**\Vend20\Model\ImageSample[]**](ImageSample.md) | A list of image objects. | [optional]
**account_code** | **string** | ??? | [optional]
**account_code_purchase** | **string** | ??? | [optional]
**button_order** | **int** | ??? | [optional]
**created_at** | **string** | Creation timestamp in UTC. | [optional]
**updated_at** | **string** | Last update timestamp in UTC. | [optional]
**deleted_at** | **string** | Deletion timestamp in UTC. | [optional]
**version** | **int** | Auto-incrementing object version number. | [optional]
**product_codes** | [**\Vend20\Model\ProductCode[]**](ProductCode.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
