# Vend20\VariantApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createVariantAttribute()**](VariantApi.md#createVariantAttribute) | **POST** /variant_attributes | 
[**deleteVariantAttributesAttributeId()**](VariantApi.md#deleteVariantAttributesAttributeId) | **DELETE** /variant_attributes/{attribute-id} | 
[**getVariantAttribute()**](VariantApi.md#getVariantAttribute) | **GET** /variant_attributes/{attribute-id} | Retrieve a single Variant Attribute
[**getVariantAttributes()**](VariantApi.md#getVariantAttributes) | **GET** /variant_attributes | Retrieve all Variant Attributes
[**updateVariantAttribute()**](VariantApi.md#updateVariantAttribute) | **PUT** /variant_attributes/{attribute-id} | 


## `createVariantAttribute()`

```php
createVariantAttribute($variant_attribute): \Vend20\Model\CreateVariantAttribute200Response
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\VariantApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$variant_attribute = new \Vend20\Model\VariantAttribute(); // \Vend20\Model\VariantAttribute

try {
    $result = $apiInstance->createVariantAttribute($variant_attribute);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VariantApi->createVariantAttribute: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **variant_attribute** | [**\Vend20\Model\VariantAttribute**](../Model/VariantAttribute.md)|  | [optional]

### Return type

[**\Vend20\Model\CreateVariantAttribute200Response**](../Model/CreateVariantAttribute200Response.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteVariantAttributesAttributeId()`

```php
deleteVariantAttributesAttributeId($attribute_id): \Vend20\Model\CreateVariantAttribute200Response
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\VariantApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attribute_id = 'attribute_id_example'; // string

try {
    $result = $apiInstance->deleteVariantAttributesAttributeId($attribute_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VariantApi->deleteVariantAttributesAttributeId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_id** | **string**|  |

### Return type

[**\Vend20\Model\CreateVariantAttribute200Response**](../Model/CreateVariantAttribute200Response.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariantAttribute()`

```php
getVariantAttribute($attribute_id, $deleted): \Vend20\Model\CreateVariantAttribute200Response
```

Retrieve a single Variant Attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\VariantApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attribute_id = 'attribute_id_example'; // string
$deleted = 'deleted_example'; // string

try {
    $result = $apiInstance->getVariantAttribute($attribute_id, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VariantApi->getVariantAttribute: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_id** | **string**|  |
 **deleted** | **string**|  | [optional]

### Return type

[**\Vend20\Model\CreateVariantAttribute200Response**](../Model/CreateVariantAttribute200Response.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariantAttributes()`

```php
getVariantAttributes($deleted): \Vend20\Model\GetVariantAttributes200Response
```

Retrieve all Variant Attributes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\VariantApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$deleted = True; // bool

try {
    $result = $apiInstance->getVariantAttributes($deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VariantApi->getVariantAttributes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **deleted** | **bool**|  | [optional]

### Return type

[**\Vend20\Model\GetVariantAttributes200Response**](../Model/GetVariantAttributes200Response.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateVariantAttribute()`

```php
updateVariantAttribute($attribute_id, $variant_attribute): \Vend20\Model\CreateVariantAttribute200Response
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\VariantApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$attribute_id = 'attribute_id_example'; // string
$variant_attribute = new \Vend20\Model\VariantAttribute(); // \Vend20\Model\VariantAttribute

try {
    $result = $apiInstance->updateVariantAttribute($attribute_id, $variant_attribute);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VariantApi->updateVariantAttribute: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_id** | **string**|  |
 **variant_attribute** | [**\Vend20\Model\VariantAttribute**](../Model/VariantAttribute.md)|  | [optional]

### Return type

[**\Vend20\Model\CreateVariantAttribute200Response**](../Model/CreateVariantAttribute200Response.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
